/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui.wizard;

import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.xplanner.ui.wizard.AbstractXPlannerQueryWizardPage;
import org.eclipse.mylyn.xplanner.ui.wizard.Messages;
import org.eclipse.mylyn.xplanner.ui.wizard.MultipleQueryPage;
import org.eclipse.mylyn.xplanner.ui.wizard.XPlannerQueryWizardUtils;

public class NewXPlannerQueryWizard
extends Wizard {
    private static final String TITLE = Messages.NewXPlannerQueryWizard_NEW_XPLANNER_QUERY;
    private final TaskRepository repository;
    private AbstractXPlannerQueryWizardPage queryPage;

    public NewXPlannerQueryWizard(TaskRepository repository) {
        this.repository = repository;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(TITLE);
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
    }

    public void addPages() {
        this.queryPage = XPlannerQueryWizardUtils.addQueryWizardFirstPage(this, this.repository, null);
    }

    public boolean performFinish() {
        if (this.queryPage instanceof MultipleQueryPage) {
            List<AbstractRepositoryQuery> queries = ((MultipleQueryPage)((Object)this.queryPage)).getQueries();
            for (AbstractRepositoryQuery query : queries) {
                TasksUiPlugin.getTaskListManager().getTaskList().addQuery(query);
            }
            AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.repository.getConnectorKind());
            if (connector != null) {
                TasksUiPlugin.getSynchronizationManager().synchronize(connector, this.repository, new HashSet<AbstractRepositoryQuery>(queries), null, 30, 0L, true);
            }
        } else {
            AbstractRepositoryQuery query = this.queryPage.getQuery();
            NewXPlannerQueryWizard.addQuery(query, this.repository);
        }
        return true;
    }

    public static void addQuery(AbstractRepositoryQuery query, TaskRepository repository) {
        if (query != null) {
            TasksUiPlugin.getTaskListManager().getTaskList().addQuery(query);
            AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
            if (connector != null) {
                TasksUiPlugin.getSynchronizationManager().synchronize(connector, query, null, true);
            }
        }
    }

    public boolean canFinish() {
        boolean canFinish = false;
        if (this.queryPage != null) {
            canFinish = this.queryPage.getNextPage() == null ? this.queryPage.isPageComplete() : this.queryPage.getNextPage().isPageComplete();
        }
        return canFinish;
    }
}

