/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui.wizard;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.mylyn.xplanner.ui.XPlannerRepositoryUtils;
import org.eclipse.mylyn.xplanner.ui.wizard.Messages;
import org.eclipse.swt.widgets.Composite;

public class XPlannerRepositorySettingsPage
extends AbstractRepositorySettingsPage {
    private static final String MESSAGE_FAILURE_CONNECT = Messages.XPlannerRepositorySettingsPage_COULD_NOT_CONNECT_TO_XPLANNER;
    private static final String TITLE = Messages.XPlannerRepositorySettingsPage_XPLANNER_REPPOSITORY_SETTINGS;
    private static final String DESCRIPTION = Messages.XPlannerRepositorySettingsPage_URL_EXAMPLE;

    public XPlannerRepositorySettingsPage(AbstractRepositoryConnectorUi connectorUi) {
        super(TITLE, DESCRIPTION, connectorUi);
        this.setNeedsProxy(true);
        this.setNeedsHttpAuth(true);
    }

    protected void createAdditionalControls(Composite parent) {
    }

    protected boolean isValidUrl(String name) {
        boolean isValidUrl = false;
        if (name.startsWith("https://") || name.startsWith("http://")) {
            try {
                new URL(name);
                isValidUrl = true;
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return isValidUrl;
    }

    protected AbstractRepositorySettingsPage.Validator getValidator(TaskRepository repository) {
        return new XPlannerValidator(repository);
    }

    class XPlannerValidator
    extends AbstractRepositorySettingsPage.Validator {
        final TaskRepository repository;

        public XPlannerValidator(TaskRepository repository) {
            super((AbstractRepositorySettingsPage)XPlannerRepositorySettingsPage.this);
            this.repository = repository;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            XPlannerRepositoryUtils.validateRepository(this.repository);
            this.setStatus((IStatus)new Status(0, "org.eclipse.mylyn.xplanner.ui", 0, Messages.XPlannerRepositorySettingsPage_VALID_SETTINGS_FOUND, null));
        }
    }
}

