/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaMessages;
import org.eclipse.osgi.util.NLS;

public class BugzillaStatus
extends Status {
    private final String errorMessage;
    private String repositoryUrl = "";

    public BugzillaStatus(int severity, String pluginId, int code) {
        super(severity, pluginId, code, "MylynStatus", null);
        this.errorMessage = null;
    }

    public BugzillaStatus(int severity, String pluginId, int code, String errorMessage) {
        super(severity, pluginId, code, "MylynStatus", null);
        this.errorMessage = errorMessage;
    }

    public BugzillaStatus(int severity, String pluginId, int code, String repositoryUrl, Throwable e) {
        super(severity, pluginId, code, "MylynStatus", e);
        this.repositoryUrl = repositoryUrl;
        this.errorMessage = e.getMessage();
    }

    public BugzillaStatus(int severity, String pluginId, int code, String repositoryUrl, String errorMessage) {
        super(severity, pluginId, code, "MylynStatus", null);
        this.errorMessage = errorMessage;
        this.repositoryUrl = repositoryUrl;
    }

    public BugzillaStatus(int severity, String pluginId, int code, String repositoryUrl, String errorMessage, Throwable e) {
        super(severity, pluginId, code, "MylynStatus", e);
        this.errorMessage = errorMessage;
        this.repositoryUrl = repositoryUrl;
    }

    public String getMessage() {
        switch (this.getCode()) {
            case 3: {
                return NLS.bind((String)BugzillaMessages.repositoryLoginFailure, (Object)this.getRepositoryUrl(), (Object)this.errorMessage);
            }
            case 4: {
                return NLS.bind((String)BugzillaMessages.repositoryNotFound, (Object)this.errorMessage);
            }
            case 1: {
                return NLS.bind((String)BugzillaMessages.errorRepository, (Object)this.getRepositoryUrl(), (Object)this.errorMessage);
            }
            case 5: {
                String string1 = "Unknown IO error occurred";
                String string2 = "No message provided";
                if (this.getException() != null) {
                    string1 = this.getException().getClass().getSimpleName();
                    string2 = this.getException().getMessage();
                }
                Object[] strings = new Object[]{this.getRepositoryUrl(), string1, string2};
                return NLS.bind((String)BugzillaMessages.errorIo, (Object[])strings);
            }
            case 7: {
                return NLS.bind((String)BugzillaMessages.errorInternal, (Object)this.errorMessage);
            }
            case 8: {
                return NLS.bind((String)BugzillaMessages.operationCancelled, (Object)this.errorMessage);
            }
            case 6: {
                return NLS.bind((String)BugzillaMessages.repositoryCollision, (Object)this.errorMessage);
            }
            case 9: {
                if (this.errorMessage == null) {
                    return BugzillaMessages.repositoryCommentRequired;
                }
                return this.errorMessage;
            }
        }
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        if (this.getException() != null) {
            String message = this.getException().getMessage();
            if (message != null) {
                return message;
            }
            return this.getException().toString();
        }
        return "Unknown";
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }
}

