/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.editor;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaCcAttributeEditor;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaKeywordAttributeEditor;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaPeoplePart;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaPlanningEditorPart;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaVotesEditor;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorPartDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaTaskEditorPage
extends AbstractTaskEditorPage {
    public static final String ID_PART_BUGZILLA_PLANNING = "org.eclipse.mylyn.bugzilla.ui.editors.part.planning";

    public BugzillaTaskEditorPage(TaskEditor editor) {
        super(editor, "bugzilla");
    }

    protected Set<TaskEditorPartDescriptor> createPartDescriptors() {
        Set descriptors = super.createPartDescriptors();
        for (TaskEditorPartDescriptor taskEditorPartDescriptor : descriptors) {
            if (!taskEditorPartDescriptor.getId().equals("org.eclipse.mylyn.tasks.ui.editors.parts.people")) continue;
            descriptors.remove(taskEditorPartDescriptor);
            break;
        }
        try {
            TaskAttribute attrEstimatedTime;
            TaskData data = TasksUi.getTaskDataManager().getTaskData(this.getTask());
            if (data != null && (attrEstimatedTime = data.getRoot().getMappedAttribute(BugzillaAttribute.ESTIMATED_TIME.getKey())) != null) {
                descriptors.add(new TaskEditorPartDescriptor(ID_PART_BUGZILLA_PLANNING){

                    public AbstractTaskEditorPart createPart() {
                        return new BugzillaPlanningEditorPart();
                    }
                }.setPath("attributes"));
            }
        }
        catch (CoreException coreException) {}
        descriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.people"){

            public AbstractTaskEditorPart createPart() {
                return new BugzillaPeoplePart();
            }
        }.setPath("people"));
        return descriptors;
    }

    protected AttributeEditorFactory createAttributeEditorFactory() {
        AttributeEditorFactory factory = new AttributeEditorFactory(this.getModel(), this.getTaskRepository()){

            public AbstractAttributeEditor createEditor(String type, TaskAttribute taskAttribute) {
                AbstractAttributeEditor editor;
                if ("bugzilla.editor.keywords".equals(type)) {
                    editor = new BugzillaKeywordAttributeEditor(BugzillaTaskEditorPage.this.getModel(), taskAttribute);
                } else if ("bugzilla.editor.removecc".equals(type)) {
                    editor = new BugzillaCcAttributeEditor(BugzillaTaskEditorPage.this.getModel(), taskAttribute);
                } else if ("bugzilla.editor.votes".equals(type)) {
                    editor = new BugzillaVotesEditor(BugzillaTaskEditorPage.this.getModel(), taskAttribute);
                } else {
                    editor = super.createEditor(type, taskAttribute);
                    if ("boolean".equals(type)) {
                        editor.setDecorationEnabled(false);
                    }
                }
                return editor;
            }
        };
        return factory;
    }
}

