/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.ui;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.window.Window;
import org.eclipse.mylyn.internal.commons.ui.ColorCanvas;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ColorSelectionWindow
extends Window {
    private ColorCanvas[] colors;
    private RGB selectedRGB;

    public ColorSelectionWindow(Shell shell) {
        super(shell);
        this.setShellStyle(2048);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                ColorSelectionWindow.this.close();
            }
        });
    }

    protected Control createContents(Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        colorComposite.setBackground(this.getShell().getDisplay().getSystemColor(2));
        colorComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        colorComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(8).spacing(1, 1).margins(1, 1).equalWidth(true).create());
        this.colors = new ColorCanvas[16];
        this.colors[0] = this.createColorCanvas(colorComposite, new RGB(0, 0, 0));
        this.colors[1] = this.createColorCanvas(colorComposite, new RGB(0, 0, 170));
        this.colors[2] = this.createColorCanvas(colorComposite, new RGB(0, 170, 0));
        this.colors[3] = this.createColorCanvas(colorComposite, new RGB(0, 170, 170));
        this.colors[4] = this.createColorCanvas(colorComposite, new RGB(170, 0, 0));
        this.colors[5] = this.createColorCanvas(colorComposite, new RGB(170, 0, 170));
        this.colors[6] = this.createColorCanvas(colorComposite, new RGB(170, 85, 0));
        this.colors[7] = this.createColorCanvas(colorComposite, new RGB(170, 170, 170));
        this.colors[8] = this.createColorCanvas(colorComposite, new RGB(85, 85, 85));
        this.colors[9] = this.createColorCanvas(colorComposite, new RGB(85, 85, 255));
        this.colors[10] = this.createColorCanvas(colorComposite, new RGB(85, 255, 85));
        this.colors[11] = this.createColorCanvas(colorComposite, new RGB(85, 255, 255));
        this.colors[12] = this.createColorCanvas(colorComposite, new RGB(255, 85, 85));
        this.colors[13] = this.createColorCanvas(colorComposite, new RGB(255, 85, 255));
        this.colors[14] = this.createColorCanvas(colorComposite, new RGB(255, 255, 85));
        this.colors[15] = this.createColorCanvas(colorComposite, new RGB(255, 255, 255));
        Button closeButton = new Button(parent, 8);
        closeButton.setText("&Close");
        closeButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorSelectionWindow.this.close();
            }
        });
        return parent;
    }

    private ColorCanvas createColorCanvas(Composite parent, RGB rgb) {
        final ColorCanvas canvas = new ColorCanvas(parent, 0, rgb);
        canvas.setLayoutData(GridDataFactory.fillDefaults().hint(16, 16).create());
        canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ColorSelectionWindow.this.selectedRGB = canvas.getRGB();
                ColorSelectionWindow.this.close();
            }
        });
        return canvas;
    }

    public RGB getSelectedRGB() {
        return this.selectedRGB;
    }
}

