/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.commons.ui;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.progress.WorkbenchJob;

public abstract class DelayedRefreshJob
extends WorkbenchJob {
    static final long REFRESH_DELAY_DEFAULT = 200L;
    static final long REFRESH_DELAY_MAX = 400L;
    protected final StructuredViewer viewer;
    private static final int NOT_SCHEDULED = -1;
    private final LinkedHashSet<Object> queue = new LinkedHashSet();
    private long scheduleTime = -1L;

    public DelayedRefreshJob(StructuredViewer viewer, String name) {
        super(name);
        Assert.isNotNull((Object)viewer);
        this.viewer = viewer;
        this.setSystem(true);
    }

    public void refreshNow() {
        this.queue.add(null);
        this.runInUIThread((IProgressMonitor)new NullProgressMonitor());
    }

    public synchronized void refresh() {
        this.refreshElement(null);
    }

    public synchronized void refreshElements(Object[] elements) {
        this.queue.addAll((Collection<Object>)Arrays.asList(elements));
        if (this.scheduleTime == -1L) {
            this.scheduleTime = System.currentTimeMillis();
            this.schedule(200L);
        } else if (System.currentTimeMillis() - this.scheduleTime < 200L) {
            this.cancel();
            this.schedule(200L);
        }
    }

    public synchronized void refreshElement(Object element) {
        this.refreshElements(new Object[]{element});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus runInUIThread(IProgressMonitor monitor) {
        Object[] items;
        if (this.viewer.getControl() == null || this.viewer.getControl().isDisposed()) {
            return Status.CANCEL_STATUS;
        }
        DelayedRefreshJob delayedRefreshJob = this;
        synchronized (delayedRefreshJob) {
            items = this.queue.contains(null) ? (Object[])null : this.queue.toArray(new Object[0]);
            this.queue.clear();
            this.scheduleTime = -1L;
        }
        this.doRefresh(items);
        return Status.OK_STATUS;
    }

    protected abstract void doRefresh(Object[] var1);
}

