/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.data;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITaskListRunnable;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskDataStorageManager;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.core.data.ITaskDataManagerListener;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManagerEvent;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataState;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataStore;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryTaskAttribute;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.ITaskDataManager;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDataManager
implements ITaskDataManager {
    private static final String ENCODING_UTF_8 = "UTF-8";
    private static final String EXTENSION = ".zip";
    private static final String FOLDER_TASKS = "tasks";
    private static final String FOLDER_DATA = "offline";
    private static final String FOLDER_TASKS_1_0 = "offline";
    private String dataPath;
    private final IRepositoryManager repositoryManager;
    @Deprecated
    private final TaskDataStorageManager taskDataStorageManager;
    private final TaskDataStore taskDataStore;
    private final TaskList taskList;
    private final TaskActivityManager taskActivityManager;
    private final List<ITaskDataManagerListener> listeners = new CopyOnWriteArrayList<ITaskDataManagerListener>();

    public TaskDataManager(TaskDataStorageManager taskDataManager, TaskDataStore taskDataStore, IRepositoryManager repositoryManager, TaskList taskList, TaskActivityManager taskActivityManager) {
        this.taskDataStorageManager = taskDataManager;
        this.taskDataStore = taskDataStore;
        this.repositoryManager = repositoryManager;
        this.taskList = taskList;
        this.taskActivityManager = taskActivityManager;
    }

    public void addListener(ITaskDataManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ITaskDataManagerListener listener) {
        this.listeners.remove(listener);
    }

    @Deprecated
    public boolean checkHasIncoming(ITask repositoryTask, RepositoryTaskData newData) {
        if (repositoryTask.getSynchronizationState() == ITask.SynchronizationState.INCOMING) {
            return true;
        }
        String lastModified = ((AbstractTask)repositoryTask).getLastReadTimeStamp();
        RepositoryTaskAttribute modifiedDateAttribute = newData.getAttribute("task.common.date.modified");
        if (lastModified != null && modifiedDateAttribute != null && modifiedDateAttribute.getValue() != null) {
            if (lastModified.trim().compareTo(modifiedDateAttribute.getValue().trim()) == 0) {
                return false;
            }
            Date modifiedDate = newData.getAttributeFactory().getDateForAttributeType("task.common.date.modified", modifiedDateAttribute.getValue());
            Date lastModifiedDate = newData.getAttributeFactory().getDateForAttributeType("task.common.date.modified", lastModified);
            if (modifiedDate != null && lastModifiedDate != null && modifiedDate.equals(lastModifiedDate)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public ITaskDataWorkingCopy createWorkingCopy(ITask task, TaskData taskData) {
        Assert.isNotNull((Object)task);
        TaskDataState state = new TaskDataState(taskData.getConnectorKind(), taskData.getRepositoryUrl(), taskData.getTaskId());
        state.setRepositoryData(taskData);
        state.setLastReadData(taskData);
        state.init(this, task);
        state.setSaved(false);
        state.revert();
        return state;
    }

    @Override
    public ITaskDataWorkingCopy getWorkingCopy(ITask itask) throws CoreException {
        return this.getWorkingCopy(itask, true);
    }

    public ITaskDataWorkingCopy getWorkingCopy(ITask itask, final boolean markRead) throws CoreException {
        final AbstractTask task = (AbstractTask)itask;
        Assert.isNotNull((Object)task);
        final String kind = task.getConnectorKind();
        final TaskDataState[] result = new TaskDataState[1];
        this.taskList.run(new ITaskListRunnable(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                File file = TaskDataManager.this.getMigratedFile(task, kind);
                TaskDataState state = TaskDataManager.this.taskDataStore.getTaskDataState(file);
                if (state == null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Task data at \"" + file + "\" not found"));
                }
                if (task.isMarkReadPending()) {
                    state.setLastReadData(state.getRepositoryData());
                }
                state.init(TaskDataManager.this, task);
                state.revert();
                if (markRead) {
                    switch (task.getSynchronizationState()) {
                        case INCOMING: 
                        case INCOMING_NEW: {
                            task.setSynchronizationState(ITask.SynchronizationState.SYNCHRONIZED);
                            task.setLastReadTimeStamp(new Date().toString());
                            break;
                        }
                        case CONFLICT: {
                            task.setSynchronizationState(ITask.SynchronizationState.OUTGOING);
                        }
                    }
                    task.setMarkReadPending(true);
                }
                result[0] = state;
            }
        });
        this.taskList.notifyElementChanged(task);
        return result[0];
    }

    public void saveWorkingCopy(ITask itask, final TaskDataState state) throws CoreException {
        final AbstractTask task = (AbstractTask)itask;
        Assert.isNotNull((Object)task);
        final String kind = task.getConnectorKind();
        this.taskList.run(new ITaskListRunnable(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                File file = TaskDataManager.this.getFile(task, kind);
                TaskDataManager.this.taskDataStore.putTaskData(TaskDataManager.this.ensurePathExists(file), state);
                switch (task.getSynchronizationState()) {
                    case SYNCHRONIZED: {
                        task.setSynchronizationState(ITask.SynchronizationState.OUTGOING);
                    }
                }
                TaskDataManager.this.taskList.addTask(task);
            }
        });
        this.taskList.notifyElementChanged(task);
    }

    public void putUpdatedTaskData(ITask itask, TaskData taskData, boolean user) throws CoreException {
        this.putUpdatedTaskData(itask, taskData, user, null);
    }

    public void putUpdatedTaskData(ITask itask, final TaskData taskData, final boolean user, Object token) throws CoreException {
        final AbstractTask task = (AbstractTask)itask;
        Assert.isNotNull((Object)task);
        Assert.isNotNull((Object)taskData);
        final AbstractRepositoryConnector connector = this.repositoryManager.getRepositoryConnector(task.getConnectorKind());
        final TaskRepository repository = this.repositoryManager.getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        final boolean taskDataChanged = connector.hasTaskChanged(repository, task, taskData);
        final TaskDataManagerEvent event = new TaskDataManagerEvent(this, itask, taskData, token);
        event.setTaskDataChanged(taskDataChanged);
        final boolean[] synchronizationStateChanged = new boolean[1];
        if (taskDataChanged || user) {
            this.taskList.run(new ITaskListRunnable(){

                public void execute(IProgressMonitor monitor) throws CoreException {
                    boolean newTask = false;
                    if (!taskData.isPartial()) {
                        File file = TaskDataManager.this.getMigratedFile(task, task.getConnectorKind());
                        newTask = !file.exists();
                        TaskDataManager.this.taskDataStore.putTaskData(TaskDataManager.this.ensurePathExists(file), taskData, task.isMarkReadPending(), user);
                        task.setMarkReadPending(false);
                        event.setTaskDataUpdated(true);
                    }
                    boolean taskChanged = TaskDataManager.this.updateTaskFromTaskData(taskData, task, connector, repository);
                    event.setTaskChanged(taskChanged);
                    if (taskDataChanged) {
                        switch (task.getSynchronizationState()) {
                            case OUTGOING: {
                                task.setSynchronizationState(ITask.SynchronizationState.CONFLICT);
                                break;
                            }
                            case SYNCHRONIZED: {
                                if (newTask) {
                                    task.setSynchronizationState(ITask.SynchronizationState.INCOMING_NEW);
                                    task.setLastReadTimeStamp(null);
                                    break;
                                }
                                task.setSynchronizationState(ITask.SynchronizationState.INCOMING);
                            }
                        }
                    }
                    if (task.isSynchronizing()) {
                        task.setSynchronizing(false);
                        synchronizationStateChanged[0] = true;
                    }
                }
            });
        } else {
            this.taskList.run(new ITaskListRunnable(){

                public void execute(IProgressMonitor monitor) throws CoreException {
                    if (task.isSynchronizing()) {
                        task.setSynchronizing(false);
                        synchronizationStateChanged[0] = true;
                    }
                }
            });
        }
        if (event.getTaskChanged() || event.getTaskDataChanged()) {
            this.taskList.notifyElementChanged(task);
            this.fireTaskDataUpdated(event);
        } else {
            if (synchronizationStateChanged[0]) {
                this.taskList.notifySynchronizationStateChanged(task);
            }
            if (event.getTaskDataUpdated()) {
                this.fireTaskDataUpdated(event);
            }
        }
    }

    private boolean updateTaskFromTaskData(TaskData taskData, AbstractTask task, AbstractRepositoryConnector connector, TaskRepository repository) {
        task.setChanged(false);
        Date oldDueDate = task.getDueDate();
        connector.updateTaskFromTaskData(repository, task, taskData);
        Date newDueDate = task.getDueDate();
        if (oldDueDate != null && !oldDueDate.equals(newDueDate) || newDueDate != oldDueDate) {
            this.taskActivityManager.setDueDate(task, newDueDate);
        }
        return task.isChanged();
    }

    private File ensurePathExists(File file) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return file;
    }

    private File getMigratedFile(ITask task, String kind) throws CoreException {
        File oldFile;
        Assert.isNotNull((Object)task);
        Assert.isNotNull((Object)kind);
        File file = this.getFile(task, kind);
        if (!file.exists() && (oldFile = this.getFile10(task, kind)).exists()) {
            TaskDataState state = this.taskDataStore.getTaskDataState(oldFile);
            this.taskDataStore.putTaskData(this.ensurePathExists(file), state);
        }
        return file;
    }

    @Override
    public void discardEdits(ITask itask) throws CoreException {
        final AbstractTask task = (AbstractTask)itask;
        Assert.isNotNull((Object)task);
        final String kind = task.getConnectorKind();
        this.taskList.run(new ITaskListRunnable(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                File dataFile = TaskDataManager.this.getFile(task, kind);
                if (dataFile.exists()) {
                    TaskDataManager.this.taskDataStore.discardEdits(dataFile);
                }
                switch (task.getSynchronizationState()) {
                    case OUTGOING: {
                        task.setSynchronizationState(ITask.SynchronizationState.SYNCHRONIZED);
                        break;
                    }
                    case CONFLICT: {
                        task.setSynchronizationState(ITask.SynchronizationState.INCOMING);
                    }
                }
            }
        });
        this.taskList.notifyElementChanged(task);
        TaskDataManagerEvent event = new TaskDataManagerEvent(this, itask);
        this.fireEditsDiscarded(event);
    }

    @Deprecated
    public void discardOutgoing(AbstractTask repositoryTask) {
        this.taskDataStorageManager.discardEdits(repositoryTask.getRepositoryUrl(), repositoryTask.getTaskId());
        repositoryTask.setSynchronizationState(ITask.SynchronizationState.SYNCHRONIZED);
    }

    private File findFile(ITask task, String kind) {
        File file = this.getFile(task, kind);
        if (file.exists()) {
            return file;
        }
        return this.getFile10(task, kind);
    }

    public String getDataPath() {
        return this.dataPath;
    }

    private File getFile(ITask task, String kind) {
        return this.getFile(task.getRepositoryUrl(), task, kind);
    }

    private File getFile(String repositoryUrl, ITask task, String kind) {
        try {
            String repositoryPath = String.valueOf(task.getConnectorKind()) + "-" + this.encode(repositoryUrl);
            String fileName = String.valueOf(this.encode(task.getTaskId())) + EXTENSION;
            File path = new File(String.valueOf(this.dataPath) + File.separator + FOLDER_TASKS + File.separator + repositoryPath + File.separator + "offline");
            return new File(path, fileName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String encode(String text) throws UnsupportedEncodingException {
        char[] chars;
        StringBuffer sb = new StringBuffer(text.length());
        char[] cArray = chars = text.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '.') {
                sb.append(c);
            } else {
                sb.append("%" + Integer.toHexString(c).toUpperCase());
            }
            ++n2;
        }
        return sb.toString();
    }

    private File getFile10(ITask task, String kind) {
        try {
            String pathName = URLEncoder.encode(task.getRepositoryUrl(), ENCODING_UTF_8);
            String fileName = String.valueOf(task.getTaskId()) + EXTENSION;
            File path = new File(String.valueOf(this.dataPath) + File.separator + "offline", pathName);
            return new File(path, fileName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TaskData getTaskData(ITask task) throws CoreException {
        Assert.isNotNull((Object)task);
        String kind = task.getConnectorKind();
        TaskDataState state = this.taskDataStore.getTaskDataState(this.findFile(task, kind));
        if (state == null) {
            return null;
        }
        return state.getRepositoryData();
    }

    public TaskDataState getTaskDataState(ITask task) throws CoreException {
        Assert.isNotNull((Object)task);
        String kind = task.getConnectorKind();
        return this.taskDataStore.getTaskDataState(this.findFile(task, kind));
    }

    @Override
    public TaskData getTaskData(TaskRepository taskRepository, String taskId) throws CoreException {
        Assert.isNotNull((Object)((Object)taskRepository));
        Assert.isNotNull((Object)taskId);
        TaskDataState state = this.taskDataStore.getTaskDataState(this.findFile(new TaskTask(taskRepository.getConnectorKind(), taskRepository.getRepositoryUrl(), taskId), taskRepository.getConnectorKind()));
        if (state == null) {
            return null;
        }
        return state.getRepositoryData();
    }

    @Override
    public boolean hasTaskData(ITask task) {
        Assert.isNotNull((Object)task);
        String kind = task.getConnectorKind();
        return this.findFile(task, kind).exists();
    }

    public void putSubmittedTaskData(ITask itask, final TaskData taskData) throws CoreException {
        final AbstractTask task = (AbstractTask)itask;
        Assert.isNotNull((Object)task);
        Assert.isNotNull((Object)taskData);
        final AbstractRepositoryConnector connector = this.repositoryManager.getRepositoryConnector(task.getConnectorKind());
        final TaskRepository repository = this.repositoryManager.getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        final TaskDataManagerEvent event = new TaskDataManagerEvent(this, itask, taskData, null);
        event.setTaskDataChanged(true);
        this.taskList.run(new ITaskListRunnable(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                if (!taskData.isPartial()) {
                    File file = TaskDataManager.this.getMigratedFile(task, task.getConnectorKind());
                    TaskDataManager.this.taskDataStore.setTaskData(TaskDataManager.this.ensurePathExists(file), taskData);
                    task.setMarkReadPending(false);
                    event.setTaskDataUpdated(true);
                }
                boolean taskChanged = TaskDataManager.this.updateTaskFromTaskData(taskData, task, connector, repository);
                event.setTaskChanged(taskChanged);
                task.setSynchronizationState(ITask.SynchronizationState.SYNCHRONIZED);
                task.setSynchronizing(false);
            }
        });
        this.taskList.notifyElementChanged(task);
        this.fireTaskDataUpdated(event);
    }

    @Deprecated
    public synchronized boolean saveIncoming(ITask itask, RepositoryTaskData newTaskData, boolean forceSync) {
        AbstractTask task = (AbstractTask)itask;
        Assert.isNotNull((Object)newTaskData);
        ITask.SynchronizationState startState = task.getSynchronizationState();
        ITask.SynchronizationState status = task.getSynchronizationState();
        RepositoryTaskData previousTaskData = this.taskDataStorageManager.getNewTaskData(task.getRepositoryUrl(), task.getTaskId());
        if (task.isSubmitting()) {
            status = ITask.SynchronizationState.SYNCHRONIZED;
            task.setSubmitting(false);
            TaskDataStorageManager dataManager = this.taskDataStorageManager;
            dataManager.discardEdits(task.getRepositoryUrl(), task.getTaskId());
            this.taskDataStorageManager.setNewTaskData(newTaskData);
        } else {
            switch (status) {
                case OUTGOING: {
                    if (this.checkHasIncoming(task, newTaskData)) {
                        status = ITask.SynchronizationState.CONFLICT;
                    }
                    this.taskDataStorageManager.setNewTaskData(newTaskData);
                    break;
                }
                case CONFLICT: 
                case INCOMING: {
                    this.taskDataStorageManager.setNewTaskData(newTaskData);
                    break;
                }
                case SYNCHRONIZED: {
                    boolean hasIncoming = this.checkHasIncoming(task, newTaskData);
                    if (hasIncoming) {
                        status = ITask.SynchronizationState.INCOMING;
                        task.setNotified(false);
                    }
                    if (!hasIncoming && previousTaskData != null && !forceSync) break;
                    this.taskDataStorageManager.setNewTaskData(newTaskData);
                }
            }
        }
        task.setSynchronizationState(status);
        return startState != task.getSynchronizationState();
    }

    @Deprecated
    public void saveOffline(ITask task, RepositoryTaskData taskData) {
        this.taskDataStorageManager.setNewTaskData(taskData);
    }

    @Deprecated
    public synchronized void saveOutgoing(AbstractTask repositoryTask, Set<RepositoryTaskAttribute> modifiedAttributes) {
        repositoryTask.setSynchronizationState(ITask.SynchronizationState.OUTGOING);
        this.taskDataStorageManager.saveEdits(repositoryTask.getRepositoryUrl(), repositoryTask.getTaskId(), Collections.unmodifiableSet(modifiedAttributes));
        this.taskList.notifyElementChanged(repositoryTask);
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setTaskRead(ITask itask, final boolean read) {
        final AbstractTask task = (AbstractTask)itask;
        Assert.isNotNull((Object)task);
        if (task.getClass() != TaskTask.class) {
            this.setTaskReadDeprecated(task, read);
            return;
        }
        try {
            this.taskList.run(new ITaskListRunnable(){

                public void execute(IProgressMonitor monitor) throws CoreException {
                    if (read) {
                        task.setLastReadTimeStamp(new Date().toString());
                        switch (task.getSynchronizationState()) {
                            case INCOMING: 
                            case INCOMING_NEW: {
                                task.setSynchronizationState(ITask.SynchronizationState.SYNCHRONIZED);
                                task.setMarkReadPending(true);
                                break;
                            }
                            case CONFLICT: {
                                task.setSynchronizationState(ITask.SynchronizationState.OUTGOING);
                                task.setMarkReadPending(true);
                            }
                        }
                    } else {
                        switch (task.getSynchronizationState()) {
                            case SYNCHRONIZED: {
                                task.setSynchronizationState(ITask.SynchronizationState.INCOMING);
                                task.setMarkReadPending(false);
                            }
                        }
                    }
                }
            });
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Unexpected error while marking task read", (Throwable)e));
        }
        this.taskList.notifyElementChanged(task);
    }

    @Deprecated
    private void setTaskReadDeprecated(ITask itask, boolean read) {
        AbstractTask task = (AbstractTask)itask;
        RepositoryTaskData taskData = this.taskDataStorageManager.getNewTaskData(task.getRepositoryUrl(), task.getTaskId());
        if (read && task.getSynchronizationState().equals((Object)ITask.SynchronizationState.INCOMING)) {
            if (taskData != null && taskData.getLastModified() != null) {
                task.setLastReadTimeStamp(taskData.getLastModified());
                this.taskDataStorageManager.setOldTaskData(taskData);
            }
            task.setSynchronizationState(ITask.SynchronizationState.SYNCHRONIZED);
            this.taskList.notifyElementChanged(task);
        } else if (read && task.getSynchronizationState().equals((Object)ITask.SynchronizationState.CONFLICT)) {
            if (taskData != null && taskData.getLastModified() != null) {
                task.setLastReadTimeStamp(taskData.getLastModified());
            }
            task.setSynchronizationState(ITask.SynchronizationState.OUTGOING);
            this.taskList.notifyElementChanged(task);
        } else if (read && task.getSynchronizationState().equals((Object)ITask.SynchronizationState.SYNCHRONIZED)) {
            if (taskData != null && taskData.getLastModified() != null) {
                task.setLastReadTimeStamp(taskData.getLastModified());
                this.taskDataStorageManager.setOldTaskData(taskData);
            }
        } else if (!read && task.getSynchronizationState().equals((Object)ITask.SynchronizationState.SYNCHRONIZED)) {
            task.setSynchronizationState(ITask.SynchronizationState.INCOMING);
            this.taskList.notifyElementChanged(task);
        }
        if (read && taskData == null && task.isLocal()) {
            task.setLastReadTimeStamp(new Date().toString());
        }
    }

    void putEdits(ITask itask, final TaskData editsData) throws CoreException {
        final AbstractTask task = (AbstractTask)itask;
        Assert.isNotNull((Object)task);
        final String kind = task.getConnectorKind();
        Assert.isNotNull((Object)editsData);
        this.taskList.run(new ITaskListRunnable(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                TaskDataManager.this.taskDataStore.putEdits(TaskDataManager.this.getFile(task, kind), editsData);
                switch (task.getSynchronizationState()) {
                    case INCOMING: 
                    case INCOMING_NEW: {
                        task.setSynchronizationState(ITask.SynchronizationState.CONFLICT);
                        break;
                    }
                    case SYNCHRONIZED: {
                        task.setSynchronizationState(ITask.SynchronizationState.OUTGOING);
                    }
                }
            }
        });
        this.taskList.notifySynchronizationStateChanged(task);
    }

    @Deprecated
    public RepositoryTaskData getNewTaskData(String repositoryUrl, String taskId) {
        return this.taskDataStorageManager.getNewTaskData(repositoryUrl, taskId);
    }

    @Deprecated
    public void setNewTaskData(RepositoryTaskData taskData) {
        this.taskDataStorageManager.setNewTaskData(taskData);
    }

    @Deprecated
    public TaskDataStorageManager getTaskDataStorageManager() {
        return this.taskDataStorageManager;
    }

    private void fireTaskDataUpdated(final TaskDataManagerEvent event) {
        ITaskDataManagerListener[] array = this.listeners.toArray(new ITaskDataManagerListener[0]);
        if (array.length > 0) {
            ITaskDataManagerListener[] iTaskDataManagerListenerArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                final ITaskDataManagerListener listener = iTaskDataManagerListenerArray[n2];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        listener.taskDataUpdated(event);
                    }
                });
                ++n2;
            }
        }
    }

    private void fireEditsDiscarded(final TaskDataManagerEvent event) {
        ITaskDataManagerListener[] array = this.listeners.toArray(new ITaskDataManagerListener[0]);
        if (array.length > 0) {
            ITaskDataManagerListener[] iTaskDataManagerListenerArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                final ITaskDataManagerListener listener = iTaskDataManagerListenerArray[n2];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        listener.editsDiscarded(event);
                    }
                });
                ++n2;
            }
        }
    }

    public void refactorRepositoryUrl(ITask itask, final String newRepositoryUrl) throws CoreException {
        Assert.isTrue((boolean)(itask instanceof AbstractTask));
        final AbstractTask task = (AbstractTask)itask;
        final String kind = task.getConnectorKind();
        this.taskList.run(new ITaskListRunnable(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                TaskDataState oldState;
                File file = TaskDataManager.this.getMigratedFile(task, kind);
                if (file.exists() && (oldState = TaskDataManager.this.taskDataStore.getTaskDataState(file)) != null) {
                    File newFile = TaskDataManager.this.getFile(newRepositoryUrl, task, kind);
                    TaskDataState newState = new TaskDataState(oldState.getConnectorKind(), newRepositoryUrl, oldState.getTaskId());
                    newState.merge(oldState);
                    TaskDataManager.this.taskDataStore.putTaskData(TaskDataManager.this.ensurePathExists(newFile), newState);
                }
            }
        });
    }
}

