/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.deprecated;

import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryTaskAttribute;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.ITask;

@Deprecated
public class DefaultTaskSchema {
    private final RepositoryTaskData taskData;

    public DefaultTaskSchema(RepositoryTaskData taskData) {
        Assert.isNotNull((Object)taskData);
        this.taskData = taskData;
    }

    public boolean applyTo(ITask task) {
        boolean changed = false;
        if (this.hasTaskPropertyChanged(task.getCompletionDate(), this.getCompletionDate())) {
            task.setCompletionDate(this.getCompletionDate());
            changed = true;
        }
        if (this.hasTaskPropertyChanged(task.getSummary(), this.getSummary())) {
            task.setSummary(this.getSummary());
            changed = true;
        }
        if (this.hasTaskPropertyChanged(task.getDueDate(), this.getDueDate())) {
            task.setDueDate(this.getDueDate());
            changed = true;
        }
        if (this.hasTaskPropertyChanged(task.getOwner(), this.getOwner())) {
            task.setOwner(this.getOwner());
            changed = true;
        }
        if (this.getPriority() != null && this.hasTaskPropertyChanged(task.getPriority(), this.getPriority().toString())) {
            task.setPriority(this.getPriority().toString());
            changed = true;
        }
        if (this.hasTaskPropertyChanged(task.getUrl(), this.getTaskUrl())) {
            task.setUrl(this.getTaskUrl());
            changed = true;
        }
        if (this.hasTaskPropertyChanged(task.getTaskKind(), this.getTaskKind())) {
            task.setTaskKind(this.getTaskKind());
            changed = true;
        }
        return changed;
    }

    public boolean getBooleanValue(String attributeKey) {
        RepositoryTaskAttribute attribute = this.taskData.getAttribute(attributeKey);
        if (attribute != null) {
            return Boolean.parseBoolean(attribute.getValue());
        }
        return false;
    }

    public String getComponent() {
        return this.getValue("task.common.component");
    }

    public Date getCreationDate() {
        return this.getDateValue("task.common.date.created");
    }

    public Date getCompletionDate() {
        return this.getDateValue("task.common.date.completed");
    }

    public Date getModificationDate() {
        return this.getDateValue("task.common.date.modified");
    }

    private Date getDateValue(String attributeKey) {
        RepositoryTaskAttribute attribute = this.taskData.getAttribute(attributeKey);
        if (attribute != null) {
            return this.taskData.getAttributeFactory().getDateForAttributeType(attributeKey, attribute.getValue());
        }
        return null;
    }

    public String getDescription() {
        return this.getValue("task.common.description");
    }

    public Date getDueDate() {
        return this.getDateValue("task.common.date.due");
    }

    public String getOwner() {
        return this.getValue("task.common.user.assigned");
    }

    public ITask.PriorityLevel getPriority() {
        String value = this.getValue("task.common.priority");
        return value != null ? ITask.PriorityLevel.fromString(value) : null;
    }

    public String getProduct() {
        return this.getValue("task.common.product");
    }

    public String getSummary() {
        return this.getValue("task.common.summary");
    }

    public String getTaskKind() {
        return this.taskData.getTaskKind();
    }

    public String getTaskUrl() {
        return this.getValue("task.common.url");
    }

    public String getValue(String attributeKey) {
        RepositoryTaskAttribute attribute = this.taskData.getAttribute(attributeKey);
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    protected final boolean hasTaskPropertyChanged(Object existingProperty, Object newProperty) {
        if (newProperty == null) {
            return false;
        }
        return existingProperty == null ? true : !existingProperty.equals(newProperty);
    }

    public RepositoryTaskAttribute setBooleanValue(String attributeKey, boolean value) {
        RepositoryTaskAttribute attribute = this.taskData.getAttribute(attributeKey);
        if (attribute == null) {
            attribute = new RepositoryTaskAttribute(attributeKey, null, false);
            this.taskData.addAttribute(attributeKey, attribute);
        }
        attribute.setValue(String.valueOf(value));
        return attribute;
    }

    public void setComponent(String component) {
        this.setValue("task.common.component", component);
    }

    public void setCreationDate(Date dateCreated) {
        this.setDateValue("task.common.date.created", dateCreated);
    }

    public void setCompletionDate(Date dateCompleted) {
        this.setDateValue("task.common.date.completed", dateCompleted);
    }

    public void setModificationDate(Date dateModified) {
        this.setDateValue("task.common.date.modified", dateModified);
    }

    private RepositoryTaskAttribute setDateValue(String attributeKey, Date value) {
        RepositoryTaskAttribute attribute = this.taskData.getAttribute(attributeKey);
        if (attribute == null) {
            attribute = new RepositoryTaskAttribute(attributeKey, null, false);
            this.taskData.addAttribute(attributeKey, attribute);
        }
        attribute.setValue(value.toString());
        return attribute;
    }

    public void setDescription(String description) {
        this.setValue("task.common.description", description);
    }

    public void setDueDate(Date value) {
        this.setDateValue("task.common.date.due", value);
    }

    public void setOwner(String owner) {
        this.setValue("task.common.user.assigned", owner);
    }

    public void setPriority(ITask.PriorityLevel priority) {
        this.setValue("task.common.priority", priority.toString());
    }

    public void setProduct(String product) {
        this.setValue("task.common.product", product);
    }

    public void setReporter(String reporter) {
        this.setValue("task.common.user.reporter", reporter);
    }

    public void setSummary(String summary) {
        this.setValue("task.common.summary", summary);
    }

    public void setTaskKind(String taskKind) {
        this.taskData.setTaskKind(taskKind);
    }

    public void setTaskUrl(String taskUrl) {
        this.setValue("task.common.url", taskUrl);
    }

    public RepositoryTaskAttribute setValue(String attributeKey, String value) {
        RepositoryTaskAttribute attribute = this.taskData.getAttribute(attributeKey);
        if (attribute == null) {
            attribute = new RepositoryTaskAttribute(attributeKey, null, false);
            this.taskData.addAttribute(attributeKey, attribute);
        }
        attribute.setValue(value);
        return attribute;
    }
}

