/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.ui.actions.AttachAction;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizardDialog;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.PlatformUI;

public class AttachScreenshotAction
extends AttachAction {
    public static final String LABEL = "Attach Screenshot...";

    public AttachScreenshotAction() {
        super(LABEL);
        this.setId("org.eclipse.mylyn.tasks.ui.actions.add.screenshot");
        this.setImageDescriptor(CommonImages.IMAGE_CAPTURE);
    }

    public void run() {
        Object selection;
        if (this.editor != null) {
            this.editor.showBusy(true);
        }
        if ((selection = super.getStructuredSelection().getFirstElement()) instanceof ITask) {
            if (this.taskDirty((ITask)selection)) {
                this.openInformationDialog(LABEL, "Submit changes or synchronize task before adding attachments.");
                return;
            }
            AbstractTask repositoryTask = (AbstractTask)selection;
            TaskRepository repository = TasksUi.getRepositoryManager().getRepository(repositoryTask.getConnectorKind(), repositoryTask.getRepositoryUrl());
            NewAttachmentWizard attachmentWizard = new NewAttachmentWizard(repository, repositoryTask, true);
            NewAttachmentWizardDialog dialog = new NewAttachmentWizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)attachmentWizard, false){

                public boolean close() {
                    boolean closed = super.close();
                    if (closed && AttachScreenshotAction.this.editor != null) {
                        AttachScreenshotAction.this.editor.showBusy(false);
                    }
                    return closed;
                }
            };
            attachmentWizard.setDialog(dialog);
            dialog.create();
            dialog.open();
        }
    }
}

