/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;

public class DeleteAction
extends Action {
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.delete";

    public DeleteAction() {
        this.setText("Delete");
        this.setId(ID);
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_DELETE"));
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    public void run() {
        Object object;
        ISelection selection = TaskListView.getFromActivePerspective().getViewer().getSelection();
        List toDelete = ((IStructuredSelection)selection).toList();
        String elements = "";
        int i = 0;
        for (Object object2 : toDelete) {
            if (object2 instanceof UnmatchedTaskContainer) continue;
            if (++i < 20) {
                if (!(object2 instanceof IRepositoryElement)) continue;
                elements = String.valueOf(elements) + "    " + ((IRepositoryElement)object2).getSummary() + "\n";
                continue;
            }
            elements = String.valueOf(elements) + "...";
            break;
        }
        String message = toDelete.size() == 1 ? ((object = toDelete.get(0)) instanceof ITask ? (((AbstractTask)object).isLocal() ? "Permanently delete the task listed below?" : "Delete the planning information and context for the repository task?  The server copy will not be deleted and the task will remain in queries that match it.") : (object instanceof TaskCategory ? "Permanently delete the category?  Local tasks will be moved to the Uncategorized folder. Repository tasks will be moved to the Unmatched folder." : (object instanceof IRepositoryQuery ? "Permanently delete the query?  Contained tasks will be moved to the Unmatched folder." : "Permanently delete the element listed below?"))) : "Delete the elements listed below?  If categories or queries are selected contained tasks will not be deleted.  Contexts will be deleted for selected tasks.";
        message = String.valueOf(message) + "\n\n" + elements;
        boolean deleteConfirmed = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Confirm Delete", (String)message);
        if (!deleteConfirmed) {
            return;
        }
        for (Object selectedObject : toDelete) {
            if (selectedObject instanceof ITask) {
                AbstractTask task = null;
                task = (AbstractTask)selectedObject;
                TasksUi.getTaskActivityManager().deactivateTask((ITask)task);
                TasksUiInternal.getTaskList().deleteTask((ITask)task);
                ContextCore.getContextManager().deleteContext(task.getHandleIdentifier());
                TasksUiInternal.closeEditorInActivePage((ITask)task, false);
                continue;
            }
            if (selectedObject instanceof IRepositoryQuery) {
                TasksUiInternal.getTaskList().deleteQuery((RepositoryQuery)selectedObject);
                continue;
            }
            if (selectedObject instanceof TaskCategory) {
                TaskCategory cat = (TaskCategory)selectedObject;
                for (ITask task : cat.getChildren()) {
                    ContextCore.getContextManager().deleteContext(task.getHandleIdentifier());
                    TasksUiInternal.closeEditorInActivePage(task, false);
                }
                TasksUiInternal.getTaskList().deleteCategory((AbstractTaskCategory)cat);
                continue;
            }
            if (selectedObject instanceof UnmatchedTaskContainer) continue;
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Delete failed", (String)"Nothing selected.");
            return;
        }
    }
}

