/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.DefaultHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonColors;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryCompletionProcessor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskRelationHyperlinkDetector;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskUrlHyperlinkDetector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TaskHyperlink;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class RepositoryTextViewerConfiguration
extends TextSourceViewerConfiguration {
    private static final String ID_CONTEXT_EDITOR_TASK = "org.eclipse.mylyn.tasks.ui.TaskEditor";
    private static final String ID_CONTEXT_EDITOR_TEXT = "org.eclipse.ui.DefaultTextEditor";
    private RepositoryTextScanner scanner;
    private final boolean spellCheck;
    private final TaskRepository taskRepository;
    private Mode mode;

    public RepositoryTextViewerConfiguration(TaskRepository taskRepository, boolean spellCheck) {
        super(EditorsUI.getPreferenceStore());
        this.taskRepository = taskRepository;
        this.spellCheck = spellCheck;
        this.mode = Mode.DEFAULT;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        Assert.isNotNull((Object)((Object)mode));
        this.mode = mode;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (this.getMode() == Mode.DEFAULT) {
            PresentationReconciler reconciler = new PresentationReconciler();
            reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getDefaultScanner());
            reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
            reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
            return reconciler;
        }
        return super.getPresentationReconciler(sourceViewer);
    }

    private RepositoryTextScanner getDefaultScanner() {
        if (this.scanner == null) {
            this.scanner = new RepositoryTextScanner(this.getMode());
        }
        return this.scanner;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (this.mode == Mode.URL) {
            return new IHyperlinkDetector[]{new TaskUrlHyperlinkDetector()};
        }
        if (this.mode == Mode.TASK_RELATION) {
            return new IHyperlinkDetector[]{new TaskRelationHyperlinkDetector()};
        }
        return super.getHyperlinkDetectors(sourceViewer);
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        IAdaptable context = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (adapter == TaskRepository.class) {
                    return RepositoryTextViewerConfiguration.this.getTaskRepository();
                }
                return null;
            }
        };
        HashMap<String, 1> targets = new HashMap<String, 1>();
        targets.put(ID_CONTEXT_EDITOR_TEXT, context);
        targets.put(ID_CONTEXT_EDITOR_TASK, context);
        return targets;
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
        return new TaskTextViewerHyperlinkPresenter(JFaceResources.getColorRegistry().get("ACTIVE_HYPERLINK_COLOR"), sourceViewer);
    }

    public int getHyperlinkStateMask(ISourceViewer sourceViewer) {
        return 0;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.spellCheck) {
            return super.getReconciler(sourceViewer);
        }
        return null;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.mode == Mode.URL) {
            return null;
        }
        ContentAssistant assistant = new ContentAssistant();
        RepositoryCompletionProcessor processor = new RepositoryCompletionProcessor(this.taskRepository);
        if (this.mode == Mode.TASK_RELATION) {
            processor.setNeverIncludePrefix(true);
        }
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        return assistant;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        URL,
        TASK_RELATION,
        DEFAULT;

    }

    private static class RepositoryTextScanner
    extends RuleBasedScanner {
        public RepositoryTextScanner(Mode mode) {
            Token bugToken = new Token((Object)new TextAttribute(JFaceResources.getColorRegistry().get("ACTIVE_HYPERLINK_COLOR")));
            Token quoteToken = new Token((Object)new TextAttribute(CommonColors.TEXT_QUOTED));
            IRule[] rules = new IRule[16];
            rules[0] = new SingleLineRule("http://", " ", (IToken)bugToken);
            rules[1] = new SingleLineRule("https://", " ", (IToken)bugToken);
            rules[2] = new SingleLineRule("bug#", " ", (IToken)bugToken);
            rules[3] = new SingleLineRule("bug#", "", (IToken)bugToken);
            rules[4] = new SingleLineRule("bug #", "", (IToken)bugToken);
            rules[5] = new SingleLineRule("http://", "\n", (IToken)bugToken);
            rules[6] = new SingleLineRule("https://", "\n", (IToken)bugToken);
            rules[7] = new SingleLineRule("task#", " ", (IToken)bugToken);
            rules[8] = new MultiLineRule("task#", "\n", (IToken)bugToken);
            rules[9] = new MultiLineRule("task# ", " ", (IToken)bugToken);
            rules[10] = new SingleLineRule("task #", "\n", (IToken)bugToken);
            rules[11] = new SingleLineRule("*** This bug has been ", "***", (IToken)bugToken);
            rules[12] = new SingleLineRule("http://", "", (IToken)bugToken);
            rules[13] = new SingleLineRule("https://", "", (IToken)bugToken);
            rules[14] = new MultiLineRule("task #", " ", (IToken)bugToken);
            SingleLineRule quoteRule = new SingleLineRule(">", null, (IToken)quoteToken, '\u0000', true);
            quoteRule.setColumnConstraint(0);
            rules[15] = quoteRule;
            this.setRules(rules);
        }
    }

    private final class TaskTextViewerHyperlinkPresenter
    extends DefaultHyperlinkPresenter {
        private final ISourceViewer sourceViewer;
        private IRegion activeRegion;
        private ITask currentTaskHyperlink;

        private TaskTextViewerHyperlinkPresenter(Color color, ISourceViewer sourceViewer) {
            super(color);
            this.sourceViewer = sourceViewer;
        }

        public void applyTextPresentation(TextPresentation textPresentation) {
            super.applyTextPresentation(textPresentation);
            if (this.activeRegion != null && this.currentTaskHyperlink != null && this.currentTaskHyperlink.isCompleted()) {
                Iterator styleRangeIterator = textPresentation.getAllStyleRangeIterator();
                while (styleRangeIterator.hasNext()) {
                    StyleRange styleRange = (StyleRange)styleRangeIterator.next();
                    if (this.activeRegion.getOffset() != styleRange.start || this.activeRegion.getLength() != styleRange.length) continue;
                    styleRange.strikeout = true;
                    break;
                }
            }
        }

        public void showHyperlinks(IHyperlink[] hyperlinks) {
            this.activeRegion = null;
            if (hyperlinks != null && hyperlinks.length > 0 && hyperlinks[0] instanceof TaskHyperlink) {
                String repositoryUrl;
                TaskHyperlink hyperlink = (TaskHyperlink)hyperlinks[0];
                TaskList taskList = TasksUiPlugin.getTaskList();
                ITask task = taskList.getTask(repositoryUrl = hyperlink.getRepository().getRepositoryUrl(), hyperlink.getTaskId());
                if (task == null) {
                    task = taskList.getTaskByKey(repositoryUrl, hyperlink.getTaskId());
                }
                if (task != null && task != this.currentTaskHyperlink) {
                    this.currentTaskHyperlink = task;
                    this.activeRegion = hyperlink.getHyperlinkRegion();
                    Control cursorControl = this.sourceViewer.getTextWidget().getDisplay().getCursorControl();
                    if (cursorControl != null) {
                        if (task.getTaskKey() == null) {
                            cursorControl.setToolTipText(task.getSummary());
                        } else {
                            cursorControl.setToolTipText(String.valueOf(task.getTaskKey()) + ": " + task.getSummary());
                        }
                    }
                }
            }
            super.showHyperlinks(hyperlinks);
        }

        public void hideHyperlinks() {
            Control cursorControl = this.sourceViewer.getTextWidget().getDisplay().getCursorControl();
            if (cursorControl != null) {
                cursorControl.setToolTipText(null);
            }
            this.currentTaskHyperlink = null;
            super.hideHyperlinks();
        }

        public void uninstall() {
            super.uninstall();
        }
    }
}

