/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTextViewer;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTextViewerConfiguration;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.themes.IThemeManager;

public class RichTextAttributeEditor
extends AbstractAttributeEditor {
    private RepositoryTextViewer viewer;
    private boolean spellCheckingEnabled;
    private final int style;
    private final TaskRepository taskRepository;
    private RepositoryTextViewerConfiguration.Mode mode;

    public RichTextAttributeEditor(TaskDataModel manager, TaskRepository taskRepository, TaskAttribute taskAttribute) {
        this(manager, taskRepository, taskAttribute, 2);
    }

    public RichTextAttributeEditor(TaskDataModel manager, TaskRepository taskRepository, TaskAttribute taskAttribute, int style) {
        super(manager, taskAttribute);
        this.taskRepository = taskRepository;
        this.style = style;
        if ((style & 2) != 0) {
            this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.MULTIPLE, LayoutHint.ColumnSpan.MULTIPLE));
        } else {
            this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.SINGLE, LayoutHint.ColumnSpan.MULTIPLE));
        }
        this.setMode(RepositoryTextViewerConfiguration.Mode.DEFAULT);
    }

    public RepositoryTextViewerConfiguration.Mode getMode() {
        return this.mode;
    }

    public void setMode(RepositoryTextViewerConfiguration.Mode mode) {
        Assert.isNotNull((Object)((Object)mode));
        this.mode = mode;
    }

    private void configureAsTextEditor(Document document) {
        AnnotationModel annotationModel = new AnnotationModel();
        this.viewer.showAnnotations(false);
        this.viewer.showAnnotationsOverview(false);
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        final SourceViewerDecorationSupport support = new SourceViewerDecorationSupport((ISourceViewer)this.viewer, null, (IAnnotationAccess)annotationAccess, EditorsUI.getSharedTextColors());
        Iterator e = new MarkerAnnotationPreferences().getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            support.setAnnotationPreference((AnnotationPreference)e.next());
        }
        support.install(EditorsUI.getPreferenceStore());
        this.viewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                support.uninstall();
            }
        });
        this.viewer.getTextWidget().setIndent(2);
        this.viewer.setDocument((IDocument)document, (IAnnotationModel)annotationModel);
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        int style = this.style;
        if (!this.isReadOnly() && (style & 0x10) == 0) {
            style |= 0x200;
        }
        this.viewer = new RepositoryTextViewer(this.taskRepository, parent, 0x800040 | style);
        RepositoryTextViewerConfiguration viewerConfig = new RepositoryTextViewerConfiguration(this.taskRepository, this.spellCheckingEnabled);
        viewerConfig.setMode(this.getMode());
        this.viewer.configure((SourceViewerConfiguration)viewerConfig);
        Document document = new Document(this.getValue());
        if (this.isReadOnly()) {
            this.viewer.setEditable(false);
            this.viewer.setDocument((IDocument)document);
        } else {
            this.viewer.setEditable(true);
            this.configureAsTextEditor(document);
            this.viewer.addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    String value = RichTextAttributeEditor.this.viewer.getTextWidget().getText();
                    if (!RichTextAttributeEditor.this.getValue().equals(value)) {
                        RichTextAttributeEditor.this.setValue(value);
                        EditorUtil.ensureVisible((Control)RichTextAttributeEditor.this.viewer.getTextWidget());
                    }
                }
            });
            this.viewer.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        }
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        Font font = themeManager.getCurrentTheme().getFontRegistry().get("org.eclipse.mylyn.tasks.ui.fonts.task.editor.comment");
        this.viewer.getTextWidget().setFont(font);
        toolkit.adapt((Control)this.viewer.getTextWidget(), false, false);
        this.setControl((Control)this.viewer.getTextWidget());
    }

    public String getValue() {
        return this.getAttributeMapper().getValue(this.getTaskAttribute());
    }

    public SourceViewer getViewer() {
        return this.viewer;
    }

    public boolean isSpellCheckingEnabled() {
        return this.spellCheckingEnabled;
    }

    public void setSpellCheckingEnabled(boolean spellCheckingEnabled) {
        this.spellCheckingEnabled = spellCheckingEnabled;
    }

    public void setValue(String value) {
        this.getAttributeMapper().setValue(this.getTaskAttribute(), value);
        this.attributeChanged();
    }
}

