/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.TaskComment;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractReplyToCommentAction;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class TaskEditorCommentPart
extends AbstractTaskEditorPart {
    private static final String KEY_EDITOR = "viewer";
    private static final String LABEL_REPLY = "Reply";
    private Section section;
    private List<ExpandableComposite> commentComposites;
    private List<TaskAttribute> comments;
    private boolean hasIncoming;

    public TaskEditorCommentPart() {
        this.setPartName("Comments");
    }

    private void expandComment(FormToolkit toolkit, Composite composite, Composite toolBarComposite, final TaskComment taskComment, boolean expanded) {
        toolBarComposite.setVisible(expanded);
        if (expanded && composite.getData(KEY_EDITOR) == null) {
            TaskAttribute textAttribute = this.getTaskData().getAttributeMapper().getAssoctiatedAttribute(taskComment.getTaskAttribute());
            AbstractAttributeEditor editor = this.createAttributeEditor(textAttribute);
            if (editor != null) {
                editor.setDecorationEnabled(false);
                editor.createControl(composite, toolkit);
                editor.getControl().addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDown(MouseEvent e) {
                        TaskEditorCommentPart.this.getTaskEditorPage().selectionChanged(taskComment);
                    }
                });
                composite.setData(KEY_EDITOR, (Object)editor);
                GridDataFactory.fillDefaults().minSize(500, 0).hint(500, -1).applyTo(editor.getControl());
                this.getTaskEditorPage().getAttributeEditorToolkit().adapt(editor);
                this.getTaskEditorPage().reflow();
            }
        } else if (!expanded && composite.getData(KEY_EDITOR) != null) {
            AbstractAttributeEditor editor = (AbstractAttributeEditor)composite.getData(KEY_EDITOR);
            editor.getControl().setMenu(null);
            editor.getControl().dispose();
            composite.setData(KEY_EDITOR, null);
            this.getTaskEditorPage().reflow();
        }
        this.getTaskEditorPage().selectionChanged(taskComment);
    }

    private void initialize() {
        this.comments = this.getTaskData().getAttributeMapper().getAttributesByType(this.getTaskData(), "comment");
        if (this.comments.size() > 0) {
            for (TaskAttribute commentAttribute : this.comments) {
                if (!this.getModel().hasIncomingChanges(commentAttribute)) continue;
                this.hasIncoming = true;
                break;
            }
        }
    }

    public void createControl(Composite parent, final FormToolkit toolkit) {
        this.initialize();
        this.section = this.createSection(parent, toolkit, this.hasIncoming);
        this.section.setText(String.valueOf(this.section.getText()) + " (" + this.comments.size() + ")");
        if (this.comments.isEmpty()) {
            this.section.setEnabled(false);
        } else if (this.hasIncoming) {
            this.expandSection(toolkit, this.section);
        } else {
            this.section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent event) {
                    if (TaskEditorCommentPart.this.commentComposites == null) {
                        TaskEditorCommentPart.this.expandSection(toolkit, TaskEditorCommentPart.this.section);
                        TaskEditorCommentPart.this.getTaskEditorPage().reflow();
                    }
                }
            });
        }
        this.setSection(toolkit, this.section);
    }

    private void expandSection(final FormToolkit toolkit, Section section) {
        Composite composite = toolkit.createComposite((Composite)section);
        section.setClient((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        this.commentComposites = new ArrayList<ExpandableComposite>();
        for (TaskAttribute commentAttribute : this.comments) {
            boolean hasIncomingChanges = this.getModel().hasIncomingChanges(commentAttribute);
            final TaskComment taskComment = new TaskComment(this.getModel().getTaskRepository(), this.getModel().getTask(), commentAttribute);
            this.getTaskData().getAttributeMapper().updateTaskComment((ITaskComment)taskComment, commentAttribute);
            int style = 8196;
            if (hasIncomingChanges) {
                style |= 0x40;
            }
            final ExpandableComposite commentComposite = toolkit.createExpandableComposite(composite, style);
            commentComposite.setLayout((Layout)new GridLayout());
            commentComposite.setLayoutData((Object)new GridData(768));
            commentComposite.setTitleBarForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            this.commentComposites.add(commentComposite);
            Composite titleComposite = toolkit.createComposite((Composite)commentComposite);
            commentComposite.setTextClient((Control)titleComposite);
            RowLayout rowLayout = new RowLayout();
            rowLayout.pack = true;
            rowLayout.marginLeft = 0;
            rowLayout.marginBottom = 0;
            rowLayout.marginTop = 0;
            titleComposite.setLayout((Layout)rowLayout);
            titleComposite.setBackground(null);
            ImageHyperlink expandCommentHyperlink = this.createTitleHyperLink(toolkit, titleComposite, (ITaskComment)taskComment);
            expandCommentHyperlink.setFont(commentComposite.getFont());
            expandCommentHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    EditorUtil.toggleExpandableComposite(!commentComposite.isExpanded(), commentComposite);
                }
            });
            final Composite buttonComposite = toolkit.createComposite(titleComposite);
            RowLayout buttonCompLayout = new RowLayout();
            buttonCompLayout.marginBottom = 0;
            buttonCompLayout.marginTop = 0;
            buttonComposite.setLayout((Layout)buttonCompLayout);
            buttonComposite.setBackground(null);
            buttonComposite.setVisible(commentComposite.isExpanded());
            this.createReplyHyperlink(buttonComposite, toolkit, (ITaskComment)taskComment);
            final Composite commentTextComposite = toolkit.createComposite((Composite)commentComposite);
            commentComposite.setClient((Control)commentTextComposite);
            GridLayout ecLayout = new GridLayout();
            ecLayout.marginHeight = 0;
            ecLayout.marginBottom = 3;
            ecLayout.marginLeft = 15;
            commentTextComposite.setLayout((Layout)ecLayout);
            commentTextComposite.setLayoutData((Object)new GridData(768));
            commentComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent event) {
                    TaskEditorCommentPart.this.expandComment(toolkit, commentTextComposite, buttonComposite, taskComment, event.getState());
                }
            });
            if (hasIncomingChanges) {
                commentComposite.setBackground(this.getTaskEditorPage().getAttributeEditorToolkit().getColorIncoming());
                this.expandComment(toolkit, commentTextComposite, buttonComposite, taskComment, true);
            }
            EditorUtil.setMarker((Widget)commentComposite, commentAttribute.getId());
        }
    }

    private ImageHyperlink createTitleHyperLink(FormToolkit toolkit, Composite toolbarComp, ITaskComment taskComment) {
        ImageHyperlink formHyperlink = toolkit.createImageHyperlink(toolbarComp, 0);
        formHyperlink.setBackground(null);
        formHyperlink.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        IRepositoryPerson author = taskComment.getAuthor();
        if (author != null && author.getPersonId().equalsIgnoreCase(this.getTaskEditorPage().getTaskRepository().getUserName())) {
            formHyperlink.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.PERSON_ME_NARROW));
        } else {
            formHyperlink.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.PERSON_NARROW));
        }
        StringBuilder sb = new StringBuilder();
        if (taskComment.getNumber() >= 0) {
            sb.append(taskComment.getNumber());
            sb.append(": ");
        }
        if (author != null) {
            if (author.getName() != null) {
                sb.append(author.getName());
                formHyperlink.setToolTipText(author.getPersonId());
            } else {
                sb.append(author.getPersonId());
            }
        }
        if (taskComment.getCreationDate() != null) {
            sb.append(", ");
            sb.append(EditorUtil.formatDateTime(taskComment.getCreationDate()));
        }
        formHyperlink.setText(sb.toString());
        formHyperlink.setEnabled(true);
        formHyperlink.setUnderlined(false);
        return formHyperlink;
    }

    private ImageHyperlink createReplyHyperlink(Composite composite, FormToolkit toolkit, final ITaskComment taskComment) {
        final ImageHyperlink replyLink = new ImageHyperlink(composite, 0);
        toolkit.adapt((Control)replyLink, false, false);
        replyLink.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.COMMENT_REPLY));
        replyLink.setToolTipText(LABEL_REPLY);
        replyLink.setBackground(null);
        replyLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AbstractReplyToCommentAction.reply(TaskEditorCommentPart.this.getTaskEditorPage(), taskComment, taskComment.getText());
            }

            public void linkEntered(HyperlinkEvent e) {
                replyLink.setUnderlined(true);
            }

            public void linkExited(HyperlinkEvent e) {
                replyLink.setUnderlined(false);
            }
        });
        return replyLink;
    }

    protected void fillToolBar(ToolBarManager barManager) {
        if (this.comments.isEmpty()) {
            return;
        }
        Action collapseAllAction = new Action(""){

            public void run() {
                TaskEditorCommentPart.this.hideAllComments();
            }
        };
        collapseAllAction.setImageDescriptor(CommonImages.COLLAPSE_ALL_SMALL);
        collapseAllAction.setToolTipText("Collapse All Comments");
        barManager.add((IAction)collapseAllAction);
        Action expandAllAction = new Action(""){

            public void run() {
                TaskEditorCommentPart.this.expandAllComments();
            }
        };
        expandAllAction.setImageDescriptor(CommonImages.EXPAND_ALL_SMALL);
        expandAllAction.setToolTipText("Expand All Comments");
        barManager.add((IAction)expandAllAction);
    }

    private void hideAllComments() {
        if (this.commentComposites != null) {
            try {
                this.getTaskEditorPage().setReflow(false);
                for (ExpandableComposite composite : this.commentComposites) {
                    if (composite.isDisposed() || !composite.isExpanded()) continue;
                    EditorUtil.toggleExpandableComposite(false, composite);
                }
            }
            finally {
                this.getTaskEditorPage().setReflow(true);
            }
            this.getTaskEditorPage().reflow();
        }
    }

    private void expandAllComments() {
        try {
            this.getTaskEditorPage().setReflow(false);
            if (this.section != null) {
                EditorUtil.toggleExpandableComposite(true, (ExpandableComposite)this.section);
            }
            for (ExpandableComposite composite : this.commentComposites) {
                if (composite.isDisposed() || composite.isExpanded()) continue;
                EditorUtil.toggleExpandableComposite(true, composite);
            }
        }
        finally {
            this.getTaskEditorPage().setReflow(true);
        }
        this.getTaskEditorPage().reflow();
    }
}

