/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UncategorizedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskKeyComparator;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TaskListTableSorter
extends ViewerSorter {
    private static final int DEFAULT_SORT_DIRECTION = 1;
    private int sortDirection = 1;
    private SortByIndex sortByIndex = SortByIndex.PRIORITY;
    private int sortDirection2 = 1;
    private SortByIndex sortByIndex2 = SortByIndex.DATE_CREATED;
    private final TaskListView view;
    private final TaskKeyComparator taskKeyComparator = new TaskKeyComparator();

    public TaskListTableSorter(TaskListView view) {
        this.view = view;
    }

    public TaskListTableSorter(TaskListView view, SortByIndex index) {
        this.view = view;
        this.sortByIndex = index;
    }

    public void setColumn(String column) {
        if (this.view.isFocusedMode()) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Task Sorting", (String)"Manual sorting is disabled in focused mode, sort order will not take effect until focused mode is disabled.");
        }
    }

    public int compare(Viewer compareViewer, Object o1, Object o2) {
        if (o1 instanceof ScheduledTaskContainer && o2 instanceof ScheduledTaskContainer) {
            ScheduledTaskContainer dateRangeTaskContainer1 = (ScheduledTaskContainer)o1;
            ScheduledTaskContainer dateRangeTaskContainer2 = (ScheduledTaskContainer)o2;
            return dateRangeTaskContainer1.getDateRange().compareTo(dateRangeTaskContainer2.getDateRange());
        }
        if (o1 instanceof ITaskContainer && o2 instanceof ScheduledTaskContainer) {
            return -1;
        }
        if (o1 instanceof ScheduledTaskContainer && o2 instanceof ITaskContainer) {
            return 1;
        }
        if (o1 instanceof ITaskContainer && o2 instanceof UncategorizedTaskContainer) {
            return 1;
        }
        if (o2 instanceof ITaskContainer && o1 instanceof UncategorizedTaskContainer) {
            return -1;
        }
        if (o1 instanceof ITaskContainer && o2 instanceof UnmatchedTaskContainer) {
            return -1;
        }
        if (o2 instanceof ITaskContainer && o1 instanceof UnmatchedTaskContainer) {
            return 1;
        }
        if (!(o1 instanceof ITask) && o2 instanceof ITask) {
            return 1;
        }
        if (o1 instanceof ITask && !(o2 instanceof ITaskContainer)) {
            return -1;
        }
        if (!(o1 instanceof ITask)) {
            if (o2 instanceof ITaskContainer || o2 instanceof IRepositoryQuery) {
                return this.sortDirection * ((IRepositoryElement)o1).getSummary().compareToIgnoreCase(((IRepositoryElement)o2).getSummary());
            }
            return -1;
        }
        if (o1 instanceof ITaskContainer) {
            if (!(o2 instanceof ITask)) {
                return -1;
            }
            if (o2 instanceof ITaskContainer) {
                IRepositoryElement element1 = (IRepositoryElement)o1;
                IRepositoryElement element2 = (IRepositoryElement)o2;
                return this.compareElements(element1, element2);
            }
        } else {
            return 0;
        }
        return 0;
    }

    private int compareElements(IRepositoryElement element1, IRepositoryElement element2) {
        if (SortByIndex.PRIORITY.equals((Object)this.sortByIndex)) {
            int result = this.sortByPriority(element1, element2, this.sortDirection);
            if (result != 0) {
                return result;
            }
            if (SortByIndex.DATE_CREATED.equals((Object)this.sortByIndex2)) {
                return this.sortByDate(element1, element2, this.sortDirection2);
            }
            if (SortByIndex.SUMMARY.equals((Object)this.sortByIndex2)) {
                return this.sortBySummary(element1, element2, this.sortDirection2);
            }
            return result;
        }
        if (SortByIndex.DATE_CREATED.equals((Object)this.sortByIndex)) {
            int result = this.sortByDate(element1, element2, this.sortDirection);
            if (result != 0) {
                return result;
            }
            if (SortByIndex.PRIORITY.equals((Object)this.sortByIndex2)) {
                return this.sortByPriority(element1, element2, this.sortDirection2);
            }
            if (SortByIndex.SUMMARY.equals((Object)this.sortByIndex2)) {
                return this.sortBySummary(element1, element2, this.sortDirection2);
            }
            return result;
        }
        int result = this.sortBySummary(element1, element2, this.sortDirection);
        if (result != 0) {
            return result;
        }
        if (SortByIndex.DATE_CREATED.equals((Object)this.sortByIndex2)) {
            return this.sortByDate(element1, element2, this.sortDirection2);
        }
        if (SortByIndex.PRIORITY.equals((Object)this.sortByIndex2)) {
            return this.sortByPriority(element1, element2, this.sortDirection2);
        }
        return result;
    }

    private int sortBySummary(IRepositoryElement element1, IRepositoryElement element2, int sortDirection) {
        return sortDirection * this.taskKeyComparator.compare(TaskListTableSorter.getSortableFromElement(element1), TaskListTableSorter.getSortableFromElement(element2));
    }

    private int sortByPriority(IRepositoryElement element1, IRepositoryElement element2, int sortDirection) {
        return sortDirection * ((AbstractTaskContainer)element1).getPriority().compareTo(((AbstractTaskContainer)element2).getPriority());
    }

    private int sortByDate(IRepositoryElement element1, IRepositoryElement element2, int sortDirection) {
        AbstractTask t1 = null;
        AbstractTask t2 = null;
        if (element1 instanceof AbstractTask) {
            t1 = (AbstractTask)element1;
        }
        if (element2 instanceof AbstractTask) {
            t2 = (AbstractTask)element2;
        }
        if (t1 != null && t2 != null && t1.getCreationDate() != null) {
            return sortDirection * t1.getCreationDate().compareTo(t2.getCreationDate());
        }
        return 0;
    }

    @Deprecated
    public static String getSortableSummaryFromElement(IRepositoryElement element) {
        ITask task1;
        String summary = element.getSummary();
        if (element instanceof ITask && (task1 = (ITask)element).getTaskKey() != null) {
            summary = String.valueOf(task1.getTaskKey()) + ": " + summary;
        }
        return summary;
    }

    public static String[] getSortableFromElement(IRepositoryElement element) {
        ITask task1;
        String[] stringArray = new String[3];
        stringArray[0] = "";
        stringArray[2] = element.getSummary();
        String[] a = stringArray;
        if (element instanceof ITask && (task1 = (ITask)element).getTaskKey() != null) {
            a[1] = task1.getTaskKey();
        }
        return a;
    }

    public SortByIndex getSortByIndex() {
        return this.sortByIndex;
    }

    public void setSortByIndex(SortByIndex sortByIndex) {
        SortByIndex oldValue = this.sortByIndex;
        this.sortByIndex = sortByIndex;
        if (!oldValue.equals((Object)sortByIndex)) {
            this.view.getViewer().refresh();
        }
    }

    public int getSortDirection() {
        return this.sortDirection;
    }

    public void setSortDirection(int sortDirection) {
        int oldValue = this.sortDirection;
        this.sortDirection = sortDirection;
        if (oldValue != this.sortDirection) {
            this.view.getViewer().refresh();
        }
    }

    public SortByIndex getSortByIndex2() {
        return this.sortByIndex2;
    }

    public void setSortByIndex2(SortByIndex sortByIndex) {
        SortByIndex oldValue = this.sortByIndex2;
        this.sortByIndex2 = sortByIndex;
        if (!oldValue.equals((Object)sortByIndex)) {
            this.view.getViewer().refresh();
        }
    }

    public int getSortDirection2() {
        return this.sortDirection2;
    }

    public void setSortDirection2(int sortDirection) {
        int oldValue = this.sortDirection2;
        this.sortDirection2 = sortDirection;
        if (oldValue != this.sortDirection2) {
            this.view.getViewer().refresh();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortByIndex {
        PRIORITY,
        SUMMARY,
        DATE_CREATED;

    }
}

