/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.ScreenshotCreationPage;
import org.eclipse.mylyn.internal.tasks.core.sync.SubmitTaskAttachmentJob;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.wizards.InputAttachmentSourcePage2;
import org.eclipse.mylyn.internal.tasks.ui.wizards.PreviewAttachmentPage2;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentModel;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.sync.SubmitJob;
import org.eclipse.mylyn.tasks.core.sync.SubmitJobEvent;
import org.eclipse.mylyn.tasks.core.sync.SubmitJobListener;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class TaskAttachmentWizard
extends Wizard {
    private static final String DIALOG_SETTINGS_KEY = "AttachmentWizard";
    private final AbstractRepositoryConnector connector;
    private IWizardPage editPage;
    private Mode mode = Mode.DEFAULT;
    private final TaskAttachmentModel model;
    private PreviewAttachmentPage2 previewPage;

    public TaskAttachmentWizard(TaskRepository taskRepository, ITask task, TaskAttribute taskAttachment) {
        Assert.isNotNull((Object)taskRepository);
        Assert.isNotNull((Object)taskAttachment);
        this.model = new TaskAttachmentModel(taskRepository, task, taskAttachment);
        this.connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(taskRepository.getConnectorKind());
        this.setMode(Mode.DEFAULT);
        this.setNeedsProgressMonitor(true);
        this.setDialogSettings(TasksUiPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY));
    }

    public void addPages() {
        if (this.model.getSource() == null) {
            if (this.mode == Mode.SCREENSHOT) {
                ScreenshotCreationPage page = new ScreenshotCreationPage();
                this.model.setSource((AbstractTaskAttachmentSource)new ImageSource(page));
                this.addPage((IWizardPage)page);
            } else {
                this.addPage((IWizardPage)new InputAttachmentSourcePage2(this.model));
            }
        }
        AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(this.model.getTaskRepository().getConnectorKind());
        this.editPage = connectorUi.getTaskAttachmentPage(this.model);
        this.addPage(this.editPage);
        this.previewPage = new PreviewAttachmentPage2(this.model);
        this.addPage((IWizardPage)this.previewPage);
    }

    public Mode getMode() {
        return this.mode;
    }

    public TaskAttachmentModel getModel() {
        return this.model;
    }

    public AbstractTaskAttachmentSource getSource() {
        return this.model.getSource();
    }

    private void handleDone(SubmitJob job) {
        if (job.getStatus() != null) {
            TasksUiInternal.displayStatus("Attachment Failed", job.getStatus());
        }
    }

    public boolean performFinish() {
        SubmitJob job = TasksUiInternal.getJobFactory().createSubmitTaskAttachmentJob(this.connector, this.model.getTaskRepository(), this.model.getTask(), this.model.getSource(), this.model.getComment(), this.model.getAttribute());
        final boolean attachContext = this.model.getAttachContext();
        job.addSubmitJobListener(new SubmitJobListener(){

            public void done(SubmitJobEvent event) {
            }

            public void taskSubmitted(SubmitJobEvent event, IProgressMonitor monitor) throws CoreException {
                if (attachContext) {
                    monitor.subTask("Attaching context");
                    AttachmentUtil.postContext(TaskAttachmentWizard.this.connector, TaskAttachmentWizard.this.model.getTaskRepository(), TaskAttachmentWizard.this.model.getTask(), null, null, monitor);
                }
            }

            public void taskSynchronized(SubmitJobEvent event, IProgressMonitor monitor) throws CoreException {
            }
        });
        if (this.previewPage.runInBackground()) {
            this.runInBackground(job);
            return false;
        }
        return this.runInWizard(job);
    }

    private void runInBackground(final SubmitJob job) {
        this.getContainer().getShell().setVisible(false);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (job.getStatus() != null) {
                            TaskAttachmentWizard.this.getContainer().getShell().setVisible(true);
                        }
                        TaskAttachmentWizard.this.handleDone(job);
                        if (job.getStatus() == null) {
                            TaskAttachmentWizard.this.getContainer().getShell().close();
                        }
                    }
                });
            }
        });
        job.schedule();
    }

    private boolean runInWizard(final SubmitJob job) {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (((SubmitTaskAttachmentJob)job).run(monitor) == Status.CANCEL_STATUS) {
                        throw new InterruptedException();
                    }
                }
            });
            this.handleDone(job);
            return job.getStatus() == null;
        }
        catch (InvocationTargetException e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Unexpected error", (Throwable)e));
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        if (mode == Mode.SCREENSHOT) {
            this.setWindowTitle("Attach Screenshot");
            this.setDefaultPageImageDescriptor(CommonImages.BANNER_SCREENSHOT);
        } else {
            this.setWindowTitle("Add Attachment");
            this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
        }
    }

    public void setSource(AbstractTaskAttachmentSource source) {
        this.model.setSource(source);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClipboardTaskAttachmentSource
    extends AbstractTaskAttachmentSource {
        private byte[] data;
        private static List<Transfer> transfers;
        private Object contents;

        public static boolean isSupportedType(Display display) {
            TransferData[] types;
            Clipboard clipboard = new Clipboard(display);
            TransferData[] transferDataArray = types = clipboard.getAvailableTypes();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                TransferData transferData = transferDataArray[n2];
                List<Transfer> transfers = ClipboardTaskAttachmentSource.getTransfers();
                for (Transfer transfer : transfers) {
                    if (!transfer.isSupportedType(transferData)) continue;
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private static List<Transfer> getTransfers() {
            if (transfers != null) {
                return transfers;
            }
            transfers = new ArrayList<Transfer>();
            try {
                Class<?> clazz = Class.forName("org.eclipse.swt.dnd.ImageTransfer");
                Method method = clazz.getMethod("getInstance", new Class[0]);
                if (method != null) {
                    transfers.add((Transfer)method.invoke(null, new Object[0]));
                }
            }
            catch (Exception exception) {
            }
            catch (LinkageError linkageError) {}
            transfers.add((Transfer)TextTransfer.getInstance());
            return transfers;
        }

        public ClipboardTaskAttachmentSource() {
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
                    List transfers = ClipboardTaskAttachmentSource.getTransfers();
                    for (Transfer transfer : transfers) {
                        ClipboardTaskAttachmentSource.this.contents = clipboard.getContents(transfer);
                        if (ClipboardTaskAttachmentSource.this.contents != null) break;
                    }
                    clipboard.dispose();
                }
            });
        }

        public InputStream createInputStream(IProgressMonitor monitor) throws CoreException {
            byte[] bytes = this.getData();
            if (bytes != null) {
                return new ByteArrayInputStream(this.data);
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Invalid content type."));
        }

        public String getContentType() {
            if (this.contents instanceof String) {
                return "text/plain";
            }
            if (this.contents instanceof ImageData) {
                return "image/png";
            }
            return "application/octet-stream";
        }

        public String getDescription() {
            return null;
        }

        public long getLength() {
            byte[] bytes = this.getData();
            return bytes != null ? bytes.length : -1;
        }

        private byte[] getData() {
            if (this.data == null) {
                if (this.contents instanceof String) {
                    this.data = ((String)this.contents).getBytes();
                } else if (this.contents instanceof ImageData) {
                    ImageLoader loader = new ImageLoader();
                    loader.data = new ImageData[]{(ImageData)this.contents};
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    loader.save((OutputStream)out, 5);
                    this.data = out.toByteArray();
                }
            }
            return this.data;
        }

        public String getName() {
            if (this.contents instanceof String) {
                return "clipboard.txt";
            }
            if (this.contents instanceof ImageData) {
                return "clipboard.png";
            }
            return "";
        }

        public boolean isLocal() {
            return true;
        }
    }

    static class ImageSource
    extends AbstractTaskAttachmentSource {
        private File file;
        private final ScreenshotCreationPage page;

        public ImageSource(ScreenshotCreationPage page) {
            this.page = page;
        }

        public InputStream createInputStream(IProgressMonitor monitor) throws CoreException {
            try {
                if (this.file == null || this.page.isImageDirty()) {
                    Image image = this.page.createImage();
                    this.page.setImageDirty(false);
                    try {
                        this.file = File.createTempFile("screenshot", ".png");
                        this.file.deleteOnExit();
                        ImageLoader loader = new ImageLoader();
                        loader.data = new ImageData[]{image.getImageData()};
                        FileOutputStream out = new FileOutputStream(this.file);
                        try {
                            loader.save((OutputStream)out, 5);
                        }
                        finally {
                            out.close();
                        }
                    }
                    finally {
                        image.dispose();
                    }
                }
                return new FileInputStream(this.file);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", e.getMessage(), (Throwable)e));
            }
        }

        public String getContentType() {
            return "image/png";
        }

        public String getDescription() {
            return "Screenshot";
        }

        public long getLength() {
            return this.file != null ? this.file.length() : -1L;
        }

        public String getName() {
            return "screenshot.png";
        }

        public boolean isLocal() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        DEFAULT,
        SCREENSHOT;

    }
}

