/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.editors;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class BrowserFormPage
extends FormPage {
    public static final String ID_EDITOR = "org.eclipse.mylyn.tasks.ui.editor.browser";
    private Browser browser;

    public BrowserFormPage(FormEditor editor, String title) {
        super(editor, ID_EDITOR, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        try {
            ScrolledForm form = managedForm.getForm();
            form.getBody().setLayout((Layout)new FillLayout());
            this.browser = new Browser(form.getBody(), 0);
            managedForm.getForm().setContent((Control)this.browser);
            String url = this.getUrl();
            if (url != null) {
                this.browser.setUrl(url);
            }
        }
        catch (SWTError e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not create browser page: " + e.getMessage(), (Throwable)e));
        }
        catch (RuntimeException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not create browser page", (Throwable)e));
        }
    }

    public Browser getBrowser() {
        return this.browser;
    }

    protected String getUrl() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof TaskEditorInput) {
            return ((TaskEditorInput)input).getTask().getUrl();
        }
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        if (input instanceof TaskEditorInput) {
            TasksUiPlugin.getTaskDataManager().setTaskRead(((TaskEditorInput)input).getTask(), true);
        }
    }
}

