/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractAttributeFactory;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractLegacyRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractTaskDataHandler;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryTaskData;
import org.eclipse.mylyn.internal.tasks.core.deprecated.TaskSelection;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.deprecated.NewTaskEditorInput;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class NewTaskWizard
extends Wizard
implements INewWizard {
    private final TaskRepository taskRepository;
    private ITaskMapping taskSelection;

    public NewTaskWizard(TaskRepository taskRepository, ITaskMapping taskSelection) {
        Assert.isNotNull((Object)taskRepository);
        this.taskRepository = taskRepository;
        this.taskSelection = taskSelection;
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
        this.setNeedsProgressMonitor(true);
    }

    public NewTaskWizard(TaskRepository taskRepository) {
        this.taskRepository = taskRepository;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
    }

    protected ITaskMapping getInitializationData() {
        return null;
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    public ITaskMapping getTaskSelection() {
        return this.taskSelection;
    }

    public boolean performFinish() {
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.taskRepository.getConnectorKind());
        if (connector instanceof AbstractLegacyRepositoryConnector) {
            return this.createLegacyTask((AbstractLegacyRepositoryConnector)connector);
        }
        final TaskData[] taskData = new TaskData[1];
        final ITaskMapping initializationData = this.getInitializationData();
        final ITaskMapping selectionData = this.getTaskSelection();
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        taskData[0] = TasksUiInternal.createTaskData(NewTaskWizard.this.taskRepository, initializationData, selectionData, monitor);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.getContainer().run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                TasksUiInternal.displayStatus("Error creating new task", ((CoreException)e.getCause()).getStatus());
            } else {
                StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Error creating new task", e.getCause()));
            }
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        try {
            TasksUiInternal.createAndOpenNewTask(taskData[0]);
            return true;
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to open new task", (Throwable)e));
            TasksUiInternal.displayStatus("Create Task", (IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to create new task: " + e.getMessage()));
            return false;
        }
    }

    private boolean createLegacyTask(AbstractLegacyRepositoryConnector legacyConnector) {
        final AbstractTaskDataHandler taskDataHandler = legacyConnector.getLegacyTaskDataHandler();
        if (taskDataHandler == null) {
            TasksUiInternal.displayStatus("Error creating new task", (IStatus)new RepositoryStatus(4, "org.eclipse.mylyn.tasks.ui", 1, "The selected repository does not support creating new tasks."));
            return false;
        }
        AbstractAttributeFactory attributeFactory = taskDataHandler.getAttributeFactory(this.taskRepository.getRepositoryUrl(), this.taskRepository.getConnectorKind(), "task");
        final RepositoryTaskData taskData = new RepositoryTaskData(attributeFactory, this.taskRepository.getConnectorKind(), this.taskRepository.getRepositoryUrl(), TasksUiPlugin.getDefault().getNextNewRepositoryTaskId());
        taskData.setNew(true);
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        if (!taskDataHandler.initializeTaskData(NewTaskWizard.this.taskRepository, taskData, monitor)) {
                            throw new CoreException((IStatus)new RepositoryStatus(4, "org.eclipse.mylyn.tasks.ui", 1, "The selected repository does not support creating new tasks."));
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.getContainer().run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                TasksUiInternal.displayStatus("Error creating new task", ((CoreException)e.getCause()).getStatus());
            } else {
                StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Error creating new task", e.getCause()));
            }
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        if (this.taskSelection instanceof TaskSelection) {
            taskDataHandler.cloneTaskData(((TaskSelection)this.taskSelection).getLegacyTaskData(), taskData);
        }
        NewTaskEditorInput editorInput = new NewTaskEditorInput(this.taskRepository, taskData);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        TasksUiUtil.openEditor(editorInput, "org.eclipse.mylyn.tasks.ui.editors.task", page);
        return true;
    }
}

