/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.team.ui;

import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.team.ui.LinkedTaskInfo;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.team.ui.AbstractTaskReference;
import org.eclipse.mylyn.team.ui.IContextChangeSet;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;
import org.eclipse.team.internal.ui.synchronize.ChangeSetDiffNode;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElement;

public class LinkedTaskInfoAdapterFactory
implements IAdapterFactory {
    private static final Class[] ADAPTER_TYPES = new Class[]{AbstractTaskReference.class};

    public Object getAdapter(Object object, Class adapterType) {
        if (!AbstractTaskReference.class.equals((Object)adapterType)) {
            return null;
        }
        if (object instanceof ChangeSetDiffNode) {
            return this.adaptChangeSetDiffNode(object);
        }
        return this.adaptFromComment(object);
    }

    public Class[] getAdapterList() {
        return ADAPTER_TYPES;
    }

    private AbstractTaskReference adaptChangeSetDiffNode(Object object) {
        ChangeSetDiffNode diffNode = (ChangeSetDiffNode)object;
        ChangeSet set = diffNode.getSet();
        Object adapter = null;
        if (set instanceof IAdaptable) {
            adapter = ((IAdaptable)set).getAdapter(AbstractTaskReference.class);
        }
        if (adapter == null) {
            adapter = Platform.getAdapterManager().getAdapter((Object)set, AbstractTaskReference.class);
        }
        if (adapter != null) {
            return (AbstractTaskReference)adapter;
        }
        return this.adaptFromComment(object);
    }

    private AbstractTaskReference adaptFromComment(Object object) {
        TaskRepository repository;
        String comment = LinkedTaskInfoAdapterFactory.getCommentForElement(object);
        if (comment == null) {
            return null;
        }
        IResource resource = LinkedTaskInfoAdapterFactory.getResourceForElement(object);
        if (resource != null && (repository = TasksUiPlugin.getDefault().getRepositoryForResource(resource)) != null) {
            return new LinkedTaskInfo(repository.getRepositoryUrl(), null, null, comment);
        }
        return new LinkedTaskInfo(null, null, null, comment);
    }

    private static String getCommentForElement(Object element) {
        if (element instanceof IContextChangeSet) {
            return ((IContextChangeSet)element).getComment(false);
        }
        if (element instanceof DiffChangeSet) {
            return ((DiffChangeSet)element).getComment();
        }
        if (element instanceof ChangeSetDiffNode) {
            return ((ChangeSetDiffNode)element).getName();
        }
        if (element instanceof IFileRevision) {
            return ((IFileRevision)element).getComment();
        }
        return null;
    }

    private static IResource getResourceForElement(Object element) {
        IResource[] resources;
        if (element instanceof DiffChangeSet && (resources = ((DiffChangeSet)element).getResources()).length > 0) {
            return resources[0];
        }
        if (element instanceof SynchronizeModelElement) {
            SynchronizeModelElement modelElement = (SynchronizeModelElement)element;
            IResource resource = modelElement.getResource();
            if (resource != null) {
                return resource;
            }
            IDiffElement[] elements = modelElement.getChildren();
            if (elements.length > 0 && elements[0] instanceof SynchronizeModelElement) {
                return ((SynchronizeModelElement)elements[0]).getResource();
            }
        }
        return null;
    }
}

