/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.axis.AxisProperties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.jira.core.JiraClientManager;
import org.eclipse.mylyn.internal.jira.core.service.JiraAuthenticationException;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.service.JiraRemoteMessageException;
import org.eclipse.mylyn.internal.jira.core.service.JiraServiceUnavailableException;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.osgi.framework.BundleContext;

public class JiraCorePlugin
extends Plugin {
    public static final String ID_PLUGIN = "org.eclipse.mylyn.internal.jira.core";
    private static JiraCorePlugin plugin;
    private JiraClientManager clientManager;
    public static final String CONNECTOR_KIND = "jira";
    public static final String LABEL = "JIRA (supports 3.3.3 and later)";

    public JiraCorePlugin() {
        plugin = this;
        AxisProperties.setProperty((String)"attachments.implementation", (String)"org.eclipse.mylyn.does.not.exist");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        File serverCache = this.getStateLocation().append("serverCache").toFile();
        Logger logger = Logger.getLogger("org.apache.axis.utils.JavaUtils");
        logger.setLevel(Level.SEVERE);
        this.clientManager = new JiraClientManager(serverCache);
        this.clientManager.start();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.clientManager != null) {
            this.clientManager.stop();
        }
        plugin = null;
        this.clientManager = null;
    }

    public static JiraCorePlugin getDefault() {
        return plugin;
    }

    public JiraClientManager getClientManager() {
        return this.clientManager;
    }

    public static void log(int severity, String message, Throwable e) {
        JiraCorePlugin.getDefault().getLog().log((IStatus)new Status(severity, ID_PLUGIN, -1, message, e));
    }

    public static void log(IStatus status) {
        JiraCorePlugin.getDefault().getLog().log(status);
    }

    public static IStatus toStatus(TaskRepository repository, Throwable e) {
        String url = repository.getRepositoryUrl();
        if (e instanceof JiraAuthenticationException) {
            return RepositoryStatus.createLoginError((String)url, (String)ID_PLUGIN);
        }
        if (e instanceof JiraServiceUnavailableException) {
            return new RepositoryStatus(url, 4, ID_PLUGIN, 5, e.getMessage(), e);
        }
        if (e instanceof JiraRemoteMessageException) {
            return RepositoryStatus.createHtmlStatus((String)url, (int)4, (String)ID_PLUGIN, (int)1, (String)e.getMessage(), (String)((JiraRemoteMessageException)e).getHtmlMessage());
        }
        if (e instanceof JiraException) {
            return new RepositoryStatus(url, 4, ID_PLUGIN, 1, e.getMessage(), e);
        }
        return RepositoryStatus.createInternalError((String)ID_PLUGIN, (String)"Unexpected error", (Throwable)e);
    }
}

