/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.jira.core.IJiraClientFactory;
import org.eclipse.mylyn.internal.jira.core.JiraAttribute;
import org.eclipse.mylyn.internal.jira.core.JiraAttributeMapper;
import org.eclipse.mylyn.internal.jira.core.JiraClientFactory;
import org.eclipse.mylyn.internal.jira.core.JiraCorePlugin;
import org.eclipse.mylyn.internal.jira.core.JiraFieldType;
import org.eclipse.mylyn.internal.jira.core.JiraRepositoryConnector;
import org.eclipse.mylyn.internal.jira.core.JiraTaskMapper;
import org.eclipse.mylyn.internal.jira.core.JiraTimeFormat;
import org.eclipse.mylyn.internal.jira.core.html.HTML2TextReader;
import org.eclipse.mylyn.internal.jira.core.model.Attachment;
import org.eclipse.mylyn.internal.jira.core.model.Comment;
import org.eclipse.mylyn.internal.jira.core.model.Component;
import org.eclipse.mylyn.internal.jira.core.model.CustomField;
import org.eclipse.mylyn.internal.jira.core.model.IssueLink;
import org.eclipse.mylyn.internal.jira.core.model.IssueType;
import org.eclipse.mylyn.internal.jira.core.model.JiraAction;
import org.eclipse.mylyn.internal.jira.core.model.JiraField;
import org.eclipse.mylyn.internal.jira.core.model.JiraIssue;
import org.eclipse.mylyn.internal.jira.core.model.JiraStatus;
import org.eclipse.mylyn.internal.jira.core.model.JiraVersion;
import org.eclipse.mylyn.internal.jira.core.model.Priority;
import org.eclipse.mylyn.internal.jira.core.model.Project;
import org.eclipse.mylyn.internal.jira.core.model.Resolution;
import org.eclipse.mylyn.internal.jira.core.model.SecurityLevel;
import org.eclipse.mylyn.internal.jira.core.model.Subtask;
import org.eclipse.mylyn.internal.jira.core.model.Version;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.service.JiraInsufficientPermissionException;
import org.eclipse.mylyn.internal.jira.core.util.JiraUtil;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteCustomFieldValue;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteIssue;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraTaskDataHandler
extends AbstractTaskDataHandler {
    private static final String CONTEXT_ATTACHEMENT_FILENAME = "mylyn-context.zip";
    private static final String CONTEXT_ATTACHEMENT_FILENAME_LEGACY = "mylar-context.zip";
    private static final String CONTEXT_ATTACHMENT_DESCRIPTION = "mylyn/context/zip";
    private static final String CONTEXT_ATTACHMENT_DESCRIPTION_LEGACY = "mylar/context/zip";
    private static final boolean TRACE_ENABLED = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.mylyn.internal.jira.ui/dataHandler"));
    private static final String REASSIGN_OPERATION = "reassign";
    private static final String LEAVE_OPERATION = "leave";
    private static final JiraVersion TASK_DATA_VERSION_1_0 = new JiraVersion("1.0");
    private static final JiraVersion TASK_DATA_VERSION_2_0 = new JiraVersion("2.0");
    private static final JiraVersion TASK_DATA_VERSION_2_2 = new JiraVersion("2.2");
    private static final JiraVersion TASK_DATA_VERSION_CURRENT = new JiraVersion("3.0");
    private final IJiraClientFactory clientFactory;

    public JiraTaskDataHandler(IJiraClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            JiraIssue jiraIssue;
            monitor.beginTask("Getting task", -1);
            JiraClient client = this.clientFactory.getJiraClient(repository);
            if (!client.getCache().hasDetails()) {
                client.getCache().refreshDetails(monitor);
            }
            if ((jiraIssue = this.getJiraIssue(client, taskId, repository.getRepositoryUrl(), monitor)) != null) {
                TaskData taskData = this.createTaskData(repository, client, jiraIssue, null, monitor);
                return taskData;
            }
            try {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.internal.jira.core", 0, "JIRA ticket not found: " + taskId, null));
            }
            catch (JiraException e) {
                IStatus status = JiraCorePlugin.toStatus(repository, e);
                JiraTaskDataHandler.trace(status);
                throw new CoreException(status);
            }
        }
        finally {
            monitor.done();
        }
    }

    private JiraIssue getJiraIssue(JiraClient client, String taskId, String repositoryUrl, IProgressMonitor monitor) throws CoreException, JiraException {
        try {
            int id = Integer.parseInt(taskId);
            String issueKey = client.getKeyFromId(String.valueOf(id), monitor);
            return client.getIssueByKey(issueKey, monitor);
        }
        catch (NumberFormatException numberFormatException) {
            return client.getIssueByKey(taskId, monitor);
        }
    }

    public TaskData createTaskData(TaskRepository repository, JiraClient client, JiraIssue jiraIssue, TaskData oldTaskData, IProgressMonitor monitor) throws JiraException {
        TaskData data = new TaskData(this.getAttributeMapper(repository), "jira", repository.getRepositoryUrl(), jiraIssue.getId());
        this.initializeTaskData(data, client, jiraIssue.getProject());
        this.updateTaskData(data, jiraIssue, client, oldTaskData, monitor);
        this.addOperations(data, jiraIssue, client, oldTaskData, monitor);
        return data;
    }

    public void initializeTaskData(TaskData data, JiraClient client, Project project) {
        Project[] jiraProjects;
        data.setVersion(TASK_DATA_VERSION_CURRENT.toString());
        this.createAttribute(data, JiraAttribute.CREATION_DATE);
        TaskAttribute summaryAttribute = this.createAttribute(data, JiraAttribute.SUMMARY);
        summaryAttribute.getMetaData().setType("shortRichText");
        TaskAttribute descriptionAttribute = this.createAttribute(data, JiraAttribute.DESCRIPTION);
        descriptionAttribute.getMetaData().setType("longRichText");
        this.createAttribute(data, JiraAttribute.STATUS);
        this.createAttribute(data, JiraAttribute.ISSUE_KEY);
        this.createAttribute(data, JiraAttribute.TASK_URL);
        this.createAttribute(data, JiraAttribute.USER_ASSIGNED);
        this.createAttribute(data, JiraAttribute.USER_REPORTER);
        this.createAttribute(data, JiraAttribute.MODIFICATION_DATE);
        TaskAttribute projectAttribute = this.createAttribute(data, JiraAttribute.PROJECT);
        Project[] projectArray = jiraProjects = client.getCache().getProjects();
        int n = jiraProjects.length;
        int n2 = 0;
        while (n2 < n) {
            Project jiraProject = projectArray[n2];
            projectAttribute.putOption(jiraProject.getId(), jiraProject.getName());
            ++n2;
        }
        projectAttribute.setValue(project.getId());
        TaskAttribute resolutions = this.createAttribute(data, JiraAttribute.RESOLUTION);
        Resolution[] jiraResolutions = client.getCache().getResolutions();
        if (jiraResolutions.length > 0) {
            Resolution[] resolutionArray = jiraResolutions;
            int n3 = jiraResolutions.length;
            int n4 = 0;
            while (n4 < n3) {
                Resolution resolution = resolutionArray[n4];
                resolutions.putOption(resolution.getId(), resolution.getName());
                ++n4;
            }
        } else {
            resolutions.putOption("1", "Fixed");
            resolutions.putOption("2", "Won't Fix");
            resolutions.putOption("3", "Duplicate");
            resolutions.putOption("4", "Incomplete");
            resolutions.putOption("5", "Cannot Reproduce");
        }
        TaskAttribute priorities = this.createAttribute(data, JiraAttribute.PRIORITY);
        Priority[] jiraPriorities = client.getCache().getPriorities();
        int i = 0;
        while (i < jiraPriorities.length) {
            Priority priority = jiraPriorities[i];
            priorities.putOption(priority.getId(), priority.getName());
            if (i == jiraPriorities.length / 2) {
                priorities.setValue(priority.getId());
            }
            ++i;
        }
        TaskAttribute types = this.createAttribute(data, JiraAttribute.TYPE);
        IssueType[] jiraIssueTypes = client.getCache().getIssueTypes();
        int i2 = 0;
        while (i2 < jiraIssueTypes.length) {
            IssueType type = jiraIssueTypes[i2];
            if (!type.isSubTaskType()) {
                types.putOption(type.getId(), type.getName());
                if (i2 == 0) {
                    types.setValue(type.getId());
                }
            }
            ++i2;
        }
        this.createAttribute(data, JiraAttribute.PARENT_KEY);
        this.createAttribute(data, JiraAttribute.PARENT_ID);
        this.createAttribute(data, JiraAttribute.DUE_DATE);
        this.createAttribute(data, JiraAttribute.ESTIMATE);
        if (!data.isNew()) {
            this.createAttribute(data, JiraAttribute.ACTUAL);
            this.createAttribute(data, JiraAttribute.INITIAL_ESTIMATE);
        }
        TaskAttribute affectsVersions = this.createAttribute(data, JiraAttribute.AFFECTSVERSIONS);
        Version[] versionArray = project.getVersions();
        int n5 = versionArray.length;
        int n6 = 0;
        while (n6 < n5) {
            Version version = versionArray[n6];
            affectsVersions.putOption(version.getId(), version.getName());
            ++n6;
        }
        TaskAttribute components = this.createAttribute(data, JiraAttribute.COMPONENTS);
        Component[] componentArray = project.getComponents();
        int n7 = componentArray.length;
        n5 = 0;
        while (n5 < n7) {
            Component component = componentArray[n5];
            components.putOption(component.getId(), component.getName());
            ++n5;
        }
        TaskAttribute fixVersions = this.createAttribute(data, JiraAttribute.FIXVERSIONS);
        Version[] versionArray2 = project.getVersions();
        int n8 = versionArray2.length;
        n7 = 0;
        while (n7 < n8) {
            Version version = versionArray2[n7];
            fixVersions.putOption(version.getId(), version.getName());
            ++n7;
        }
        this.createAttribute(data, JiraAttribute.ENVIRONMENT);
        if (!data.isNew()) {
            TaskAttribute commentAttribute = this.createAttribute(data, JiraAttribute.COMMENT_NEW);
            commentAttribute.getMetaData().setType("longRichText");
        }
    }

    public TaskAttribute createAttribute(TaskData data, JiraAttribute key) {
        TaskAttribute attribute = data.getRoot().createAttribute(key.id());
        attribute.getMetaData().defaults().setReadOnly(key.isReadOnly()).setKind(key.getKind()).setLabel(key.getName()).setType(key.getType().getTaskType()).putValue("type", key.getType().getKey());
        return attribute;
    }

    private void updateTaskData(TaskData data, JiraIssue jiraIssue, JiraClient client, TaskData oldTaskData, IProgressMonitor monitor) throws JiraException {
        Serializable version;
        Serializable[] serializableArray;
        IssueType issueType;
        int n;
        IssueLink[] issueLinks;
        String parentKey = jiraIssue.getParentKey();
        if (parentKey != null) {
            this.setAttributeValue(data, JiraAttribute.PARENT_KEY, parentKey);
        } else {
            this.removeAttribute(data, JiraAttribute.PARENT_KEY);
        }
        String parentId = jiraIssue.getParentId();
        if (parentId != null) {
            this.setAttributeValue(data, JiraAttribute.PARENT_ID, parentId);
        } else {
            this.removeAttribute(data, JiraAttribute.PARENT_ID);
        }
        Subtask[] subtasks = jiraIssue.getSubtasks();
        if (subtasks != null && subtasks.length > 0) {
            this.createAttribute(data, JiraAttribute.SUBTASK_IDS);
            this.createAttribute(data, JiraAttribute.SUBTASK_KEYS);
            Subtask[] subtaskArray = subtasks;
            int n2 = subtasks.length;
            int n3 = 0;
            while (n3 < n2) {
                Subtask subtask = subtaskArray[n3];
                this.addAttributeValue(data, JiraAttribute.SUBTASK_IDS, subtask.getIssueId());
                this.addAttributeValue(data, JiraAttribute.SUBTASK_KEYS, subtask.getIssueKey());
                ++n3;
            }
        }
        if ((issueLinks = jiraIssue.getIssueLinks()) != null && issueLinks.length > 0) {
            HashMap<String, TaskAttribute> links = new HashMap<String, TaskAttribute>();
            IssueLink[] issueLinkArray = issueLinks;
            n = issueLinks.length;
            int n4 = 0;
            while (n4 < n) {
                String desc;
                String key;
                IssueLink link = issueLinkArray[n4];
                if (link.getInwardDescription() == null) {
                    key = String.valueOf(link.getLinkTypeId()) + "outward";
                    desc = link.getOutwardDescription();
                } else {
                    key = String.valueOf(link.getLinkTypeId()) + "inward";
                    desc = link.getInwardDescription();
                }
                String label = String.valueOf(this.capitalize(desc)) + ":";
                TaskAttribute attribute = (TaskAttribute)links.get(key);
                if (attribute == null) {
                    attribute = data.getRoot().createAttribute("attribute.jira.link::" + key);
                    attribute.getMetaData().setKind("task.common.kind.default").setLabel(label).setType(JiraFieldType.ISSUELINKS.getTaskType()).putValue("type", JiraFieldType.ISSUELINKS.getKey());
                    links.put(key, attribute);
                }
                attribute.addValue(link.getIssueKey());
                if (link.getInwardDescription() != null) {
                    attribute = data.getRoot().getMappedAttribute(JiraAttribute.LINKED_IDS.id());
                    if (attribute == null) {
                        attribute = this.createAttribute(data, JiraAttribute.LINKED_IDS);
                    }
                    this.addAttributeValue(data, JiraAttribute.LINKED_IDS, link.getIssueId());
                }
                ++n4;
            }
        }
        this.setAttributeValue(data, JiraAttribute.CREATION_DATE, JiraUtil.dateToString(jiraIssue.getCreated()));
        this.setAttributeValue(data, JiraAttribute.SUMMARY, jiraIssue.getSummary());
        this.setAttributeValue(data, JiraAttribute.DESCRIPTION, jiraIssue.getDescription());
        this.setAttributeValue(data, JiraAttribute.ISSUE_KEY, jiraIssue.getKey());
        this.setAttributeValue(data, JiraAttribute.TASK_URL, jiraIssue.getUrl());
        this.setAttributeValue(data, JiraAttribute.RESOLUTION, jiraIssue.getResolution() == null ? "" : jiraIssue.getResolution().getId());
        this.setAttributeValue(data, JiraAttribute.MODIFICATION_DATE, JiraUtil.dateToString(jiraIssue.getUpdated()));
        this.setAttributeValue(data, JiraAttribute.USER_ASSIGNED, this.getAssignee(jiraIssue));
        this.setAttributeValue(data, JiraAttribute.USER_REPORTER, this.getReporter(jiraIssue));
        this.setAttributeValue(data, JiraAttribute.PROJECT, jiraIssue.getProject().getId());
        if (jiraIssue.getStatus() != null) {
            TaskAttribute attribute = data.getRoot().getAttribute(JiraAttribute.STATUS.id());
            attribute.putOption(jiraIssue.getStatus().getId(), jiraIssue.getStatus().getName());
            attribute.setValue(jiraIssue.getStatus().getId());
        }
        if (jiraIssue.getPriority() != null) {
            this.setAttributeValue(data, JiraAttribute.PRIORITY, jiraIssue.getPriority().getId());
        } else {
            this.removeAttribute(data, JiraAttribute.PRIORITY);
        }
        SecurityLevel securityLevel = jiraIssue.getSecurityLevel();
        if (securityLevel != null) {
            TaskAttribute attribute = this.createAttribute(data, JiraAttribute.SECURITY_LEVEL);
            attribute.putOption(securityLevel.getId(), securityLevel.getName());
            attribute.setValue(securityLevel.getId());
        }
        if ((issueType = jiraIssue.getType()) != null) {
            TaskAttribute attribute = this.setAttributeValue(data, JiraAttribute.TYPE, issueType.getId());
            if (issueType.isSubTaskType()) {
                attribute.getMetaData().setReadOnly(true).putValue("isSubtaskType", Boolean.toString(true));
                attribute.clearOptions();
                attribute.putOption(issueType.getId(), issueType.getName());
            }
        } else {
            this.removeAttribute(data, JiraAttribute.TYPE);
        }
        if (jiraIssue.getActual() > 0L) {
            this.setAttributeValue(data, JiraAttribute.INITIAL_ESTIMATE, String.valueOf(jiraIssue.getInitialEstimate()));
        } else {
            this.removeAttribute(data, JiraAttribute.INITIAL_ESTIMATE);
        }
        this.setAttributeValue(data, JiraAttribute.ESTIMATE, String.valueOf(jiraIssue.getEstimate()));
        this.setAttributeValue(data, JiraAttribute.ACTUAL, String.valueOf(jiraIssue.getActual()));
        if (jiraIssue.getDue() != null) {
            this.setAttributeValue(data, JiraAttribute.DUE_DATE, JiraUtil.dateToString(jiraIssue.getDue()));
        } else {
            this.removeAttribute(data, JiraAttribute.DUE_DATE);
        }
        if (jiraIssue.getComponents() != null) {
            serializableArray = jiraIssue.getComponents();
            int n5 = serializableArray.length;
            n = 0;
            while (n < n5) {
                Serializable component = serializableArray[n];
                this.addAttributeValue(data, JiraAttribute.COMPONENTS, ((Component)component).getId());
                ++n;
            }
        }
        if (jiraIssue.getReportedVersions() != null) {
            serializableArray = jiraIssue.getReportedVersions();
            int n6 = serializableArray.length;
            n = 0;
            while (n < n6) {
                version = serializableArray[n];
                this.addAttributeValue(data, JiraAttribute.AFFECTSVERSIONS, ((Version)version).getId());
                ++n;
            }
        }
        if (jiraIssue.getFixVersions() != null) {
            serializableArray = jiraIssue.getFixVersions();
            int n7 = serializableArray.length;
            n = 0;
            while (n < n7) {
                version = serializableArray[n];
                this.addAttributeValue(data, JiraAttribute.FIXVERSIONS, ((Version)version).getId());
                ++n;
            }
        }
        if (jiraIssue.getEnvironment() != null) {
            this.setAttributeValue(data, JiraAttribute.ENVIRONMENT, jiraIssue.getEnvironment());
        } else {
            this.removeAttribute(data, JiraAttribute.ENVIRONMENT);
        }
        this.addComments(data, jiraIssue);
        this.addAttachments(data, jiraIssue, client);
        this.addCustomFields(data, jiraIssue);
        this.updateMarkup(data, jiraIssue, client, oldTaskData, monitor);
        HashSet<String> editableKeys = this.getEditableKeys(data, jiraIssue, client, oldTaskData, monitor);
        this.updateProperties(data, editableKeys);
    }

    private String getReporter(JiraIssue jiraIssue) {
        String reporter = jiraIssue.getReporter();
        return reporter == null ? "" : reporter;
    }

    private void addComments(TaskData data, JiraIssue jiraIssue) {
        int i = 1;
        Comment[] commentArray = jiraIssue.getComments();
        int n = commentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Comment comment = commentArray[n2];
            TaskAttribute attribute = data.getRoot().createAttribute("task.common.comment-" + i);
            TaskCommentMapper taskComment = TaskCommentMapper.createFrom((TaskAttribute)attribute);
            taskComment.setAuthor(data.getAttributeMapper().getTaskRepository().createPerson(comment.getAuthor()));
            taskComment.setNumber(Integer.valueOf(i));
            String commentText = comment.getComment();
            if (comment.isMarkupDetected()) {
                commentText = JiraTaskDataHandler.stripTags(commentText);
            }
            taskComment.setText(commentText);
            taskComment.setCreationDate(comment.getCreated());
            taskComment.applyTo(attribute);
            ++i;
            ++n2;
        }
    }

    private void addAttachments(TaskData data, JiraIssue jiraIssue, JiraClient client) {
        int i = 1;
        Attachment[] attachmentArray = jiraIssue.getAttachments();
        int n = attachmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Attachment attachment = attachmentArray[n2];
            TaskAttribute attribute = data.getRoot().createAttribute("task.common.attachment-" + i);
            TaskAttachmentMapper taskAttachment = TaskAttachmentMapper.createFrom((TaskAttribute)attribute);
            taskAttachment.setAttachmentId(attachment.getId());
            taskAttachment.setAuthor(data.getAttributeMapper().getTaskRepository().createPerson(attachment.getAuthor()));
            taskAttachment.setFileName(attachment.getName());
            if (CONTEXT_ATTACHEMENT_FILENAME.equals(attachment.getName())) {
                taskAttachment.setDescription(CONTEXT_ATTACHMENT_DESCRIPTION);
            } else if (CONTEXT_ATTACHEMENT_FILENAME_LEGACY.equals(attachment.getName())) {
                taskAttachment.setDescription(CONTEXT_ATTACHMENT_DESCRIPTION_LEGACY);
            } else {
                taskAttachment.setDescription(attachment.getName());
            }
            taskAttachment.setLength(Long.valueOf(attachment.getSize()));
            taskAttachment.setCreationDate(attachment.getCreated());
            taskAttachment.setUrl(String.valueOf(client.getBaseUrl()) + "/secure/attachment/" + attachment.getId() + "/" + attachment.getName());
            taskAttachment.applyTo(attribute);
            ++i;
            ++n2;
        }
    }

    private void addCustomFields(TaskData data, JiraIssue jiraIssue) {
        CustomField[] customFieldArray = jiraIssue.getCustomFields();
        int n = customFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomField field = customFieldArray[n2];
            String mappedKey = this.mapCommonAttributeKey(field.getId());
            String name = String.valueOf(field.getName()) + ":";
            String kind = JiraAttribute.valueById(mappedKey).getKind();
            String type = field.getKey();
            String taskType = JiraFieldType.fromKey(type).getTaskType();
            TaskAttribute attribute = data.getRoot().createAttribute(mappedKey);
            attribute.getMetaData().defaults().setKind(kind).setLabel(name).setReadOnly(field.isReadOnly()).setType(taskType).putValue("type", type);
            for (String value : field.getValues()) {
                attribute.addValue(value);
            }
            ++n2;
        }
    }

    private HashSet<String> getEditableKeys(TaskData data, JiraIssue jiraIssue, JiraClient client, TaskData oldTaskData, IProgressMonitor monitor) throws JiraException {
        HashSet<String> editableKeys = new HashSet<String>();
        if (!JiraRepositoryConnector.isClosed(jiraIssue)) {
            if (this.useCachedInformation(jiraIssue, oldTaskData)) {
                TaskAttribute attribute2;
                for (TaskAttribute attribute2 : oldTaskData.getRoot().getAttributes().values()) {
                    if (attribute2.getMetaData().isReadOnly()) continue;
                    editableKeys.add(attribute2.getId());
                }
                attribute2 = oldTaskData.getRoot().getAttribute("attribute.jira.read-only");
                if (attribute2 != null) {
                    data.getRoot().deepAddCopy(attribute2);
                }
            } else {
                try {
                    JiraField[] editableAttributes = client.getEditableAttributes(jiraIssue.getKey(), monitor);
                    if (editableAttributes != null) {
                        JiraField[] jiraFieldArray = editableAttributes;
                        int n = editableAttributes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            JiraField field = jiraFieldArray[n2];
                            editableKeys.add(this.mapCommonAttributeKey(field.getId()));
                            ++n2;
                        }
                    }
                }
                catch (JiraInsufficientPermissionException jiraInsufficientPermissionException) {
                    data.getRoot().createAttribute("attribute.jira.read-only");
                }
            }
        }
        return editableKeys;
    }

    private void updateProperties(TaskData data, HashSet<String> editableKeys) {
        for (TaskAttribute attribute : data.getRoot().getAttributes().values()) {
            TaskAttributeMetaData properties = attribute.getMetaData();
            boolean editable = editableKeys.contains(attribute.getId().toLowerCase());
            if (editable && (attribute.getId().startsWith("attribute.jira.custom::") || !JiraAttribute.valueById(attribute.getId()).isHidden())) {
                properties.setKind("task.common.kind.default");
            }
            if ("task.common.comment.new".equals(attribute.getId()) || "task.common.resolution".equals(attribute.getId()) || "task.common.user.assigned".equals(attribute.getId())) {
                properties.setReadOnly(false);
                continue;
            }
            String key = properties.getValue("type");
            Map options = attribute.getOptions();
            if (JiraFieldType.SELECT.getKey().equals(key) && (options.isEmpty() || properties.isReadOnly())) {
                properties.setReadOnly(true);
                continue;
            }
            if (JiraFieldType.MULTISELECT.getKey().equals(key) && options.isEmpty()) {
                properties.setReadOnly(true);
                continue;
            }
            properties.setReadOnly(!editable);
        }
    }

    private void addAttributeValue(TaskData data, JiraAttribute key, String value) {
        data.getRoot().getAttribute(key.id()).addValue(value);
    }

    private TaskAttribute setAttributeValue(TaskData data, JiraAttribute key, String value) {
        TaskAttribute attribute = data.getRoot().getAttribute(key.id());
        attribute.setValue(value);
        return attribute;
    }

    private boolean useCachedInformation(JiraIssue issue, TaskData oldTaskData) {
        TaskAttribute attribute;
        if (oldTaskData != null && issue.getStatus() != null && (attribute = oldTaskData.getRoot().getMappedAttribute("task.common.status")) != null) {
            return attribute.getValue().equals(issue.getStatus().getId());
        }
        return false;
    }

    private void removeAttribute(TaskData data, JiraAttribute key) {
        data.getRoot().removeAttribute(key.id());
    }

    private String capitalize(String s) {
        char c;
        char uc;
        if (s.length() > 1 && (uc = Character.toUpperCase(c = s.charAt(0))) != c) {
            return String.valueOf(uc) + s.substring(1);
        }
        return s;
    }

    private String getAssignee(JiraIssue jiraIssue) {
        String assignee = jiraIssue.getAssignee();
        return assignee == null || "-1".equals(assignee) ? "" : assignee;
    }

    public static String stripTags(String text) {
        int len;
        char[] chars;
        block4: {
            if (text == null || text.length() == 0) {
                return "";
            }
            StringReader stringReader = new StringReader(text);
            HTML2TextReader html2TextReader = new HTML2TextReader(stringReader);
            try {
                chars = new char[text.length()];
                len = html2TextReader.read(chars, 0, text.length());
                if (len != -1) break block4;
                return "";
            }
            catch (IOException iOException) {
                return text;
            }
        }
        return new String(chars, 0, len);
    }

    private void updateMarkup(TaskData data, JiraIssue jiraIssue, JiraClient client, TaskData oldTaskData, IProgressMonitor monitor) throws JiraException {
        if (!jiraIssue.isMarkupDetected()) {
            return;
        }
        if (jiraIssue.getUpdated() != null && oldTaskData != null) {
            String value = this.getAttributeValue(oldTaskData, JiraAttribute.MODIFICATION_DATE);
            if (jiraIssue.getUpdated().equals(JiraUtil.stringToDate(value))) {
                if (data.getRoot().getAttribute("task.common.description") != null) {
                    this.setAttributeValue(data, JiraAttribute.DESCRIPTION, this.getAttributeValue(oldTaskData, JiraAttribute.DESCRIPTION));
                }
                if (data.getRoot().getAttribute("attribute.jira.environment") != null) {
                    this.setAttributeValue(data, JiraAttribute.ENVIRONMENT, this.getAttributeValue(oldTaskData, JiraAttribute.ENVIRONMENT));
                }
                CustomField[] customFieldArray = jiraIssue.getCustomFields();
                int n = customFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CustomField field = customFieldArray[n2];
                    if (field.isMarkupDetected()) {
                        String attributeId = this.mapCommonAttributeKey(field.getId());
                        TaskAttribute oldAttribute = oldTaskData.getRoot().getAttribute(attributeId);
                        if (oldAttribute != null) {
                            TaskAttribute attribute = data.getRoot().getAttribute(attributeId);
                            attribute.setValues(oldAttribute.getValues());
                        }
                    }
                    ++n2;
                }
                return;
            }
        }
        RemoteIssue remoteIssue = client.getSoapClient().getIssueByKey(jiraIssue.getKey(), monitor);
        if (data.getRoot().getAttribute("task.common.description") != null) {
            if (remoteIssue.getDescription() == null) {
                this.setAttributeValue(data, JiraAttribute.DESCRIPTION, "");
            } else {
                this.setAttributeValue(data, JiraAttribute.DESCRIPTION, remoteIssue.getDescription());
            }
        }
        if (data.getRoot().getAttribute("attribute.jira.environment") != null) {
            if (remoteIssue.getEnvironment() == null) {
                this.setAttributeValue(data, JiraAttribute.ENVIRONMENT, "");
            } else {
                this.setAttributeValue(data, JiraAttribute.ENVIRONMENT, remoteIssue.getEnvironment());
            }
        }
        RemoteCustomFieldValue[] fields = remoteIssue.getCustomFieldValues();
        CustomField[] customFieldArray = jiraIssue.getCustomFields();
        int n = customFieldArray.length;
        int n3 = 0;
        while (n3 < n) {
            CustomField field = customFieldArray[n3];
            if (field.isMarkupDetected()) {
                RemoteCustomFieldValue[] remoteCustomFieldValueArray = fields;
                int n4 = fields.length;
                int n5 = 0;
                while (n5 < n4) {
                    RemoteCustomFieldValue remoteField = remoteCustomFieldValueArray[n5];
                    if (field.getId().equals(remoteField.getCustomfieldId())) {
                        String attributeId = this.mapCommonAttributeKey(field.getId());
                        TaskAttribute attribute = data.getRoot().getAttribute(attributeId);
                        if (attribute == null) break;
                        attribute.setValues(Arrays.asList(remoteField.getValues()));
                        break;
                    }
                    ++n5;
                }
            }
            ++n3;
        }
    }

    public void addOperations(TaskData data, JiraIssue issue, JiraClient client, TaskData oldTaskData, IProgressMonitor monitor) throws JiraException {
        if (this.useCachedInformation(issue, oldTaskData)) {
            List attributes = oldTaskData.getAttributeMapper().getAttributesByType(oldTaskData, "operation");
            for (TaskAttribute taskAttribute : attributes) {
                data.getRoot().deepAddCopy(taskAttribute);
            }
            return;
        }
        String label = "Leave as " + issue.getStatus().getName();
        TaskAttribute attribute = data.getRoot().createAttribute("task.common.operation-leave");
        TaskOperation.applyTo((TaskAttribute)attribute, (String)LEAVE_OPERATION, (String)label);
        attribute = data.getRoot().createAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)attribute, (String)LEAVE_OPERATION, (String)label);
        JiraAction[] availableActions = client.getAvailableActions(issue.getKey(), monitor);
        if (availableActions != null) {
            JiraAction[] jiraActionArray = availableActions;
            int n = availableActions.length;
            int n2 = 0;
            while (n2 < n) {
                String[] fields;
                JiraAction action = jiraActionArray[n2];
                attribute = data.getRoot().createAttribute("task.common.operation-" + action.getId());
                TaskOperation.applyTo((TaskAttribute)attribute, (String)action.getId(), (String)action.getName());
                String[] stringArray = fields = client.getActionFields(issue.getKey(), action.getId(), monitor);
                int n3 = fields.length;
                int n4 = 0;
                while (n4 < n3) {
                    String field = stringArray[n4];
                    if ("task.common.resolution".equals(this.mapCommonAttributeKey(field))) {
                        attribute.getMetaData().putValue("task.meta.associated.attribute", "task.common.resolution");
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public RepositoryResponse postTaskData(TaskRepository repository, TaskData taskData, Set<TaskAttribute> changedAttributes, IProgressMonitor monitor) throws CoreException {
        try {
            JiraIssue issue;
            block15: {
                String newComment;
                String operationId;
                JiraClient client;
                block14: {
                    monitor.beginTask("Sending task", -1);
                    client = this.clientFactory.getJiraClient(repository);
                    if (client == null) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.internal.jira.core", 4, "Unable to create Jira client", null));
                    }
                    try {
                        if (!client.getCache().hasDetails()) {
                            client.getCache().refreshDetails((IProgressMonitor)new NullProgressMonitor());
                        }
                        issue = this.buildJiraIssue(taskData, client);
                        if (taskData.isNew()) {
                            if ((issue = issue.getType().isSubTaskType() && issue.getParentId() != null ? client.createSubTask(issue, monitor) : client.createIssue(issue, monitor)) == null) {
                                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.internal.jira.core", 0, "Could not create issue.", null));
                            }
                            RepositoryResponse repositoryResponse = new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_CREATED, issue.getId());
                            return repositoryResponse;
                        }
                        operationId = this.getOperationId(taskData);
                        newComment = this.getNewComment(taskData);
                        if (!LEAVE_OPERATION.equals(operationId) && !REASSIGN_OPERATION.equals(operationId)) break block14;
                    }
                    catch (JiraException e) {
                        IStatus status = JiraCorePlugin.toStatus(repository, e);
                        JiraTaskDataHandler.trace(status);
                        throw new CoreException(status);
                    }
                    if (!JiraRepositoryConnector.isClosed(issue) && taskData.getRoot().getMappedAttribute("attribute.jira.read-only") == null) {
                        client.updateIssue(issue, newComment, monitor);
                    } else if (newComment.length() > 0) {
                        client.addCommentToIssue(issue, newComment, monitor);
                    }
                    break block15;
                }
                client.advanceIssueWorkflow(issue, operationId, newComment, monitor);
            }
            RepositoryResponse repositoryResponse = new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_UPDATED, issue.getId());
            return repositoryResponse;
        }
        finally {
            monitor.done();
        }
    }

    private String getNewComment(TaskData taskData) {
        String newComment = "";
        TaskAttribute attribute = taskData.getRoot().getMappedAttribute("task.common.comment.new");
        if (attribute != null) {
            newComment = taskData.getAttributeMapper().getValue(attribute);
        }
        return newComment;
    }

    private String getOperationId(TaskData taskData) {
        String operationId = "";
        TaskAttribute attribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        if (attribute != null) {
            operationId = taskData.getAttributeMapper().getValue(attribute);
        }
        if (operationId.length() == 0) {
            operationId = LEAVE_OPERATION;
        }
        return operationId;
    }

    public boolean initializeTaskData(TaskRepository repository, TaskData data, ITaskMapping initializationData, IProgressMonitor monitor) throws CoreException {
        Project project;
        if (initializationData == null) {
            return false;
        }
        String product = initializationData.getProduct();
        if (product == null) {
            return false;
        }
        JiraClient client = this.clientFactory.getJiraClient(repository);
        if (!client.getCache().hasDetails()) {
            try {
                client.getCache().refreshDetails(monitor);
            }
            catch (JiraException ex) {
                IStatus status = JiraCorePlugin.toStatus(repository, ex);
                JiraTaskDataHandler.trace(status);
                throw new CoreException(status);
            }
        }
        if ((project = this.getProject(client, product)) == null) {
            return false;
        }
        this.initializeTaskData(data, client, project);
        return true;
    }

    private Project getProject(JiraClient client, String product) {
        Project[] projects;
        Project[] projectArray = projects = client.getCache().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            Project project = projectArray[n2];
            if (product.equals(project.getName()) || product.equals(project.getKey())) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    public boolean initializeSubTaskData(TaskRepository repository, TaskData taskData, TaskData parentTaskData, IProgressMonitor monitor) throws CoreException {
        try {
            IssueType[] jiraIssueTypes;
            TaskAttribute projectAttribute;
            monitor.beginTask("Creating subtask", -1);
            JiraClient client = JiraClientFactory.getDefault().getJiraClient(repository);
            if (!client.getCache().hasDetails()) {
                client.getCache().refreshDetails((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            if ((projectAttribute = parentTaskData.getRoot().getAttribute("task.common.product")) == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.internal.jira.core", 0, "The parent task does not have a valid project.", null));
            }
            Project project = client.getCache().getProjectById(projectAttribute.getValue());
            this.initializeTaskData(taskData, client, project);
            new JiraTaskMapper(taskData).merge((ITaskMapping)new JiraTaskMapper(parentTaskData));
            taskData.getRoot().getAttribute(JiraAttribute.PROJECT.id()).setValue(project.getId());
            taskData.getRoot().getAttribute(JiraAttribute.DESCRIPTION.id()).setValue("");
            taskData.getRoot().getAttribute(JiraAttribute.SUMMARY.id()).setValue("");
            TaskAttribute typeAttribute = taskData.getRoot().getAttribute(JiraAttribute.TYPE.id());
            typeAttribute.clearOptions();
            IssueType[] issueTypeArray = jiraIssueTypes = client.getCache().getIssueTypes();
            int n = jiraIssueTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IssueType type = issueTypeArray[n2];
                if (type.isSubTaskType()) {
                    typeAttribute.putOption(type.getId(), type.getName());
                }
                ++n2;
            }
            Map options = typeAttribute.getOptions();
            if (options.size() == 0) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.internal.jira.core", 0, "The repository does not support subtasks.", null));
            }
            if (options.size() == 1) {
                typeAttribute.getMetaData().setReadOnly(true);
            }
            typeAttribute.setValue((String)options.keySet().iterator().next());
            typeAttribute.getMetaData().putValue("isSubtaskType", Boolean.TRUE.toString());
            TaskAttribute attribute = taskData.getRoot().getAttribute(JiraAttribute.PARENT_ID.id());
            attribute.setValue(parentTaskData.getTaskId());
            attribute = taskData.getRoot().getAttribute(JiraAttribute.PARENT_KEY.id());
            attribute.setValue(parentTaskData.getRoot().getAttribute(JiraAttribute.ISSUE_KEY.id()).getValue());
            return true;
        }
        catch (JiraException e) {
            IStatus status = JiraCorePlugin.toStatus(repository, e);
            JiraTaskDataHandler.trace(status);
            throw new CoreException(status);
        }
        finally {
            monitor.done();
        }
    }

    public boolean canInitializeSubTaskData(TaskRepository taskRepository, ITask task) {
        return true;
    }

    private JiraIssue buildJiraIssue(TaskData taskData, JiraClient client) {
        TaskAttribute affectsVersionAttr;
        TaskAttribute fixVersionAttr;
        String estimate;
        String securityLevelId;
        JiraIssue issue = new JiraIssue();
        issue.setId(taskData.getTaskId());
        issue.setKey(this.getAttributeValue(taskData, JiraAttribute.ISSUE_KEY));
        issue.setSummary(this.getAttributeValue(taskData, JiraAttribute.SUMMARY));
        issue.setDescription(this.getAttributeValue(taskData, JiraAttribute.DESCRIPTION));
        issue.setDue(JiraUtil.stringToDate(this.getAttributeValue(taskData, JiraAttribute.DUE_DATE)));
        String parentId = this.getAttributeValue(taskData, JiraAttribute.PARENT_ID);
        if (parentId != null) {
            issue.setParentId(parentId);
        }
        if ((securityLevelId = this.getAttributeValue(taskData, JiraAttribute.SECURITY_LEVEL)) != null) {
            issue.setSecurityLevel(new SecurityLevel(securityLevelId));
        }
        if ((estimate = this.getAttributeValue(taskData, JiraAttribute.ESTIMATE)) != null) {
            try {
                issue.setEstimate(Long.parseLong(estimate));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((estimate = this.getAttributeValue(taskData, JiraAttribute.INITIAL_ESTIMATE)) != null) {
            try {
                issue.setInitialEstimate(Long.parseLong(estimate));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        issue.setProject(new Project(this.getAttributeValue(taskData, JiraAttribute.PROJECT)));
        boolean subTaskType = JiraTaskDataHandler.hasSubTaskType(this.getAttribute(taskData, JiraAttribute.TYPE));
        IssueType issueType = new IssueType(this.getAttributeValue(taskData, JiraAttribute.TYPE), subTaskType);
        issue.setType(issueType);
        issue.setStatus(new JiraStatus(this.getAttributeValue(taskData, JiraAttribute.STATUS)));
        TaskAttribute componentsAttribute = taskData.getRoot().getMappedAttribute("attribute.jira.components");
        if (componentsAttribute != null) {
            ArrayList<Component> components = new ArrayList<Component>();
            for (String value : componentsAttribute.getValues()) {
                components.add(new Component(value));
            }
            issue.setComponents(components.toArray(new Component[components.size()]));
        }
        if ((fixVersionAttr = taskData.getRoot().getMappedAttribute("attribute.jira.fixversions")) != null) {
            ArrayList<Version> fixVersions = new ArrayList<Version>();
            for (String value : fixVersionAttr.getValues()) {
                fixVersions.add(new Version(value));
            }
            issue.setFixVersions(fixVersions.toArray(new Version[fixVersions.size()]));
        }
        if ((affectsVersionAttr = taskData.getRoot().getMappedAttribute("attribute.jira.affectsversions")) != null) {
            ArrayList<Version> affectsVersions = new ArrayList<Version>();
            for (String value : affectsVersionAttr.getValues()) {
                affectsVersions.add(new Version(value));
            }
            issue.setReportedVersions(affectsVersions.toArray(new Version[affectsVersions.size()]));
        }
        issue.setReporter(this.getAttributeValue(taskData, JiraAttribute.USER_REPORTER));
        String assignee = this.getAttributeValue(taskData, JiraAttribute.USER_ASSIGNED);
        issue.setAssignee(JiraRepositoryConnector.getAssigneeFromAttribute(assignee));
        issue.setEnvironment(this.getAttributeValue(taskData, JiraAttribute.ENVIRONMENT));
        String priorityId = this.getAttributeValue(taskData, JiraAttribute.PRIORITY);
        if (priorityId != null) {
            issue.setPriority(new Priority(priorityId));
        }
        ArrayList<CustomField> customFields = new ArrayList<CustomField>();
        for (TaskAttribute attribute : taskData.getRoot().getAttributes().values()) {
            if (!attribute.getId().startsWith("attribute.jira.custom::")) continue;
            String id = attribute.getId().substring("attribute.jira.custom::".length());
            String type = attribute.getMetaData().getValue("type");
            CustomField field = new CustomField(id, type, "", attribute.getValues());
            customFields.add(field);
        }
        issue.setCustomFields(customFields.toArray(new CustomField[customFields.size()]));
        String resolutionId = this.getAttributeValue(taskData, JiraAttribute.RESOLUTION);
        if (resolutionId != null) {
            issue.setResolution(new Resolution(resolutionId));
        }
        return issue;
    }

    public static boolean hasSubTaskType(TaskAttribute typeAttribute) {
        return Boolean.parseBoolean(typeAttribute.getMetaData().getValue("isSubtaskType"));
    }

    private TaskAttribute getAttribute(TaskData taskData, JiraAttribute key) {
        return taskData.getRoot().getAttribute(key.id());
    }

    private String getAttributeValue(TaskData taskData, JiraAttribute key) {
        TaskAttribute attribute = taskData.getRoot().getAttribute(key.id());
        return attribute != null ? attribute.getValue() : null;
    }

    private static void trace(IStatus status) {
        if (TRACE_ENABLED) {
            JiraCorePlugin.getDefault().getLog().log(status);
        }
    }

    public TaskAttributeMapper getAttributeMapper(TaskRepository taskRepository) {
        JiraClient client = this.clientFactory.getJiraClient(taskRepository);
        return new JiraAttributeMapper(taskRepository, client);
    }

    public void migrateTaskData(TaskRepository taskRepository, TaskData taskData) {
        String taskDataVersion = taskData.getVersion();
        JiraVersion version = new JiraVersion(taskDataVersion != null ? taskDataVersion : "0.0");
        if (version.isSmallerOrEquals(TASK_DATA_VERSION_1_0)) {
            for (TaskAttribute attribute : taskData.getRoot().getAttributes().values()) {
                if ("task.common.product".equals(attribute.getId())) {
                    String projectName = attribute.getValue();
                    Map options = taskData.getAttributeMapper().getOptions(attribute);
                    for (String key : options.keySet()) {
                        String value = (String)options.get(key);
                        if (projectName.equals(value)) {
                            attribute.setValue(key);
                        }
                        attribute.putOption(key, value);
                    }
                    continue;
                }
                Object type = JiraFieldType.fromKey(attribute.getMetaData().getValue("type"));
                if (JiraFieldType.SELECT != type && JiraFieldType.MULTISELECT != type || attribute.getOptions().isEmpty()) continue;
                HashSet values = new HashSet(attribute.getValues());
                attribute.clearValues();
                Map options = attribute.getOptions();
                for (String key : options.keySet()) {
                    if (!values.contains(options.get(key))) continue;
                    attribute.addValue(key);
                }
            }
        }
        if (version.isSmallerOrEquals(TASK_DATA_VERSION_2_0)) {
            ArrayList attributes = new ArrayList(taskData.getRoot().getAttributes().values());
            for (TaskAttribute attribute : attributes) {
                if (attribute.getId().startsWith("task.common.operation-")) {
                    if (attribute.getValue().equals(REASSIGN_OPERATION)) {
                        taskData.getRoot().removeAttribute(attribute.getId());
                        continue;
                    }
                    TaskAttribute associatedAttribute = taskData.getAttributeMapper().getAssoctiatedAttribute(attribute);
                    if (associatedAttribute != null && associatedAttribute.getId().equals("resolution")) {
                        TaskAttribute resolutionAttribute = taskData.getRoot().getAttribute(JiraAttribute.RESOLUTION.id());
                        if (resolutionAttribute != null) {
                            Map options = associatedAttribute.getOptions();
                            for (String key : options.keySet()) {
                                resolutionAttribute.putOption(key, (String)options.get(key));
                            }
                            resolutionAttribute.getMetaData().setType("singleSelect");
                            resolutionAttribute.getMetaData().setReadOnly(false);
                        }
                        attribute.getMetaData().putValue("task.meta.associated.attribute", JiraAttribute.RESOLUTION.id());
                        attribute.removeAttribute(associatedAttribute.getId());
                    }
                } else if (attribute.getId().equals(JiraAttribute.TYPE.id()) && attribute.getOptions().isEmpty()) {
                    IssueType[] jiraIssueTypes;
                    JiraClient client = this.clientFactory.getJiraClient(taskRepository);
                    IssueType[] issueTypeArray = jiraIssueTypes = client.getCache().getIssueTypes();
                    int n = jiraIssueTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IssueType type = issueTypeArray[n2];
                        if (attribute.getValue().equals(type.getName())) {
                            attribute.putOption(type.getId(), type.getName());
                            attribute.setValue(type.getId());
                            break;
                        }
                        ++n2;
                    }
                }
                attribute.getMetaData().setType(this.getType(attribute));
            }
        }
        if (version.isSmallerOrEquals(TASK_DATA_VERSION_2_2)) {
            for (TaskAttribute attribute : taskData.getRoot().getAttributes().values()) {
                String value;
                JiraTimeFormat format = new JiraTimeFormat();
                if (!JiraTaskDataHandler.isTimeSpanAttribute(attribute) || (value = attribute.getValue()).length() <= 0) continue;
                try {
                    Long.parseLong(value);
                }
                catch (NumberFormatException numberFormatException) {
                    attribute.setValue(String.valueOf(format.parse(value)));
                }
            }
        }
        if (version.isSmallerOrEquals(TASK_DATA_VERSION_CURRENT)) {
            taskData.setVersion(TASK_DATA_VERSION_CURRENT.toString());
        }
    }

    public static boolean isTimeSpanAttribute(TaskAttribute attribute) {
        return JiraAttribute.INITIAL_ESTIMATE.id().equals(attribute.getId()) || JiraAttribute.ESTIMATE.id().equals(attribute.getId()) || JiraAttribute.ACTUAL.id().equals(attribute.getId());
    }

    private String getType(TaskAttribute taskAttribute) {
        if (JiraAttribute.DESCRIPTION.id().equals(taskAttribute.getId())) {
            return "longRichText";
        }
        if (JiraAttribute.COMMENT_NEW.id().equals(taskAttribute.getId())) {
            return "longRichText";
        }
        if (JiraAttribute.SUMMARY.id().equals(taskAttribute.getId())) {
            return "shortRichText";
        }
        if ("task.common.operation".equals(taskAttribute.getId()) || taskAttribute.getId().startsWith("task.common.operation-")) {
            return "operation";
        }
        if (taskAttribute.getId().startsWith("task.common.comment-")) {
            return "comment";
        }
        if (taskAttribute.getId().startsWith("task.common.attachment-")) {
            return "attachment";
        }
        JiraFieldType fieldType = null;
        if (JiraAttribute.CREATION_DATE.id().equals(taskAttribute.getId()) || JiraAttribute.DUE_DATE.id().equals(taskAttribute.getId()) || JiraAttribute.MODIFICATION_DATE.id().equals(taskAttribute.getId())) {
            fieldType = JiraFieldType.DATE;
            taskAttribute.getMetaData().putValue("type", fieldType.getKey());
        }
        if (fieldType == null) {
            fieldType = JiraFieldType.fromKey(taskAttribute.getMetaData().getValue("type"));
        }
        if (fieldType.getTaskType() != null) {
            return fieldType.getTaskType();
        }
        fieldType = JiraAttribute.valueById(taskAttribute.getId()).getType();
        if (fieldType.getTaskType() != null) {
            return fieldType.getTaskType();
        }
        String existingType = taskAttribute.getMetaData().getType();
        if (existingType != null) {
            return existingType;
        }
        return "shortText";
    }

    public String mapCommonAttributeKey(String key) {
        if ("summary".equals(key)) {
            return JiraAttribute.SUMMARY.id();
        }
        if ("description".equals(key)) {
            return JiraAttribute.DESCRIPTION.id();
        }
        if ("priority".equals(key)) {
            return JiraAttribute.PRIORITY.id();
        }
        if ("resolution".equals(key)) {
            return JiraAttribute.RESOLUTION.id();
        }
        if ("assignee".equals(key)) {
            return JiraAttribute.USER_ASSIGNED.id();
        }
        if ("environment".equals(key)) {
            return JiraAttribute.ENVIRONMENT.id();
        }
        if ("issuetype".equals(key)) {
            return JiraAttribute.TYPE.id();
        }
        if ("components".equals(key)) {
            return JiraAttribute.COMPONENTS.id();
        }
        if ("versions".equals(key)) {
            return JiraAttribute.AFFECTSVERSIONS.id();
        }
        if ("fixVersions".equals(key)) {
            return JiraAttribute.FIXVERSIONS.id();
        }
        if ("timetracking".equals(key)) {
            return JiraAttribute.ESTIMATE.id();
        }
        if ("duedate".equals(key)) {
            return JiraAttribute.DUE_DATE.id();
        }
        if (key.startsWith("issueLink")) {
            return "attribute.jira.link::" + key;
        }
        if (key.startsWith("customfield")) {
            return "attribute.jira.custom::" + key;
        }
        return key;
    }
}

