/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service;

import org.eclipse.mylyn.internal.jira.core.service.JiraRemoteException;

public class JiraRemoteMessageException
extends JiraRemoteException {
    private static final long serialVersionUID = 4622602207502097037L;
    private final String htmlMessage;

    public JiraRemoteMessageException(String message, String htmlMessage) {
        super(message);
        this.htmlMessage = htmlMessage;
    }

    public JiraRemoteMessageException(String htmlMessage) {
        super(JiraRemoteMessageException.getTitle(htmlMessage));
        this.htmlMessage = htmlMessage;
    }

    private static String getTitle(String text) {
        int stop;
        if (text == null) {
            return null;
        }
        int start = text.indexOf("<strong>");
        if (start != -1 && (stop = text.indexOf("</strong>", start + 8)) != -1) {
            return text.substring(start + 8, stop);
        }
        return null;
    }

    public String getHtmlMessage() {
        return this.htmlMessage;
    }

    public String toString() {
        String message = this.getMessage();
        if (message != null) {
            if (this.htmlMessage != null) {
                return String.valueOf(message) + " (" + this.htmlMessage + ")";
            }
            return message;
        }
        return this.htmlMessage;
    }
}

