/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service.soap;

import org.apache.commons.httpclient.HttpMethodBase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class JiraRequest {
    private static final int METHOD_POLL_INTERVAL = 200;
    private static ThreadLocal<JiraRequest> currentRequest = new ThreadLocal();
    private volatile HttpMethodBase method;
    private final IProgressMonitor monitor;
    private volatile boolean done;

    public static JiraRequest getCurrentRequest() {
        return currentRequest.get();
    }

    public static void setCurrentRequest(JiraRequest request) {
        currentRequest.set(request);
    }

    public JiraRequest(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void cancel() {
        while (this.method == null) {
            if (this.done) {
                throw new OperationCanceledException();
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                throw new OperationCanceledException();
            }
        }
        this.method.abort();
    }

    public HttpMethodBase getMethod() {
        return this.method;
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMethod(HttpMethodBase method) {
        this.method = method;
    }

    public void done() {
        this.done = true;
    }
}

