/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service.soap;

import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.configuration.FileProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.commons.net.UnsupportedRequestException;
import org.eclipse.mylyn.commons.net.WebRequest;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.jira.core.model.Comment;
import org.eclipse.mylyn.internal.jira.core.model.Component;
import org.eclipse.mylyn.internal.jira.core.model.CustomField;
import org.eclipse.mylyn.internal.jira.core.model.Group;
import org.eclipse.mylyn.internal.jira.core.model.IssueType;
import org.eclipse.mylyn.internal.jira.core.model.JiraAction;
import org.eclipse.mylyn.internal.jira.core.model.JiraField;
import org.eclipse.mylyn.internal.jira.core.model.JiraStatus;
import org.eclipse.mylyn.internal.jira.core.model.NamedFilter;
import org.eclipse.mylyn.internal.jira.core.model.Priority;
import org.eclipse.mylyn.internal.jira.core.model.Project;
import org.eclipse.mylyn.internal.jira.core.model.Resolution;
import org.eclipse.mylyn.internal.jira.core.model.ServerInfo;
import org.eclipse.mylyn.internal.jira.core.model.User;
import org.eclipse.mylyn.internal.jira.core.model.Version;
import org.eclipse.mylyn.internal.jira.core.service.JiraAuthenticationException;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.service.JiraInsufficientPermissionException;
import org.eclipse.mylyn.internal.jira.core.service.JiraServiceUnavailableException;
import org.eclipse.mylyn.internal.jira.core.service.soap.JiraRequest;
import org.eclipse.mylyn.internal.jira.core.service.soap.JiraSoapConverter;
import org.eclipse.mylyn.internal.jira.core.service.soap.JiraSoapServiceLocator;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteField;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteIssue;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteNamedObject;
import org.eclipse.mylyn.internal.jira.core.wsdl.soap.JiraSoapService;
import org.eclipse.mylyn.internal.jira.core.wsdl.soap.RemoteAuthenticationException;
import org.eclipse.mylyn.internal.jira.core.wsdl.soap.RemotePermissionException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraSoapClient {
    private static final String ERROR_RPC_NOT_ENABLED = "JIRA RPC services are not enabled. Please contact your JIRA administrator.";
    private static final String REMOTE_ERROR_BAD_ID = "White spaces are required between publicId and systemId.";
    private static final String REMOTE_ERROR_BAD_ENVELOPE_TAG = "Bad envelope tag:  html";
    private static final String REMOTE_ERROR_CONTENT_NOT_ALLOWED_IN_PROLOG = "Content is not allowed in prolog.";
    private static final String SOAP_SERVICE_URL = "/rpc/soap/jirasoapservice-v2";
    private static final long DEFAULT_SESSION_TIMEOUT = 600000L;
    private JiraSoapService soapService = null;
    private final Lock soapServiceLock = new ReentrantLock();
    private final LoginToken loginToken;
    private final JiraClient jiraClient;

    public JiraSoapClient(JiraClient jiraClient) {
        this.jiraClient = jiraClient;
        this.loginToken = new LoginToken(jiraClient.getLocation(), 600000L);
    }

    private JiraSoapService getSoapService() throws JiraException {
        this.soapServiceLock.lock();
        try {
            if (this.soapService == null) {
                JiraSoapServiceLocator locator = new JiraSoapServiceLocator((EngineConfiguration)new FileProvider(this.getClass().getClassLoader().getResourceAsStream("client-config.wsdd")));
                locator.setLocation(this.jiraClient.getLocation());
                locator.setCompression(this.jiraClient.useCompression());
                try {
                    this.soapService = locator.getJirasoapserviceV2(new URL(String.valueOf(this.jiraClient.getBaseUrl()) + SOAP_SERVICE_URL));
                }
                catch (ServiceException e) {
                    throw new JiraException(e);
                }
                catch (MalformedURLException e) {
                    throw new JiraException(e);
                }
                if (this.soapService == null) {
                    throw new JiraException("Initialization of JIRA Soap service failed");
                }
            }
            JiraSoapService jiraSoapService = this.soapService;
            return jiraSoapService;
        }
        finally {
            this.soapServiceLock.unlock();
        }
    }

    public User getUser(IProgressMonitor monitor, final String username) throws JiraException {
        return this.call(monitor, new RemoteRunnable<User>(){

            @Override
            public User run() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getUser(JiraSoapClient.this.loginToken.getCurrentValue(), username));
            }
        });
    }

    public Component[] getComponents(final String projectKey, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new RemoteRunnable<Component[]>(){

            @Override
            public Component[] run() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getComponents(JiraSoapClient.this.loginToken.getCurrentValue(), projectKey));
            }
        });
    }

    public void login(IProgressMonitor monitor) throws JiraException {
        this.loginToken.expire();
        this.call(monitor, new RemoteRunnable<Object>(){

            @Override
            public Object run() throws RemoteException, JiraException {
                return JiraSoapClient.this.loginToken.getCurrentValue();
            }
        });
    }

    public Group getGroup(final String name, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new RemoteRunnable<Group>(){

            @Override
            public Group run() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getGroup(JiraSoapClient.this.loginToken.getCurrentValue(), name));
            }
        });
    }

    public ServerInfo getServerInfo(IProgressMonitor monitor) throws JiraException {
        ServerInfo serverInfo = this.call(monitor, new RemoteRunnable<ServerInfo>(){

            @Override
            public ServerInfo run() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getServerInfo(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
        return serverInfo;
    }

    public String getKeyFromId(final String issueId, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new RemoteRunnable<String>(){

            @Override
            public String run() throws RemoteException, JiraException {
                RemoteIssue issue = JiraSoapClient.this.getSoapService().getIssueById(JiraSoapClient.this.loginToken.getCurrentValue(), issueId);
                return issue != null ? issue.getKey() : null;
            }
        });
    }

    public JiraAction[] getAvailableActions(final String taskKey, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new RemoteRunnable<JiraAction[]>(){

            @Override
            public JiraAction[] run() throws RemoteException, JiraException {
                RemoteNamedObject[] actions = JiraSoapClient.this.getSoapService().getAvailableActions(JiraSoapClient.this.loginToken.getCurrentValue(), taskKey);
                if (actions == null) {
                    return new JiraAction[0];
                }
                JiraAction[] operations = new JiraAction[actions.length];
                int i = 0;
                while (i < actions.length) {
                    RemoteNamedObject action = actions[i];
                    operations[i] = new JiraAction(action.getId(), action.getName());
                    ++i;
                }
                return operations;
            }
        });
    }

    public String[] getActionFields(final String taskKey, final String actionId, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new RemoteRunnable<String[]>(){

            @Override
            public String[] run() throws RemoteException, JiraException {
                RemoteField[] remoteFields = JiraSoapClient.this.getSoapService().getFieldsForAction(JiraSoapClient.this.loginToken.getCurrentValue(), taskKey, actionId);
                if (remoteFields == null) {
                    return new String[0];
                }
                String[] fields = new String[remoteFields.length];
                int i = 0;
                while (i < remoteFields.length) {
                    fields[i] = remoteFields[i].getId();
                    ++i;
                }
                return fields;
            }
        });
    }

    public JiraField[] getEditableAttributes(final String taskKey, final boolean workAroundBug205015, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new RemoteRunnable<JiraField[]>(){

            @Override
            public JiraField[] run() throws RemoteException, JiraException {
                RemoteField[] fields = JiraSoapClient.this.getSoapService().getFieldsForEdit(JiraSoapClient.this.loginToken.getCurrentValue(), taskKey);
                if (fields == null) {
                    return new JiraField[0];
                }
                int add = 0;
                if (workAroundBug205015) {
                    add += 2;
                }
                JiraField[] attributes = new JiraField[fields.length + add];
                int i = 0;
                while (i < fields.length) {
                    RemoteField field = fields[i];
                    attributes[i] = new JiraField(field.getId(), field.getName());
                    ++i;
                }
                if (add > 0) {
                    attributes[attributes.length - 2] = new JiraField("duedate", "Due Date");
                    attributes[attributes.length - 1] = new JiraField("fixVersions", "Fix Version/s");
                }
                return attributes;
            }
        });
    }

    public CustomField[] getCustomAttributes(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new RemoteRunnable<CustomField[]>(){

            @Override
            public CustomField[] run() throws RemoteException, JiraException {
                RemoteField[] remoteFields = JiraSoapClient.this.getSoapService().getCustomFields(JiraSoapClient.this.loginToken.getCurrentValue());
                CustomField[] fields = new CustomField[remoteFields.length];
                int i = 0;
                while (i < remoteFields.length) {
                    RemoteField remoteField = remoteFields[i];
                    fields[i] = new CustomField(remoteField.getId(), null, remoteField.getName(), Collections.<String>emptyList());
                    ++i;
                }
                return fields;
            }
        });
    }

    public RemoteIssue getIssueByKey(final String key, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new RemoteRunnable<RemoteIssue>(){

            @Override
            public RemoteIssue run() throws RemoteException, JiraException {
                return JiraSoapClient.this.getSoapService().getIssue(JiraSoapClient.this.loginToken.getCurrentValue(), key);
            }
        });
    }

    public Project[] getProjects(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new RemoteRunnable<Project[]>(){

            @Override
            public Project[] run() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getProjects(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public Project[] getProjectsNoSchemes(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new RemoteRunnable<Project[]>(){

            @Override
            public Project[] run() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getProjectsNoSchemes(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public JiraStatus[] getStatuses(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new RemoteRunnable<JiraStatus[]>(){

            @Override
            public JiraStatus[] run() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getStatuses(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public IssueType[] getIssueTypes(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new RemoteRunnable<IssueType[]>(){

            @Override
            public IssueType[] run() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getIssueTypes(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public IssueType[] getSubTaskIssueTypes(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new RemoteRunnable<IssueType[]>(){

            @Override
            public IssueType[] run() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getSubTaskIssueTypes(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public Priority[] getPriorities(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new RemoteRunnable<Priority[]>(){

            @Override
            public Priority[] run() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getPriorities(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public Resolution[] getResolutions(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new RemoteRunnable<Resolution[]>(){

            @Override
            public Resolution[] run() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getResolutions(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public Comment[] getComments(String issueKey, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new RemoteRunnable<Comment[]>(){

            @Override
            public Comment[] run() throws RemoteException, JiraException {
                return null;
            }
        });
    }

    public Version[] getVersions(final String componentKey, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new RemoteRunnable<Version[]>(){

            @Override
            public Version[] run() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getVersions(JiraSoapClient.this.loginToken.getCurrentValue(), componentKey));
            }
        });
    }

    public void logout(IProgressMonitor monitor) throws JiraException {
        this.callOnce(monitor, new RemoteRunnable<Object>(){

            @Override
            public Object run() throws RemoteException, JiraException {
                JiraSoapClient.this.loginToken.expire();
                return null;
            }
        });
    }

    public NamedFilter[] getNamedFilters(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new RemoteRunnable<NamedFilter[]>(){

            @Override
            public NamedFilter[] run() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getSavedFilters(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    static String unwrapRemoteException(RemoteException e) {
        AxisFault fault;
        Element httpErrorElement;
        if (e instanceof AxisFault && (httpErrorElement = (fault = (AxisFault)e).lookupFaultDetail(Constants.QNAME_FAULTDETAIL_HTTPERRORCODE)) != null) {
            int responseCode = Integer.parseInt(httpErrorElement.getFirstChild().getTextContent());
            switch (responseCode) {
                case 500: {
                    return "Internal Server Error. Please contact your JIRA administrator.";
                }
                case 503: {
                    return ERROR_RPC_NOT_ENABLED;
                }
                case 404: {
                    return "No JIRA repository found at location.";
                }
                case 301: {
                    return "The location of the Jira server has moved.";
                }
            }
        }
        if (e.getCause() != null) {
            Throwable cause = e.getCause();
            if (cause instanceof UnknownHostException) {
                return "Unknown host.";
            }
            if (cause instanceof ConnectException) {
                return "Unable to connect to server.";
            }
            if (cause instanceof SAXException && (REMOTE_ERROR_BAD_ENVELOPE_TAG.equals(cause.getMessage()) || REMOTE_ERROR_BAD_ID.equals(cause.getMessage()) || REMOTE_ERROR_CONTENT_NOT_ALLOWED_IN_PROLOG.equals(cause.getMessage()))) {
                return ERROR_RPC_NOT_ENABLED;
            }
            return e.getCause().getLocalizedMessage();
        }
        if (e instanceof AxisFault) {
            return "Server error: " + e.getLocalizedMessage();
        }
        return e.getLocalizedMessage();
    }

    private <T> T callWithRetry(IProgressMonitor monitor, RemoteRunnable<T> runnable) throws JiraException {
        try {
            return this.callOnce(monitor, runnable);
        }
        catch (JiraAuthenticationException jiraAuthenticationException) {
            this.loginToken.expire();
            return this.callOnce(monitor, runnable);
        }
    }

    private <T> T callOnce(IProgressMonitor monitor, final RemoteRunnable<T> runnable) throws JiraException, JiraInsufficientPermissionException, JiraAuthenticationException, JiraServiceUnavailableException {
        try {
            monitor = Policy.monitorFor((IProgressMonitor)monitor);
            final JiraRequest request = new JiraRequest(monitor);
            return (T)WebUtil.execute((IProgressMonitor)monitor, (WebRequest)new WebRequest<T>(){

                public void abort() {
                    request.cancel();
                }

                public T call() throws Exception {
                    try {
                        JiraRequest.setCurrentRequest(request);
                        Object t = runnable.run();
                        return t;
                    }
                    finally {
                        request.done();
                    }
                }
            });
        }
        catch (RemotePermissionException e) {
            throw new JiraInsufficientPermissionException(e.getMessage());
        }
        catch (RemoteAuthenticationException e) {
            throw new JiraAuthenticationException(e.getMessage());
        }
        catch (org.eclipse.mylyn.internal.jira.core.wsdl.soap.RemoteException e) {
            throw new JiraServiceUnavailableException(e.getMessage());
        }
        catch (RemoteException e) {
            throw new JiraServiceUnavailableException(JiraSoapClient.unwrapRemoteException(e));
        }
        catch (JiraException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T call(IProgressMonitor monitor, RemoteRunnable<T> runnable) throws JiraException {
        while (true) {
            try {
                return this.callWithRetry(monitor, runnable);
            }
            catch (JiraAuthenticationException e) {
                try {
                    this.jiraClient.getLocation().requestCredentials(AuthenticationType.REPOSITORY, null, monitor);
                }
                catch (UnsupportedRequestException unsupportedRequestException) {
                    throw e;
                }
            }
        }
    }

    private class LoginToken {
        private final long timeout;
        private String token;
        private long lastAccessed;
        private final AbstractWebLocation location;
        private AuthenticationCredentials credentials;

        public LoginToken(AbstractWebLocation location, long timeout) {
            this.location = location;
            this.timeout = timeout;
            this.lastAccessed = -1L;
        }

        public synchronized String getCurrentValue() throws JiraException, RemoteAuthenticationException, org.eclipse.mylyn.internal.jira.core.wsdl.soap.RemoteException, RemoteException {
            AuthenticationCredentials newCredentials = this.location.getCredentials(AuthenticationType.REPOSITORY);
            if (newCredentials == null) {
                this.expire();
                return "";
            }
            if (!newCredentials.equals((Object)this.credentials)) {
                this.expire();
                this.credentials = newCredentials;
            }
            if (System.currentTimeMillis() - this.lastAccessed >= this.timeout || this.token == null) {
                this.expire();
                this.token = JiraSoapClient.this.getSoapService().login(this.credentials.getUserName(), this.credentials.getPassword());
                this.lastAccessed = System.currentTimeMillis();
            }
            return this.token;
        }

        public synchronized void expire() {
            if (this.token != null) {
                try {
                    JiraSoapClient.this.getSoapService().logout(this.token);
                }
                catch (RemoteException remoteException) {
                }
                catch (JiraException jiraException) {}
                this.token = null;
                this.lastAccessed = -1L;
            }
        }

        public synchronized boolean isValidToken() {
            return this.token != null && System.currentTimeMillis() - this.lastAccessed < this.timeout;
        }

        public String toString() {
            long expiresIn = (this.timeout - (System.currentTimeMillis() - this.lastAccessed)) / 1000L;
            return "[credentials=" + this.credentials + ", timeout=" + this.timeout + ", valid=" + this.isValidToken() + ", expires=" + expiresIn + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface RemoteRunnable<T> {
        public T run() throws RemoteException, JiraException;
    }
}

