/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service.web.rss;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.jira.core.model.JiraVersion;
import org.eclipse.mylyn.internal.jira.core.model.NamedFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.FilterDefinition;
import org.eclipse.mylyn.internal.jira.core.model.filter.IssueCollector;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.service.web.JiraWebSession;
import org.eclipse.mylyn.internal.jira.core.service.web.JiraWebSessionCallback;
import org.eclipse.mylyn.internal.jira.core.service.web.rss.JiraRssFilterConverter;
import org.eclipse.mylyn.internal.jira.core.service.web.rss.JiraRssSessionCallback;

public class JiraRssClient {
    private final JiraClient client;
    private final JiraRssFilterConverter filterService;
    private final boolean useGZipCompression;

    public JiraRssClient(JiraClient client) {
        this.client = client;
        this.useGZipCompression = client.useCompression();
        this.filterService = new JiraRssFilterConverter();
    }

    private void doInSession(IProgressMonitor monitor, JiraWebSessionCallback callback) throws JiraException {
        JiraWebSession session = new JiraWebSession(this.client);
        session.doInSession(callback, monitor);
    }

    public void executeNamedFilter(final NamedFilter filter, final IssueCollector collector, IProgressMonitor monitor) throws JiraException {
        this.doInSession(monitor, new JiraRssSessionCallback(this.useGZipCompression, collector){

            protected String getRssUrl(String baseUrl) throws JiraException {
                StringBuilder rssUrlBuffer = new StringBuilder(baseUrl);
                String version = JiraRssClient.this.client.getCache().getServerInfo().getVersion();
                if (new JiraVersion(version).compareTo(JiraVersion.JIRA_3_7) >= 0) {
                    rssUrlBuffer.append("/sr/jira.issueviews:searchrequest-xml/").append(filter.getId()).append("/SearchRequest-").append(filter.getId()).append(".xml");
                    if (collector.getMaxHits() != -1) {
                        rssUrlBuffer.append("?tempMax=").append(collector.getMaxHits());
                    }
                } else {
                    rssUrlBuffer.append("/secure/IssueNavigator.jspa?view=rss&decorator=none&");
                    if (collector.getMaxHits() != -1) {
                        rssUrlBuffer.append("tempMax=").append(collector.getMaxHits()).append('&');
                    }
                    rssUrlBuffer.append("requestId=").append(filter.getId());
                }
                return rssUrlBuffer.toString();
            }
        });
    }

    public void findIssues(final FilterDefinition filterDefinition, final IssueCollector collector, IProgressMonitor monitor) throws JiraException {
        this.doInSession(monitor, new JiraRssSessionCallback(this.useGZipCompression, collector){

            protected String getRssUrl(String baseUrl) throws JiraException {
                StringBuilder rssUrlBuffer = new StringBuilder(baseUrl);
                String version = JiraRssClient.this.client.getCache().getServerInfo().getVersion();
                if (new JiraVersion(version).compareTo(JiraVersion.JIRA_3_7) >= 0) {
                    rssUrlBuffer.append("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?decorator=none&reset=true&");
                    if (collector.getMaxHits() != -1) {
                        rssUrlBuffer.append("tempMax=").append(collector.getMaxHits()).append('&');
                    }
                } else {
                    rssUrlBuffer.append("/secure/IssueNavigator.jspa?view=rss&decorator=none&reset=true&");
                    if (collector.getMaxHits() != -1) {
                        rssUrlBuffer.append("tempMax=").append(collector.getMaxHits()).append('&');
                    }
                }
                rssUrlBuffer.append(JiraRssClient.this.filterService.convert(filterDefinition, JiraRssClient.this.client.getCharacterEncoding()));
                return rssUrlBuffer.toString();
            }
        });
    }

    public void getIssueByKey(final String issueKey, IssueCollector collector, IProgressMonitor monitor) throws JiraException {
        this.doInSession(monitor, new JiraRssSessionCallback(this.useGZipCompression, collector){

            protected String getRssUrl(String baseUrl) throws JiraException {
                StringBuilder rssUrlBuffer = new StringBuilder(baseUrl);
                String version = JiraRssClient.this.client.getCache().getServerInfo().getVersion();
                if (new JiraVersion(version).compareTo(JiraVersion.JIRA_3_7) >= 0) {
                    rssUrlBuffer.append("/si/jira.issueviews:issue-xml/");
                    rssUrlBuffer.append(issueKey);
                    rssUrlBuffer.append("/");
                    rssUrlBuffer.append(issueKey);
                    rssUrlBuffer.append(".xml");
                } else {
                    rssUrlBuffer.append("/browse/");
                    rssUrlBuffer.append(issueKey);
                    rssUrlBuffer.append("?view=rss&decorator=none&reset=true&tempMax=1");
                }
                return rssUrlBuffer.toString();
            }
        });
    }

    public void quickSearch(final String searchString, final IssueCollector collector, IProgressMonitor monitor) throws JiraException {
        this.doInSession(monitor, new JiraRssSessionCallback(this.useGZipCompression, collector){

            protected String getRssUrl(String baseUrl) {
                StringBuilder rssUrlBuffer = new StringBuilder(baseUrl);
                rssUrlBuffer.append("/secure/QuickSearch.jspa?view=rss&decorator=none&reset=true&");
                if (collector.getMaxHits() != -1) {
                    rssUrlBuffer.append("tempMax=").append(collector.getMaxHits()).append('&');
                }
                try {
                    rssUrlBuffer.append("searchString=").append(URLEncoder.encode(searchString, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                return rssUrlBuffer.toString();
            }
        });
    }
}

