/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui.editor;

import org.eclipse.mylyn.internal.jira.core.JiraFieldType;
import org.eclipse.mylyn.internal.jira.core.JiraTaskDataHandler;
import org.eclipse.mylyn.internal.jira.core.util.JiraUtil;
import org.eclipse.mylyn.internal.jira.ui.editor.DateTimeAttributeEditor;
import org.eclipse.mylyn.internal.jira.ui.editor.TimeSpanAttributeEditor;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;

public class JiraTaskEditorPage
extends AbstractTaskEditorPage {
    public JiraTaskEditorPage(TaskEditor editor) {
        super(editor, "jira");
    }

    protected AttributeEditorFactory createAttributeEditorFactory() {
        AttributeEditorFactory factory = new AttributeEditorFactory(this.getModel(), this.getTaskRepository()){

            public AbstractAttributeEditor createEditor(String type, TaskAttribute taskAttribute) {
                if (JiraTaskDataHandler.isTimeSpanAttribute((TaskAttribute)taskAttribute)) {
                    return new TimeSpanAttributeEditor(JiraTaskEditorPage.this.getModel(), taskAttribute);
                }
                if (JiraUtil.isCustomDateTimeAttribute((TaskAttribute)taskAttribute)) {
                    String metaType = taskAttribute.getMetaData().getValue("type");
                    if (JiraFieldType.DATETIME.getKey().equals(metaType)) {
                        return new DateTimeAttributeEditor(JiraTaskEditorPage.this.getModel(), taskAttribute, true);
                    }
                    if (JiraFieldType.DATE.getKey().equals(metaType)) {
                        return new DateTimeAttributeEditor(JiraTaskEditorPage.this.getModel(), taskAttribute, false);
                    }
                }
                return super.createEditor(type, taskAttribute);
            }
        };
        return factory;
    }
}

