/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui.editor;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mylyn.internal.jira.core.JiraTimeFormat;
import org.eclipse.mylyn.internal.jira.core.util.JiraUtil;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TimeSpanAttributeEditor
extends AbstractAttributeEditor {
    private Text text;
    private final JiraTimeFormat format;

    public TimeSpanAttributeEditor(TaskDataModel model, TaskAttribute taskAttribute) {
        super(model, taskAttribute);
        this.format = JiraUtil.getTimeFormat((TaskRepository)model.getTaskRepository());
    }

    protected Text getText() {
        return this.text;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        if (this.isReadOnly()) {
            this.text = new Text(parent, 0x800008);
            this.text.setFont(JFaceResources.getDefaultFont());
            this.text.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
            this.text.setText(this.getValue());
        } else {
            this.text = toolkit.createText(parent, this.getValue(), 0x800000);
            this.text.setFont(JFaceResources.getDefaultFont());
            this.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TimeSpanAttributeEditor.this.setValue(TimeSpanAttributeEditor.this.text.getText());
                }
            });
        }
        toolkit.adapt((Control)this.text, false, false);
        this.setControl((Control)this.text);
    }

    public String getValue() {
        return this.format.format((Object)this.getAttributeMapper().getLongValue(this.getTaskAttribute()));
    }

    public void setValue(String text) {
        this.getAttributeMapper().setLongValue(this.getTaskAttribute(), Long.valueOf(this.format.parse(text)));
        this.attributeChanged();
    }
}

