/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui.wizards;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.internal.jira.core.JiraClientFactory;
import org.eclipse.mylyn.internal.jira.core.JiraCorePlugin;
import org.eclipse.mylyn.internal.jira.core.model.JiraConfiguration;
import org.eclipse.mylyn.internal.jira.core.model.ServerInfo;
import org.eclipse.mylyn.internal.jira.core.service.JiraAuthenticationException;
import org.eclipse.mylyn.internal.jira.core.util.JiraUtil;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class JiraRepositorySettingsPage
extends AbstractRepositorySettingsPage {
    private static final String TITLE = "JIRA Repository Settings";
    private static final String DESCRIPTION = "Example: http://developer.atlassian.com/jira";
    private Button compressionButton;
    private boolean characterEncodingValidated;
    private Button autoRefreshConfigurationButton;
    private Button useResolutionButton;
    private Spinner workDaysPerWeekSpinner;
    private Spinner workHoursPerDaySpinner;
    private Spinner maxSearchResultsSpinner;
    private Button linkedTasksAsSubtasksButton;
    private FormToolkit toolkit;
    private JiraConfiguration configuration;
    private Text dateTimePatternText;
    private Text datePatternText;
    private Combo localeCombo;
    private Locale[] locales;

    public JiraRepositorySettingsPage(TaskRepository taskRepository) {
        super(TITLE, DESCRIPTION, taskRepository);
        this.setNeedsProxy(true);
        this.setNeedsHttpAuth(true);
    }

    protected void repositoryTemplateSelected(RepositoryTemplate template) {
        this.repositoryLabelEditor.setStringValue(template.label);
        this.setUrl(template.repositoryUrl);
        this.getContainer().updateButtons();
    }

    protected void createAdditionalControls(Composite parent) {
        this.configuration = this.repository != null ? JiraUtil.getConfiguration((TaskRepository)this.repository) : new JiraConfiguration();
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.addRepositoryTemplatesToServerUrlCombo();
        if (this.repository != null) {
            this.characterEncodingValidated = JiraUtil.getCharacterEncodingValidated((TaskRepository)this.repository);
        }
        Label compressionLabel = new Label(parent, 0);
        compressionLabel.setText("Compression:");
        this.compressionButton = new Button(parent, 16416);
        this.compressionButton.setText("Enabled");
        if (this.repository != null) {
            this.compressionButton.setSelection(JiraUtil.getCompression((TaskRepository)this.repository));
        }
        Label label = new Label(parent, 0);
        label.setText("Refresh configuration:");
        this.autoRefreshConfigurationButton = new Button(parent, 16416);
        this.autoRefreshConfigurationButton.setText("Automatically");
        this.autoRefreshConfigurationButton.setToolTipText("If checked the repository configuration will be periodically updated. Note: This can cause a significant load on the repository if it has many projects.");
        if (this.repository != null) {
            this.autoRefreshConfigurationButton.setSelection(JiraUtil.getAutoRefreshConfiguration((TaskRepository)this.repository));
        }
        label = new Label(parent, 0);
        label.setText("Completed tasks:");
        this.useResolutionButton = new Button(parent, 16416);
        this.useResolutionButton.setText("Based on resolution");
        this.useResolutionButton.setToolTipText("If checked an issue is considered completed if it has a resolution. Otherwise detection is based on the status of the issue.");
        if (this.repository != null) {
            this.useResolutionButton.setSelection(JiraUtil.getCompletedBasedOnResolution((TaskRepository)this.repository));
        }
        label = new Label(parent, 0);
        label.setText("Subtasks:");
        this.linkedTasksAsSubtasksButton = new Button(parent, 16416);
        this.linkedTasksAsSubtasksButton.setText("Show linked tasks");
        this.linkedTasksAsSubtasksButton.setToolTipText("If checked linked tasks show as subtasks in the task list.");
        if (this.repository != null) {
            this.linkedTasksAsSubtasksButton.setSelection(JiraUtil.getLinkedTasksAsSubtasks((TaskRepository)this.repository));
        }
        label = new Label(parent, 0);
        label.setText("Time tracking:");
        Composite timeTrackingComposite = new Composite(parent, 0);
        timeTrackingComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        this.workDaysPerWeekSpinner = new Spinner(timeTrackingComposite, 133120);
        this.workDaysPerWeekSpinner.setValues(7, 1, 7, 0, 1, 1);
        if (this.repository != null) {
            this.workDaysPerWeekSpinner.setSelection(JiraUtil.getWorkDaysPerWeek((TaskRepository)this.repository));
        }
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)this.workDaysPerWeekSpinner);
        label = new Label(timeTrackingComposite, 0);
        label.setText("working days per week");
        this.workHoursPerDaySpinner = new Spinner(timeTrackingComposite, 2048);
        this.workHoursPerDaySpinner.setValues(24, 1, 24, 0, 1, 1);
        if (this.repository != null) {
            this.workHoursPerDaySpinner.setSelection(JiraUtil.getWorkHoursPerDay((TaskRepository)this.repository));
        }
        label = new Label(timeTrackingComposite, 0);
        label.setText("working hours per day");
        label = new Label(parent, 0);
        label.setText("Max number of search results:");
        this.maxSearchResultsSpinner = new Spinner(parent, 2048);
        this.maxSearchResultsSpinner.setValues(5000, -1, 99999, 0, 1, 1000);
        if (this.repository != null) {
            this.maxSearchResultsSpinner.setSelection(JiraUtil.getMaxSearchResults((TaskRepository)this.repository));
        }
        this.createAdvancedComposite(parent);
    }

    private void createAdvancedComposite(Composite parent) {
        ExpandableComposite expandableComposite = this.toolkit.createExpandableComposite(parent, 290);
        GridData gd = new GridData(4, 128, true, false);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = -5;
        expandableComposite.setLayoutData((Object)gd);
        expandableComposite.setFont(parent.getFont());
        expandableComposite.setBackground(parent.getBackground());
        expandableComposite.setText("Advanced &Configuration");
        expandableComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                JiraRepositorySettingsPage.this.getControl().getShell().pack();
            }
        });
        this.toolkit.paintBordersFor((Composite)expandableComposite);
        Composite composite = this.toolkit.createComposite((Composite)expandableComposite, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        expandableComposite.setClient((Control)composite);
        Label label = new Label(composite, 0);
        label.setText("Date Picker Format:");
        this.datePatternText = new Text(composite, 0);
        this.datePatternText.setText(this.configuration.getDatePattern());
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.datePatternText);
        label = new Label(composite, 0);
        label.setText("Date Time Picker Format:");
        this.dateTimePatternText = new Text(composite, 0);
        this.dateTimePatternText.setText(this.configuration.getDateTimePattern());
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.dateTimePatternText);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.datePatternText);
        label = new Label(composite, 0);
        label.setText("Locale:");
        this.localeCombo = new Combo(composite, 12);
        this.locales = Locale.getAvailableLocales();
        Arrays.sort(this.locales, new Comparator<Locale>(){

            @Override
            public int compare(Locale o1, Locale o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        Locale[] localeArray = this.locales;
        int n = this.locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            this.localeCombo.add(locale.getDisplayName());
            ++n2;
        }
        this.localeCombo.setText(this.configuration.getLocale().getDisplayName());
        Hyperlink hyperlink = this.toolkit.createHyperlink(composite, "Reset to defaults", 0);
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                JiraRepositorySettingsPage.this.datePatternText.setText("dd/MMM/yy");
                JiraRepositorySettingsPage.this.dateTimePatternText.setText("dd/MMM/yy hh:mm a");
                JiraRepositorySettingsPage.this.localeCombo.setText(JiraConfiguration.DEFAULT_LOCALE.getDisplayName());
            }
        });
        this.toolkit.paintBordersFor(composite);
    }

    protected boolean isValidUrl(String name) {
        if (name.startsWith("https://") || name.startsWith("http://")) {
            try {
                new URL(name);
                return true;
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return false;
    }

    protected AbstractRepositorySettingsPage.Validator getValidator(TaskRepository repository) {
        return new JiraValidator(repository);
    }

    public void applyTo(TaskRepository repository) {
        super.applyTo(repository);
        this.configuration.setDatePattern(this.datePatternText.getText());
        this.configuration.setDateTimePattern(this.dateTimePatternText.getText());
        if (this.localeCombo.getSelectionIndex() != -1) {
            this.configuration.setLocale(this.locales[this.localeCombo.getSelectionIndex()]);
        }
        JiraUtil.setConfiguration((TaskRepository)repository, (JiraConfiguration)this.configuration);
        JiraUtil.setCompression((TaskRepository)repository, (boolean)this.compressionButton.getSelection());
        JiraUtil.setAutoRefreshConfiguration((TaskRepository)repository, (boolean)this.autoRefreshConfigurationButton.getSelection());
        JiraUtil.setCompletedBasedOnResolution((TaskRepository)repository, (boolean)this.useResolutionButton.getSelection());
        JiraUtil.setLinkedTasksAsSubtasks((TaskRepository)repository, (boolean)this.linkedTasksAsSubtasksButton.getSelection());
        JiraUtil.setWorkDaysPerWeek((TaskRepository)repository, (int)this.workDaysPerWeekSpinner.getSelection());
        JiraUtil.setWorkHoursPerDay((TaskRepository)repository, (int)this.workHoursPerDaySpinner.getSelection());
        JiraUtil.setMaxSearchResults((TaskRepository)repository, (int)this.maxSearchResultsSpinner.getSelection());
        if (this.characterEncodingValidated) {
            JiraUtil.setCharacterEncodingValidated((TaskRepository)repository, (boolean)true);
        }
    }

    protected void applyValidatorResult(AbstractRepositorySettingsPage.Validator validator) {
        JiraValidator jiraValidator = (JiraValidator)validator;
        ServerInfo serverInfo = jiraValidator.getServerInfo();
        if (serverInfo != null) {
            String url = jiraValidator.getRepositoryUrl();
            if (serverInfo.getBaseUrl() != null && !url.equals(serverInfo.getBaseUrl())) {
                LinkedHashSet<String> urls = new LinkedHashSet<String>();
                urls.add(url);
                urls.add(serverInfo.getBaseUrl());
                if (serverInfo.getWebBaseUrl() != null) {
                    urls.add(serverInfo.getWebBaseUrl());
                }
                UrlSelectionDialog dialog = new UrlSelectionDialog(this.getShell(), urls.toArray(new String[0]));
                dialog.setSelectedUrl(serverInfo.getBaseUrl());
                int result = dialog.open();
                if (result == 0) {
                    this.setUrl(dialog.getSelectedUrl());
                }
            }
            if (serverInfo.getCharacterEncoding() != null) {
                this.setEncoding(serverInfo.getCharacterEncoding());
            } else {
                this.setEncoding("UTF-8");
                jiraValidator.setStatus((IStatus)new Status(2, "org.eclipse.mylyn.jira.ui", 0, "Authentication credentials are valid. Note: The character encoding could not be determined, verify 'Additional Settings'.", null));
            }
            if (serverInfo.isInsecureRedirect()) {
                jiraValidator.setStatus((IStatus)new Status(2, "org.eclipse.mylyn.jira.ui", 0, "Authentication credentials are valid. Note: The server redirected to an insecure location.", null));
            }
            this.characterEncodingValidated = true;
        }
        super.applyValidatorResult(validator);
    }

    public String getConnectorKind() {
        return "jira";
    }

    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        super.dispose();
    }

    private class JiraValidator
    extends AbstractRepositorySettingsPage.Validator {
        final TaskRepository repository;
        private ServerInfo serverInfo;

        public JiraValidator(TaskRepository repository) {
            super((AbstractRepositorySettingsPage)JiraRepositorySettingsPage.this);
            this.repository = repository;
        }

        public ServerInfo getServerInfo() {
            return this.serverInfo;
        }

        public String getRepositoryUrl() {
            return this.repository.getRepositoryUrl();
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            try {
                new URL(this.repository.getRepositoryUrl());
            }
            catch (MalformedURLException malformedURLException) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.jira.ui", 0, "Repository url is invalid.", null));
            }
            AbstractWebLocation location = new TaskRepositoryLocationFactory().createWebLocation(this.repository);
            try {
                this.serverInfo = JiraClientFactory.getDefault().validateConnection(location, monitor);
            }
            catch (JiraAuthenticationException jiraAuthenticationException) {
                throw new CoreException((IStatus)RepositoryStatus.createStatus((String)this.repository.getRepositoryUrl(), (int)4, (String)"org.eclipse.mylyn.jira.ui", (String)"Unable to authenticate with repository. Login credentials invalid."));
            }
            catch (Exception e) {
                throw new CoreException(JiraCorePlugin.toStatus((TaskRepository)this.repository, (Throwable)e));
            }
        }
    }

    private static class UrlSelectionDialog
    extends Dialog {
        private final String[] locations;
        private String selectedUrl;

        protected UrlSelectionDialog(Shell parentShell, String[] locations) {
            super(parentShell);
            if (locations == null || locations.length < 2) {
                throw new IllegalArgumentException();
            }
            this.locations = locations;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText("Select repository location");
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            UrlSelectionDialog.applyDialogFont((Control)composite);
            Label label = new Label(composite, 0);
            label.setText("The repository location reported by the server does not match the provided location.");
            ArrayList<Button> buttons = new ArrayList<Button>(this.locations.length);
            if (this.getSelectedUrl() == null) {
                this.setSelectedUrl(this.locations[0]);
            }
            int i = 1;
            while (i < this.locations.length) {
                Button button = new Button(composite, 16);
                button.setText("Use server location: " + this.locations[i]);
                button.setData((Object)this.locations[i]);
                button.setSelection(this.getSelectedUrl().equals(this.locations[i]));
                buttons.add(button);
                ++i;
            }
            Button keepLocationButton = new Button(composite, 16);
            keepLocationButton.setText("Keep current location: " + this.locations[0]);
            keepLocationButton.setData((Object)this.locations[0]);
            keepLocationButton.setSelection(this.getSelectedUrl().equals(this.locations[0]));
            buttons.add(keepLocationButton);
            SelectionListener listener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    Object source = e.getSource();
                    if (source instanceof Button && ((Button)source).getSelection()) {
                        UrlSelectionDialog.this.setSelectedUrl((String)((Button)source).getData());
                    }
                }
            };
            for (Button button : buttons) {
                button.addSelectionListener(listener);
            }
            return composite;
        }

        public void setSelectedUrl(String selectedUrl) {
            this.selectedUrl = selectedUrl;
        }

        public String getSelectedUrl() {
            return this.selectedUrl;
        }
    }
}

