/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.internal.trac.core.TracAttributeMapper;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TracAttribute {
    CC(TracTicket.Key.CC, "CC:", "task.common.user.cc", "shortText", TracAttributeMapper.Flag.PEOPLE, new TracAttributeMapper.Flag[0]),
    CHANGE_TIME(TracTicket.Key.CHANGE_TIME, "Last Modification:", "task.common.date.modified", "date", TracAttributeMapper.Flag.READ_ONLY, new TracAttributeMapper.Flag[0]),
    COMPONENT(TracTicket.Key.COMPONENT, "Component:", "task.common.product", "singleSelect", TracAttributeMapper.Flag.ATTRIBUTE, new TracAttributeMapper.Flag[0]),
    DESCRIPTION(TracTicket.Key.DESCRIPTION, "Description:", "task.common.description", "longRichText"),
    ID(TracTicket.Key.ID, "ID:", "task.common.key", "shortText", TracAttributeMapper.Flag.PEOPLE, new TracAttributeMapper.Flag[0]),
    KEYWORDS(TracTicket.Key.KEYWORDS, "Keywords:", "task.common.keywords", "shortText", TracAttributeMapper.Flag.ATTRIBUTE, new TracAttributeMapper.Flag[0]),
    MILESTONE(TracTicket.Key.MILESTONE, "Milestone:", null, "singleSelect", TracAttributeMapper.Flag.ATTRIBUTE, new TracAttributeMapper.Flag[0]),
    OWNER(TracTicket.Key.OWNER, "Assigned to:", "task.common.user.assigned", "person", TracAttributeMapper.Flag.PEOPLE, new TracAttributeMapper.Flag[0]),
    PRIORITY(TracTicket.Key.PRIORITY, "Priority:", "task.common.priority", "singleSelect", TracAttributeMapper.Flag.ATTRIBUTE, new TracAttributeMapper.Flag[0]),
    REPORTER(TracTicket.Key.REPORTER, "Reporter:", "task.common.user.reporter", "person", TracAttributeMapper.Flag.READ_ONLY, new TracAttributeMapper.Flag[0]),
    RESOLUTION(TracTicket.Key.RESOLUTION, "Resolution:", "task.common.resolution", "singleSelect"),
    SEVERITY(TracTicket.Key.SEVERITY, "Severity:", null, "singleSelect", TracAttributeMapper.Flag.ATTRIBUTE, new TracAttributeMapper.Flag[0]),
    STATUS(TracTicket.Key.STATUS, "Status:", "task.common.status", "shortText"),
    SUMMARY(TracTicket.Key.SUMMARY, "Summary:", "task.common.summary", "shortRichText"),
    TIME(TracTicket.Key.TIME, "Created:", "task.common.date.created", "date", TracAttributeMapper.Flag.READ_ONLY, new TracAttributeMapper.Flag[0]),
    TYPE(TracTicket.Key.TYPE, "Type:", "task.common.kind", "singleSelect", TracAttributeMapper.Flag.ATTRIBUTE, new TracAttributeMapper.Flag[0]),
    VERSION(TracTicket.Key.VERSION, "Version:", null, "singleSelect", TracAttributeMapper.Flag.ATTRIBUTE, new TracAttributeMapper.Flag[0]);

    static Map<String, TracAttribute> attributeByTracKey;
    static Map<String, String> tracKeyByTaskKey;
    private final String tracKey;
    private final String prettyName;
    private final String taskKey;
    private final String type;
    private EnumSet<TracAttributeMapper.Flag> flags;

    static {
        attributeByTracKey = new HashMap<String, TracAttribute>();
        tracKeyByTaskKey = new HashMap<String, String>();
    }

    public static TracAttribute getByTaskKey(String taskKey) {
        TracAttribute[] tracAttributeArray = TracAttribute.values();
        int n = tracAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracAttribute attribute = tracAttributeArray[n2];
            if (taskKey.equals(attribute.getTaskKey())) {
                return attribute;
            }
            ++n2;
        }
        return null;
    }

    public static TracAttribute getByTracKey(String tracKey) {
        TracAttribute[] tracAttributeArray = TracAttribute.values();
        int n = tracAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracAttribute attribute = tracAttributeArray[n2];
            if (tracKey.equals(attribute.getTracKey())) {
                return attribute;
            }
            ++n2;
        }
        return null;
    }

    private TracAttribute(TracTicket.Key tracKey, String prettyName, String taskKey, String type, TracAttributeMapper.Flag firstFlag, TracAttributeMapper.Flag ... moreFlags) {
        this.tracKey = tracKey.getKey();
        this.taskKey = taskKey;
        this.prettyName = prettyName;
        this.type = type;
        this.flags = firstFlag == null ? TracAttributeMapper.NO_FLAGS : EnumSet.of(firstFlag, moreFlags);
    }

    private TracAttribute(TracTicket.Key tracKey, String prettyName, String taskKey, String type) {
        this(tracKey, prettyName, taskKey, type, null, new TracAttributeMapper.Flag[0]);
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    public String getTracKey() {
        return this.tracKey;
    }

    public String getKind() {
        if (this.flags.contains((Object)TracAttributeMapper.Flag.ATTRIBUTE)) {
            return "task.common.kind.default";
        }
        if (this.flags.contains((Object)TracAttributeMapper.Flag.PEOPLE)) {
            return "task.common.kind.people";
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public boolean isReadOnly() {
        return this.flags.contains((Object)TracAttributeMapper.Flag.READ_ONLY);
    }

    public String toString() {
        return this.prettyName;
    }
}

