/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.ui;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.trac.ui.WebHyperlink;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TaskHyperlink;

public class TracHyperlinkUtil {
    static Pattern ticketPattern = Pattern.compile("(ticket:|#)(\\d+)");
    static Pattern commentPattern = Pattern.compile("comment:ticket:(\\d+):(\\d+)");
    static Pattern reportPattern1 = Pattern.compile("report:(\\d+)");
    static Pattern reportPattern2 = Pattern.compile("\\{(\\d+)\\}");
    static Pattern changesetPattern1 = Pattern.compile("(r|changeset:)(\\d+)(/\\w+)?");
    static Pattern changesetPattern2 = Pattern.compile("\\[(\\d+)(/\\w+)?\\]");
    static Pattern revisionLogPattern1 = Pattern.compile("r(\\d+):(\\d+)");
    static Pattern revisionLogPattern2 = Pattern.compile("\\[(\\d+):(\\d+)\\]");
    static Pattern revisionLogPattern3 = Pattern.compile("log:(\\w+)?@(\\d+):(\\d+)");
    static Pattern diffPattern1 = Pattern.compile("diff:@(\\d+):(\\d+)");
    static Pattern diffPattern2 = Pattern.compile("diff:([\\w\\./-]+)(@(\\d+))?//([\\w\\./-]+)(@(\\d+))?");
    static Pattern wikiPattern1 = Pattern.compile("wiki:(\\w+)");
    static Pattern wikiPattern2 = Pattern.compile("[A-Z][a-z0-9]+[A-Z]\\w*");
    static Pattern milestonePattern = Pattern.compile("milestone:([\\w\\.]+)");
    static Pattern attachmentPattern = Pattern.compile("attachment:ticket:(\\d+):([\\w\\.]+)");
    static Pattern filesPattern = Pattern.compile("source:/*([\\w\\./\\-_]+)(@(\\d+)(#L(\\d+))?)?");

    public static IHyperlink[] findTicketHyperlinks(TaskRepository repository, String text, int lineOffset, int regionOffset) {
        ArrayList<TaskHyperlink> links = null;
        Matcher m = ticketPattern.matcher(text);
        while (m.find()) {
            if (!TracHyperlinkUtil.isInRegion(lineOffset, m)) continue;
            String id = m.group(2);
            if (links == null) {
                links = new ArrayList<TaskHyperlink>();
            }
            links.add(new TaskHyperlink(TracHyperlinkUtil.determineRegion(regionOffset, m), repository, id));
        }
        return links == null ? null : links.toArray(new IHyperlink[0]);
    }

    public static IHyperlink[] findTracHyperlinks(TaskRepository repository, String text, int lineOffset, int regionOffset) {
        String page;
        String branch;
        String url;
        String rev;
        String url2;
        String stopRev;
        String rev2;
        String id;
        ArrayList<Object> links = new ArrayList<Object>();
        Matcher m = ticketPattern.matcher(text);
        while (m.find()) {
            if (!TracHyperlinkUtil.isInRegion(lineOffset, m)) continue;
            id = m.group(2);
            links.add(new TaskHyperlink(TracHyperlinkUtil.determineRegion(regionOffset, m), repository, id));
        }
        m = commentPattern.matcher(text);
        while (m.find()) {
            if (!TracHyperlinkUtil.isInRegion(lineOffset, m)) continue;
            id = m.group(1);
            links.add(new TaskHyperlink(TracHyperlinkUtil.determineRegion(regionOffset, m), repository, id));
        }
        m = reportPattern1.matcher(text);
        while (m.find()) {
            if (!TracHyperlinkUtil.isInRegion(lineOffset, m)) continue;
            id = m.group(1);
            links.add(new WebHyperlink(TracHyperlinkUtil.determineRegion(regionOffset, m), String.valueOf(repository.getRepositoryUrl()) + "/report/" + id));
        }
        m = reportPattern2.matcher(text);
        while (m.find()) {
            if (!TracHyperlinkUtil.isInRegion(lineOffset, m)) continue;
            id = m.group(1);
            links.add(new WebHyperlink(TracHyperlinkUtil.determineRegion(regionOffset, m), String.valueOf(repository.getRepositoryUrl()) + "/report/" + id));
        }
        m = revisionLogPattern1.matcher(text);
        while (m.find()) {
            if (!TracHyperlinkUtil.isInRegion(lineOffset, m)) continue;
            rev2 = m.group(1);
            stopRev = m.group(2);
            url2 = String.valueOf(repository.getRepositoryUrl()) + "/log/" + "?rev=" + rev2 + "&stop_rev=" + stopRev;
            links.add(new WebHyperlink(TracHyperlinkUtil.determineRegion(regionOffset, m), url2));
        }
        m = revisionLogPattern2.matcher(text);
        while (m.find()) {
            if (!TracHyperlinkUtil.isInRegion(lineOffset, m)) continue;
            rev2 = m.group(1);
            stopRev = m.group(2);
            url2 = String.valueOf(repository.getRepositoryUrl()) + "/log/" + "?rev=" + rev2 + "&stop_rev=" + stopRev;
            links.add(new WebHyperlink(TracHyperlinkUtil.determineRegion(regionOffset, m), url2));
        }
        m = revisionLogPattern3.matcher(text);
        while (m.find()) {
            if (!TracHyperlinkUtil.isInRegion(lineOffset, m)) continue;
            String branch2 = m.group(1);
            rev = m.group(2);
            String stopRev2 = m.group(3);
            url = String.valueOf(repository.getRepositoryUrl()) + "/log/";
            if (branch2 != null) {
                url = String.valueOf(url) + branch2;
            }
            url = String.valueOf(url) + "?rev=" + rev + "&stop_rev=" + stopRev2;
            links.add(new WebHyperlink(TracHyperlinkUtil.determineRegion(regionOffset, m), url));
        }
        m = changesetPattern1.matcher(text);
        while (m.find()) {
            if (!TracHyperlinkUtil.isInRegion(lineOffset, m)) continue;
            rev2 = m.group(2);
            branch = m.group(3);
            url2 = String.valueOf(repository.getRepositoryUrl()) + "/changeset/" + rev2;
            if (branch != null) {
                url2 = String.valueOf(url2) + branch;
            }
            links.add(new WebHyperlink(TracHyperlinkUtil.determineRegion(regionOffset, m), url2));
        }
        m = changesetPattern2.matcher(text);
        while (m.find()) {
            if (!TracHyperlinkUtil.isInRegion(lineOffset, m)) continue;
            rev2 = m.group(1);
            branch = m.group(2);
            url2 = String.valueOf(repository.getRepositoryUrl()) + "/changeset/" + rev2;
            if (branch != null) {
                url2 = String.valueOf(url2) + branch;
            }
            links.add(new WebHyperlink(TracHyperlinkUtil.determineRegion(regionOffset, m), url2));
        }
        m = diffPattern1.matcher(text);
        while (m.find()) {
            if (!TracHyperlinkUtil.isInRegion(lineOffset, m)) continue;
            String old_rev = m.group(1);
            String new_rev = m.group(2);
            url2 = String.valueOf(repository.getRepositoryUrl()) + "/changeset/";
            url2 = String.valueOf(url2) + "?new=" + new_rev + "&old=" + old_rev;
            links.add(new WebHyperlink(TracHyperlinkUtil.determineRegion(regionOffset, m), url2));
        }
        m = diffPattern2.matcher(text);
        while (m.find()) {
            if (!TracHyperlinkUtil.isInRegion(lineOffset, m)) continue;
            String old_path = m.group(1);
            String old_rev = m.group(3);
            String new_path = m.group(4);
            String new_rev = m.group(6);
            String url3 = String.valueOf(repository.getRepositoryUrl()) + "/changeset/";
            try {
                url3 = String.valueOf(url3) + "?new_path=" + URLEncoder.encode(new_path, "UTF-8");
                url3 = String.valueOf(url3) + "&old_path=" + URLEncoder.encode(old_path, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.trac.ui", "Unexcpected exception", (Throwable)e));
                continue;
            }
            if (new_rev != null) {
                url3 = String.valueOf(url3) + "&new=" + new_rev;
            }
            if (old_rev != null) {
                url3 = String.valueOf(url3) + "&old=" + old_rev;
            }
            links.add(new WebHyperlink(TracHyperlinkUtil.determineRegion(regionOffset, m), url3));
        }
        m = wikiPattern1.matcher(text);
        while (m.find()) {
            if (!TracHyperlinkUtil.isInRegion(lineOffset, m)) continue;
            page = m.group(1);
            links.add(new WebHyperlink(TracHyperlinkUtil.determineRegion(regionOffset, m), String.valueOf(repository.getRepositoryUrl()) + "/wiki/" + page));
        }
        m = wikiPattern2.matcher(text);
        while (m.find()) {
            if (!TracHyperlinkUtil.isInRegion(lineOffset, m)) continue;
            page = m.group(0);
            links.add(new WebHyperlink(TracHyperlinkUtil.determineRegion(regionOffset, m), String.valueOf(repository.getRepositoryUrl()) + "/wiki/" + page));
        }
        m = milestonePattern.matcher(text);
        while (m.find()) {
            if (!TracHyperlinkUtil.isInRegion(lineOffset, m)) continue;
            String milestone = m.group(1);
            links.add(new WebHyperlink(TracHyperlinkUtil.determineRegion(regionOffset, m), String.valueOf(repository.getRepositoryUrl()) + "/milestone/" + milestone));
        }
        m = attachmentPattern.matcher(text);
        while (m.find()) {
            if (!TracHyperlinkUtil.isInRegion(lineOffset, m)) continue;
            id = m.group(1);
            links.add(new TaskHyperlink(TracHyperlinkUtil.determineRegion(regionOffset, m), repository, id));
        }
        m = filesPattern.matcher(text);
        while (m.find()) {
            if (!TracHyperlinkUtil.isInRegion(lineOffset, m)) continue;
            String filename = m.group(1);
            rev = m.group(3);
            String line = m.group(5);
            url = String.valueOf(repository.getRepositoryUrl()) + "/browser/" + filename;
            if (rev != null) {
                url = String.valueOf(url) + "?rev=" + rev;
                if (line != null) {
                    url = String.valueOf(url) + "#L" + line;
                }
            }
            links.add(new WebHyperlink(TracHyperlinkUtil.determineRegion(regionOffset, m), url));
        }
        return links.isEmpty() ? null : links.toArray(new IHyperlink[0]);
    }

    private static boolean isInRegion(int lineOffset, Matcher m) {
        return lineOffset >= m.start() && lineOffset <= m.end();
    }

    private static IRegion determineRegion(int regionOffset, Matcher m) {
        return new Region(regionOffset + m.start(), m.end() - m.start());
    }
}

