/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.bridge.bugs;

import javax.security.auth.login.LoginException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.BugzillaMylynSearchOperation;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.BugzillaSearchManager;
import org.eclipse.ui.PlatformUI;

public class BugzillaMylynSearchJob
extends Job {
    private final BugzillaMylynSearchOperation operation;

    public BugzillaMylynSearchJob(String name, BugzillaMylynSearchOperation operation) {
        super(name);
        this.operation = operation;
    }

    protected IStatus run(IProgressMonitor monitor) {
        final IStatus[] status = new IStatus[1];
        try {
            this.operation.execute(monitor);
            status[0] = this.operation.getStatus();
            if (status[0] != null) {
                if (status[0].getCode() == 8) {
                    status[0] = Status.OK_STATUS;
                    BugzillaSearchManager.removeSearchJob(String.valueOf(this.operation.getSearchMember().getHandleIdentifier()) + " " + this.operation.getScope());
                    IStatus iStatus = status[0];
                    return iStatus;
                }
                if (!status[0].isOK()) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            ErrorDialog.openError(null, (String)"Bugzilla Search Error", null, (IStatus)status[0]);
                        }
                    });
                    status[0] = Status.OK_STATUS;
                    BugzillaSearchManager.removeSearchJob(String.valueOf(this.operation.getSearchMember().getHandleIdentifier()) + " " + this.operation.getScope());
                    IStatus iStatus = status[0];
                    return iStatus;
                }
            }
        }
        catch (LoginException e) {
            MessageDialog.openError(null, (String)"Login Error", (String)"Bugzilla could not log you in to get the information you requested since login name or password is incorrect.\nPlease check your settings in the bugzilla preferences. ");
            BugzillaCorePlugin.log((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla.ui", 0, "", (Throwable)e));
        }
        finally {
            BugzillaSearchManager.removeSearchJob(String.valueOf(this.operation.getSearchMember().getHandleIdentifier()) + " " + this.operation.getScope());
        }
        return status[0];
    }
}

