/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.bridge.bugs;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.BugzillaReportInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaSearchManager {
    private final Map<String, Map<Integer, List<BugzillaReportInfo>>> landmarksHash = Collections.synchronizedMap(new HashMap());
    static Map<String, Job> runningJobs = Collections.synchronizedMap(new HashMap());

    public void removeFromLandmarksHash(IJavaElement removed) {
        this.landmarksHash.remove(removed.getHandleIdentifier());
    }

    public void removeFromLandmarksHash(List<IJavaElement> removed) {
        for (IJavaElement je : removed) {
            this.landmarksHash.remove(je.getHandleIdentifier());
        }
    }

    public void addToLandmarksHash(List<BugzillaReportInfo> doiList, IMember m, int scope) {
        Map<Integer, List<BugzillaReportInfo>> searches = this.landmarksHash.get(m.getHandleIdentifier());
        if (searches == null) {
            searches = new HashMap<Integer, List<BugzillaReportInfo>>();
        }
        searches.put(scope, doiList);
        this.landmarksHash.put(m.getHandleIdentifier(), searches);
    }

    public List<BugzillaReportInfo> getFromLandmarksHash(IMember m, int scope) {
        Map<Integer, List<BugzillaReportInfo>> scopes = this.landmarksHash.get(m.getHandleIdentifier());
        if (scopes == null) {
            return null;
        }
        return scopes.get(scope);
    }

    public static boolean doesJobExist(String handle) {
        return runningJobs.containsKey(handle);
    }

    public static void removeSearchJob(String handle) {
        if (BugzillaSearchManager.doesJobExist(handle)) {
            Job prevJob = runningJobs.get(handle);
            prevJob.cancel();
            runningJobs.remove(handle);
        }
    }

    public static void addJob(String handle, Job searchJob) {
        runningJobs.put(handle, searchJob);
    }

    public static void cancelAllRunningJobs() {
        Collection<Job> jobs = runningJobs.values();
        for (Job j : jobs) {
            j.cancel();
        }
        runningJobs.clear();
    }
}

