/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui;

import java.util.Arrays;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColorCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.context.ui.HighlighterImageDescriptor;
import org.eclipse.mylyn.internal.sandbox.ui.SandboxUiPlugin;
import org.eclipse.mylyn.internal.sandbox.ui.highlighters.Highlighter;
import org.eclipse.mylyn.internal.sandbox.ui.highlighters.HighlighterList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SandboxUiPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ICellEditorListener {
    private Table table;
    private TableViewer tableViewer;
    private Button enableErrorInterest = null;
    private ColorCellEditor colorDialogEditor;
    private Button incomingOverlaysButton = null;
    private Button activateOnOpen;
    private Button enableLocalSubTasksButton;
    private Button showTaskTrimButton;
    private Highlighter selection = null;
    private HighlighterContentProvider contentProvider = null;
    private static final String LABEL_COLUMN = "Label";
    private static final String COLOR_COLUMN = "Color";
    private static final String TYPE_COLUMN = "Type";
    private static String[] columnNames = new String[]{"Label", "Color", "Type"};
    static final String[] TYPE_ARRAY = new String[]{"Gradient", "Solid"};

    public SandboxUiPreferencePage() {
        this.setPreferenceStore(ContextUiPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        this.createTaskNavigationGroup(container);
        this.createTaskListGroup(container);
        this.createJavaGroup(container);
        this.createHighlightersTable(container);
        this.createTableViewer();
        this.contentProvider = new HighlighterContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new HighlighterLabelProvider());
        this.tableViewer.setInput((Object)SandboxUiPlugin.getDefault().getHighlighterList());
        return container;
    }

    public void init(IWorkbench workbench) {
    }

    private void createTaskNavigationGroup(Composite parent) {
        Group navigationGroup = new Group(parent, 0);
        navigationGroup.setText("Task Navigation");
        navigationGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        navigationGroup.setLayout((Layout)new GridLayout());
        IPreferenceStore uiPreferenceStore = TasksUiPlugin.getDefault().getPreferenceStore();
        this.showTaskTrimButton = new Button((Composite)navigationGroup, 32);
        this.showTaskTrimButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.showTaskTrimButton.setText("Show Task Trim widget");
        this.showTaskTrimButton.setSelection(uiPreferenceStore.getBoolean("org.eclipse.mylyn.tasks.ui.show.trim"));
    }

    private void createTaskListGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText("Task List");
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        IPreferenceStore uiPreferenceStore = TasksUiPlugin.getDefault().getPreferenceStore();
        this.incomingOverlaysButton = new Button((Composite)group, 32);
        this.incomingOverlaysButton.setText("Use Synchronize View style incoming overlays and placement");
        this.incomingOverlaysButton.setSelection(uiPreferenceStore.getBoolean("org.eclipse.mylyn.tasks.ui.overlays.incoming.tight"));
        this.activateOnOpen = new Button((Composite)group, 32);
        this.activateOnOpen.setText("Activate tasks on open");
        this.activateOnOpen.setSelection(uiPreferenceStore.getBoolean("org.eclipse.mylyn.tasks.ui.activate.when.opened"));
        this.enableLocalSubTasksButton = new Button((Composite)group, 32);
        this.enableLocalSubTasksButton.setText("Enable subtasks for local tasks");
        this.enableLocalSubTasksButton.setSelection(uiPreferenceStore.getBoolean("org.eclipse.mylyn.tasks.ui.subtasks.local"));
    }

    private void createJavaGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        group.setText("Java");
        GridLayout gl = new GridLayout(1, false);
        group.setLayout((Layout)gl);
        this.enableErrorInterest = new Button((Composite)group, 32);
        this.enableErrorInterest.setText("Enable predicted interest of errors (significantly increases view refresh).");
        this.enableErrorInterest.setSelection(SandboxUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.java.ui.interest.prediction.errors"));
    }

    private void createHighlightersTable(Composite parent) {
        Group tableComposite = new Group(parent, 16);
        tableComposite.setText("Context Highlighters");
        tableComposite.setLayout((Layout)new GridLayout(2, false));
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        int style = 100868;
        this.table = new Table((Composite)tableComposite, style);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 0, 0);
        column.setText(LABEL_COLUMN);
        column.setWidth(150);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SandboxUiPreferencePage.this.tableViewer.setSorter((ViewerSorter)new HighlighterTableSorter(1));
            }
        });
        column = new TableColumn(this.table, 16384, 1);
        column.setResizable(false);
        column.setText(COLOR_COLUMN);
        column.setWidth(100);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SandboxUiPreferencePage.this.tableViewer.setSorter((ViewerSorter)new HighlighterTableSorter(2));
            }
        });
        column = new TableColumn(this.table, 16384, 2);
        column.setResizable(false);
        column.setText("Kind");
        column.setWidth(80);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SandboxUiPreferencePage.this.tableViewer.setSorter((ViewerSorter)new HighlighterTableSorter(3));
            }
        });
        this.createAddRemoveButtons((Composite)tableComposite);
    }

    public boolean performOk() {
        IPreferenceStore uiPreferenceStore = TasksUiPlugin.getDefault().getPreferenceStore();
        uiPreferenceStore.setValue("org.eclipse.mylyn.tasks.ui.show.trim", this.showTaskTrimButton.getSelection());
        uiPreferenceStore.setValue("org.eclipse.mylyn.tasks.ui.activate.when.opened", this.activateOnOpen.getSelection());
        uiPreferenceStore.setValue("org.eclipse.mylyn.tasks.ui.subtasks.local", this.enableLocalSubTasksButton.getSelection());
        uiPreferenceStore.setValue("org.eclipse.mylyn.tasks.ui.overlays.incoming.tight", this.incomingOverlaysButton.getSelection());
        TaskListView view = TaskListView.getFromActivePerspective();
        if (view != null) {
            view.setSynchronizationOverlaid(this.incomingOverlaysButton.getSelection());
        }
        SandboxUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.java.ui.interest.prediction.errors", this.enableErrorInterest.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.ui.interest.highlighters", SandboxUiPlugin.getDefault().getHighlighterList().externalizeToString());
        return true;
    }

    public boolean performCancel() {
        this.enableErrorInterest.setSelection(SandboxUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.java.ui.interest.prediction.errors"));
        String highlighters = this.getPreferenceStore().getString("org.eclipse.mylyn.ui.interest.highlighters");
        SandboxUiPlugin.getDefault().getHighlighterList().internalizeFromString(highlighters);
        IPreferenceStore uiPreferenceStore = TasksUiPlugin.getDefault().getPreferenceStore();
        this.activateOnOpen.setSelection(uiPreferenceStore.getBoolean("org.eclipse.mylyn.tasks.ui.activate.when.opened"));
        this.enableLocalSubTasksButton.setSelection(uiPreferenceStore.getBoolean("org.eclipse.mylyn.tasks.ui.subtasks.local"));
        this.showTaskTrimButton.setSelection(uiPreferenceStore.getBoolean("org.eclipse.mylyn.tasks.ui.show.trim"));
        this.contentProvider = new HighlighterContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        return true;
    }

    public void performDefaults() {
        super.performDefaults();
        this.enableErrorInterest.setSelection(SandboxUiPlugin.getDefault().getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.java.ui.interest.prediction.errors"));
        this.contentProvider = new HighlighterContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        SandboxUiPlugin.getDefault().getHighlighterList().setToDefaultList();
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(columnNames);
        CellEditor[] editors = new CellEditor[columnNames.length];
        TextCellEditor textEditor = new TextCellEditor((Composite)this.table);
        ((Text)textEditor.getControl()).setTextLimit(20);
        ((Text)textEditor.getControl()).setOrientation(0x2000000);
        editors[0] = textEditor;
        this.colorDialogEditor = new ColorCellEditor((Composite)this.table);
        this.colorDialogEditor.addListener((ICellEditorListener)this);
        editors[1] = this.colorDialogEditor;
        editors[2] = new ComboBoxCellEditor((Composite)this.table, TYPE_ARRAY, 8);
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setCellModifier((ICellModifier)new HighlighterCellModifier());
    }

    private void createAddRemoveButtons(Composite parent) {
        Composite addRemoveComposite = new Composite(parent, 16384);
        addRemoveComposite.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        addRemoveComposite.setLayout((Layout)new GridLayout(2, false));
        Button add = new Button(addRemoveComposite, 0x1000008);
        add.setText("Add");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        add.setLayoutData((Object)gridData);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Highlighter hl = SandboxUiPlugin.getDefault().getHighlighterList().addHighlighter();
                SandboxUiPreferencePage.this.contentProvider.addHighlighter(hl);
            }
        });
        Button delete = new Button(addRemoveComposite, 0x1000008);
        delete.setText("Delete");
        gridData = new GridData(32);
        gridData.widthHint = 80;
        delete.setLayoutData((Object)gridData);
        delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Highlighter hl = (Highlighter)((IStructuredSelection)SandboxUiPreferencePage.this.tableViewer.getSelection()).getFirstElement();
                if (hl != null) {
                    SandboxUiPlugin.getDefault().getHighlighterList().removeHighlighter(hl);
                    SandboxUiPreferencePage.this.contentProvider.removeHighlighter(hl);
                }
            }
        });
    }

    public void applyEditorValue() {
        Object obj = this.colorDialogEditor.getValue();
        if (!this.colorDialogEditor.isDirty() || !this.colorDialogEditor.isValueValid()) {
            return;
        }
        if (obj instanceof RGB) {
            RGB rgb = (RGB)obj;
            Color c = new Color((Device)Display.getCurrent(), rgb.red, rgb.green, rgb.blue);
            if (this.selection != null) {
                this.selection.setCore(c);
                this.contentProvider.updateHighlighter(this.selection);
            }
        }
    }

    public void cancelEditor() {
    }

    public void editorValueChanged(boolean oldValidState, boolean newValidState) {
    }

    private class HighlighterCellModifier
    implements ICellModifier {
        HighlighterCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return element instanceof Highlighter && !((Highlighter)element).getName().equals(HighlighterList.DEFAULT_HIGHLIGHTER.getName());
        }

        public Object getValue(Object element, String property) {
            int columnIndex = Arrays.asList(columnNames).indexOf(property);
            Object res = null;
            if (element instanceof Highlighter) {
                Highlighter hl = (Highlighter)element;
                switch (columnIndex) {
                    case 0: {
                        res = hl.getName();
                        break;
                    }
                    case 1: {
                        SandboxUiPreferencePage.this.selection = hl;
                        if (SandboxUiPreferencePage.this.selection.getCore() != null) {
                            return SandboxUiPreferencePage.this.selection.getCore().getRGB();
                        }
                        return Display.getCurrent().getSystemColor(22).getRGB();
                    }
                    case 2: {
                        if (hl.isGradient()) {
                            res = new Integer(0);
                            break;
                        }
                        if (hl.isIntersection()) {
                            res = new Integer(2);
                            break;
                        }
                        res = new Integer(1);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            return res;
        }

        public void modify(Object element, String property, Object value) {
            int columnIndex = Arrays.asList(columnNames).indexOf(property);
            TableItem item = (TableItem)element;
            Highlighter hl = (Highlighter)item.getData();
            switch (columnIndex) {
                case 0: {
                    if (!(value instanceof String)) break;
                    hl.setName((String)value);
                    SandboxUiPreferencePage.this.contentProvider.updateHighlighter(hl);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (!(value instanceof Integer)) break;
                    int choice = (Integer)value;
                    switch (choice) {
                        case 0: {
                            hl.setGradient(true);
                            hl.setIntersection(false);
                            break;
                        }
                        case 1: {
                            hl.setGradient(false);
                            hl.setIntersection(false);
                            break;
                        }
                        case 2: {
                            hl.setGradient(false);
                            hl.setIntersection(true);
                            break;
                        }
                    }
                    SandboxUiPreferencePage.this.contentProvider.updateHighlighter(hl);
                }
            }
        }
    }

    private class HighlighterContentProvider
    implements IStructuredContentProvider {
        private HighlighterContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return SandboxUiPlugin.getDefault().getHighlighterList().getHighlighters().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void addHighlighter(Highlighter hl) {
            SandboxUiPreferencePage.this.tableViewer.add((Object)hl);
        }

        public void removeHighlighter(Highlighter hl) {
            SandboxUiPreferencePage.this.tableViewer.remove((Object)hl);
        }

        public void updateHighlighter(Highlighter hl) {
            SandboxUiPreferencePage.this.tableViewer.update((Object)hl, null);
        }
    }

    private static class HighlighterLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object obj, int columnIndex) {
            String result = "";
            if (obj instanceof Highlighter) {
                Highlighter h = (Highlighter)obj;
                switch (columnIndex) {
                    case 0: {
                        result = h.getName();
                        break;
                    }
                    case 2: {
                        result = h.getHighlightKind();
                        break;
                    }
                }
            }
            return result;
        }

        public Image getColumnImage(Object obj, int columnIndex) {
            if (obj instanceof Highlighter) {
                Highlighter h = (Highlighter)obj;
                switch (columnIndex) {
                    case 1: {
                        HighlighterImageDescriptor des = h.isGradient() ? new HighlighterImageDescriptor(h.getBase(), h.getHighlightColor()) : new HighlighterImageDescriptor(h.getHighlightColor(), h.getHighlightColor());
                        return des.getImage();
                    }
                }
            }
            return null;
        }
    }

    private static class HighlighterTableSorter
    extends ViewerSorter {
        public static final int LABEL = 1;
        public static final int COLOR = 2;
        public static final int TYPE = 3;
        private final int criteria;

        public HighlighterTableSorter(int criteria) {
            this.criteria = criteria;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            Highlighter h1 = (Highlighter)o1;
            Highlighter h2 = (Highlighter)o2;
            switch (this.criteria) {
                case 1: {
                    return this.compareLabel(h1, h2);
                }
                case 2: {
                    return this.compareImage(h1, h2);
                }
                case 3: {
                    return this.compareType(h1, h2);
                }
            }
            return 0;
        }

        protected int compareLabel(Highlighter h1, Highlighter h2) {
            return h1.getName().compareTo(h2.getName());
        }

        protected int compareImage(Highlighter h1, Highlighter h2) {
            return 0;
        }

        protected int compareType(Highlighter h1, Highlighter h2) {
            return h1.getHighlightKind().compareTo(h2.getHighlightKind());
        }

        public int getCriteria() {
            return this.criteria;
        }
    }
}

