/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.actions;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.internal.context.ui.ContextWorkingSetManager;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class FindReferencesInContextAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public void run(IAction action) {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor != null && editor instanceof JavaEditor) {
            try {
                IJavaElement[] resolved = SelectionConverter.codeResolve((JavaEditor)((JavaEditor)editor));
                if (resolved != null && resolved.length == 1 && resolved[0] != null) {
                    IJavaElement element = resolved[0];
                    ContextWorkingSetManager updater = ContextWorkingSetManager.getDefault().getWorkingSetUpdater();
                    if (updater != null && updater.getWorkingSet() != null) {
                        IJavaSearchScope scope = JavaSearchScopeFactory.getInstance().createJavaSearchScope(updater.getWorkingSet(), false);
                        JavaSearchQuery query = new JavaSearchQuery((QuerySpecification)new ElementQuerySpecification(element, 2, scope, "Mylyn Current Task Context"));
                        NewSearchUI.activateSearchResultView();
                        if (query.canRunInBackground()) {
                            NewSearchUI.runQueryInBackground((ISearchQuery)query);
                        } else {
                            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                            NewSearchUI.runQueryInForeground((IRunnableContext)progressService, (ISearchQuery)query);
                        }
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

