/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.editors;

import java.util.ArrayList;
import java.util.SortedSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.mylyn.internal.sandbox.ui.editors.TaskEditorExtensions;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.ui.actions.CompoundContributionItem;

public class EditorStyleContributionItem
extends CompoundContributionItem {
    private final TaskRepository taskRepository;

    public EditorStyleContributionItem() {
        this(null);
    }

    public EditorStyleContributionItem(String id) {
        this(id, TasksUiUtil.getSelectedRepository());
    }

    public EditorStyleContributionItem(String id, TaskRepository taskRepository) {
        super(id);
        this.taskRepository = taskRepository;
    }

    protected IContributionItem[] getContributionItems() {
        ArrayList<ActionContributionItem> items = new ArrayList<ActionContributionItem>();
        EditorStyleContributionAction noEditorStyleContributionAction = new EditorStyleContributionAction("org.eclipse.mylyn.sandbox.ui.action.none", "None");
        items.add(new ActionContributionItem((IAction)noEditorStyleContributionAction));
        String defaultExtensionId = TaskEditorExtensions.getTaskEditorExtensionId(this.taskRepository);
        if (defaultExtensionId == null || defaultExtensionId.equals("")) {
            noEditorStyleContributionAction.setChecked(true);
        }
        SortedSet<TaskEditorExtensions.RegisteredTaskEditorExtension> allEditorExtensions = TaskEditorExtensions.getTaskEditorExtensions();
        for (TaskEditorExtensions.RegisteredTaskEditorExtension editorExtension : allEditorExtensions) {
            EditorStyleContributionAction editorStyleAction = new EditorStyleContributionAction(editorExtension);
            ActionContributionItem item = new ActionContributionItem((IAction)editorStyleAction);
            if (editorExtension.getId().equals(defaultExtensionId)) {
                editorStyleAction.setChecked(true);
            }
            items.add(item);
        }
        return items.toArray(new IContributionItem[items.size()]);
    }

    private class EditorStyleContributionAction
    extends Action {
        private final TaskEditorExtensions.RegisteredTaskEditorExtension editorExtension;

        public EditorStyleContributionAction(TaskEditorExtensions.RegisteredTaskEditorExtension editorExtension) {
            super(editorExtension.getName());
            this.setId(String.valueOf(editorExtension.getId()) + ".action");
            this.editorExtension = editorExtension;
        }

        public EditorStyleContributionAction(String id, String name) {
            super(name);
            this.setId(id);
            this.editorExtension = null;
        }

        public void run() {
            if (EditorStyleContributionItem.this.taskRepository != null) {
                TaskEditorExtensions.setTaskEditorExtensionId(EditorStyleContributionItem.this.taskRepository, this.editorExtension != null ? this.editorExtension.getId() : "");
                this.setChecked(true);
            }
        }
    }
}

