/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.editors;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.sandbox.ui.editors.AbstractTaskEditorExtension;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextAttributeEditor;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.themes.IThemeManager;

public class ExtensibleRichTextAttributeEditor
extends RichTextAttributeEditor {
    private SourceViewer source;
    private final TaskRepository taskRepository;
    private final int styles;
    private final IContextService contextService;
    private IContextActivation contextActivation;
    private final AbstractTaskEditorExtension extension;
    private CTabFolder folder;
    private SourceViewer preview;

    public ExtensibleRichTextAttributeEditor(IContextService contextService, TaskDataModel manager, TaskRepository taskRepository, AbstractTaskEditorExtension extension, TaskAttribute taskAttribute, int styles) {
        super(manager, taskRepository, taskAttribute, styles);
        this.contextService = contextService;
        this.taskRepository = taskRepository;
        this.extension = extension;
        this.styles = styles;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        if (this.isReadOnly()) {
            this.source = this.extension.createViewer(this.taskRepository, parent, this.styles);
            this.source.setDocument((IDocument)new Document(this.getValue()));
            this.setControl(this.source.getControl());
        } else {
            this.folder = new CTabFolder(parent, 0x800400);
            this.folder.setLayout((Layout)new GridLayout());
            this.folder.setTabHeight(0);
            CTabItem viewerItem = new CTabItem(this.folder, 0);
            viewerItem.setText("Source");
            viewerItem.setToolTipText("Edit Source");
            this.source = this.extension.createEditor(this.taskRepository, (Composite)this.folder, this.styles | 0x200);
            this.source.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
            EditorUtil.setTextViewer((Widget)this.source.getTextWidget(), (TextViewer)this.source);
            if (this.source.getDocument() == null) {
                this.source.setDocument((IDocument)new Document(this.getValue()), (IAnnotationModel)new AnnotationModel());
            }
            this.source.addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    String value = ExtensibleRichTextAttributeEditor.this.source.getTextWidget().getText();
                    if (!ExtensibleRichTextAttributeEditor.this.getValue().equals(value)) {
                        ExtensibleRichTextAttributeEditor.this.setValue(value);
                    }
                }
            });
            this.source.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            FocusListener focusListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                    ExtensibleRichTextAttributeEditor.this.setContext();
                }

                public void focusLost(FocusEvent e) {
                    ExtensibleRichTextAttributeEditor.this.unsetContext();
                }
            };
            this.source.getTextWidget().addFocusListener(focusListener);
            DisposeListener disposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ExtensibleRichTextAttributeEditor.this.unsetContext();
                }
            };
            this.source.getTextWidget().addDisposeListener(disposeListener);
            viewerItem.setControl((Control)(this.source instanceof Viewer ? this.source.getControl() : this.source.getTextWidget()));
            this.folder.setSelection(viewerItem);
            CTabItem previewItem = new CTabItem(this.folder, 0);
            previewItem.setText("Preview");
            previewItem.setToolTipText("Preview Source");
            this.preview = this.extension.createViewer(this.taskRepository, (Composite)this.folder, this.styles | 0x200);
            previewItem.setControl((Control)(this.preview instanceof Viewer ? this.preview.getControl() : this.preview.getTextWidget()));
            this.preview.getTextWidget().setFont(this.getFont());
            this.setControl((Control)this.folder);
        }
        this.source.getTextWidget().setFont(this.getFont());
        toolkit.adapt(this.source.getControl(), false, false);
    }

    private Font getFont() {
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        Font font = themeManager.getCurrentTheme().getFontRegistry().get("org.eclipse.mylyn.tasks.ui.fonts.task.editor.comment");
        return font;
    }

    public SourceViewer getViewer() {
        return this.source;
    }

    protected void setContext() {
        if (this.contextActivation != null) {
            this.contextService.deactivateContext(this.contextActivation);
            this.contextActivation = null;
        }
        if (this.contextService != null && this.extension.getEditorContextId() != null) {
            this.contextActivation = this.contextService.activateContext(this.extension.getEditorContextId());
        }
    }

    public void toggleEditing(boolean editing) {
        if (!this.isReadOnly() && this.folder != null) {
            if (!editing) {
                this.folder.setSelection(1);
                Document document = new Document(this.source.getDocument().get());
                this.preview.setDocument((IDocument)document);
            } else {
                this.folder.setSelection(0);
            }
        }
    }

    protected void unsetContext() {
        if (this.contextActivation != null) {
            this.contextService.deactivateContext(this.contextActivation);
            this.contextActivation = null;
        }
    }
}

