/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.planner;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.commons.core.DateUtil;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.sandbox.ui.planner.OpenTaskEditorAction;
import org.eclipse.mylyn.internal.sandbox.ui.planner.PlannedTasksContentProvider;
import org.eclipse.mylyn.internal.sandbox.ui.planner.RemoveTaskAction;
import org.eclipse.mylyn.internal.sandbox.ui.planner.TaskActivityContentProvider;
import org.eclipse.mylyn.internal.sandbox.ui.planner.TaskActivityEditorInput;
import org.eclipse.mylyn.internal.sandbox.ui.planner.TaskPlannerLabelProvider;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.part.EditorPart;

public class TaskActivityEditorPart
extends EditorPart {
    private static final String LABEL_PLANNED_ACTIVITY = "Planned Activity";
    private static final String LABEL_DIALOG = "Summary";
    private static final String LABEL_PAST_ACTIVITY = "Past Activity";
    private TaskActivityEditorInput editorInput = null;
    private final String[] activityColumnNames = new String[]{" ", " !", "Description", "Elapsed", "Estimated", "Created", "Completed"};
    private final int[] activityColumnWidths = new int[]{100, 30, 200, 70, 70, 90, 90};
    private final int[] activitySortConstants;
    private static final String LABEL_ESTIMATED = "Total estimated time: ";
    private static final String NO_TIME_ELAPSED = "&nbsp;";
    private static final String BLANK_CELL = "&nbsp;";
    private Label totalEstimatedHoursLabel;
    private Label numberCompleted;
    private Label totalTimeOnCompleted;
    private Label numberInProgress;
    private Label totalTimeOnIncomplete;
    private Label totalEstimatedTime;
    private Label totalTime;
    private TaskActivityContentProvider activityContentProvider;
    private PlannedTasksContentProvider planContentProvider;

    public TaskActivityEditorPart() {
        int[] nArray = new int[7];
        nArray[1] = 2;
        nArray[2] = 1;
        nArray[3] = 5;
        nArray[4] = 6;
        nArray[5] = 3;
        nArray[6] = 4;
        this.activitySortConstants = nArray;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.editorInput = (TaskActivityEditorInput)input;
        this.setPartName(this.editorInput.getName());
        this.setTitleToolTip(this.editorInput.getToolTipText());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm sform = toolkit.createScrolledForm(parent);
        Composite editorComposite = sform.getBody();
        editorComposite.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 1808;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        editorComposite.setLayoutData((Object)gridData);
        this.createSummarySection(editorComposite, toolkit, this.editorInput.getReportStartDate(), this.editorInput.getReportEndDate());
        String label = LABEL_PAST_ACTIVITY;
        ArrayList<AbstractTask> allTasks = new ArrayList<AbstractTask>();
        allTasks.addAll(this.editorInput.getCompletedTasks());
        allTasks.addAll(this.editorInput.getInProgressTasks());
        SashForm sashForm = new SashForm(editorComposite, 512);
        sashForm.setLayout((Layout)new GridLayout());
        sashForm.setLayoutData((Object)new GridData(1808));
        this.activityContentProvider = new TaskActivityContentProvider(this.editorInput);
        final TreeViewer activityViewer = this.createTableSection((Composite)sashForm, toolkit, label, this.activityColumnNames, this.activityColumnWidths, this.activitySortConstants);
        activityViewer.setContentProvider((IContentProvider)this.activityContentProvider);
        activityViewer.setLabelProvider((IBaseLabelProvider)new TaskPlannerLabelProvider(activityViewer, this.editorInput.getReportStartDate(), this.editorInput.getReportEndDate()));
        this.setSorters(this.activityColumnNames, this.activitySortConstants, activityViewer.getTree(), activityViewer, false);
        activityViewer.setInput((Object)this.editorInput);
        activityViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TaskActivityEditorPart.this.updateLabels();
            }
        });
        MenuManager activityContextMenuMgr = new MenuManager("#ActivityPlannerPopupMenu");
        activityContextMenuMgr.setRemoveAllWhenShown(true);
        activityContextMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TaskActivityEditorPart.this.fillContextMenu(activityViewer, manager);
            }
        });
        Menu menu = activityContextMenuMgr.createContextMenu(activityViewer.getControl());
        activityViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(activityContextMenuMgr, (ISelectionProvider)activityViewer);
        this.planContentProvider = new PlannedTasksContentProvider(this.editorInput);
        TreeViewer planViewer = this.createTableSection((Composite)sashForm, toolkit, LABEL_PLANNED_ACTIVITY, this.activityColumnNames, this.activityColumnWidths, this.activitySortConstants);
        planViewer.setContentProvider((IContentProvider)this.planContentProvider);
        planViewer.setLabelProvider((IBaseLabelProvider)new TaskPlannerLabelProvider(planViewer, this.editorInput.getReportStartDate(), this.editorInput.getReportEndDate()));
        this.setSorters(this.activityColumnNames, this.activitySortConstants, planViewer.getTree(), planViewer, true);
        planViewer.setInput((Object)this.editorInput);
        this.totalEstimatedHoursLabel = toolkit.createLabel(editorComposite, "Total estimated time: 0 hours  ", 0);
        this.createButtons(editorComposite, toolkit, planViewer, this.planContentProvider);
        this.updateLabels();
    }

    private void fillContextMenu(TreeViewer viewer, IMenuManager manager) {
        if (!viewer.getSelection().isEmpty()) {
            manager.add((IAction)new OpenTaskEditorAction(viewer));
            manager.add((IAction)new RemoveTaskAction(viewer));
            manager.add((IContributionItem)new Separator("additions"));
        } else {
            manager.add((IContributionItem)new Separator("additions"));
        }
    }

    public void setFocus() {
    }

    private void createSummarySection(Composite parent, FormToolkit toolkit, Date startDate, Date endDate) {
        String dateLabel;
        Section summarySection = toolkit.createSection(parent, 256);
        summarySection.setText(LABEL_DIALOG);
        summarySection.setLayout((Layout)new GridLayout());
        summarySection.setLayoutData((Object)new GridData(768));
        Composite summaryContainer = toolkit.createComposite((Composite)summarySection);
        summarySection.setClient((Control)summaryContainer);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        summaryContainer.setLayout((Layout)layout);
        String formatString = "yyyy-MM-dd, h:mm a";
        SimpleDateFormat formater = new SimpleDateFormat(formatString, Locale.ENGLISH);
        if (startDate != null) {
            dateLabel = "Date start: " + formater.format(startDate);
            toolkit.createLabel(summaryContainer, dateLabel, 0);
        }
        if (endDate != null) {
            dateLabel = "Date end: " + formater.format(endDate);
            toolkit.createLabel(summaryContainer, dateLabel, 0);
        }
        String numComplete = "Number completed: " + this.editorInput.getCompletedTasks().size();
        this.numberCompleted = toolkit.createLabel(summaryContainer, numComplete, 0);
        String totalCompletedTaskTime = "Total time on completed: " + DateUtil.getFormattedDuration((long)this.editorInput.getTotalTimeSpentOnCompletedTasks(), (boolean)false);
        this.totalTimeOnCompleted = toolkit.createLabel(summaryContainer, totalCompletedTaskTime, 0);
        String numInProgress = "Number in progress: " + this.editorInput.getInProgressTasks().size();
        this.numberInProgress = toolkit.createLabel(summaryContainer, numInProgress, 0);
        String totalInProgressTaskTime = "Total time on incomplete: " + DateUtil.getFormattedDuration((long)this.editorInput.getTotalTimeSpentOnInProgressTasks(), (boolean)false);
        this.totalTimeOnIncomplete = toolkit.createLabel(summaryContainer, totalInProgressTaskTime, 0);
        String spacer = "        ";
        String totalEstimated = LABEL_ESTIMATED + this.editorInput.getTotalTimeEstimated() + " hours" + spacer;
        this.totalEstimatedTime = toolkit.createLabel(summaryContainer, totalEstimated, 0);
        String grandTotalTime = "Total time: " + this.getTotalTime();
        this.totalTime = toolkit.createLabel(summaryContainer, grandTotalTime, 0);
    }

    private void updateSummarySection() {
        String numComplete = "Number completed: " + this.editorInput.getCompletedTasks().size();
        this.numberCompleted.setText(numComplete);
        String totalCompletedTaskTime = "Total time on completed: " + DateUtil.getFormattedDuration((long)this.editorInput.getTotalTimeSpentOnCompletedTasks(), (boolean)false);
        this.totalTimeOnCompleted.setText(totalCompletedTaskTime);
        String numInProgress = "Number in progress: " + this.editorInput.getInProgressTasks().size();
        this.numberInProgress.setText(numInProgress);
        String totalInProgressTaskTime = "Total time on incomplete: " + DateUtil.getFormattedDuration((long)this.editorInput.getTotalTimeSpentOnInProgressTasks(), (boolean)false);
        this.totalTimeOnIncomplete.setText(totalInProgressTaskTime);
        String spacer = "        ";
        String totalEstimated = LABEL_ESTIMATED + this.editorInput.getTotalTimeEstimated() + " hours" + spacer;
        this.totalEstimatedTime.setText(totalEstimated);
        String grandTotalTime = "Total time: " + this.getTotalTime();
        this.totalTime.setText(grandTotalTime);
    }

    private String getTotalTime() {
        return DateUtil.getFormattedDuration((long)(this.editorInput.getTotalTimeSpentOnCompletedTasks() + this.editorInput.getTotalTimeSpentOnInProgressTasks()), (boolean)false);
    }

    private TreeViewer createTableSection(Composite parent, FormToolkit toolkit, String title, String[] columnNames, int[] columnWidths, int[] sortConstants) {
        Section tableSection = toolkit.createSection(parent, 256);
        tableSection.setText(title);
        tableSection.marginHeight = 8;
        tableSection.setLayout((Layout)new GridLayout());
        tableSection.setLayoutData((Object)new GridData(768));
        Composite detailContainer = toolkit.createComposite((Composite)tableSection);
        tableSection.setClient((Control)detailContainer);
        detailContainer.setLayout((Layout)new GridLayout());
        detailContainer.setLayoutData((Object)new GridData(1808));
        return this.createTable(detailContainer, toolkit, columnNames, columnWidths, sortConstants);
    }

    private TreeViewer createTable(Composite parent, FormToolkit toolkit, String[] columnNames, int[] columnWidths, int[] sortConstants) {
        int style = 101122;
        Tree tree = toolkit.createTree(parent, style);
        tree.setLayout((Layout)new GridLayout());
        GridData tableGridData = new GridData(1808);
        tableGridData.heightHint = 100;
        tree.setLayoutData((Object)tableGridData);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        tree.setEnabled(true);
        int i = 0;
        while (i < columnNames.length) {
            TreeColumn column = new TreeColumn(tree, 16384, i);
            column.setText(columnNames[i]);
            column.setWidth(columnWidths[i]);
            ++i;
        }
        TreeViewer treeViewer = new TreeViewer(tree);
        treeViewer.setUseHashlookup(true);
        treeViewer.setColumnProperties(columnNames);
        final OpenTaskEditorAction openAction = new OpenTaskEditorAction(treeViewer);
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                openAction.run();
            }
        });
        return treeViewer;
    }

    private void setSorters(String[] columnNames, int[] sortConstants, Tree tree, TreeViewer treeViewer, boolean plan) {
        int i = 0;
        while (i < columnNames.length) {
            TreeColumn column = tree.getColumn(i);
            this.addColumnSelectionListener(treeViewer, column, sortConstants[i], plan);
            ++i;
        }
    }

    private void addColumnSelectionListener(TreeViewer tableViewer, TreeColumn column, int sorterConstant, boolean plan) {
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
    }

    private void createButtons(Composite parent, FormToolkit toolkit, TreeViewer viewer, PlannedTasksContentProvider contentProvider) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        Button exportToHTML = toolkit.createButton(container, "Export to HTML...", 0x1000008);
        exportToHTML.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskActivityEditorPart.this.exportToHtml();
            }
        });
    }

    private void updateLabels() {
        this.totalEstimatedHoursLabel.setText(LABEL_ESTIMATED + this.editorInput.getPlannedEstimate() + " hours");
        this.updateSummarySection();
    }

    private void exportToHtml() {
        try {
            FileDialog dialog = new FileDialog(this.getSite().getWorkbenchWindow().getShell());
            dialog.setText("Specify a file name");
            dialog.setFilterExtensions(new String[]{"*.html", "*.*"});
            String filename = dialog.open();
            if (filename == null || filename.equals("")) {
                return;
            }
            if (!filename.endsWith(".html")) {
                filename = String.valueOf(filename) + ".html";
            }
            File outputFile = new File(filename);
            BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));
            writer.write("<html><head></head><body>");
            this.exportSummarySection(writer);
            this.exportActivitySection(writer);
            this.exportPlanSection(writer);
            writer.write("</body></html>");
            writer.close();
        }
        catch (IOException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not write to file", (Throwable)e));
        }
    }

    private void exportPlanSection(BufferedWriter writer) throws IOException {
        writer.write("<H2>Planned Activity</H2>");
        writer.write("<table border=\"1\" width=\"100%\" id=\"plannedActivityTable\">");
        writer.write("<tr>");
        writer.write("<td width=\"59\"><b>Type</b></td><td width=\"55\"><b>Priority</b></td><td width=\"495\"><b>Description</b></td>");
        writer.write("<td><b>Elapsed</b></td><td><b>Estimated</b></td><td><b>Reminder</b></td>");
        writer.write("</tr>");
        Object[] objectArray = this.planContentProvider.getElements(null);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof ITask) {
                AbstractTask currentTask = (AbstractTask)element;
                String formatString = "dd-MM-yyyy";
                SimpleDateFormat format = new SimpleDateFormat(formatString, Locale.ENGLISH);
                String elapsedTimeString = DateUtil.getFormattedDuration((long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)currentTask), (boolean)false);
                String estimatedTimeString = String.valueOf(currentTask.getEstimatedTimeHours()) + " hours";
                if (elapsedTimeString.equals("")) {
                    elapsedTimeString = "&nbsp;";
                }
                DateRange reminderDate = currentTask.getScheduledForDate();
                String reminderDateString = "&nbsp;";
                if (reminderDate != null) {
                    reminderDateString = format.format(reminderDate);
                }
                writer.write("<tr>");
                writer.write("<td width=\"59\">ICON</td><td width=\"55\">" + currentTask.getPriority() + "</td><td width=\"495\">");
                if (TasksUiInternal.isValidUrl((String)currentTask.getUrl())) {
                    writer.write("<a href='" + currentTask.getUrl() + "'>" + currentTask.getSummary() + "</a>");
                } else {
                    writer.write(currentTask.getSummary());
                }
                writer.write("</td><td>" + elapsedTimeString + "</td><td>" + estimatedTimeString + "</td><td>" + reminderDateString + "</td>");
                writer.write("</tr>");
            }
            ++n2;
        }
        writer.write("</table>");
        writer.write("<BR></BR>");
        writer.write("<H3>" + this.totalEstimatedHoursLabel.getText() + "</H3>");
    }

    private void exportActivitySection(BufferedWriter writer) throws IOException {
        writer.write("<H2>Past Activity</H2>");
        writer.write("<table border=\"1\" width=\"100%\" id=\"activityTable\">");
        writer.write("<tr>");
        writer.write("<td width=\"59\"><b>Type</b></td><td width=\"55\"><b>Priority</b></td><td width=\"495\"><b>Description</b></td>");
        writer.write("<td><b>Created</b></td><td><b>Completed</b></td><td><b>Elapsed</b></td><td><b>Estimated</b></td>");
        writer.write("</tr>");
        Object[] objectArray = this.activityContentProvider.getElements(null);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof ITask) {
                AbstractTask currentTask = (AbstractTask)element;
                String formatString = "dd-MM-yyyy";
                SimpleDateFormat format = new SimpleDateFormat(formatString, Locale.ENGLISH);
                String elapsedTimeString = DateUtil.getFormattedDuration((long)TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)currentTask), (boolean)false);
                String estimatedTimeString = String.valueOf(currentTask.getEstimatedTimeHours()) + " hours";
                if (elapsedTimeString.equals("")) {
                    elapsedTimeString = "&nbsp;";
                }
                Date creationDate = currentTask.getCreationDate();
                String creationDateString = "&nbsp;";
                if (creationDate != null) {
                    creationDateString = format.format(creationDate);
                }
                String completionDateString = "&nbsp;";
                Date completedDate = currentTask.getCompletionDate();
                if (completedDate != null) {
                    completionDateString = format.format(completedDate);
                }
                writer.write("<tr>");
                writer.write("<td width=\"59\">ICON</td><td width=\"55\">" + currentTask.getPriority() + "</td><td width=\"495\">");
                if (TasksUiInternal.isValidUrl((String)currentTask.getUrl())) {
                    writer.write("<a href='" + currentTask.getUrl() + "'>" + currentTask.getSummary() + "</a>");
                } else {
                    writer.write(currentTask.getSummary());
                }
                writer.write("</td><td>" + creationDateString + "</td>");
                writer.write("<td>" + completionDateString + "</td><td>" + elapsedTimeString + "</td><td>" + estimatedTimeString + "</td>");
                writer.write("</tr>");
            }
            ++n2;
        }
        writer.write("</table>");
    }

    private void exportSummarySection(BufferedWriter writer) throws IOException {
        Date startDate = this.editorInput.getReportStartDate();
        Date endDate = this.editorInput.getReportEndDate();
        writer.write("<H2>Summary</H2>");
        String formatString = "yyyy-MM-dd, h:mm a";
        SimpleDateFormat format = new SimpleDateFormat(formatString, Locale.ENGLISH);
        writer.write("<table border=\"0\" width=\"75%\" id=\"table1\">\n<tr>\n");
        writer.write("<td width=\"138\">Date start:</td> ");
        String dateLabel = "Not Available";
        if (startDate != null) {
            dateLabel = format.format(startDate);
        }
        writer.write("<td>" + dateLabel + "</td>");
        writer.write("<td width=\"138\">Date end:</td> ");
        String endLabel = "Not Available";
        if (endDate != null) {
            endLabel = format.format(endDate);
        }
        writer.write("<td>" + endLabel + "</td>");
        writer.write("<tr><td width=\"138\">Number Completed:</td><td>" + this.editorInput.getCompletedTasks().size() + "</td>");
        writer.write("<td width=\"169\">Total time on completed:</td><td width=\"376\">" + DateUtil.getFormattedDuration((long)this.editorInput.getTotalTimeSpentOnCompletedTasks(), (boolean)false) + "</td>");
        writer.write("</tr>");
        writer.write("<tr><td width=\"138\">Number in Progress:</td><td>" + this.editorInput.getInProgressTasks().size() + "</td>");
        writer.write("<td width=\"169\">Total time on incompleted:</td><td width=\"376\">" + DateUtil.getFormattedDuration((long)this.editorInput.getTotalTimeSpentOnInProgressTasks(), (boolean)false) + "</td>");
        writer.write("</tr>");
        writer.write("<tr><td width=\"138\">Outstanding estimated hours:</td><td>" + this.editorInput.getTotalTimeEstimated() + "</td>");
        writer.write("<td width=\"169\">Total time:</td><td width=\"376\">" + this.getTotalTime() + "</td>");
        writer.write("</tr>");
        writer.write("</table>");
    }
}

