/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.web.tasks;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.web.tasks.ParametersEditor;
import org.eclipse.mylyn.internal.web.tasks.Util;
import org.eclipse.mylyn.internal.web.tasks.WebContentProposalProvider;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class WebRepositorySettingsPage
extends AbstractRepositorySettingsPage
implements IPropertyChangeListener {
    private static final String TITLE = "Web Repository Settings";
    private static final String DESCRIPTION = "Select a server template example and modify to match the settings for your project, \nusually found in the query URL.  For more connectors see http://eclipse.org/mylyn";
    private ParametersEditor parametersEditor;
    private Text taskUrlText;
    private Text newTaskText;
    private Text queryUrlText;
    private ComboViewer queryRequestMethod;
    private Text queryPatternText;
    private Text loginFormUrlText;
    private Text loginTokenPatternText;
    private Text loginRequestUrlText;
    private ComboViewer loginRequestMethod;
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private Map<String, String> oldProperties;
    private final ArrayList<ControlDecoration> decorations = new ArrayList();

    public WebRepositorySettingsPage(TaskRepository taskRepository) {
        super(TITLE, DESCRIPTION, taskRepository);
        this.setNeedsAnonymousLogin(true);
        this.setNeedsValidation(false);
    }

    public void dispose() {
        for (ControlDecoration decoration : this.decorations) {
            decoration.dispose();
        }
        super.dispose();
    }

    protected void repositoryTemplateSelected(RepositoryTemplate template) {
        this.repositoryLabelEditor.setStringValue(template.label);
        this.setUrl(Util.nvl(template.repositoryUrl));
        this.taskUrlText.setText(Util.nvl(template.taskPrefixUrl));
        this.newTaskText.setText(Util.nvl(template.newTaskUrl));
        this.queryUrlText.setText(Util.nvl(template.taskQueryUrl));
        this.selectMethod(this.queryRequestMethod, template.getAttribute("queryMethod"));
        this.queryPatternText.setText(Util.nvl(template.getAttribute("queryPattern")));
        this.loginRequestUrlText.setText(Util.nvl(template.getAttribute("loginRequestUrl")));
        this.selectMethod(this.loginRequestMethod, template.getAttribute("loginRequestMethod"));
        this.loginFormUrlText.setText(Util.nvl(template.getAttribute("loginFormUrl")));
        this.loginTokenPatternText.setText(Util.nvl(template.getAttribute("loginTokenPattern")));
        this.parametersEditor.removeAll();
        for (Map.Entry entry : template.getAttributes().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("param_")) continue;
            this.parametersEditor.add(key.substring("param_".length()), (String)entry.getValue());
        }
        this.getContainer().updateButtons();
    }

    protected void createAdditionalControls(Composite parent) {
        this.addRepositoryTemplatesToServerUrlCombo();
        Composite composite = new Composite(parent, 0);
        this.createParameterEditor(composite);
        this.createAdvancedComposite(composite);
        GridDataFactory.fillDefaults().grab(true, false).hint(200, -1).span(2, -1).applyTo((Control)composite);
        if (this.repository != null) {
            this.taskUrlText.setText(this.getTextProperty("taskUrl"));
            this.newTaskText.setText(this.getTextProperty("taskCreationUrl"));
            this.selectMethod(this.queryRequestMethod, this.getTextProperty("queryMethod"));
            this.queryUrlText.setText(this.getTextProperty("queryUrl"));
            this.queryPatternText.setText(this.getTextProperty("queryPattern"));
            this.loginFormUrlText.setText(this.getTextProperty("loginFormUrl"));
            this.loginTokenPatternText.setText(this.getTextProperty("loginTokenPattern"));
            this.selectMethod(this.loginRequestMethod, this.getTextProperty("loginRequestMethod"));
            this.loginRequestUrlText.setText(this.getTextProperty("loginRequestUrl"));
            this.oldProperties = this.repository.getProperties();
            this.parametersEditor.addParams(this.oldProperties, new LinkedHashMap<String, String>());
        }
    }

    private void selectMethod(ComboViewer viewer, String method) {
        if (!Util.isPresent(method)) {
            method = "GET";
        }
        viewer.setSelection((ISelection)new StructuredSelection(new Object[]{method}), true);
    }

    private String getTextProperty(String name) {
        return Util.nvl(this.repository.getProperty(name));
    }

    protected boolean isValidUrl(String name) {
        return name != null && name.trim().length() > 0;
    }

    private void createParameterEditor(Composite composite) {
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginBottom = 10;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        this.parametersEditor = new ParametersEditor(composite, 0);
        GridData parametersEditorGridData = new GridData(4, 4, true, true);
        parametersEditorGridData.minimumHeight = 100;
        this.parametersEditor.setLayoutData(parametersEditorGridData);
    }

    private void createAdvancedComposite(Composite composite) {
        ExpandableComposite expComposite = this.toolkit.createExpandableComposite(composite, 290);
        expComposite.clientVerticalSpacing = 0;
        GridData gridData_2 = new GridData(4, 128, true, false);
        gridData_2.horizontalIndent = -5;
        expComposite.setLayoutData((Object)gridData_2);
        expComposite.setFont(composite.getFont());
        expComposite.setBackground(composite.getBackground());
        expComposite.setText("Advanced &Configuration");
        expComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                WebRepositorySettingsPage.this.getControl().getShell().pack();
            }
        });
        this.toolkit.paintBordersFor((Composite)expComposite);
        Composite composite2 = this.toolkit.createComposite((Composite)expComposite, 2048);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 3;
        gridLayout2.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout2);
        expComposite.setClient((Control)composite2);
        Label taskUrlLabel = this.toolkit.createLabel(composite2, "&Task URL:", 0);
        taskUrlLabel.setLayoutData((Object)new GridData());
        this.taskUrlText = new Text(composite2, 2048);
        this.taskUrlText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.decorations.add(WebContentProposalProvider.createDecoration(this.taskUrlText, this.parametersEditor, false));
        Label newTaskLabel = this.toolkit.createLabel(composite2, "&New Task URL:", 0);
        newTaskLabel.setLayoutData((Object)new GridData());
        this.newTaskText = new Text(composite2, 2048);
        this.newTaskText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.decorations.add(WebContentProposalProvider.createDecoration(this.newTaskText, this.parametersEditor, false));
        Label separatorLabel2 = new Label(composite2, 258);
        GridData gridData_4 = new GridData(4, 0x1000000, false, false, 3, 1);
        gridData_4.verticalIndent = 5;
        gridData_4.heightHint = 5;
        separatorLabel2.setLayoutData((Object)gridData_4);
        this.toolkit.adapt((Control)separatorLabel2, true, true);
        Label queryUrlLabel = this.toolkit.createLabel(composite2, "&Query Request URL:", 0);
        queryUrlLabel.setLayoutData((Object)new GridData());
        this.queryUrlText = new Text(composite2, 2048);
        this.queryUrlText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.decorations.add(WebContentProposalProvider.createDecoration(this.queryUrlText, this.parametersEditor, false));
        this.queryRequestMethod = new ComboViewer(composite2, 2056);
        this.queryRequestMethod.setContentProvider((IContentProvider)new MethodTypeContentProvider());
        this.queryRequestMethod.setInput((Object)"");
        Combo combo = this.queryRequestMethod.getCombo();
        this.toolkit.adapt((Control)combo, true, true);
        combo.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        Label queryPatternLabel = this.toolkit.createLabel(composite2, "Query &Pattern:", 0);
        queryPatternLabel.setLayoutData((Object)new GridData(16384, 4, false, true));
        this.queryPatternText = new Text(composite2, 2626);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        gridData.widthHint = 200;
        gridData.heightHint = 60;
        this.queryPatternText.setLayoutData((Object)gridData);
        this.decorations.add(WebContentProposalProvider.createDecoration(this.queryPatternText, this.parametersEditor, true));
        Label separatorLabel1 = new Label(composite2, 258);
        GridData gridData_3 = new GridData(4, 0x1000000, false, false, 3, 1);
        gridData_3.heightHint = 5;
        gridData_3.verticalIndent = 5;
        separatorLabel1.setLayoutData((Object)gridData_3);
        this.toolkit.adapt((Control)separatorLabel1, true, true);
        Label loginrequestUrlLabel = new Label(composite2, 0);
        loginrequestUrlLabel.setLayoutData((Object)new GridData());
        this.toolkit.adapt((Control)loginrequestUrlLabel, true, true);
        loginrequestUrlLabel.setText("Login &Request URL:");
        this.loginRequestUrlText = new Text(composite2, 2048);
        this.toolkit.adapt((Control)this.loginRequestUrlText, true, true);
        this.loginRequestUrlText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.decorations.add(WebContentProposalProvider.createDecoration(this.loginRequestUrlText, this.parametersEditor, false));
        this.loginRequestMethod = new ComboViewer(composite2, 2056);
        this.loginRequestMethod.setContentProvider((IContentProvider)new MethodTypeContentProvider());
        this.loginRequestMethod.setInput((Object)"");
        Combo combo2 = this.loginRequestMethod.getCombo();
        this.toolkit.adapt((Control)combo2, true, true);
        combo2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        Label loginPageLabel = this.toolkit.createLabel(composite2, "Login &Form URL:", 0);
        loginPageLabel.setLayoutData((Object)new GridData());
        this.loginFormUrlText = new Text(composite2, 2048);
        this.loginFormUrlText.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.decorations.add(WebContentProposalProvider.createDecoration(this.loginFormUrlText, this.parametersEditor, false));
        Label loginTokenLabel = this.toolkit.createLabel(composite2, "Login T&oken Pattern:", 0);
        loginTokenLabel.setLayoutData((Object)new GridData(16384, 4, false, true));
        this.loginTokenPatternText = new Text(composite2, 2626);
        GridData gridData_1 = new GridData(4, 4, false, true, 2, 1);
        gridData_1.widthHint = 200;
        gridData_1.heightHint = 30;
        this.loginTokenPatternText.setLayoutData((Object)gridData_1);
        this.decorations.add(WebContentProposalProvider.createDecoration(this.loginTokenPatternText, this.parametersEditor, true));
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        if (source == this.taskUrlText || source == this.taskUrlText) {
            this.getWizard().getContainer().updateButtons();
        }
    }

    public void applyTo(TaskRepository repository) {
        super.applyTo(repository);
        repository.setProperty("taskUrl", this.taskUrlText.getText());
        repository.setProperty("taskCreationUrl", this.newTaskText.getText());
        repository.setProperty("queryUrl", this.queryUrlText.getText());
        repository.setProperty("queryPattern", this.queryPatternText.getText());
        repository.setProperty("queryMethod", this.getSelection(this.queryRequestMethod));
        String loginRequestUrl = this.loginRequestUrlText.getText();
        repository.setProperty("loginRequestUrl", loginRequestUrl);
        if (loginRequestUrl.length() > 0) {
            repository.setProperty("loginRequestMethod", this.getSelection(this.loginRequestMethod));
        } else {
            repository.removeProperty("loginRequestMethod");
        }
        repository.setProperty("loginFormUrl", this.loginFormUrlText.getText());
        repository.setProperty("loginTokenPattern", this.loginTokenPatternText.getText());
        if (this.oldProperties != null) {
            for (Map.Entry<String, String> e : this.oldProperties.entrySet()) {
                String key = e.getKey();
                if (!key.startsWith("param_")) continue;
                repository.removeProperty(key);
            }
        }
        for (Map.Entry<String, String> e : this.parametersEditor.getParameters().entrySet()) {
            repository.setProperty(e.getKey(), e.getValue());
        }
    }

    private String getSelection(ComboViewer viewer) {
        return (String)((IStructuredSelection)viewer.getSelection()).getFirstElement();
    }

    protected AbstractRepositorySettingsPage.Validator getValidator(TaskRepository repository) {
        return null;
    }

    public String getConnectorKind() {
        return "web";
    }

    private static class MethodTypeContentProvider
    implements IStructuredContentProvider {
        private static final Object[] ELEMENTS = new Object[]{"GET", "POST"};

        private MethodTypeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ELEMENTS;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

