/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui;

import java.net.Proxy;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Set;
import javax.security.auth.login.LoginException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.xplanner.core.service.XPlannerClient;
import org.eclipse.mylyn.xplanner.ui.Messages;
import org.eclipse.mylyn.xplanner.ui.XPlannerAttributeMapper;
import org.eclipse.mylyn.xplanner.ui.XPlannerClientFacade;
import org.eclipse.mylyn.xplanner.ui.XPlannerMylynUIPlugin;
import org.eclipse.mylyn.xplanner.ui.XPlannerRepositoryUtils;
import org.eclipse.mylyn.xplanner.ui.wizard.XPlannerTaskMapping;
import org.xplanner.soap.TimeEntryData;
import org.xplanner.soap.UserStoryData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPlannerTaskDataHandler
extends AbstractTaskDataHandler {
    private TaskAttributeMapper attributeFactory = null;

    public TaskData downloadTaskData(ITask repositoryTask, TaskRepository repository, Proxy proxySettings) throws CoreException, LoginException {
        if (!repositoryTask.getConnectorKind().equals("xplanner")) {
            return null;
        }
        TaskData repositoryTaskData = null;
        XPlannerClient client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
        repositoryTaskData = XPlannerRepositoryUtils.createRepositoryTaskData(repository, repositoryTask, client);
        return repositoryTaskData;
    }

    public boolean initializeTaskData(TaskRepository repository, TaskData repositoryTaskData, ITaskMapping initializationData, IProgressMonitor monitor) throws CoreException {
        if (!(initializationData instanceof XPlannerTaskMapping)) {
            return false;
        }
        XPlannerTaskMapping xplannerTaskMapping = (XPlannerTaskMapping)initializationData;
        return this.initializeTaskData(repository, repositoryTaskData, xplannerTaskMapping.getUserStoryData());
    }

    public boolean initializeTaskData(TaskRepository repository, TaskData repositoryTaskData, UserStoryData userStory) throws CoreException {
        if (repository == null || repositoryTaskData == null || userStory == null) {
            return false;
        }
        XPlannerRepositoryUtils.setupNewTaskAttributes(userStory, repositoryTaskData);
        return true;
    }

    public TaskAttributeMapper getAttributeMapper(TaskRepository taskRepository) {
        if (this.attributeFactory == null) {
            this.attributeFactory = new XPlannerAttributeMapper(taskRepository);
        }
        return this.attributeFactory;
    }

    public RepositoryResponse postTaskData(TaskRepository repository, TaskData repositoryTaskData, Set<TaskAttribute> changedAttributes, IProgressMonitor monitor) throws CoreException {
        RepositoryResponse result = new RepositoryResponse();
        try {
            result = this.postChangesToRepository(repository, repositoryTaskData);
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.xplanner.core", 4, Messages.XPlannerOfflineTaskHandler_CANNOT_POST_DATA_TO_SERVER, null));
        }
        return result;
    }

    private RepositoryResponse postChangesToRepository(TaskRepository repository, TaskData repositoryTaskData) throws CoreException {
        RepositoryResponse response = new RepositoryResponse();
        String error = null;
        String newTaskId = null;
        XPlannerClient client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
        if (client != null) {
            try {
                org.xplanner.soap.TaskData taskData = null;
                if (repositoryTaskData.isNew()) {
                    taskData = XPlannerRepositoryUtils.createNewTaskData(repositoryTaskData, client);
                    if ((taskData = client.addTask(taskData)).getCreatedDate() == null) {
                        taskData.setCreatedDate(taskData.getLastUpdateTime());
                    }
                    newTaskId = "" + taskData.getId();
                } else {
                    taskData = client.getTask(Integer.valueOf(repositoryTaskData.getTaskId()).intValue());
                }
                if (taskData != null) {
                    taskData.setName(XPlannerRepositoryUtils.getName(repositoryTaskData));
                    taskData.setDescription(XPlannerRepositoryUtils.getDescription(repositoryTaskData));
                    taskData.setEstimatedHours(Double.valueOf(XPlannerRepositoryUtils.getEstimatedHours(repositoryTaskData)).doubleValue());
                    taskData.setCompleted(XPlannerRepositoryUtils.isCompleted(repositoryTaskData));
                    int personId = client.getCurrentPersonId();
                    if (personId >= 0) {
                        taskData.setAcceptorId(personId);
                    }
                    Double currentActualHours = taskData.getActualHours();
                    Double changedActualHours = XPlannerRepositoryUtils.getActualHours(repositoryTaskData);
                    if (currentActualHours < changedActualHours) {
                        TimeEntryData newTimeEntry = new TimeEntryData();
                        newTimeEntry.setDuration(changedActualHours - currentActualHours);
                        newTimeEntry.setPerson1Id(taskData.getAcceptorId());
                        newTimeEntry.setTaskId(taskData.getId());
                        newTimeEntry.setReportDate(Calendar.getInstance());
                        client.addTimeEntry(newTimeEntry);
                    }
                    XPlannerRepositoryUtils.ensureTaskDataValid(taskData);
                    client.update(taskData);
                    response = new RepositoryResponse(repositoryTaskData.isNew() ? RepositoryResponse.ResponseKind.TASK_CREATED : RepositoryResponse.ResponseKind.TASK_UPDATED, "" + taskData.getId());
                } else {
                    UserStoryData userStory = client.getUserStory(Integer.valueOf(repositoryTaskData.getTaskId()).intValue());
                    if (userStory != null) {
                        userStory.setName(XPlannerRepositoryUtils.getName(repositoryTaskData));
                        userStory.setDescription(XPlannerRepositoryUtils.getDescription(repositoryTaskData));
                        userStory.setActualHours(XPlannerRepositoryUtils.getActualHours(repositoryTaskData));
                        client.update(userStory);
                        response = new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_UPDATED, repositoryTaskData.getTaskId());
                    }
                }
            }
            catch (NumberFormatException e) {
                XPlannerMylynUIPlugin.log(e.getCause(), "", false);
                error = e.getMessage();
            }
            catch (RemoteException e) {
                XPlannerMylynUIPlugin.log(e.getCause(), "", false);
                error = e.getMessage();
            }
        }
        if (error == null && repositoryTaskData.isNew()) {
            error = newTaskId;
        }
        return response;
    }

    public boolean initializeSubTaskData(TaskRepository repository, org.xplanner.soap.TaskData taskData, org.xplanner.soap.TaskData parentTaskData, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    public void migrateTaskData(TaskRepository taskRepository, TaskData taskData) {
        int version = 0;
        if (taskData.getVersion() != null) {
            try {
                version = Integer.parseInt(taskData.getVersion());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (version < 1) {
            TaskAttribute root = taskData.getRoot();
            ArrayList attributes = new ArrayList(root.getAttributes().values());
            for (TaskAttribute attribute : attributes) {
                if (!XPlannerAttributeMapper.Attribute.DESCRIPTION.getCommonAttributeKey().equals(attribute.getId())) continue;
                attribute.getMetaData().setType(XPlannerRepositoryUtils.getType(attribute.getId()));
            }
            taskData.setVersion("1");
        }
    }
}

