/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.mylyn.tasks.core.AbstractTaskListMigrator;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.xplanner.ui.XPlannerAttributeMapper;
import org.eclipse.mylyn.xplanner.ui.XPlannerMylynUIPlugin;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPlannerTaskListMigrator
extends AbstractTaskListMigrator {
    public static final List<Integer> INVALID_IDS = Arrays.asList(-1);
    private static final String TOKEN_SEPARATOR = ";";
    private static final String KEY_XPLANNER = "XPlanner";
    private static final String KEY_CUSTOM = "XPlannerCustom";
    private static final String KEY_XPLANNER_QUERY = "XPlannerQuery";
    private static final String KEY_XPLANNER_CUSTOM = "XPlannerXPlannerCustomQuery";
    private static final String KEY_XPLANNER_ITEM = "XPlannerItem";
    private static final String KEY_QUERY_CONTENT_ID_TYPE = "QueryContentIdType";
    private static final String KEY_QUERY_IS_TASKS = "QueryIsTasks";
    public static final String KEY_QUERY_CONTENT_IDS = "QueryConentId";
    private static final String KEY_QUERY_PERSON_ID = "QueryPersonId";
    private static final String KEY_QUERY_MY_CURRENT_TASKS = "QueryMyCurrentTasks";
    public static final String KEY_TASK_UPDATE = "LastUpdate";

    public boolean canReadQuery(Node node) {
        return node.getNodeName().equals(KEY_XPLANNER_QUERY) || node.getNodeName().equals(KEY_XPLANNER_CUSTOM);
    }

    public String getConnectorKind() {
        return "xplanner";
    }

    public Set<String> getQueryElementNames() {
        HashSet<String> names = new HashSet<String>();
        names.add(KEY_XPLANNER_CUSTOM);
        return names;
    }

    public String getTaskElementName() {
        return KEY_XPLANNER_ITEM;
    }

    public static boolean isUseTasks(IRepositoryQuery query) {
        String isTasksValue = query.getAttribute(KEY_QUERY_IS_TASKS);
        return isTasksValue == null || isTasksValue.length() == 0 ? false : Boolean.valueOf(isTasksValue);
    }

    public static void setUseTasks(IRepositoryQuery query, boolean isUseTasks) {
        XPlannerTaskListMigrator.setUseTasks(query, Boolean.toString(isUseTasks));
    }

    public static void setUseTasks(IRepositoryQuery query, String isUseTasksValue) {
        query.setAttribute(KEY_QUERY_IS_TASKS, isUseTasksValue == null || isUseTasksValue.length() == 0 ? Boolean.toString(true) : isUseTasksValue);
    }

    public static int getPersonId(IRepositoryQuery query) {
        String personIdValue = query.getAttribute(KEY_QUERY_PERSON_ID);
        int personId = -1;
        try {
            personId = personIdValue == null || personIdValue.length() == 0 ? -1 : Integer.valueOf(personIdValue);
        }
        catch (NumberFormatException e) {
            XPlannerMylynUIPlugin.log(e, "Could not format person id: " + personIdValue, false);
        }
        return personId;
    }

    public static void setPersonId(IRepositoryQuery query, int personId) {
        XPlannerTaskListMigrator.setPersonId(query, Integer.toString(personId));
    }

    public static void setPersonId(IRepositoryQuery query, String personIdValue) {
        query.setAttribute(KEY_QUERY_PERSON_ID, personIdValue == null || personIdValue.length() == 0 ? XPlannerAttributeMapper.INVALID_ID_STRING : personIdValue);
    }

    public static boolean isMyCurrentTasks(IRepositoryQuery query) {
        String isMyCurrentTasksValue = query.getAttribute(KEY_QUERY_MY_CURRENT_TASKS);
        return isMyCurrentTasksValue == null || isMyCurrentTasksValue.length() == 0 ? false : Boolean.valueOf(isMyCurrentTasksValue);
    }

    public static void setMyCurrentTasks(IRepositoryQuery query, boolean isMyCurrentTasks) {
        query.setAttribute(KEY_QUERY_MY_CURRENT_TASKS, Boolean.toString(isMyCurrentTasks));
    }

    public void migrateQuery(IRepositoryQuery query, Element element) {
        boolean isMyCurrentTasks = Boolean.parseBoolean(element.getAttribute(KEY_QUERY_MY_CURRENT_TASKS));
        XPlannerTaskListMigrator.setMyCurrentTasks(query, isMyCurrentTasks);
        if (!isMyCurrentTasks) {
            query.setAttribute(KEY_QUERY_MY_CURRENT_TASKS, Boolean.toString(false));
            XPlannerTaskListMigrator.setContentIdType(query, element.getAttribute(KEY_QUERY_CONTENT_ID_TYPE));
            XPlannerTaskListMigrator.setUseTasks(query, element.getAttribute(KEY_QUERY_IS_TASKS));
            XPlannerTaskListMigrator.setContentIds(query, element.getAttribute(KEY_QUERY_CONTENT_IDS));
            XPlannerTaskListMigrator.setPersonId(query, element.getAttribute(KEY_QUERY_PERSON_ID));
        }
    }

    public void migrateTask(ITask task, Element element) {
        String taskKind = element.getAttribute("Task");
        task.setTaskKind(taskKind == null || taskKind.length() == 0 || taskKind.equals("task.common.kind.default") ? XPlannerAttributeMapper.XPlannerTaskKind.TASK.toString() : taskKind);
        task.setModificationDate(XPlannerAttributeMapper.getDateForAttributeType("LastModified", element.getAttribute("LastModified")));
        boolean setDefaultKind = taskKind == null || taskKind.length() == 0 || taskKind.equals("task.common.kind.default");
        task.setTaskKind(setDefaultKind ? XPlannerAttributeMapper.XPlannerTaskKind.TASK.toString() : taskKind);
        String lastModDate = element.getAttribute("LastModified");
        task.setAttribute(KEY_TASK_UPDATE, lastModDate);
        try {
            Date lastUpdated = XPlannerAttributeMapper.TIME_DATE_FORMAT.parse(lastModDate);
            task.setModificationDate(lastUpdated);
        }
        catch (ParseException parseException) {}
    }

    public static List<Integer> getContentIds(IRepositoryQuery query) {
        return XPlannerTaskListMigrator.decodeQueryContentIds(query.getAttribute(KEY_QUERY_CONTENT_IDS));
    }

    public static void setContentIds(IRepositoryQuery query, List<Integer> contentIds) {
        XPlannerTaskListMigrator.setContentIds(query, XPlannerTaskListMigrator.encodeQueryContentIds(contentIds));
    }

    public static void setContentIds(IRepositoryQuery query, String contentIdsValue) {
        query.setAttribute(KEY_QUERY_CONTENT_IDS, contentIdsValue);
    }

    public static ContentIdType getContentIdType(IRepositoryQuery query) {
        String contentIdTypeValue = query.getAttribute(KEY_QUERY_CONTENT_ID_TYPE);
        return XPlannerTaskListMigrator.getContentIdType(contentIdTypeValue);
    }

    public static void setContentIdType(IRepositoryQuery query, ContentIdType contentIdType) {
        XPlannerTaskListMigrator.setContentIdType(query, contentIdType.name());
    }

    public static void setContentIdType(IRepositoryQuery query, String contentIdTypeValue) {
        query.setAttribute(KEY_QUERY_CONTENT_ID_TYPE, contentIdTypeValue == null || contentIdTypeValue.length() == 0 ? ContentIdType.USER_STORY.name() : contentIdTypeValue);
    }

    public static ContentIdType getContentIdType(String contentIdTypeValue) {
        return contentIdTypeValue == null || contentIdTypeValue.length() == 0 ? ContentIdType.USER_STORY : ContentIdType.valueOf(contentIdTypeValue);
    }

    public static String encodeQueryContentIds(List<Integer> contentIds) {
        StringBuilder result = new StringBuilder();
        Iterator<Integer> iter = contentIds.iterator();
        while (iter.hasNext()) {
            Integer id = iter.next();
            result.append(id);
            if (!iter.hasNext()) continue;
            result.append(TOKEN_SEPARATOR);
        }
        return result.toString();
    }

    public static List<Integer> decodeQueryContentIds(String encoded) {
        if (encoded == null || encoded.length() == 0) {
            return INVALID_IDS;
        }
        StringTokenizer tokens = new StringTokenizer(encoded, TOKEN_SEPARATOR);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            try {
                ids.add(Integer.valueOf(token));
            }
            catch (NumberFormatException e) {
                XPlannerMylynUIPlugin.log(e, "Could not format query id: " + token, false);
            }
        }
        return ids;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentIdType {
        PROJECT,
        ITERATION,
        USER_STORY;

    }
}

