/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core;

import org.eclipse.mylyn.internal.jira.core.JiraFieldType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JiraAttribute {
    ACTUAL("attribute.jira.actual", JiraFieldType.TEXTFIELD, "Time Spent:", false, true, "timespent"),
    AFFECTSVERSIONS("attribute.jira.affectsversions", JiraFieldType.MULTISELECT, "Affects Versions:", false, false, "versions"),
    COMMENT_NEW("task.common.comment.new", JiraFieldType.TEXTAREA, "New Comment:", true, false, "comment"),
    COMPONENTS("attribute.jira.components", JiraFieldType.MULTISELECT, "Components:", false, false, "components"),
    CREATION_DATE("task.common.date.created", JiraFieldType.DATE, "Created:"),
    DESCRIPTION("task.common.description", JiraFieldType.TEXTFIELD, "Description:", true, false, "description"),
    DUE_DATE("attribute.jira.due", JiraFieldType.DATE, "Due Date:", false, false, "duedate"),
    ENVIRONMENT("attribute.jira.environment", JiraFieldType.TEXTAREA, "Environment:", false, false, "environment"),
    ESTIMATE("attribute.jira.estimate", JiraFieldType.TEXTFIELD, "Estimate:", false, false, "timetracking"),
    FIXVERSIONS("attribute.jira.fixversions", JiraFieldType.MULTISELECT, "Fix Versions:", false, false, "fixVersions"),
    INITIAL_ESTIMATE("attribute.jira.initialestimate", JiraFieldType.TEXTFIELD, "Original Estimate:", false, true),
    ISSUE_KEY("task.common.key", JiraFieldType.TEXTFIELD, "Key:"),
    LINKED_IDS("attribute.jira.link_ids", JiraFieldType.TEXTFIELD, "Linked ids:", true, true),
    MODIFICATION_DATE("task.common.date.modified", JiraFieldType.DATE, "Modified:"),
    PARENT_ID("attribute.jira.issue_parent_id", JiraFieldType.ISSUELINK, "Parent ID:", true, true),
    PARENT_KEY("attribute.jira.issue_parent_key", JiraFieldType.ISSUELINK, "Parent:", false, true),
    PRIORITY("task.common.priority", JiraFieldType.SELECT, "Priority:", false, false, "priority"),
    PROJECT("task.common.product", JiraFieldType.PROJECT, "Project:", false, true),
    RESOLUTION("task.common.resolution", JiraFieldType.SELECT, "Resolution:", true, false, "resolution"),
    SECURITY_LEVEL("attribute.jira.security", JiraFieldType.SELECT, "Security Level:", false, true),
    STATUS("task.common.status", JiraFieldType.SELECT, "Status:"),
    SUBTASK_IDS("attribute.jira.subtask_ids", JiraFieldType.TEXTFIELD, "Subtask ids:", true, true),
    SUBTASK_KEYS("attribute.jira.subtask_keys", JiraFieldType.ISSUELINKS, "Subtasks:", false, true),
    SUMMARY("task.common.summary", JiraFieldType.TEXTFIELD, "Summary:", true, false, "summary"),
    TYPE("attribute.jira.type", JiraFieldType.SELECT, "Type:", false, false, "issuetype"),
    UNKNOWN(null, JiraFieldType.UNKNOWN, "unknown:", true, true),
    USER_ASSIGNED("task.common.user.assigned", JiraFieldType.USERPICKER, "Assigned to:", true, false, "assignee"),
    USER_REPORTER("task.common.user.reporter", JiraFieldType.USERPICKER, "Reported by:"),
    TASK_URL("task.common.url", JiraFieldType.URL, "URL:");

    private final String id;
    private final boolean isHidden;
    private final boolean isReadOnly;
    private final String name;
    private final String paramName;
    private final JiraFieldType type;

    public static JiraAttribute valueById(String id) {
        JiraAttribute[] jiraAttributeArray = JiraAttribute.values();
        int n = jiraAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JiraAttribute attribute = jiraAttributeArray[n2];
            if (id.equals(attribute.id())) {
                return attribute;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    private JiraAttribute(String id, JiraFieldType type, String name) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.isHidden = true;
        this.isReadOnly = true;
        this.paramName = null;
    }

    private JiraAttribute(String id, JiraFieldType type, String name, boolean isHidden, boolean isReadOnly) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.isHidden = isHidden;
        this.isReadOnly = isReadOnly;
        this.paramName = null;
    }

    private JiraAttribute(String id, JiraFieldType type, String name, boolean isHidden, boolean isReadOnly, String paramName) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.isHidden = isHidden;
        this.isReadOnly = isReadOnly;
        this.paramName = paramName;
    }

    public String id() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getParamName() {
        return this.paramName;
    }

    public JiraFieldType getType() {
        return this.type;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public String getKind() {
        return this.isHidden ? null : "task.common.kind.default";
    }
}

