/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.jira.core.JiraAttribute;
import org.eclipse.mylyn.internal.jira.core.JiraClientFactory;
import org.eclipse.mylyn.internal.jira.core.JiraCorePlugin;
import org.eclipse.mylyn.internal.jira.core.JiraIssueCollector;
import org.eclipse.mylyn.internal.jira.core.JiraTaskAttachmentHandler;
import org.eclipse.mylyn.internal.jira.core.JiraTaskDataHandler;
import org.eclipse.mylyn.internal.jira.core.JiraTaskMapper;
import org.eclipse.mylyn.internal.jira.core.model.JiraFilter;
import org.eclipse.mylyn.internal.jira.core.model.JiraIssue;
import org.eclipse.mylyn.internal.jira.core.model.Project;
import org.eclipse.mylyn.internal.jira.core.model.filter.DateRangeFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.FilterDefinition;
import org.eclipse.mylyn.internal.jira.core.model.filter.IssueCollector;
import org.eclipse.mylyn.internal.jira.core.model.filter.Order;
import org.eclipse.mylyn.internal.jira.core.model.filter.RelativeDateRangeFilter;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.util.JiraUtil;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskRelation;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraRepositoryConnector
extends AbstractRepositoryConnector {
    private static final String ID_STATUS_RESOLVED = "5";
    private static final String ID_STATUS_CLOSED = "6";
    private static final String ERROR_REPOSITORY_CONFIGURATION = "The repository returned an unknown project. Please update the repository attributes.";
    private static final int MAX_MARK_STALE_QUERY_HITS = 500;
    private static final boolean TRACE_ENABLED = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.mylyn.internal.jira.ui/connector"));
    public static final String ISSUE_URL_PREFIX = "/browse/";
    public static final String FILTER_URL_PREFIX = "/secure/IssueNavigator.jspa?mode=hide";
    private final JiraTaskDataHandler taskDataHandler = new JiraTaskDataHandler(JiraClientFactory.getDefault());
    private final JiraTaskAttachmentHandler attachmentHandler = new JiraTaskAttachmentHandler();
    public static final String UNASSIGNED_USER = "-1";
    public static final String NEW_TASK_DESC = "New Task";
    public static final int RETURN_ALL_HITS = -1;

    public String getLabel() {
        return "JIRA (supports 3.3.3 and later)";
    }

    public String getConnectorKind() {
        return "jira";
    }

    public boolean canCreateTaskFromKey(TaskRepository repository) {
        return true;
    }

    public IStatus performQuery(TaskRepository repository, IRepositoryQuery repositoryQuery, TaskDataCollector resultCollector, ISynchronizationSession session, IProgressMonitor monitor) {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask("Query Repository", -1);
            JiraClient client = JiraClientFactory.getDefault().getJiraClient(repository);
            try {
                if (!client.getCache().hasDetails()) {
                    client.getCache().refreshDetails(monitor);
                }
            }
            catch (JiraException e) {
                IStatus iStatus = JiraCorePlugin.toStatus(repository, e);
                monitor.done();
                return iStatus;
            }
            JiraFilter filter = JiraUtil.getQuery(repository, client, repositoryQuery, true);
            if (filter == null) {
                RepositoryStatus repositoryStatus = RepositoryStatus.createStatus((TaskRepository)repository, (int)4, (String)"org.eclipse.mylyn.internal.jira.core", (String)"The JIRA query is invalid");
                return repositoryStatus;
            }
            QueryHitCollector collector = new QueryHitCollector(repository, client, resultCollector, session, monitor);
            client.search(filter, collector, monitor);
            IStatus iStatus = collector.getStatus();
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void preSynchronization(ISynchronizationSession session, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask("Getting changed tasks", -1);
            session.setNeedsPerformQueries(true);
            if (!session.isFullSynchronization()) {
                return;
            }
            Date now = new Date();
            TaskRepository repository = session.getTaskRepository();
            FilterDefinition changedFilter = this.getSynchronizationFilter(session, now);
            if (changedFilter == null) {
                repository.setSynchronizationTimeStamp(JiraUtil.dateToString(now));
                return;
            }
            ArrayList<JiraIssue> issues = new ArrayList<JiraIssue>();
            JiraClient client = JiraClientFactory.getDefault().getJiraClient(repository);
            int maxResults = JiraUtil.getMaxSearchResults(repository);
            maxResults = maxResults <= 0 ? 500 : Math.min(500, maxResults);
            JiraIssueCollector issueCollector = new JiraIssueCollector((IProgressMonitor)new NullProgressMonitor(), issues, maxResults);
            try {
                client.search(changedFilter, issueCollector, monitor);
                if (issues.isEmpty()) {
                    repository.setSynchronizationTimeStamp(JiraUtil.dateToString(now));
                    session.setNeedsPerformQueries(false);
                    return;
                }
                HashMap<String, ITask> taskById = new HashMap<String, ITask>();
                for (ITask task : session.getTasks()) {
                    taskById.put(task.getTaskId(), task);
                }
                for (JiraIssue issue : issues) {
                    ITask task = (ITask)taskById.get(issue.getId());
                    if (task == null) continue;
                    if (issue.getProject() == null) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.internal.jira.core", 0, ERROR_REPOSITORY_CONFIGURATION, null));
                    }
                    monitor.subTask(String.valueOf(issue.getKey()) + " " + issue.getSummary());
                    if (!this.hasChanged(task, issue)) continue;
                    TaskData oldTaskData = null;
                    if (session.getTaskDataManager() != null) {
                        try {
                            oldTaskData = session.getTaskDataManager().getTaskData(repository, issue.getId());
                        }
                        catch (CoreException coreException) {}
                    }
                    TaskData taskData = this.taskDataHandler.createTaskData(repository, client, issue, oldTaskData, monitor);
                    session.putTaskData(task, taskData);
                }
                repository.setSynchronizationTimeStamp(JiraUtil.dateToString(now));
                Date lastUpdate = ((JiraIssue)issues.get(0)).getUpdated();
                Date repositoryUpdateTimeStamp = JiraUtil.getLastUpdate(repository);
                if (repositoryUpdateTimeStamp != null && repositoryUpdateTimeStamp.equals(lastUpdate)) {
                    session.setNeedsPerformQueries(false);
                    return;
                } else {
                    if (lastUpdate == null) return;
                    JiraUtil.setLastUpdate(repository, lastUpdate);
                }
                return;
            }
            catch (JiraException e) {
                IStatus status = JiraCorePlugin.toStatus(repository, e);
                this.trace(status);
                throw new CoreException(status);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void postSynchronization(ISynchronizationSession event, IProgressMonitor monitor) throws CoreException {
    }

    public FilterDefinition getSynchronizationFilter(ISynchronizationSession session, Date now) {
        Set tasks = session.getTasks();
        if (tasks.isEmpty()) {
            return null;
        }
        TaskRepository repository = session.getTaskRepository();
        Date lastSyncDate = JiraUtil.stringToDate(repository.getSynchronizationTimeStamp());
        if (lastSyncDate == null) {
            for (ITask task : tasks) {
                session.markStale(task);
            }
            return null;
        }
        long nowTime = now.getTime();
        long lastSyncTime = lastSyncDate.getTime();
        if (lastSyncTime >= nowTime) {
            this.trace((IStatus)new Status(2, "org.eclipse.mylyn.internal.jira.core", 0, "Synchronization time stamp clock skew detected for " + repository.getRepositoryUrl() + ": " + lastSyncTime + " >= " + now, null));
            lastSyncDate = null;
            for (ITask task : tasks) {
                Date date = task.getModificationDate();
                if (lastSyncDate != null && (date == null || !date.after(lastSyncDate))) continue;
                lastSyncDate = date;
            }
            if (lastSyncDate == null) {
                return null;
            }
            FilterDefinition changedFilter = new FilterDefinition();
            changedFilter.setUpdatedDateFilter(new DateRangeFilter(lastSyncDate, null));
            changedFilter.setOrdering(new Order[]{new Order(Order.Field.UPDATED, false)});
            return changedFilter;
        }
        FilterDefinition changedFilter = new FilterDefinition();
        long minutes = (now.getTime() - lastSyncDate.getTime()) / 60000L + 1L;
        changedFilter.setUpdatedDateFilter(new RelativeDateRangeFilter(RelativeDateRangeFilter.RangeType.MINUTE, -minutes));
        changedFilter.setOrdering(new Order[]{new Order(Order.Field.UPDATED, false)});
        return changedFilter;
    }

    public boolean canCreateNewTask(TaskRepository repository) {
        return true;
    }

    public String getRepositoryUrlFromTaskUrl(String url) {
        if (url == null) {
            return null;
        }
        int index = url.indexOf(ISSUE_URL_PREFIX);
        return index != -1 ? url.substring(0, index) : null;
    }

    public String getTaskIdFromTaskUrl(String url) {
        String taskId;
        if (url == null) {
            return null;
        }
        int index = url.indexOf(ISSUE_URL_PREFIX);
        if (index != -1 && (taskId = url.substring(index + ISSUE_URL_PREFIX.length())).contains("-")) {
            return taskId;
        }
        return null;
    }

    public String getTaskUrl(String repositoryUrl, String taskId) {
        return String.valueOf(repositoryUrl) + ISSUE_URL_PREFIX + taskId;
    }

    public String[] getTaskIdsFromComment(TaskRepository repository, String comment) {
        JiraClient client = JiraClientFactory.getDefault().getJiraClient(repository);
        Project[] projects = client.getCache().getProjects();
        if (projects != null && projects.length > 0) {
            StringBuilder sb = new StringBuilder("(");
            String sep = "";
            Project[] projectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                Project project = projectArray[n2];
                sb.append(sep).append("(?:" + project.getKey() + "\\-\\d+?)");
                sep = "|";
                ++n2;
            }
            sb.append(")(?:\\D|\\z)");
            Pattern p = Pattern.compile(sb.toString(), 42);
            Matcher m = p.matcher(comment);
            if (m.find()) {
                HashSet<String> ids = new HashSet<String>();
                do {
                    ids.add(m.group(1));
                } while (m.find());
                return ids.toArray(new String[ids.size()]);
            }
        }
        return super.getTaskIdsFromComment(repository, comment);
    }

    public static String getTaskUrlFromKey(String repositoryUrl, String key) {
        return String.valueOf(repositoryUrl) + ISSUE_URL_PREFIX + key;
    }

    public static boolean isCompleted(TaskData taskData) {
        if (JiraUtil.getCompletedBasedOnResolution(taskData.getAttributeMapper().getTaskRepository())) {
            TaskAttribute attribute = taskData.getRoot().getAttribute(JiraAttribute.RESOLUTION.id());
            return attribute != null && attribute.getValue().length() > 0;
        }
        TaskAttribute attribute = taskData.getRoot().getAttribute(JiraAttribute.STATUS.id());
        return attribute != null && (ID_STATUS_RESOLVED.equals(attribute.getValue()) || ID_STATUS_CLOSED.equals(attribute.getValue()));
    }

    public static boolean isClosed(JiraIssue issue) {
        return issue.getStatus() != null && ID_STATUS_CLOSED.equals(issue.getStatus().getId());
    }

    static ITask.PriorityLevel getPriorityLevel(String priorityId) {
        if ("1".equals(priorityId)) {
            return ITask.PriorityLevel.P1;
        }
        if ("2".equals(priorityId)) {
            return ITask.PriorityLevel.P2;
        }
        if ("3".equals(priorityId)) {
            return ITask.PriorityLevel.P3;
        }
        if ("4".equals(priorityId)) {
            return ITask.PriorityLevel.P4;
        }
        if (ID_STATUS_RESOLVED.equals(priorityId)) {
            return ITask.PriorityLevel.P5;
        }
        return ITask.PriorityLevel.getDefault();
    }

    public String toString() {
        return this.getLabel();
    }

    public void updateRepositoryConfiguration(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        try {
            JiraClient client = JiraClientFactory.getDefault().getJiraClient(repository);
            client.getCache().refreshDetails(monitor);
        }
        catch (JiraException e) {
            IStatus status = JiraCorePlugin.toStatus(repository, e);
            this.trace(status);
            throw new CoreException(status);
        }
    }

    public String getTaskIdPrefix() {
        return "issue";
    }

    public static String getAssigneeFromAttribute(String assignee) {
        return "".equals(assignee) ? UNASSIGNED_USER : assignee;
    }

    private void trace(IStatus status) {
        if (TRACE_ENABLED) {
            JiraCorePlugin.getDefault().getLog().log(status);
        }
    }

    public boolean isRepositoryConfigurationStale(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        return JiraUtil.getAutoRefreshConfiguration(repository);
    }

    public JiraTaskDataHandler getTaskDataHandler() {
        return this.taskDataHandler;
    }

    public boolean hasTaskChanged(TaskRepository taskRepository, ITask task, TaskData taskData) {
        JiraTaskMapper scheme = this.getTaskMapping(taskData);
        Date repositoryDate = scheme.getModificationDate();
        Date localDate = task.getModificationDate();
        return repositoryDate == null || !repositoryDate.equals(localDate);
    }

    private boolean hasChanged(ITask task, JiraIssue issue) {
        Date repositoryDate = issue.getUpdated();
        Date localDate = task.getModificationDate();
        return repositoryDate == null || !repositoryDate.equals(localDate);
    }

    public TaskData getTaskData(TaskRepository taskRepository, String taskId, IProgressMonitor monitor) throws CoreException {
        return this.taskDataHandler.getTaskData(taskRepository, taskId, monitor);
    }

    public void updateTaskFromTaskData(TaskRepository repository, ITask task, TaskData taskData) {
        JiraTaskMapper scheme = this.getTaskMapping(taskData);
        scheme.applyTo(task);
        task.setCompletionDate(scheme.getCompletionDate());
    }

    public JiraTaskAttachmentHandler getTaskAttachmentHandler() {
        return this.attachmentHandler;
    }

    public JiraTaskMapper getTaskMapping(TaskData taskData) {
        return new JiraTaskMapper(taskData);
    }

    public Collection<TaskRelation> getTaskRelations(TaskData taskData) {
        ArrayList<TaskRelation> relations = new ArrayList<TaskRelation>();
        TaskAttribute attribute = taskData.getRoot().getAttribute(JiraAttribute.SUBTASK_IDS.id());
        if (attribute != null) {
            for (String taskId : attribute.getValues()) {
                relations.add(TaskRelation.subtask((String)taskId));
            }
        }
        if (JiraUtil.getLinkedTasksAsSubtasks(taskData.getAttributeMapper().getTaskRepository()) && (attribute = taskData.getRoot().getAttribute(JiraAttribute.LINKED_IDS.id())) != null) {
            for (String taskId : attribute.getValues()) {
                relations.add(TaskRelation.subtask((String)taskId));
            }
        }
        return relations;
    }

    public boolean hasRepositoryDueDate(TaskRepository taskRepository, ITask task, TaskData taskData) {
        return taskData.getRoot().getMappedAttribute(JiraAttribute.DUE_DATE.id()) != null;
    }

    private class QueryHitCollector
    implements IssueCollector {
        private final IProgressMonitor monitor;
        private final ISynchronizationSession session;
        private final JiraClient client;
        private final TaskRepository repository;
        private final TaskDataCollector collector;
        private final int maxHits;
        private List<IStatus> statuses;

        public QueryHitCollector(TaskRepository repository, JiraClient client, TaskDataCollector collector, ISynchronizationSession session, IProgressMonitor monitor) {
            this.repository = repository;
            this.client = client;
            this.collector = collector;
            this.session = session;
            this.monitor = monitor;
            this.maxHits = JiraUtil.getMaxSearchResults(repository);
        }

        public void collectIssue(JiraIssue issue) {
            if (issue.getProject() == null) {
                this.addStatus((IStatus)new Status(4, "org.eclipse.mylyn.internal.jira.core", 0, JiraRepositoryConnector.ERROR_REPOSITORY_CONFIGURATION, null));
                return;
            }
            this.monitor.subTask("Retrieving issue " + issue.getKey() + " " + issue.getSummary());
            TaskData oldTaskData = null;
            if (this.session != null) {
                try {
                    oldTaskData = this.session.getTaskDataManager().getTaskData(this.repository, issue.getId());
                }
                catch (CoreException coreException) {}
            }
            try {
                TaskData taskData = JiraRepositoryConnector.this.taskDataHandler.createTaskData(this.repository, this.client, issue, oldTaskData, this.monitor);
                this.collector.accept(taskData);
            }
            catch (JiraException e) {
                this.addStatus(JiraCorePlugin.toStatus(this.repository, e));
            }
        }

        private void addStatus(IStatus status) {
            if (this.statuses == null) {
                this.statuses = new ArrayList<IStatus>();
            }
            this.statuses.add(status);
        }

        public void done() {
        }

        public int getMaxHits() {
            return this.maxHits;
        }

        public IStatus getStatus() {
            return this.statuses != null ? this.statuses.get(0) : Status.OK_STATUS;
        }

        public boolean isCancelled() {
            return this.monitor.isCanceled();
        }

        public void start() {
        }
    }
}

