/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service;

import java.io.File;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.jira.core.model.Attachment;
import org.eclipse.mylyn.internal.jira.core.model.Component;
import org.eclipse.mylyn.internal.jira.core.model.CustomField;
import org.eclipse.mylyn.internal.jira.core.model.IssueType;
import org.eclipse.mylyn.internal.jira.core.model.JiraAction;
import org.eclipse.mylyn.internal.jira.core.model.JiraConfiguration;
import org.eclipse.mylyn.internal.jira.core.model.JiraField;
import org.eclipse.mylyn.internal.jira.core.model.JiraFilter;
import org.eclipse.mylyn.internal.jira.core.model.JiraIssue;
import org.eclipse.mylyn.internal.jira.core.model.JiraStatus;
import org.eclipse.mylyn.internal.jira.core.model.JiraVersion;
import org.eclipse.mylyn.internal.jira.core.model.NamedFilter;
import org.eclipse.mylyn.internal.jira.core.model.Priority;
import org.eclipse.mylyn.internal.jira.core.model.Project;
import org.eclipse.mylyn.internal.jira.core.model.Resolution;
import org.eclipse.mylyn.internal.jira.core.model.ServerInfo;
import org.eclipse.mylyn.internal.jira.core.model.Version;
import org.eclipse.mylyn.internal.jira.core.model.WebServerInfo;
import org.eclipse.mylyn.internal.jira.core.model.filter.FilterDefinition;
import org.eclipse.mylyn.internal.jira.core.model.filter.IssueCollector;
import org.eclipse.mylyn.internal.jira.core.model.filter.SingleIssueCollector;
import org.eclipse.mylyn.internal.jira.core.model.filter.TextFilter;
import org.eclipse.mylyn.internal.jira.core.service.JiraClientCache;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.service.soap.JiraSoapClient;
import org.eclipse.mylyn.internal.jira.core.service.web.JiraWebClient;
import org.eclipse.mylyn.internal.jira.core.service.web.rss.JiraRssClient;

public class JiraClient {
    public static final int ASSIGNEE_CURRENT = 2;
    public static final int ASSIGNEE_DEFAULT = 1;
    public static final int ASSIGNEE_NONE = 3;
    public static final int ASSIGNEE_SELF = 5;
    public static final int ASSIGNEE_USER = 4;
    public static final String DEFAULT_CHARSET = "UTF-8";
    private boolean attemptedToDetermineCharacterEncoding;
    private final String baseUrl;
    private final JiraClientCache cache;
    private final JiraRssClient rssClient;
    private final JiraWebClient webClient;
    private final AbstractWebLocation location;
    private final JiraSoapClient soapClient;
    private final JiraConfiguration configuration;

    public JiraClient(AbstractWebLocation location, JiraConfiguration configuration) {
        Assert.isNotNull((Object)location);
        Assert.isNotNull((Object)configuration);
        this.baseUrl = location.getUrl();
        this.location = location;
        this.configuration = configuration;
        this.cache = new JiraClientCache(this);
        this.rssClient = new JiraRssClient(this);
        this.webClient = new JiraWebClient(this);
        this.soapClient = new JiraSoapClient(this);
    }

    public JiraClient(AbstractWebLocation location) {
        this(location, new JiraConfiguration());
    }

    public void addCommentToIssue(JiraIssue issue, String comment, IProgressMonitor monitor) throws JiraException {
        this.webClient.addCommentToIssue(issue, comment, monitor);
    }

    public void advanceIssueWorkflow(JiraIssue issue, String actionKey, String comment, IProgressMonitor monitor) throws JiraException {
        String[] fields = this.getActionFields(issue.getKey(), actionKey, monitor);
        this.webClient.advanceIssueWorkflow(issue, actionKey, comment, fields, monitor);
    }

    public void assignIssueTo(JiraIssue issue, int assigneeType, String user, String comment, IProgressMonitor monitor) throws JiraException {
        this.webClient.assignIssueTo(issue, assigneeType, user, comment, monitor);
    }

    public void addAttachment(JiraIssue issue, String comment, PartSource partSource, String contentType, IProgressMonitor monitor) throws JiraException {
        this.webClient.attachFile(issue, comment, partSource, contentType, monitor);
    }

    public void addAttachment(JiraIssue issue, String comment, String filename, byte[] contents, String contentType, IProgressMonitor monitor) throws JiraException {
        this.webClient.attachFile(issue, comment, filename, contents, contentType, monitor);
    }

    public void addAttachment(JiraIssue issue, String comment, String filename, File file, String contentType, IProgressMonitor monitor) throws JiraException {
        this.webClient.attachFile(issue, comment, filename, file, contentType, monitor);
    }

    public JiraIssue createIssue(JiraIssue issue, IProgressMonitor monitor) throws JiraException {
        String issueKey = this.webClient.createIssue(issue, monitor);
        return this.getIssueByKey(issueKey, monitor);
    }

    public JiraIssue createSubTask(JiraIssue issue, IProgressMonitor monitor) throws JiraException {
        String issueKey = this.webClient.createSubTask(issue, monitor);
        return this.getIssueByKey(issueKey, monitor);
    }

    public void deleteIssue(JiraIssue issue, IProgressMonitor monitor) throws JiraException {
        this.webClient.deleteIssue(issue, monitor);
    }

    public boolean equals(Object obj) {
        if (obj instanceof JiraClient) {
            return this.getBaseUrl().equals(((JiraClient)obj).getBaseUrl());
        }
        return false;
    }

    public void executeNamedFilter(NamedFilter filter, IssueCollector collector, IProgressMonitor monitor) throws JiraException {
        this.rssClient.executeNamedFilter(filter, collector, monitor);
    }

    public void findIssues(FilterDefinition filterDefinition, IssueCollector collector, IProgressMonitor monitor) throws JiraException {
        this.rssClient.findIssues(filterDefinition, collector, monitor);
    }

    public String[] getActionFields(String issueKey, String actionId, IProgressMonitor monitor) throws JiraException {
        return this.soapClient.getActionFields(issueKey, actionId, monitor);
    }

    public JiraAction[] getAvailableActions(String issueKey, IProgressMonitor monitor) throws JiraException {
        return this.soapClient.getAvailableActions(issueKey, monitor);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public JiraClientCache getCache() {
        return this.cache;
    }

    public String getCharacterEncoding() throws JiraException {
        if (this.configuration.getCharacterEncoding() == null) {
            String serverEncoding = this.getCache().getServerInfo().getCharacterEncoding();
            if (serverEncoding != null) {
                return serverEncoding;
            }
            if (!this.attemptedToDetermineCharacterEncoding) {
                this.getCache().refreshServerInfo((IProgressMonitor)new NullProgressMonitor());
                serverEncoding = this.getCache().getServerInfo().getCharacterEncoding();
                if (serverEncoding != null) {
                    return serverEncoding;
                }
            }
            return DEFAULT_CHARSET;
        }
        return this.configuration.getCharacterEncoding();
    }

    public Component[] getComponents(String projectKey, IProgressMonitor monitor) throws JiraException {
        return this.soapClient.getComponents(projectKey, monitor);
    }

    public JiraConfiguration getConfiguration() {
        return this.configuration;
    }

    public CustomField[] getCustomAttributes(IProgressMonitor monitor) throws JiraException {
        return this.soapClient.getCustomAttributes(monitor);
    }

    public JiraField[] getEditableAttributes(String issueKey, IProgressMonitor monitor) throws JiraException {
        String version = this.getCache().getServerInfo().getVersion();
        boolean workAround = new JiraVersion(version).compareTo(JiraVersion.JIRA_3_12) < 0;
        return this.soapClient.getEditableAttributes(issueKey, workAround, monitor);
    }

    public JiraIssue getIssueByKey(String issueKey, IProgressMonitor monitor) throws JiraException {
        SingleIssueCollector collector = new SingleIssueCollector();
        this.rssClient.getIssueByKey(issueKey, collector, monitor);
        if (collector.getIssue() != null && collector.getIssue().getProject() == null) {
            throw new JiraException("Repository returned an unknown project for issue '" + collector.getIssue().getKey() + "'");
        }
        return collector.getIssue();
    }

    public IssueType[] getIssueTypes(IProgressMonitor monitor) throws JiraException {
        return this.soapClient.getIssueTypes(monitor);
    }

    public String getKeyFromId(String issueId, IProgressMonitor monitor) throws JiraException {
        return this.soapClient.getKeyFromId(issueId, monitor);
    }

    public AbstractWebLocation getLocation() {
        return this.location;
    }

    public NamedFilter[] getNamedFilters(IProgressMonitor monitor) throws JiraException {
        return this.soapClient.getNamedFilters(monitor);
    }

    public Priority[] getPriorities(IProgressMonitor monitor) throws JiraException {
        return this.soapClient.getPriorities(monitor);
    }

    public Project[] getProjects(IProgressMonitor monitor) throws JiraException {
        String version = this.getCache().getServerInfo().getVersion();
        if (new JiraVersion(version).compareTo(JiraVersion.JIRA_3_4) >= 0) {
            return this.soapClient.getProjectsNoSchemes(monitor);
        }
        return this.soapClient.getProjects(monitor);
    }

    public Resolution[] getResolutions(IProgressMonitor monitor) throws JiraException {
        return this.soapClient.getResolutions(monitor);
    }

    public ServerInfo getServerInfo(IProgressMonitor monitor) throws JiraException {
        ServerInfo serverInfo = this.soapClient.getServerInfo(monitor);
        WebServerInfo webServerInfo = this.webClient.getWebServerInfo(monitor);
        serverInfo.setCharacterEncoding(webServerInfo.getCharacterEncoding());
        serverInfo.setWebBaseUrl(webServerInfo.getBaseUrl());
        return serverInfo;
    }

    public JiraSoapClient getSoapClient() {
        return this.soapClient;
    }

    public JiraStatus[] getStatuses(IProgressMonitor monitor) throws JiraException {
        return this.soapClient.getStatuses(monitor);
    }

    public IssueType[] getSubTaskIssueTypes(IProgressMonitor monitor) throws JiraException {
        return this.soapClient.getSubTaskIssueTypes(monitor);
    }

    public String getUserName() {
        AuthenticationCredentials credentials = this.location.getCredentials(AuthenticationType.REPOSITORY);
        return credentials != null ? credentials.getUserName() : "";
    }

    public Version[] getVersions(String key, IProgressMonitor monitor) throws JiraException {
        return this.soapClient.getVersions(key, monitor);
    }

    public int hashCode() {
        return this.getBaseUrl().hashCode();
    }

    public void login(IProgressMonitor monitor) throws JiraException {
        this.soapClient.login(monitor);
    }

    public void logout(IProgressMonitor monitor) throws JiraException {
        this.soapClient.logout(monitor);
    }

    public void quickSearch(String searchString, IssueCollector collector, IProgressMonitor monitor) throws JiraException {
        this.rssClient.quickSearch(searchString, collector, monitor);
    }

    public byte[] getAttachment(JiraIssue issue, Attachment attachment, IProgressMonitor monitor) throws JiraException {
        byte[] result = new byte[(int)attachment.getSize()];
        this.webClient.retrieveFile(issue, attachment, result, monitor);
        return result;
    }

    public void getAttachment(JiraIssue issue, Attachment attachment, OutputStream out, IProgressMonitor monitor) throws JiraException {
        this.webClient.retrieveFile(issue, attachment, out, monitor);
    }

    public void search(JiraFilter query, IssueCollector collector, IProgressMonitor monitor) throws JiraException {
        if (query instanceof TextFilter) {
            this.quickSearch(((TextFilter)query).getKeywords(), collector, monitor);
        } else if (query instanceof FilterDefinition) {
            this.findIssues((FilterDefinition)query, collector, monitor);
        } else if (query instanceof NamedFilter) {
            this.executeNamedFilter((NamedFilter)query, collector, monitor);
        } else {
            throw new IllegalArgumentException("Unknown query type: " + query.getClass());
        }
    }

    public String toString() {
        return this.getBaseUrl();
    }

    public void unvoteIssue(JiraIssue issue, IProgressMonitor monitor) throws JiraException {
        this.webClient.unvoteIssue(issue, monitor);
    }

    public void unwatchIssue(JiraIssue issue, IProgressMonitor monitor) throws JiraException {
        this.webClient.unwatchIssue(issue, monitor);
    }

    public void updateIssue(JiraIssue issue, String comment, IProgressMonitor monitor) throws JiraException {
        this.webClient.updateIssue(issue, comment, monitor);
    }

    public boolean useCompression() {
        return this.configuration.isCompressionEnabled();
    }

    public void voteIssue(JiraIssue issue, IProgressMonitor monitor) throws JiraException {
        this.webClient.voteIssue(issue, monitor);
    }

    public void watchIssue(JiraIssue issue, IProgressMonitor monitor) throws JiraException {
        this.webClient.watchIssue(issue, monitor);
    }
}

