/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.jira.core.model.IssueType;
import org.eclipse.mylyn.internal.jira.core.model.JiraStatus;
import org.eclipse.mylyn.internal.jira.core.model.JiraVersion;
import org.eclipse.mylyn.internal.jira.core.model.Priority;
import org.eclipse.mylyn.internal.jira.core.model.Project;
import org.eclipse.mylyn.internal.jira.core.model.Resolution;
import org.eclipse.mylyn.internal.jira.core.model.ServerInfo;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraClientData;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;

public class JiraClientCache {
    private volatile JiraClientData data;
    private final JiraClient jiraClient;

    public JiraClientCache(JiraClient jiraClient) {
        this.jiraClient = jiraClient;
        this.data = new JiraClientData();
    }

    public JiraStatus getStatusById(String id) {
        return this.data.statusesById.get(id);
    }

    public JiraStatus[] getStatuses() {
        return this.data.statuses;
    }

    public IssueType getIssueTypeById(String id) {
        return this.data.issueTypesById.get(id);
    }

    public IssueType[] getIssueTypes() {
        return this.data.issueTypes;
    }

    public boolean hasDetails() {
        return this.data.lastUpdate != 0L;
    }

    private void initializeProjects(JiraClientData data, IProgressMonitor monitor) throws JiraException {
        data.projects = this.jiraClient.getProjects(monitor);
        data.projectsById = new HashMap<String, Project>(data.projects.length);
        data.projectsByKey = new HashMap<String, Project>(data.projects.length);
        Project[] projectArray = data.projects;
        int n = data.projects.length;
        int n2 = 0;
        while (n2 < n) {
            Project project = projectArray[n2];
            project.setComponents(this.jiraClient.getComponents(project.getKey(), monitor));
            project.setVersions(this.jiraClient.getVersions(project.getKey(), monitor));
            data.projectsById.put(project.getId(), project);
            data.projectsByKey.put(project.getKey(), project);
            ++n2;
        }
    }

    public Project getProjectById(String id) {
        return this.data.projectsById.get(id);
    }

    public Project getProjectByKey(String key) {
        return this.data.projectsByKey.get(key);
    }

    public Project[] getProjects() {
        return this.data.projects;
    }

    private void initializePriorities(JiraClientData data, IProgressMonitor monitor) throws JiraException {
        data.priorities = this.jiraClient.getPriorities(monitor);
        data.prioritiesById = new HashMap<String, Priority>(data.priorities.length);
        Priority[] priorityArray = data.priorities;
        int n = data.priorities.length;
        int n2 = 0;
        while (n2 < n) {
            Priority priority = priorityArray[n2];
            data.prioritiesById.put(priority.getId(), priority);
            ++n2;
        }
    }

    public Priority getPriorityById(String id) {
        return this.data.prioritiesById.get(id);
    }

    public Priority[] getPriorities() {
        return this.data.priorities;
    }

    private void initializeIssueTypes(JiraClientData data, IProgressMonitor monitor) throws JiraException {
        IssueType issueType;
        IssueType[] issueTypes = this.jiraClient.getIssueTypes(monitor);
        String version = data.serverInfo.getVersion();
        IssueType[] subTaskIssueTypes = new JiraVersion(version).compareTo(JiraVersion.JIRA_3_3) >= 0 ? this.jiraClient.getSubTaskIssueTypes(monitor) : new IssueType[]{};
        data.issueTypesById = new HashMap<String, IssueType>(issueTypes.length + subTaskIssueTypes.length);
        IssueType[] issueTypeArray = issueTypes;
        int n = issueTypes.length;
        int n2 = 0;
        while (n2 < n) {
            issueType = issueTypeArray[n2];
            data.issueTypesById.put(issueType.getId(), issueType);
            ++n2;
        }
        issueTypeArray = subTaskIssueTypes;
        n = subTaskIssueTypes.length;
        n2 = 0;
        while (n2 < n) {
            issueType = issueTypeArray[n2];
            issueType.setSubTaskType(true);
            data.issueTypesById.put(issueType.getId(), issueType);
            ++n2;
        }
        data.issueTypes = new IssueType[issueTypes.length + subTaskIssueTypes.length];
        System.arraycopy(issueTypes, 0, data.issueTypes, 0, issueTypes.length);
        System.arraycopy(subTaskIssueTypes, 0, data.issueTypes, issueTypes.length, subTaskIssueTypes.length);
    }

    private void initializeStatuses(JiraClientData data, IProgressMonitor monitor) throws JiraException {
        data.statuses = this.jiraClient.getStatuses(monitor);
        data.statusesById = new HashMap<String, JiraStatus>(data.statuses.length);
        JiraStatus[] jiraStatusArray = data.statuses;
        int n = data.statuses.length;
        int n2 = 0;
        while (n2 < n) {
            JiraStatus status = jiraStatusArray[n2];
            data.statusesById.put(status.getId(), status);
            ++n2;
        }
    }

    private void initializeResolutions(JiraClientData data, IProgressMonitor monitor) throws JiraException {
        data.resolutions = this.jiraClient.getResolutions(monitor);
        data.resolutionsById = new HashMap<String, Resolution>(data.resolutions.length);
        Resolution[] resolutionArray = data.resolutions;
        int n = data.resolutions.length;
        int n2 = 0;
        while (n2 < n) {
            Resolution resolution = resolutionArray[n2];
            data.resolutionsById.put(resolution.getId(), resolution);
            ++n2;
        }
    }

    public Resolution getResolutionById(String id) {
        return this.data.resolutionsById.get(id);
    }

    public Resolution[] getResolutions() {
        return this.data.resolutions;
    }

    public void setData(JiraClientData data) {
        this.data = data;
    }

    public JiraClientData getData() {
        return this.data;
    }

    public synchronized void refreshDetails(IProgressMonitor monitor) throws JiraException {
        try {
            monitor = Policy.monitorFor((IProgressMonitor)monitor);
            monitor.beginTask("Updating repository configuration", -1);
            JiraClientData newData = new JiraClientData();
            this.data.serverInfo = newData.serverInfo = this.jiraClient.getServerInfo(monitor);
            Policy.advance((IProgressMonitor)monitor, (int)1);
            this.initializeProjects(newData, monitor);
            Policy.advance((IProgressMonitor)monitor, (int)1);
            this.initializePriorities(newData, monitor);
            Policy.advance((IProgressMonitor)monitor, (int)1);
            this.initializeIssueTypes(newData, monitor);
            Policy.advance((IProgressMonitor)monitor, (int)1);
            this.initializeResolutions(newData, monitor);
            Policy.advance((IProgressMonitor)monitor, (int)1);
            this.initializeStatuses(newData, monitor);
            Policy.advance((IProgressMonitor)monitor, (int)1);
            newData.lastUpdate = System.currentTimeMillis();
            this.data = newData;
        }
        finally {
            monitor.done();
        }
    }

    public synchronized void refreshServerInfo(IProgressMonitor monitor) throws JiraException {
        try {
            monitor.beginTask("Getting server information", -1);
            this.data.serverInfo = this.jiraClient.getServerInfo(monitor);
        }
        finally {
            monitor.done();
        }
    }

    public ServerInfo getServerInfo() throws JiraException {
        ServerInfo info = this.data.serverInfo;
        if (info == null) {
            info = this.jiraClient.getServerInfo(null);
        }
        this.data.serverInfo = info;
        return info;
    }
}

