/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service.web.rss;

import java.text.SimpleDateFormat;
import java.util.Locale;
import org.eclipse.mylyn.internal.jira.core.model.Component;
import org.eclipse.mylyn.internal.jira.core.model.IssueType;
import org.eclipse.mylyn.internal.jira.core.model.JiraStatus;
import org.eclipse.mylyn.internal.jira.core.model.Priority;
import org.eclipse.mylyn.internal.jira.core.model.Resolution;
import org.eclipse.mylyn.internal.jira.core.model.Version;
import org.eclipse.mylyn.internal.jira.core.model.filter.ComponentFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.ContentFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.CurrentUserFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.DateFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.DateRangeFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.EstimateVsActualFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.FilterDefinition;
import org.eclipse.mylyn.internal.jira.core.model.filter.IssueTypeFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.NobodyFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.Order;
import org.eclipse.mylyn.internal.jira.core.model.filter.PriorityFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.ProjectFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.RelativeDateRangeFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.ResolutionFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.SpecificUserFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.StatusFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.UserFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.UserInGroupFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.VersionFilter;
import org.eclipse.mylyn.internal.jira.core.util.JiraUtil;

public class JiraRssFilterConverter {
    private final String DATE_FORMAT = "dd/MMM/yy";

    public String convert(FilterDefinition filterDefinition, String encoding) {
        StringBuilder buffer = new StringBuilder();
        if (filterDefinition.getProjectFilter() != null) {
            String versionFilterString;
            buffer.append('&').append(this.convertProjectFilter(filterDefinition.getProjectFilter()));
            if (filterDefinition.getComponentFilter() != null) {
                buffer.append('&').append(this.convertComponentFilter(filterDefinition.getComponentFilter()));
            }
            if (filterDefinition.getFixForVersionFilter() != null && (versionFilterString = this.convertVersionFilter("fixfor", filterDefinition.getFixForVersionFilter())).length() > 0) {
                buffer.append('&').append(versionFilterString);
            }
            if (filterDefinition.getReportedInVersionFilter() != null && (versionFilterString = this.convertVersionFilter("version", filterDefinition.getReportedInVersionFilter())).length() > 0) {
                buffer.append('&').append(versionFilterString);
            }
        }
        if (filterDefinition.getContentFilter() != null) {
            buffer.append('&').append(this.convertContentFilter(filterDefinition.getContentFilter(), encoding));
        }
        if (filterDefinition.getIssueTypeFilter() != null) {
            buffer.append('&').append(this.convertIssueTypeFilter(filterDefinition.getIssueTypeFilter()));
        }
        if (filterDefinition.getAssignedToFilter() != null) {
            buffer.append('&').append(this.convertAssignedToFilter(filterDefinition.getAssignedToFilter()));
        }
        if (filterDefinition.getPriorityFilter() != null) {
            buffer.append('&').append(this.convertPriorityFilter(filterDefinition.getPriorityFilter()));
        }
        if (filterDefinition.getStatusFilter() != null) {
            buffer.append('&').append(this.convertStatusFilter(filterDefinition.getStatusFilter()));
        }
        if (filterDefinition.getResolutionFilter() != null) {
            buffer.append('&').append(this.convertResolutionFilter(filterDefinition.getResolutionFilter()));
        }
        if (filterDefinition.getReportedByFilter() != null) {
            buffer.append('&').append(this.convertReportedByFilter(filterDefinition.getReportedByFilter()));
        }
        if (filterDefinition.getEstimateVsActualFilter() != null) {
            buffer.append('&').append(this.convertEstimateVsActualFilter(filterDefinition.getEstimateVsActualFilter()));
        }
        if (filterDefinition.getCreatedDateFilter() != null) {
            buffer.append(this.convertCreatedDateFilter(filterDefinition.getCreatedDateFilter()));
        }
        if (filterDefinition.getUpdatedDateFilter() != null) {
            buffer.append(this.convertUpdatedDateFilter(filterDefinition.getUpdatedDateFilter()));
        }
        if (filterDefinition.getDueDateFilter() != null) {
            buffer.append(this.convertDueDateFilter(filterDefinition.getDueDateFilter()));
        }
        if (filterDefinition.getOrdering() != null) {
            buffer.append(this.convertOrdering(filterDefinition.getOrdering()));
        }
        if (buffer.length() > 0) {
            return buffer.substring(1);
        }
        return "";
    }

    protected String convertAssignedToFilter(UserFilter assignedToFilter) {
        StringBuilder buffer = new StringBuilder();
        if (assignedToFilter instanceof NobodyFilter) {
            buffer.append("assigneeSelect=unassigned");
        } else if (assignedToFilter instanceof SpecificUserFilter) {
            buffer.append("assigneeSelect=specificuser&assignee=").append(((SpecificUserFilter)assignedToFilter).getUser());
        } else if (assignedToFilter instanceof UserInGroupFilter) {
            buffer.append("assigneeSelect=specificgroup&assignee=").append(((UserInGroupFilter)assignedToFilter).getGroup());
        } else if (assignedToFilter instanceof CurrentUserFilter) {
            return "assigneeSelect=issue_current_user";
        }
        return buffer.toString();
    }

    protected String convertComponentFilter(ComponentFilter componentFilter) {
        if (componentFilter.hasNoComponent()) {
            return "component=-1";
        }
        StringBuilder buffer = new StringBuilder();
        Component[] components = componentFilter.getComponents();
        if (components.length == 0) {
            return "";
        }
        buffer.append("component=").append(components[0].getId());
        int i = 1;
        while (i < components.length) {
            buffer.append("&component=").append(components[i].getId());
            ++i;
        }
        return buffer.toString();
    }

    protected String convertContentFilter(ContentFilter contentFilter, String encoding) {
        return "query=" + JiraUtil.encode(contentFilter.getQueryString(), encoding) + "&summary=" + contentFilter.isSearchingSummary() + "&description=" + contentFilter.isSearchingDescription() + "&body=" + contentFilter.isSearchingComments() + "&environment=" + contentFilter.isSearchingEnvironment();
    }

    protected String convertCreatedDateFilter(DateFilter createdDateFilter) {
        return this.createDateFilter(createdDateFilter, "created");
    }

    protected String convertDueDateFilter(DateFilter dueDateFilter) {
        return this.createDateFilter(dueDateFilter, "duedate");
    }

    protected String convertEstimateVsActualFilter(EstimateVsActualFilter filter) {
        StringBuilder buffer = new StringBuilder();
        float min = filter.getMinVariation();
        float max = filter.getMaxVariation();
        if (min != 0.0f) {
            buffer.append("minRatioLimit=").append(min);
        }
        if (max != 0.0f) {
            if (buffer.length() > 0) {
                buffer.append('&');
            }
            buffer.append("maxRatioLimit=").append(max);
        }
        return buffer.toString();
    }

    protected String convertIssueTypeFilter(IssueTypeFilter issueTypeFilter) {
        StringBuilder buffer = new StringBuilder();
        if (issueTypeFilter.isStandardTypes()) {
            buffer.append("type=").append("-2");
        } else if (issueTypeFilter.isSubTaskTypes()) {
            buffer.append("type=").append("-3");
        } else if (issueTypeFilter.getIsueTypes() != null) {
            IssueType[] issueTypes = issueTypeFilter.getIsueTypes();
            if (issueTypes.length == 0) {
                return "";
            }
            buffer.append("type=").append(issueTypes[0].getId());
            int i = 1;
            while (i < issueTypes.length) {
                buffer.append('&').append("type=").append(issueTypes[i].getId());
                ++i;
            }
        }
        return buffer.toString();
    }

    protected String convertOrdering(Order[] ordering) {
        StringBuilder buffer = new StringBuilder();
        Order[] orderArray = ordering;
        int n = ordering.length;
        int n2 = 0;
        while (n2 < n) {
            Order order = orderArray[n2];
            String fieldName = this.getNameFromField(order.getField());
            if (fieldName != null) {
                buffer.append("&sorter/field=").append(fieldName).append("&sorter/order=").append(order.isAscending() ? "ASC" : "DESC");
            }
            ++n2;
        }
        return buffer.toString();
    }

    protected String convertPriorityFilter(PriorityFilter priorityFilter) {
        Priority[] priorities = priorityFilter.getPriorities();
        if (priorities.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("priority=").append(priorities[0].getId());
        int i = 1;
        while (i < priorities.length) {
            buffer.append("&priority=").append(priorities[i].getId());
            ++i;
        }
        return buffer.toString();
    }

    protected String convertProjectFilter(ProjectFilter projectFilter) {
        return "pid=" + projectFilter.getProject().getId();
    }

    protected String convertReportedByFilter(UserFilter reportedByFilter) {
        StringBuilder buffer = new StringBuilder();
        if (reportedByFilter instanceof NobodyFilter) {
            return "reporterSelect=unassigned";
        }
        if (reportedByFilter instanceof SpecificUserFilter) {
            buffer.append("reporterSelect=specificuser&reporter=").append(((SpecificUserFilter)reportedByFilter).getUser());
        } else if (reportedByFilter instanceof UserInGroupFilter) {
            buffer.append("reporterSelect=specificgroup&reporter=").append(((UserInGroupFilter)reportedByFilter).getGroup());
        } else if (reportedByFilter instanceof CurrentUserFilter) {
            return "reporterSelect=issue_current_user";
        }
        return buffer.toString();
    }

    protected String convertResolutionFilter(ResolutionFilter resolutionFilter) {
        if (resolutionFilter.isUnresolved()) {
            return "resolution=-1";
        }
        Resolution[] resolution = resolutionFilter.getResolutions();
        if (resolution.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("resolution=").append(resolution[0].getId());
        int i = 1;
        while (i < resolution.length) {
            buffer.append("&resolution=").append(resolution[i].getId());
            ++i;
        }
        return buffer.toString();
    }

    protected String convertStatusFilter(StatusFilter statusFilter) {
        JiraStatus[] statuses = statusFilter.getStatuses();
        if (statuses.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("status=").append(statuses[0].getId());
        int i = 1;
        while (i < statuses.length) {
            buffer.append("&status=").append(statuses[i].getId());
            ++i;
        }
        return buffer.toString();
    }

    protected String convertUpdatedDateFilter(DateFilter updatedDateFilter) {
        return this.createDateFilter(updatedDateFilter, "updated");
    }

    protected String convertVersionFilter(String param, VersionFilter versionFilter) {
        if (versionFilter.isReleasedVersions() && versionFilter.isUnreleasedVersions()) {
            return "";
        }
        if (versionFilter.hasNoVersion()) {
            return String.valueOf(param) + "=-1";
        }
        if (versionFilter.isUnreleasedVersions()) {
            return String.valueOf(param) + "=-2";
        }
        if (versionFilter.isReleasedVersions()) {
            return String.valueOf(param) + "=-3";
        }
        StringBuilder buffer = new StringBuilder();
        Version[] versions = versionFilter.getVersions();
        if (versions.length == 0) {
            return "";
        }
        buffer.append(param).append("=").append(versions[0].getId());
        int i = 1;
        while (i < versions.length) {
            buffer.append("&").append(param).append("=").append(versions[i].getId());
            ++i;
        }
        return buffer.toString();
    }

    private String createDateFilter(DateFilter dateFilter, String name) {
        StringBuilder buffer = new StringBuilder();
        if (dateFilter instanceof DateRangeFilter) {
            SimpleDateFormat df = new SimpleDateFormat("dd/MMM/yy", Locale.US);
            DateRangeFilter filter = (DateRangeFilter)dateFilter;
            if (filter.getFromDate() != null) {
                buffer.append("&" + name + ":after=").append(df.format(filter.getFromDate()));
            }
            if (filter.getToDate() != null) {
                buffer.append("&" + name + ":before=").append(df.format(filter.getToDate()));
            }
        } else if (dateFilter instanceof RelativeDateRangeFilter) {
            RelativeDateRangeFilter filter = (RelativeDateRangeFilter)dateFilter;
            if (filter.previousMilliseconds() != 0L) {
                buffer.append("&" + name + ":previous=").append(this.createRelativeDateString(filter.getPreviousRangeType(), filter.getPreviousCount()));
            }
            if (filter.nextMilliseconds() != 0L) {
                buffer.append("&" + name + ":next=").append(this.createRelativeDateString(filter.getNextRangeType(), filter.getNextCount()));
            }
        }
        return buffer.toString();
    }

    private String createRelativeDateString(RelativeDateRangeFilter.RangeType rangeType, long count) {
        StringBuilder dateString = new StringBuilder("");
        dateString.append(Long.toString(count));
        if (RelativeDateRangeFilter.RangeType.MINUTE.equals(rangeType)) {
            dateString.append('m');
        } else if (RelativeDateRangeFilter.RangeType.HOUR.equals(rangeType)) {
            dateString.append('h');
        } else if (RelativeDateRangeFilter.RangeType.DAY.equals(rangeType)) {
            dateString.append('d');
        } else if (RelativeDateRangeFilter.RangeType.WEEK.equals(rangeType)) {
            dateString.append('w');
        }
        return dateString.toString();
    }

    protected String getNameFromField(Order.Field field) {
        if (Order.Field.ISSUE_TYPE == field) {
            return "issuetype";
        }
        if (Order.Field.ISSUE_KEY == field) {
            return "issuekey";
        }
        if (Order.Field.SUMMARY == field) {
            return "summary";
        }
        if (Order.Field.ASSIGNEE == field) {
            return "assignee";
        }
        if (Order.Field.REPORTER == field) {
            return "reporter";
        }
        if (Order.Field.PRIORITY == field) {
            return "priority";
        }
        if (Order.Field.STATUS == field) {
            return "status";
        }
        if (Order.Field.RESOLUTION == field) {
            return "resolution";
        }
        if (Order.Field.CREATED == field) {
            return "created";
        }
        if (Order.Field.UPDATED == field) {
            return "updated";
        }
        if (Order.Field.DUE_DATE == field) {
            return "duedate";
        }
        return null;
    }
}

