/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.util;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.mylyn.internal.jira.core.InvalidJiraQueryException;
import org.eclipse.mylyn.internal.jira.core.model.Component;
import org.eclipse.mylyn.internal.jira.core.model.IssueType;
import org.eclipse.mylyn.internal.jira.core.model.JiraStatus;
import org.eclipse.mylyn.internal.jira.core.model.Priority;
import org.eclipse.mylyn.internal.jira.core.model.Project;
import org.eclipse.mylyn.internal.jira.core.model.Resolution;
import org.eclipse.mylyn.internal.jira.core.model.Version;
import org.eclipse.mylyn.internal.jira.core.model.filter.ComponentFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.ContentFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.CurrentUserFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.DateFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.DateRangeFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.FilterDefinition;
import org.eclipse.mylyn.internal.jira.core.model.filter.IssueTypeFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.NobodyFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.PriorityFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.ProjectFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.ResolutionFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.SpecificUserFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.StatusFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.UserFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.UserInGroupFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.VersionFilter;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterDefinitionConverter {
    private static final String PROJECT_KEY = "pid";
    private static final String COMPONENT_KEY = "component";
    private static final String TYPE_KEY = "type";
    private static final String PRIORITY_KEY = "priority";
    private static final String STATUS_KEY = "status";
    private static final String RESOLUTION_KEY = "resolution";
    private static final String FIXFOR_KEY = "fixfor";
    private static final String VERSION_KEY = "version";
    private static final String QUERY_KEY = "query";
    private static final String ENVIRONMENT_KEY = "environment";
    private static final String BODY_KEY = "body";
    private static final String DESCRIPTION_KEY = "description";
    private static final String SUMMARY_KEY = "summary";
    private static final String ASSIGNEE_KEY = "assignee";
    private static final String REPORTER_KEY = "reporter";
    private static final String CREATED_KEY = "created";
    private static final String UPDATED_KEY = "updated";
    private static final String DUEDATE_KEY = "duedate";
    private static final String ISSUE_SPECIFIC_GROUP = "specificgroup";
    private static final String ISSUE_SPECIFIC_USER = "specificuser";
    private static final String ISSUE_CURRENT_USER = "issue_current_user";
    private static final String ISSUE_NO_REPORTER = "issue_no_reporter";
    private static final String VERSION_NONE = "-1";
    private static final String VERSION_RELEASED = "-2";
    private static final String VERSION_UNRELEASED = "-3";
    private static final String UNRESOLVED = "-1";
    private static final String COMPONENT_NONE = "-1";
    private final String encoding;

    public FilterDefinitionConverter(String encoding) {
        this.encoding = encoding;
    }

    public String toUrl(String repositoryUrl, FilterDefinition filter) {
        return String.valueOf(repositoryUrl) + "/secure/IssueNavigator.jspa?mode=hide" + "&reset=true" + this.getQueryParams(filter);
    }

    public FilterDefinition toFilter(JiraClient client, String url, boolean validate) {
        Object values;
        FilterDefinition filter = new FilterDefinition();
        int n = url.indexOf(63);
        if (n == -1) {
            return filter;
        }
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        String[] stringArray = url.substring(n + 1).split("&");
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String pair = stringArray[n3];
            String[] tokens = pair.split("=");
            if (tokens.length > 1) {
                try {
                    String key = tokens[0];
                    String value = tokens.length == 1 ? "" : URLDecoder.decode(tokens[1], this.encoding);
                    values = params.get(key);
                    if (values == null) {
                        values = new ArrayList<String>();
                        params.put(key, (List<String>)values);
                    }
                    values.add((String)value);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            ++n3;
        }
        List<String> projectIds = this.getIds(params, PROJECT_KEY);
        for (String projectId : projectIds) {
            Project project = client.getCache().getProjectById(projectId);
            if (project == null) {
                if (!validate) continue;
                throw new InvalidJiraQueryException("Unknown project " + projectId);
            }
            filter.setProjectFilter(new ProjectFilter(project));
            List<String> componentIds = this.getIds(params, COMPONENT_KEY);
            ArrayList<Object> components = new ArrayList<Object>();
            values = componentIds.iterator();
            while (values.hasNext()) {
                String componentId = (String)values.next();
                Component[] projectComponents = project.getComponents();
                Component[] componentArray = projectComponents;
                int n4 = projectComponents.length;
                int n5 = 0;
                while (n5 < n4) {
                    Component component = componentArray[n5];
                    if (component.getId().equals(componentId)) {
                        components.add(component);
                    }
                    ++n5;
                }
            }
            if (!componentIds.isEmpty()) {
                filter.setComponentFilter(new ComponentFilter(components.toArray(new Component[components.size()])));
            }
            Version[] projectVersions = project.getVersions();
            filter.setFixForVersionFilter(this.getVersionFilter(filter, this.getIds(params, FIXFOR_KEY), projectVersions));
            filter.setReportedInVersionFilter(this.getVersionFilter(filter, this.getIds(params, VERSION_KEY), projectVersions));
        }
        List<String> typeIds = this.getIds(params, TYPE_KEY);
        ArrayList<IssueType> issueTypes = new ArrayList<IssueType>();
        for (String typeId : typeIds) {
            IssueType issueType = client.getCache().getIssueTypeById(typeId);
            if (issueType != null) {
                issueTypes.add(issueType);
                continue;
            }
            if (!validate) continue;
            throw new InvalidJiraQueryException("Unknown type " + typeId);
        }
        if (!issueTypes.isEmpty()) {
            filter.setIssueTypeFilter(new IssueTypeFilter(issueTypes.toArray(new IssueType[issueTypes.size()])));
        }
        List<String> statusIds = this.getIds(params, STATUS_KEY);
        ArrayList<JiraStatus> statuses = new ArrayList<JiraStatus>();
        for (String statusId : statusIds) {
            JiraStatus status = client.getCache().getStatusById(statusId);
            if (status != null) {
                statuses.add(status);
                continue;
            }
            if (!validate) continue;
            throw new InvalidJiraQueryException("Unknown status " + statusId);
        }
        if (!statuses.isEmpty()) {
            filter.setStatusFilter(new StatusFilter(statuses.toArray(new JiraStatus[statuses.size()])));
        }
        List<String> resolutionIds = this.getIds(params, RESOLUTION_KEY);
        ArrayList<Resolution> resolutions = new ArrayList<Resolution>();
        boolean unresolved = false;
        for (String resolutionId : resolutionIds) {
            if (!"-1".equals(resolutionId)) {
                Resolution resolution = client.getCache().getResolutionById(resolutionId);
                if (resolution != null) {
                    resolutions.add(resolution);
                    continue;
                }
                if (!validate) continue;
                throw new InvalidJiraQueryException("Unknown resolution " + resolutionId);
            }
            unresolved = true;
        }
        if (!resolutionIds.isEmpty()) {
            filter.setResolutionFilter(new ResolutionFilter(resolutions.toArray(new Resolution[resolutions.size()])));
        } else if (unresolved) {
            filter.setResolutionFilter(new ResolutionFilter(new Resolution[0]));
        }
        List<String> priorityIds = this.getIds(params, PRIORITY_KEY);
        ArrayList<Priority> priorities = new ArrayList<Priority>();
        for (String priorityId : priorityIds) {
            Priority priority = client.getCache().getPriorityById(priorityId);
            if (priority != null) {
                priorities.add(priority);
                continue;
            }
            if (!validate) continue;
            throw new InvalidJiraQueryException("Unknown priority " + priorityId);
        }
        if (!priorities.isEmpty()) {
            filter.setPriorityFilter(new PriorityFilter(priorities.toArray(new Priority[priorities.size()])));
        }
        List<String> queries = this.getIds(params, QUERY_KEY);
        for (String query : queries) {
            boolean searchSummary = this.getIds(params, SUMMARY_KEY).contains("true");
            boolean searchDescription = this.getIds(params, DESCRIPTION_KEY).contains("true");
            boolean searchEnvironment = this.getIds(params, ENVIRONMENT_KEY).contains("true");
            boolean searchComments = this.getIds(params, BODY_KEY).contains("true");
            filter.setContentFilter(new ContentFilter(query, searchSummary, searchDescription, searchEnvironment, searchComments));
        }
        filter.setReportedByFilter(this.createUserFilter(params, REPORTER_KEY));
        filter.setAssignedToFilter(this.createUserFilter(params, ASSIGNEE_KEY));
        filter.setCreatedDateFilter(this.createDateFilter(params, CREATED_KEY));
        filter.setUpdatedDateFilter(this.createDateFilter(params, UPDATED_KEY));
        filter.setDueDateFilter(this.createDateFilter(params, DUEDATE_KEY));
        return filter;
    }

    private VersionFilter getVersionFilter(FilterDefinition filter, List<String> fixForIds, Version[] projectVersions) {
        if (fixForIds.isEmpty()) {
            return null;
        }
        boolean hasNoVersions = false;
        boolean hasReleasedVersions = false;
        boolean hasUnreleasedVersions = false;
        ArrayList<Version> fixForversions = new ArrayList<Version>();
        for (String fixForId : fixForIds) {
            if (fixForId.equals("-1")) {
                hasNoVersions = true;
                continue;
            }
            if (fixForId.equals(VERSION_RELEASED)) {
                hasReleasedVersions = true;
                continue;
            }
            if (fixForId.equals(VERSION_UNRELEASED)) {
                hasUnreleasedVersions = true;
                continue;
            }
            Version[] versionArray = projectVersions;
            int n = projectVersions.length;
            int n2 = 0;
            while (n2 < n) {
                Version projectVersion = versionArray[n2];
                if (projectVersion.getId().equals(fixForId)) {
                    fixForversions.add(projectVersion);
                }
                ++n2;
            }
        }
        if (!fixForversions.isEmpty()) {
            return new VersionFilter(fixForversions.toArray(new Version[fixForversions.size()]));
        }
        if (hasNoVersions) {
            return new VersionFilter(new Version[0]);
        }
        if (hasReleasedVersions || hasUnreleasedVersions) {
            return new VersionFilter(hasReleasedVersions, hasUnreleasedVersions);
        }
        return null;
    }

    private DateFilter createDateFilter(Map<String, List<String>> params, String key) {
        Date toDate;
        Date fromDate;
        String after = this.getId(params, String.valueOf(key) + ":after");
        String before = this.getId(params, String.valueOf(key) + ":before");
        SimpleDateFormat df = new SimpleDateFormat("d/MMM/yy", Locale.US);
        try {
            fromDate = df.parse(after);
        }
        catch (Exception exception) {
            fromDate = null;
        }
        try {
            toDate = df.parse(before);
        }
        catch (Exception exception) {
            toDate = null;
        }
        return fromDate == null && toDate == null ? null : new DateRangeFilter(fromDate, toDate);
    }

    private UserFilter createUserFilter(Map<String, List<String>> params, String key) {
        String type = this.getId(params, String.valueOf(key) + "Select");
        if (ISSUE_NO_REPORTER.equals(type)) {
            return new NobodyFilter();
        }
        if (ISSUE_CURRENT_USER.equals(type)) {
            return new CurrentUserFilter();
        }
        String reporter = this.getId(params, key);
        if (reporter != null) {
            if (ISSUE_SPECIFIC_USER.equals(type)) {
                return new SpecificUserFilter(reporter);
            }
            if (ISSUE_SPECIFIC_GROUP.equals(type)) {
                return new UserInGroupFilter(reporter);
            }
        }
        return null;
    }

    private String getId(Map<String, List<String>> params, String key) {
        List<String> ids = this.getIds(params, key);
        return ids.isEmpty() ? null : ids.get(0);
    }

    private List<String> getIds(Map<String, List<String>> params, String key) {
        List<String> ids = params.get(key);
        if (ids == null) {
            return Collections.emptyList();
        }
        return ids;
    }

    private String getQueryParams(FilterDefinition filter) {
        ContentFilter contentFilter;
        PriorityFilter priorityFilter;
        int n;
        Serializable[] serializableArray;
        ResolutionFilter resolutionFilter;
        StatusFilter statusFilter;
        IssueTypeFilter issueTypeFilter;
        VersionFilter reportedInVersionFilter;
        VersionFilter fixForVersionFilter;
        int n2;
        ComponentFilter componentFilter;
        StringBuilder sb = new StringBuilder();
        ProjectFilter projectFilter = filter.getProjectFilter();
        if (projectFilter != null) {
            Project project = projectFilter.getProject();
            this.addParameter(sb, PROJECT_KEY, project.getId());
        }
        if ((componentFilter = filter.getComponentFilter()) != null) {
            if (componentFilter.hasNoComponent()) {
                this.addParameter(sb, COMPONENT_KEY, "-1");
            } else {
                Component[] componentArray = componentFilter.getComponents();
                n2 = componentArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Component component = componentArray[n3];
                    this.addParameter(sb, COMPONENT_KEY, component.getId());
                    ++n3;
                }
            }
        }
        if ((fixForVersionFilter = filter.getFixForVersionFilter()) != null) {
            if (fixForVersionFilter.hasNoVersion()) {
                this.addParameter(sb, FIXFOR_KEY, "-1");
            }
            if (fixForVersionFilter.isReleasedVersions()) {
                this.addParameter(sb, FIXFOR_KEY, VERSION_RELEASED);
            }
            if (fixForVersionFilter.isUnreleasedVersions()) {
                this.addParameter(sb, FIXFOR_KEY, VERSION_UNRELEASED);
            }
            if (fixForVersionFilter.getVersions() != null) {
                Version[] versionArray = fixForVersionFilter.getVersions();
                int n4 = versionArray.length;
                n2 = 0;
                while (n2 < n4) {
                    Version fixVersion = versionArray[n2];
                    this.addParameter(sb, FIXFOR_KEY, fixVersion.getId());
                    ++n2;
                }
            }
        }
        if ((reportedInVersionFilter = filter.getReportedInVersionFilter()) != null) {
            if (reportedInVersionFilter.hasNoVersion()) {
                this.addParameter(sb, VERSION_KEY, "-1");
            }
            if (reportedInVersionFilter.isReleasedVersions()) {
                this.addParameter(sb, VERSION_KEY, VERSION_RELEASED);
            }
            if (reportedInVersionFilter.isUnreleasedVersions()) {
                this.addParameter(sb, VERSION_KEY, VERSION_UNRELEASED);
            }
            if (reportedInVersionFilter.getVersions() != null) {
                Version[] versionArray = reportedInVersionFilter.getVersions();
                int n5 = versionArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    Version reportedVersion = versionArray[n6];
                    this.addParameter(sb, VERSION_KEY, reportedVersion.getId());
                    ++n6;
                }
            }
        }
        if ((issueTypeFilter = filter.getIssueTypeFilter()) != null) {
            IssueType[] issueTypeArray = issueTypeFilter.getIsueTypes();
            int n7 = issueTypeArray.length;
            int n8 = 0;
            while (n8 < n7) {
                IssueType issueType = issueTypeArray[n8];
                this.addParameter(sb, TYPE_KEY, issueType.getId());
                ++n8;
            }
        }
        if ((statusFilter = filter.getStatusFilter()) != null) {
            JiraStatus[] jiraStatusArray = statusFilter.getStatuses();
            int n9 = jiraStatusArray.length;
            int n10 = 0;
            while (n10 < n9) {
                JiraStatus status = jiraStatusArray[n10];
                this.addParameter(sb, STATUS_KEY, status.getId());
                ++n10;
            }
        }
        if ((resolutionFilter = filter.getResolutionFilter()) != null) {
            Resolution[] resolutions = resolutionFilter.getResolutions();
            if (resolutions.length == 0) {
                this.addParameter(sb, RESOLUTION_KEY, "-1");
            } else {
                serializableArray = resolutions;
                n = resolutions.length;
                int n11 = 0;
                while (n11 < n) {
                    Serializable resolution = serializableArray[n11];
                    this.addParameter(sb, RESOLUTION_KEY, ((Resolution)resolution).getId());
                    ++n11;
                }
            }
        }
        if ((priorityFilter = filter.getPriorityFilter()) != null) {
            serializableArray = priorityFilter.getPriorities();
            n = serializableArray.length;
            int n12 = 0;
            while (n12 < n) {
                Serializable priority = serializableArray[n12];
                this.addParameter(sb, PRIORITY_KEY, ((Priority)priority).getId());
                ++n12;
            }
        }
        if ((contentFilter = filter.getContentFilter()) != null) {
            String queryString = contentFilter.getQueryString();
            if (queryString != null) {
                this.addParameter(sb, QUERY_KEY, queryString);
            }
            if (contentFilter.isSearchingSummary()) {
                this.addParameter(sb, SUMMARY_KEY, "true");
            }
            if (contentFilter.isSearchingDescription()) {
                this.addParameter(sb, DESCRIPTION_KEY, "true");
            }
            if (contentFilter.isSearchingComments()) {
                this.addParameter(sb, BODY_KEY, "true");
            }
            if (contentFilter.isSearchingEnvironment()) {
                this.addParameter(sb, ENVIRONMENT_KEY, "true");
            }
        }
        this.addUserFilter(sb, filter.getReportedByFilter(), REPORTER_KEY);
        this.addUserFilter(sb, filter.getAssignedToFilter(), ASSIGNEE_KEY);
        this.addDateFilter(sb, filter.getCreatedDateFilter(), CREATED_KEY);
        this.addDateFilter(sb, filter.getUpdatedDateFilter(), UPDATED_KEY);
        this.addDateFilter(sb, filter.getDueDateFilter(), DUEDATE_KEY);
        return sb.toString();
    }

    private void addDateFilter(StringBuilder sb, DateFilter filter, String type) {
        if (filter instanceof DateRangeFilter) {
            SimpleDateFormat df = new SimpleDateFormat("d/MMM/yy", Locale.US);
            DateRangeFilter rangeFilter = (DateRangeFilter)filter;
            this.addParameter(sb, String.valueOf(type) + ":after", df.format(rangeFilter.getFromDate()));
            this.addParameter(sb, String.valueOf(type) + ":before", df.format(rangeFilter.getToDate()));
        }
    }

    private void addUserFilter(StringBuilder sb, UserFilter filter, String type) {
        if (filter instanceof NobodyFilter) {
            this.addParameter(sb, String.valueOf(type) + "Select", ISSUE_NO_REPORTER);
        } else if (filter instanceof CurrentUserFilter) {
            this.addParameter(sb, String.valueOf(type) + "Select", ISSUE_CURRENT_USER);
        } else if (filter instanceof SpecificUserFilter) {
            this.addParameter(sb, String.valueOf(type) + "Select", ISSUE_SPECIFIC_USER);
            this.addParameter(sb, type, ((SpecificUserFilter)filter).getUser());
        } else if (filter instanceof UserInGroupFilter) {
            this.addParameter(sb, String.valueOf(type) + "Select", ISSUE_SPECIFIC_GROUP);
            this.addParameter(sb, type, ((UserInGroupFilter)filter).getGroup());
        }
    }

    private void addParameter(StringBuilder sb, String name, String value) {
        try {
            sb.append('&').append(name).append('=').append(URLEncoder.encode(value, this.encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }
}

