/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.jira.core.JiraClientFactory;
import org.eclipse.mylyn.internal.jira.core.model.Component;
import org.eclipse.mylyn.internal.jira.core.model.IssueType;
import org.eclipse.mylyn.internal.jira.core.model.JiraFilter;
import org.eclipse.mylyn.internal.jira.core.model.JiraStatus;
import org.eclipse.mylyn.internal.jira.core.model.Priority;
import org.eclipse.mylyn.internal.jira.core.model.Project;
import org.eclipse.mylyn.internal.jira.core.model.Resolution;
import org.eclipse.mylyn.internal.jira.core.model.Version;
import org.eclipse.mylyn.internal.jira.core.model.filter.ComponentFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.ContentFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.CurrentUserFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.DateFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.DateRangeFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.FilterDefinition;
import org.eclipse.mylyn.internal.jira.core.model.filter.IssueTypeFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.NobodyFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.PriorityFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.ProjectFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.ResolutionFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.SpecificUserFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.StatusFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.UserFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.UserInGroupFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.VersionFilter;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.util.FilterDefinitionConverter;
import org.eclipse.mylyn.internal.jira.core.util.JiraUtil;
import org.eclipse.mylyn.internal.jira.ui.JiraUiPlugin;
import org.eclipse.mylyn.internal.provisional.commons.ui.DatePicker;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class JiraFilterDefinitionPage
extends AbstractRepositoryQueryPage {
    protected static final String PAGE_NAME = "JiraSearchPage";
    private static final String SEARCH_URL_ID = "JiraSearchPage.SEARCHURL";
    private static final String TITLE_PAGE = "JIRA Query";
    final Placeholder ANY_ASSIGNEE = new Placeholder("Any");
    final Placeholder ANY_COMPONENT = new Placeholder("Any");
    final Placeholder ANY_FIX_VERSION = new Placeholder("Any");
    final Placeholder ANY_ISSUE_TYPE = new Placeholder("Any");
    final Placeholder ANY_PRIORITY = new Placeholder("Any");
    final Placeholder ANY_REPORTED_VERSION = new Placeholder("Any");
    final Placeholder ANY_REPORTER = new Placeholder("Any");
    final Placeholder ANY_RESOLUTION = new Placeholder("Any");
    final Placeholder ANY_STATUS = new Placeholder("Any");
    private Text assignee;
    private ComboViewer assigneeType;
    private final JiraClient client;
    private ListViewer components;
    private DatePicker createdEndDatePicker;
    private DatePicker createdStartDatePicker;
    final Placeholder CURRENT_USER_ASSIGNEE = new Placeholder("Current User");
    final Placeholder CURRENT_USER_REPORTER = new Placeholder("Current User");
    private DatePicker dueEndDatePicker;
    private DatePicker dueStartDatePicker;
    private boolean firstTime = true;
    private ListViewer fixFor;
    private ListViewer issueType;
    final Placeholder NO_COMPONENT = new Placeholder("No Component");
    final Placeholder NO_FIX_VERSION = new Placeholder("No Fix Version");
    final Placeholder NO_REPORTED_VERSION = new Placeholder("No Version");
    final Placeholder NO_REPORTER = new Placeholder("No Reporter");
    private ListViewer priority;
    private ListViewer project;
    private Text queryString;
    final Placeholder RELEASED_VERSION = new Placeholder("Released Versions");
    private ListViewer reportedIn;
    private Text reporter;
    private ComboViewer reporterType;
    private ListViewer resolution;
    private Button searchComments;
    private Button searchDescription;
    private Button searchEnvironment;
    private Button searchSummary;
    final Placeholder SPECIFIC_GROUP_ASSIGNEE = new Placeholder("Specified Group");
    final Placeholder SPECIFIC_GROUP_REPORTER = new Placeholder("Specified Group");
    final Placeholder SPECIFIC_USER_ASSIGNEE = new Placeholder("Specified User");
    final Placeholder SPECIFIC_USER_REPORTER = new Placeholder("Specified User");
    private ListViewer status;
    private Text titleText;
    final Placeholder UNASSIGNED = new Placeholder("Unassigned");
    final Placeholder UNRELEASED_VERSION = new Placeholder("Unreleased Versions");
    final Placeholder UNRESOLVED = new Placeholder("Unresolved");
    private DatePicker updatedEndDatePicker;
    private DatePicker updatedStartDatePicker;
    private FilterDefinition workingCopy;

    public JiraFilterDefinitionPage(TaskRepository repository) {
        this(repository, null);
    }

    public JiraFilterDefinitionPage(TaskRepository repository, IRepositoryQuery query) {
        super(TITLE_PAGE, repository, query);
        this.client = JiraClientFactory.getDefault().getJiraClient(repository);
        this.workingCopy = query != null ? (FilterDefinition)JiraUtil.getQuery((TaskRepository)repository, (JiraClient)this.client, (IRepositoryQuery)query, (boolean)false) : new FilterDefinition();
        this.setDescription("Add search filters to define query.");
        this.setPageComplete(false);
    }

    void applyChanges() {
        boolean selectionContainsNone;
        boolean selectionContainsAll;
        if (this.queryString.getText().length() > 0 || this.searchSummary.getSelection() || this.searchDescription.getSelection() || this.searchEnvironment.getSelection() || this.searchComments.getSelection()) {
            this.workingCopy.setContentFilter(new ContentFilter(this.queryString.getText(), this.searchSummary.getSelection(), this.searchDescription.getSelection(), this.searchEnvironment.getSelection(), this.searchComments.getSelection()));
        } else {
            this.workingCopy.setContentFilter(null);
        }
        IStructuredSelection projectSelection = (IStructuredSelection)this.project.getSelection();
        if (!projectSelection.isEmpty() && projectSelection.getFirstElement() instanceof Project) {
            this.workingCopy.setProjectFilter(new ProjectFilter((Project)projectSelection.getFirstElement()));
        } else {
            this.workingCopy.setProjectFilter(null);
        }
        IStructuredSelection reportedInSelection = (IStructuredSelection)this.reportedIn.getSelection();
        if (reportedInSelection.isEmpty()) {
            this.workingCopy.setReportedInVersionFilter(null);
        } else {
            boolean selectionContainsReleased = false;
            boolean selectionContainsUnreleased = false;
            selectionContainsAll = false;
            selectionContainsNone = false;
            ArrayList<Version> selectedVersions = new ArrayList<Version>();
            for (Object selection : reportedInSelection) {
                if (this.ANY_REPORTED_VERSION.equals(selection)) {
                    selectionContainsAll = true;
                    continue;
                }
                if (this.NO_REPORTED_VERSION.equals(selection)) {
                    selectionContainsNone = true;
                    continue;
                }
                if (this.RELEASED_VERSION.equals(selection)) {
                    selectionContainsReleased = true;
                    continue;
                }
                if (this.UNRELEASED_VERSION.equals(selection)) {
                    selectionContainsUnreleased = true;
                    continue;
                }
                if (!(selection instanceof Version)) continue;
                selectedVersions.add((Version)selection);
            }
            if (selectionContainsAll) {
                this.workingCopy.setReportedInVersionFilter(null);
            } else if (selectionContainsNone) {
                this.workingCopy.setReportedInVersionFilter(new VersionFilter(new Version[0]));
            } else if (selectionContainsReleased || selectionContainsUnreleased) {
                this.workingCopy.setReportedInVersionFilter(new VersionFilter(selectionContainsReleased, selectionContainsUnreleased));
            } else if (selectedVersions.size() > 0) {
                this.workingCopy.setReportedInVersionFilter(new VersionFilter(selectedVersions.toArray(new Version[selectedVersions.size()])));
            } else {
                this.workingCopy.setReportedInVersionFilter(null);
            }
        }
        IStructuredSelection fixForSelection = (IStructuredSelection)this.fixFor.getSelection();
        if (fixForSelection.isEmpty()) {
            this.workingCopy.setFixForVersionFilter(null);
        } else {
            boolean selectionContainsReleased = false;
            boolean selectionContainsUnreleased = false;
            boolean selectionContainsAll2 = false;
            boolean selectionContainsNone2 = false;
            ArrayList<Version> selectedVersions = new ArrayList<Version>();
            for (Object selection : fixForSelection) {
                if (this.ANY_FIX_VERSION.equals(selection)) {
                    selectionContainsAll2 = true;
                    continue;
                }
                if (this.NO_FIX_VERSION.equals(selection)) {
                    selectionContainsNone2 = true;
                    continue;
                }
                if (this.RELEASED_VERSION.equals(selection)) {
                    selectionContainsReleased = true;
                    continue;
                }
                if (this.UNRELEASED_VERSION.equals(selection)) {
                    selectionContainsUnreleased = true;
                    continue;
                }
                if (!(selection instanceof Version)) continue;
                selectedVersions.add((Version)selection);
            }
            if (selectionContainsAll2) {
                this.workingCopy.setFixForVersionFilter(null);
            } else if (selectionContainsNone2) {
                this.workingCopy.setFixForVersionFilter(new VersionFilter(new Version[0]));
            } else if (selectionContainsReleased || selectionContainsUnreleased) {
                this.workingCopy.setFixForVersionFilter(new VersionFilter(selectionContainsReleased, selectionContainsUnreleased));
            } else if (selectedVersions.size() > 0) {
                this.workingCopy.setFixForVersionFilter(new VersionFilter(selectedVersions.toArray(new Version[selectedVersions.size()])));
            } else {
                this.workingCopy.setFixForVersionFilter(null);
            }
        }
        IStructuredSelection componentsSelection = (IStructuredSelection)this.components.getSelection();
        if (componentsSelection.isEmpty()) {
            this.workingCopy.setComponentFilter(null);
        } else {
            selectionContainsAll = false;
            selectionContainsNone = false;
            ArrayList<Component> selectedComponents = new ArrayList<Component>();
            for (Object selection : componentsSelection) {
                if (this.ANY_COMPONENT.equals(selection)) {
                    selectionContainsAll = true;
                    continue;
                }
                if (this.NO_COMPONENT.equals(selection)) {
                    selectionContainsNone = true;
                    continue;
                }
                if (!(selection instanceof Component)) continue;
                selectedComponents.add((Component)selection);
            }
            if (selectionContainsAll) {
                this.workingCopy.setComponentFilter(null);
            } else if (selectedComponents.size() > 0) {
                this.workingCopy.setComponentFilter(new ComponentFilter(selectedComponents.toArray(new Component[selectedComponents.size()])));
            } else if (selectionContainsNone) {
                this.workingCopy.setComponentFilter(new ComponentFilter(new Component[0]));
            } else {
                this.workingCopy.setComponentFilter(null);
            }
        }
        IStructuredSelection issueTypeSelection = (IStructuredSelection)this.issueType.getSelection();
        if (issueTypeSelection.isEmpty()) {
            this.workingCopy.setIssueTypeFilter(null);
        } else {
            boolean isAnyIssueTypeSelected = false;
            ArrayList<IssueType> selectedIssueTypes = new ArrayList<IssueType>();
            for (Object selection : issueTypeSelection) {
                if (this.ANY_ISSUE_TYPE.equals(selection)) {
                    isAnyIssueTypeSelected = true;
                    continue;
                }
                if (!(selection instanceof IssueType)) continue;
                selectedIssueTypes.add((IssueType)selection);
            }
            if (isAnyIssueTypeSelected) {
                this.workingCopy.setIssueTypeFilter(null);
            } else {
                this.workingCopy.setIssueTypeFilter(new IssueTypeFilter(selectedIssueTypes.toArray(new IssueType[selectedIssueTypes.size()])));
            }
        }
        IStructuredSelection reporterSelection = (IStructuredSelection)this.reporterType.getSelection();
        if (reporterSelection.isEmpty()) {
            this.workingCopy.setReportedByFilter(null);
        } else if (this.ANY_REPORTER.equals(reporterSelection.getFirstElement())) {
            this.workingCopy.setReportedByFilter(null);
        } else if (this.NO_REPORTER.equals(reporterSelection.getFirstElement())) {
            this.workingCopy.setReportedByFilter((UserFilter)new NobodyFilter());
        } else if (this.CURRENT_USER_REPORTER.equals(reporterSelection.getFirstElement())) {
            this.workingCopy.setReportedByFilter((UserFilter)new CurrentUserFilter());
        } else if (this.SPECIFIC_GROUP_REPORTER.equals(reporterSelection.getFirstElement())) {
            this.workingCopy.setReportedByFilter((UserFilter)new UserInGroupFilter(this.reporter.getText()));
        } else if (this.SPECIFIC_USER_REPORTER.equals(reporterSelection.getFirstElement())) {
            this.workingCopy.setReportedByFilter((UserFilter)new SpecificUserFilter(this.reporter.getText()));
        } else {
            this.workingCopy.setReportedByFilter(null);
        }
        IStructuredSelection assigneeSelection = (IStructuredSelection)this.assigneeType.getSelection();
        if (assigneeSelection.isEmpty()) {
            this.workingCopy.setAssignedToFilter(null);
        } else if (this.ANY_ASSIGNEE.equals(assigneeSelection.getFirstElement())) {
            this.workingCopy.setAssignedToFilter(null);
        } else if (this.UNASSIGNED.equals(assigneeSelection.getFirstElement())) {
            this.workingCopy.setAssignedToFilter((UserFilter)new NobodyFilter());
        } else if (this.CURRENT_USER_ASSIGNEE.equals(assigneeSelection.getFirstElement())) {
            this.workingCopy.setAssignedToFilter((UserFilter)new CurrentUserFilter());
        } else if (this.SPECIFIC_GROUP_ASSIGNEE.equals(assigneeSelection.getFirstElement())) {
            this.workingCopy.setAssignedToFilter((UserFilter)new UserInGroupFilter(this.assignee.getText()));
        } else if (this.SPECIFIC_USER_ASSIGNEE.equals(assigneeSelection.getFirstElement())) {
            this.workingCopy.setAssignedToFilter((UserFilter)new SpecificUserFilter(this.assignee.getText()));
        } else {
            this.workingCopy.setAssignedToFilter(null);
        }
        IStructuredSelection statusSelection = (IStructuredSelection)this.status.getSelection();
        if (statusSelection.isEmpty()) {
            this.workingCopy.setStatusFilter(null);
        } else {
            boolean isAnyStatusSelected = false;
            ArrayList<JiraStatus> selectedStatuses = new ArrayList<JiraStatus>();
            for (Object selection : statusSelection) {
                if (this.ANY_STATUS.equals(selection)) {
                    isAnyStatusSelected = true;
                    continue;
                }
                if (!(selection instanceof JiraStatus)) continue;
                selectedStatuses.add((JiraStatus)selection);
            }
            if (isAnyStatusSelected) {
                this.workingCopy.setStatusFilter(null);
            } else {
                this.workingCopy.setStatusFilter(new StatusFilter(selectedStatuses.toArray(new JiraStatus[selectedStatuses.size()])));
            }
        }
        IStructuredSelection resolutionSelection = (IStructuredSelection)this.resolution.getSelection();
        if (resolutionSelection.isEmpty()) {
            this.workingCopy.setResolutionFilter(null);
        } else {
            boolean isAnyResolutionSelected = false;
            ArrayList<Resolution> selectedResolutions = new ArrayList<Resolution>();
            for (Object selection : resolutionSelection) {
                if (this.ANY_RESOLUTION.equals(selection)) {
                    isAnyResolutionSelected = true;
                    continue;
                }
                if (!(selection instanceof Resolution)) continue;
                selectedResolutions.add((Resolution)selection);
            }
            if (isAnyResolutionSelected) {
                this.workingCopy.setResolutionFilter(null);
            } else {
                this.workingCopy.setResolutionFilter(new ResolutionFilter(selectedResolutions.toArray(new Resolution[selectedResolutions.size()])));
            }
        }
        IStructuredSelection prioritySelection = (IStructuredSelection)this.priority.getSelection();
        if (prioritySelection.isEmpty()) {
            this.workingCopy.setPriorityFilter(null);
        } else {
            boolean isAnyPrioritiesSelected = false;
            ArrayList<Priority> selectedPriorities = new ArrayList<Priority>();
            for (Object selection : prioritySelection) {
                if (this.ANY_PRIORITY.equals(selection)) {
                    isAnyPrioritiesSelected = true;
                    continue;
                }
                if (!(selection instanceof Priority)) continue;
                selectedPriorities.add((Priority)selection);
            }
            if (isAnyPrioritiesSelected) {
                this.workingCopy.setPriorityFilter(null);
            } else {
                this.workingCopy.setPriorityFilter(new PriorityFilter(selectedPriorities.toArray(new Priority[selectedPriorities.size()])));
            }
        }
        this.workingCopy.setDueDateFilter((DateFilter)this.getRangeFilter(this.dueStartDatePicker, this.dueEndDatePicker));
        this.workingCopy.setCreatedDateFilter((DateFilter)this.getRangeFilter(this.createdStartDatePicker, this.createdEndDatePicker));
        this.workingCopy.setUpdatedDateFilter((DateFilter)this.getRangeFilter(this.updatedStartDatePicker, this.updatedEndDatePicker));
    }

    public void applyTo(IRepositoryQuery query) {
        this.applyChanges();
        if (this.titleText != null) {
            query.setSummary(this.titleText.getText());
        }
        JiraUtil.setQuery((TaskRepository)this.getTaskRepository(), (IRepositoryQuery)query, (JiraFilter)this.workingCopy);
    }

    private void createComponentsViewer(Composite c) {
        this.components = new ListViewer(c, 2818);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 50;
        gridData.widthHint = 90;
        this.components.getControl().setLayoutData((Object)gridData);
        this.components.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private Project project;

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (this.project != null) {
                    Component[] components = this.project.getComponents();
                    Object[] elements = new Object[components.length + 2];
                    elements[0] = JiraFilterDefinitionPage.this.ANY_COMPONENT;
                    elements[1] = JiraFilterDefinitionPage.this.NO_COMPONENT;
                    System.arraycopy(components, 0, elements, 2, components.length);
                    return elements;
                }
                return new Object[]{JiraFilterDefinitionPage.this.ANY_COMPONENT};
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.project = (Project)newInput;
            }
        });
        this.components.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider());
        this.components.setInput(null);
    }

    public void createControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(3, false));
        c.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)c);
        if (!this.inSearchContainer()) {
            Label lblName = new Label(c, 0);
            GridData gridData = new GridData();
            lblName.setLayoutData((Object)gridData);
            lblName.setText("Query Title:");
            this.titleText = new Text(c, 2048);
            this.titleText.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
            this.titleText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    JiraFilterDefinitionPage.this.setPageComplete(JiraFilterDefinitionPage.this.isPageComplete());
                }
            });
        }
        SashForm sashForm = new SashForm(c, 512);
        GridData gd_sashForm = new GridData(4, 4, false, true, 3, 1);
        gd_sashForm.heightHint = 200;
        gd_sashForm.widthHint = 500;
        sashForm.setLayoutData((Object)gd_sashForm);
        SashForm cc = new SashForm((Composite)sashForm, 256);
        Composite comp = new Composite((Composite)cc, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        comp.setLayout((Layout)gridLayout);
        Label label = new Label(comp, 0);
        label.setText("Project:");
        this.createProjectsViewer(comp);
        comp = new Composite((Composite)cc, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        comp.setLayout((Layout)gridLayout);
        new Label(comp, 0).setText("Fix For:");
        this.createFixForViewer(comp);
        comp = new Composite((Composite)cc, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        comp.setLayout((Layout)gridLayout);
        new Label(comp, 0).setText("In Components:");
        this.createComponentsViewer(comp);
        comp = new Composite((Composite)cc, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        comp.setLayout((Layout)gridLayout);
        label = new Label(comp, 0);
        label.setText("Reported In:");
        this.createReportedInViewer(comp);
        cc.setWeights(new int[]{1, 1, 1, 1});
        cc = new SashForm((Composite)sashForm, 0);
        ISelectionChangedListener selectionChangeListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        };
        Composite comp2 = new Composite((Composite)cc, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        comp2.setLayout((Layout)gridLayout2);
        Label typeLabel = new Label(comp2, 0);
        typeLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        typeLabel.setText("Type:");
        this.issueType = new ListViewer(comp2, 2818);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 50;
        gridData.widthHint = 90;
        this.issueType.getList().setLayoutData((Object)gridData);
        this.issueType.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Placeholder) {
                    return ((Placeholder)element).getText();
                }
                return ((IssueType)element).getName();
            }
        });
        this.issueType.addSelectionChangedListener(selectionChangeListener);
        comp2 = new Composite((Composite)cc, 0);
        gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        comp2.setLayout((Layout)gridLayout2);
        Label statusLabel = new Label(comp2, 0);
        statusLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        statusLabel.setText("Status:");
        this.status = new ListViewer(comp2, 2818);
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 50;
        gridData.widthHint = 90;
        this.status.getList().setLayoutData((Object)gridData);
        this.status.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Placeholder) {
                    return ((Placeholder)element).getText();
                }
                return ((JiraStatus)element).getName();
            }
        });
        this.status.addSelectionChangedListener(selectionChangeListener);
        comp2 = new Composite((Composite)cc, 0);
        gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        comp2.setLayout((Layout)gridLayout2);
        Label resolutionLabel = new Label(comp2, 0);
        resolutionLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        resolutionLabel.setText("Resolution:");
        this.resolution = new ListViewer(comp2, 2818);
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 50;
        gridData.widthHint = 90;
        this.resolution.getList().setLayoutData((Object)gridData);
        this.resolution.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Placeholder) {
                    return ((Placeholder)element).getText();
                }
                return ((Resolution)element).getName();
            }
        });
        this.resolution.addSelectionChangedListener(selectionChangeListener);
        comp2 = new Composite((Composite)cc, 0);
        gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        comp2.setLayout((Layout)gridLayout2);
        Label priorityLabel = new Label(comp2, 0);
        priorityLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        priorityLabel.setText("Priority:");
        this.priority = new ListViewer(comp2, 2818);
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 50;
        gridData.widthHint = 90;
        this.priority.getList().setLayoutData((Object)gridData);
        this.priority.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Placeholder) {
                    return ((Placeholder)element).getText();
                }
                return ((Priority)element).getName();
            }
        });
        this.priority.addSelectionChangedListener(selectionChangeListener);
        cc.setWeights(new int[]{1, 1, 1, 1});
        sashForm.setWeights(new int[]{1, 1});
        this.createUpdateButton(c);
        Label lblQuery = new Label(c, 0);
        GridData gd_lblQuery = new GridData();
        gd_lblQuery.verticalIndent = 7;
        lblQuery.setLayoutData((Object)gd_lblQuery);
        lblQuery.setText("Query:");
        this.queryString = new Text(c, 2048);
        GridData gd_queryString = new GridData(4, 4, false, false, 2, 1);
        gd_queryString.verticalIndent = 7;
        this.queryString.setLayoutData((Object)gd_queryString);
        this.queryString.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        Label lblFields = new Label(c, 0);
        lblFields.setText("Fields:");
        lblFields.setLayoutData((Object)new GridData());
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        };
        Composite comp3 = new Composite(c, 0);
        comp3.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        comp3.setLayout((Layout)new FillLayout());
        this.searchSummary = new Button(comp3, 32);
        this.searchSummary.setText("Summary");
        this.searchSummary.addSelectionListener((SelectionListener)selectionAdapter);
        this.searchDescription = new Button(comp3, 32);
        this.searchDescription.setText("Description");
        this.searchDescription.addSelectionListener((SelectionListener)selectionAdapter);
        this.searchComments = new Button(comp3, 32);
        this.searchComments.setText("Comments");
        this.searchComments.addSelectionListener((SelectionListener)selectionAdapter);
        this.searchEnvironment = new Button(comp3, 32);
        this.searchEnvironment.setText("Environment");
        this.searchEnvironment.addSelectionListener((SelectionListener)selectionAdapter);
        Label reportedByLabel = new Label(c, 0);
        reportedByLabel.setText("Reported By:");
        this.reporterType = new ComboViewer(c, 2056);
        GridData gridData_1 = new GridData(4, 0x1000000, false, false);
        gridData_1.widthHint = 133;
        this.reporterType.getControl().setLayoutData((Object)gridData_1);
        this.reporterType.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return new Object[]{JiraFilterDefinitionPage.this.ANY_REPORTER, JiraFilterDefinitionPage.this.NO_REPORTER, JiraFilterDefinitionPage.this.CURRENT_USER_REPORTER, JiraFilterDefinitionPage.this.SPECIFIC_USER_REPORTER, JiraFilterDefinitionPage.this.SPECIFIC_GROUP_REPORTER};
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.reporterType.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Placeholder)element).getText();
            }
        });
        this.reporterType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (JiraFilterDefinitionPage.this.SPECIFIC_USER_REPORTER.equals(selection) || JiraFilterDefinitionPage.this.SPECIFIC_GROUP_REPORTER.equals(selection)) {
                    JiraFilterDefinitionPage.this.reporter.setEnabled(true);
                } else {
                    JiraFilterDefinitionPage.this.reporter.setEnabled(false);
                    JiraFilterDefinitionPage.this.reporter.setText("");
                }
            }
        });
        this.reporterType.setInput((Object)this.client);
        this.reporter = new Text(c, 2048);
        this.reporter.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.reporter.setEnabled(false);
        this.reporter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        Label assignedToLabel = new Label(c, 0);
        assignedToLabel.setText("Assigned To:");
        this.assigneeType = new ComboViewer(c, 2056);
        GridData gridData_2 = new GridData(4, 0x1000000, false, false);
        gridData_2.widthHint = 133;
        this.assigneeType.getCombo().setLayoutData((Object)gridData_2);
        this.assigneeType.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return new Object[]{JiraFilterDefinitionPage.this.ANY_ASSIGNEE, JiraFilterDefinitionPage.this.UNASSIGNED, JiraFilterDefinitionPage.this.CURRENT_USER_ASSIGNEE, JiraFilterDefinitionPage.this.SPECIFIC_USER_ASSIGNEE, JiraFilterDefinitionPage.this.SPECIFIC_GROUP_ASSIGNEE};
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.assigneeType.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Placeholder)element).getText();
            }
        });
        this.assigneeType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (JiraFilterDefinitionPage.this.SPECIFIC_USER_ASSIGNEE.equals(selection) || JiraFilterDefinitionPage.this.SPECIFIC_GROUP_ASSIGNEE.equals(selection)) {
                    JiraFilterDefinitionPage.this.assignee.setEnabled(true);
                } else {
                    JiraFilterDefinitionPage.this.assignee.setEnabled(false);
                    JiraFilterDefinitionPage.this.assignee.setText("");
                }
            }
        });
        this.assigneeType.setInput((Object)this.client);
        this.assignee = new Text(c, 2048);
        this.assignee.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.assignee.setEnabled(false);
        this.assignee.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        Label createdLabel = new Label(c, 0);
        createdLabel.setText("Created:");
        Composite composite = new Composite(c, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.spacing = 5;
        composite.setLayout((Layout)fillLayout);
        composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.createdStartDatePicker = new DatePicker(composite, 2048, "<start date>", true, 0);
        this.createdEndDatePicker = new DatePicker(composite, 2048, "<end date>", true, 0);
        Label updatedLabel = new Label(c, 0);
        updatedLabel.setText("Updated:");
        composite = new Composite(c, 0);
        fillLayout = new FillLayout();
        fillLayout.spacing = 5;
        composite.setLayout((Layout)fillLayout);
        composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.updatedStartDatePicker = new DatePicker(composite, 2048, "<start date>", true, 0);
        this.updatedEndDatePicker = new DatePicker(composite, 2048, "<end date>", true, 0);
        Label dueDateLabel = new Label(c, 0);
        dueDateLabel.setText("Due Date:");
        composite = new Composite(c, 0);
        fillLayout = new FillLayout();
        fillLayout.spacing = 5;
        composite.setLayout((Layout)fillLayout);
        composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.dueStartDatePicker = new DatePicker(composite, 2048, "<start date>", true, 0);
        this.dueEndDatePicker = new DatePicker(composite, 2048, "<end date>", true, 0);
        this.loadDefaults();
    }

    private void createFixForViewer(Composite c) {
        this.fixFor = new ListViewer(c, 2818);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 50;
        gridData.widthHint = 90;
        this.fixFor.getControl().setLayoutData((Object)gridData);
        this.fixFor.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private Project project;

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (this.project != null) {
                    Version[] versions = this.project.getVersions();
                    Version[] releasedVersions = this.project.getReleasedVersions();
                    Version[] unreleasedVersions = this.project.getUnreleasedVersions();
                    Object[] elements = new Object[versions.length + 4];
                    elements[0] = JiraFilterDefinitionPage.this.ANY_FIX_VERSION;
                    elements[1] = JiraFilterDefinitionPage.this.NO_FIX_VERSION;
                    elements[2] = JiraFilterDefinitionPage.this.RELEASED_VERSION;
                    System.arraycopy(releasedVersions, 0, elements, 3, releasedVersions.length);
                    elements[releasedVersions.length + 3] = JiraFilterDefinitionPage.this.UNRELEASED_VERSION;
                    System.arraycopy(unreleasedVersions, 0, elements, releasedVersions.length + 4, unreleasedVersions.length);
                    return elements;
                }
                return new Object[]{JiraFilterDefinitionPage.this.ANY_REPORTED_VERSION};
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.project = (Project)newInput;
            }
        });
        this.fixFor.setLabelProvider((IBaseLabelProvider)new VersionLabelProvider());
        this.fixFor.setInput(null);
    }

    private void createProjectsViewer(Composite c) {
        this.project = new ListViewer(c, 2818);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 50;
        gridData.widthHint = 90;
        this.project.getControl().setLayoutData((Object)gridData);
        this.project.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Placeholder) {
                    return ((Placeholder)element).getText();
                }
                return ((Project)element).getName();
            }
        });
        this.project.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Project selectedProject = null;
                if (!selection.isEmpty() && !(selection.getFirstElement() instanceof Placeholder)) {
                    selectedProject = (Project)selection.getFirstElement();
                }
                JiraFilterDefinitionPage.this.updateCurrentProject(selectedProject);
            }
        });
    }

    private void createReportedInViewer(Composite c) {
        this.reportedIn = new ListViewer(c, 2818);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 50;
        gridData.widthHint = 90;
        this.reportedIn.getControl().setLayoutData((Object)gridData);
        this.reportedIn.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private Project project;

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (this.project != null) {
                    Version[] versions = this.project.getVersions();
                    Version[] releasedVersions = this.project.getReleasedVersions();
                    Version[] unreleasedVersions = this.project.getUnreleasedVersions();
                    Object[] elements = new Object[versions.length + 4];
                    elements[0] = JiraFilterDefinitionPage.this.ANY_REPORTED_VERSION;
                    elements[1] = JiraFilterDefinitionPage.this.NO_REPORTED_VERSION;
                    elements[2] = JiraFilterDefinitionPage.this.RELEASED_VERSION;
                    System.arraycopy(releasedVersions, 0, elements, 3, releasedVersions.length);
                    elements[releasedVersions.length + 3] = JiraFilterDefinitionPage.this.UNRELEASED_VERSION;
                    System.arraycopy(unreleasedVersions, 0, elements, releasedVersions.length + 4, unreleasedVersions.length);
                    return elements;
                }
                return new Object[]{JiraFilterDefinitionPage.this.ANY_REPORTED_VERSION};
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.project = (Project)newInput;
            }
        });
        this.reportedIn.setLabelProvider((IBaseLabelProvider)new VersionLabelProvider());
        this.reportedIn.setInput(null);
    }

    protected void createUpdateButton(Composite control) {
        Button updateButton = new Button(control, 8);
        updateButton.setText("Update Attributes from Repository");
        updateButton.setLayoutData((Object)new GridData(131072, 4, false, false, 3, 1));
        updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraFilterDefinitionPage.this.applyChanges();
                JiraFilterDefinitionPage.this.updateAttributesFromRepository(true);
                JiraFilterDefinitionPage.this.loadFromWorkingCopy();
            }
        });
    }

    public IDialogSettings getDialogSettings() {
        IDialogSettings settings = JiraUiPlugin.getDefault().getDialogSettings();
        IDialogSettings dialogSettings = settings.getSection(PAGE_NAME);
        if (dialogSettings == null) {
            dialogSettings = settings.addNewSection(PAGE_NAME);
        }
        return dialogSettings;
    }

    public String getQueryTitle() {
        return this.titleText != null ? this.titleText.getText() : "";
    }

    private DateRangeFilter getRangeFilter(DatePicker startDatePicker, DatePicker endDatePicker) {
        Calendar startDate = startDatePicker.getDate();
        Calendar endDate = endDatePicker.getDate();
        if (startDate != null && endDate != null) {
            return new DateRangeFilter(startDate.getTime(), endDate.getTime());
        }
        return null;
    }

    private void initializeContentProviders() {
        this.project.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                JiraClient server = (JiraClient)inputElement;
                Object[] elements = new Object[server.getCache().getProjects().length + 1];
                elements[0] = new Placeholder("All Projects");
                System.arraycopy(server.getCache().getProjects(), 0, elements, 1, server.getCache().getProjects().length);
                return elements;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.project.setInput((Object)this.client);
        this.issueType.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                JiraClient server = (JiraClient)inputElement;
                Object[] elements = new Object[server.getCache().getIssueTypes().length + 1];
                elements[0] = JiraFilterDefinitionPage.this.ANY_ISSUE_TYPE;
                System.arraycopy(server.getCache().getIssueTypes(), 0, elements, 1, server.getCache().getIssueTypes().length);
                return elements;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.issueType.setInput((Object)this.client);
        this.status.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                JiraClient server = (JiraClient)inputElement;
                Object[] elements = new Object[server.getCache().getStatuses().length + 1];
                elements[0] = JiraFilterDefinitionPage.this.ANY_STATUS;
                System.arraycopy(server.getCache().getStatuses(), 0, elements, 1, server.getCache().getStatuses().length);
                return elements;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.status.setInput((Object)this.client);
        this.resolution.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                JiraClient server = (JiraClient)inputElement;
                Object[] elements = new Object[server.getCache().getResolutions().length + 2];
                elements[0] = JiraFilterDefinitionPage.this.ANY_RESOLUTION;
                elements[1] = JiraFilterDefinitionPage.this.UNRESOLVED;
                System.arraycopy(server.getCache().getResolutions(), 0, elements, 2, server.getCache().getResolutions().length);
                return elements;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.resolution.setInput((Object)this.client);
        this.priority.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                JiraClient client = (JiraClient)inputElement;
                Object[] elements = new Object[client.getCache().getPriorities().length + 1];
                elements[0] = JiraFilterDefinitionPage.this.ANY_PRIORITY;
                System.arraycopy(client.getCache().getPriorities(), 0, elements, 1, client.getCache().getPriorities().length);
                return elements;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.priority.setInput((Object)this.client);
    }

    private void initializePage() {
        this.updateAttributesFromRepository(false);
        if (this.inSearchContainer()) {
            this.restoreWidgetValues();
        }
        if (this.titleText != null && this.getQuery() != null) {
            this.titleText.setText(this.getQuery().getSummary());
        }
        this.loadFromWorkingCopy();
    }

    private void loadDefaults() {
        this.searchSummary.setSelection(true);
        this.searchDescription.setSelection(true);
    }

    private void loadFromWorkingCopy() {
        if (this.workingCopy.getProjectFilter() != null) {
            this.project.setSelection((ISelection)new StructuredSelection((Object)this.workingCopy.getProjectFilter().getProject()), true);
        } else {
            this.project.setSelection((ISelection)new StructuredSelection((Object)new Placeholder("All Projects")), true);
        }
        if (this.workingCopy.getFixForVersionFilter() != null) {
            if (this.workingCopy.getFixForVersionFilter().hasNoVersion()) {
                this.fixFor.setSelection((ISelection)new StructuredSelection(new Object[]{this.NO_FIX_VERSION}));
            } else if (this.workingCopy.getFixForVersionFilter().isReleasedVersions() && this.workingCopy.getFixForVersionFilter().isUnreleasedVersions()) {
                this.fixFor.setSelection((ISelection)new StructuredSelection(new Object[]{this.RELEASED_VERSION, this.UNRELEASED_VERSION}), true);
            } else if (this.workingCopy.getFixForVersionFilter().isReleasedVersions()) {
                this.fixFor.setSelection((ISelection)new StructuredSelection((Object)this.RELEASED_VERSION), true);
            } else if (this.workingCopy.getFixForVersionFilter().isUnreleasedVersions()) {
                this.fixFor.setSelection((ISelection)new StructuredSelection((Object)this.UNRELEASED_VERSION), true);
            } else {
                this.fixFor.setSelection((ISelection)new StructuredSelection((Object[])this.workingCopy.getFixForVersionFilter().getVersions()), true);
            }
        } else {
            this.fixFor.setSelection((ISelection)new StructuredSelection((Object)this.ANY_FIX_VERSION), true);
        }
        if (this.workingCopy.getReportedInVersionFilter() != null) {
            if (this.workingCopy.getReportedInVersionFilter().hasNoVersion()) {
                this.reportedIn.setSelection((ISelection)new StructuredSelection(new Object[]{this.NO_REPORTED_VERSION}), true);
            } else if (this.workingCopy.getReportedInVersionFilter().isReleasedVersions() && this.workingCopy.getReportedInVersionFilter().isUnreleasedVersions()) {
                this.reportedIn.setSelection((ISelection)new StructuredSelection(new Object[]{this.RELEASED_VERSION, this.UNRELEASED_VERSION}), true);
            } else if (this.workingCopy.getReportedInVersionFilter().isReleasedVersions()) {
                this.reportedIn.setSelection((ISelection)new StructuredSelection((Object)this.RELEASED_VERSION), true);
            } else if (this.workingCopy.getReportedInVersionFilter().isUnreleasedVersions()) {
                this.reportedIn.setSelection((ISelection)new StructuredSelection((Object)this.UNRELEASED_VERSION), true);
            } else {
                this.reportedIn.setSelection((ISelection)new StructuredSelection((Object[])this.workingCopy.getReportedInVersionFilter().getVersions()), true);
            }
        } else {
            this.reportedIn.setSelection((ISelection)new StructuredSelection((Object)this.ANY_REPORTED_VERSION), true);
        }
        if (this.workingCopy.getContentFilter() != null) {
            this.queryString.setText(this.workingCopy.getContentFilter().getQueryString());
            this.searchComments.setSelection(this.workingCopy.getContentFilter().isSearchingComments());
            this.searchDescription.setSelection(this.workingCopy.getContentFilter().isSearchingDescription());
            this.searchEnvironment.setSelection(this.workingCopy.getContentFilter().isSearchingEnvironment());
            this.searchSummary.setSelection(this.workingCopy.getContentFilter().isSearchingSummary());
        }
        if (this.workingCopy.getComponentFilter() != null) {
            if (this.workingCopy.getComponentFilter().hasNoComponent()) {
                this.components.setSelection((ISelection)new StructuredSelection((Object)this.NO_COMPONENT), true);
            } else {
                this.components.setSelection((ISelection)new StructuredSelection((Object[])this.workingCopy.getComponentFilter().getComponents()), true);
            }
        } else {
            this.components.setSelection((ISelection)new StructuredSelection((Object)this.ANY_COMPONENT), true);
        }
        if (this.workingCopy.getIssueTypeFilter() != null) {
            this.issueType.setSelection((ISelection)new StructuredSelection((Object[])this.workingCopy.getIssueTypeFilter().getIsueTypes()), true);
        } else {
            this.issueType.setSelection((ISelection)new StructuredSelection((Object)this.ANY_ISSUE_TYPE), true);
        }
        if (this.workingCopy.getReportedByFilter() != null) {
            UserFilter reportedByFilter = this.workingCopy.getReportedByFilter();
            if (reportedByFilter instanceof NobodyFilter) {
                this.reporterType.setSelection((ISelection)new StructuredSelection((Object)this.NO_REPORTER));
            } else if (reportedByFilter instanceof CurrentUserFilter) {
                this.reporterType.setSelection((ISelection)new StructuredSelection((Object)this.CURRENT_USER_REPORTER));
            } else if (reportedByFilter instanceof SpecificUserFilter) {
                this.reporterType.setSelection((ISelection)new StructuredSelection((Object)this.SPECIFIC_USER_REPORTER));
                this.reporter.setText(((SpecificUserFilter)reportedByFilter).getUser());
            } else if (reportedByFilter instanceof UserInGroupFilter) {
                this.reporterType.setSelection((ISelection)new StructuredSelection((Object)this.SPECIFIC_GROUP_REPORTER));
                this.reporter.setText(((UserInGroupFilter)reportedByFilter).getGroup());
            }
        } else {
            this.reporterType.setSelection((ISelection)new StructuredSelection((Object)this.ANY_REPORTER));
        }
        if (this.workingCopy.getAssignedToFilter() != null) {
            UserFilter assignedToFilter = this.workingCopy.getAssignedToFilter();
            if (assignedToFilter instanceof NobodyFilter) {
                this.assigneeType.setSelection((ISelection)new StructuredSelection((Object)this.UNASSIGNED));
            } else if (assignedToFilter instanceof CurrentUserFilter) {
                this.assigneeType.setSelection((ISelection)new StructuredSelection((Object)this.CURRENT_USER_ASSIGNEE));
            } else if (assignedToFilter instanceof SpecificUserFilter) {
                this.assigneeType.setSelection((ISelection)new StructuredSelection((Object)this.SPECIFIC_USER_ASSIGNEE));
                this.assignee.setText(((SpecificUserFilter)assignedToFilter).getUser());
            } else if (assignedToFilter instanceof UserInGroupFilter) {
                this.assigneeType.setSelection((ISelection)new StructuredSelection((Object)this.SPECIFIC_GROUP_ASSIGNEE));
                this.assignee.setText(((UserInGroupFilter)assignedToFilter).getGroup());
            }
        } else {
            this.assigneeType.setSelection((ISelection)new StructuredSelection((Object)this.ANY_ASSIGNEE));
        }
        if (this.workingCopy.getStatusFilter() != null) {
            this.status.setSelection((ISelection)new StructuredSelection((Object[])this.workingCopy.getStatusFilter().getStatuses()), true);
        } else {
            this.status.setSelection((ISelection)new StructuredSelection((Object)this.ANY_STATUS), true);
        }
        if (this.workingCopy.getResolutionFilter() != null) {
            Object[] resolutions = this.workingCopy.getResolutionFilter().getResolutions();
            if (resolutions.length == 0) {
                this.resolution.setSelection((ISelection)new StructuredSelection((Object)this.UNRESOLVED), true);
            } else {
                this.resolution.setSelection((ISelection)new StructuredSelection(resolutions), true);
            }
        } else {
            this.resolution.setSelection((ISelection)new StructuredSelection((Object)this.ANY_RESOLUTION), true);
        }
        if (this.workingCopy.getPriorityFilter() != null) {
            this.priority.setSelection((ISelection)new StructuredSelection((Object[])this.workingCopy.getPriorityFilter().getPriorities()), true);
        } else {
            this.priority.setSelection((ISelection)new StructuredSelection((Object)this.ANY_PRIORITY), true);
        }
        this.setDateRange(this.workingCopy.getCreatedDateFilter(), this.createdStartDatePicker, this.createdEndDatePicker);
        this.setDateRange(this.workingCopy.getUpdatedDateFilter(), this.updatedStartDatePicker, this.updatedEndDatePicker);
        this.setDateRange(this.workingCopy.getDueDateFilter(), this.dueStartDatePicker, this.dueEndDatePicker);
    }

    public boolean performSearch() {
        if (this.inSearchContainer()) {
            this.saveState();
        }
        return super.performSearch();
    }

    private boolean restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        String searchUrl = settings.get("JiraSearchPage.SEARCHURL." + this.getTaskRepository().getRepositoryUrl());
        if (searchUrl == null) {
            return false;
        }
        FilterDefinitionConverter converter = new FilterDefinitionConverter(this.getTaskRepository().getCharacterEncoding());
        this.workingCopy = converter.toFilter(this.client, searchUrl, false);
        return true;
    }

    public void saveState() {
        String repoId = "." + this.getTaskRepository().getRepositoryUrl();
        IDialogSettings settings = this.getDialogSettings();
        settings.put(SEARCH_URL_ID + repoId, this.createQuery().getUrl());
    }

    private void setDateRange(DateFilter dateFilter, DatePicker startDatePicker, DatePicker endDatePicker) {
        if (dateFilter instanceof DateRangeFilter) {
            DateRangeFilter rangeFilter = (DateRangeFilter)dateFilter;
            Calendar c1 = Calendar.getInstance();
            c1.setTime(rangeFilter.getFromDate());
            startDatePicker.setDate(c1);
            Calendar c2 = Calendar.getInstance();
            c2.setTime(rangeFilter.getToDate());
            endDatePicker.setDate(c2);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.getSearchContainer() != null) {
            this.getSearchContainer().setPerformActionEnabled(true);
        }
        if (visible && this.firstTime) {
            this.firstTime = false;
            if (!this.client.getCache().hasDetails()) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (JiraFilterDefinitionPage.this.getControl() != null && !JiraFilterDefinitionPage.this.getControl().isDisposed()) {
                            JiraFilterDefinitionPage.this.initializePage();
                        }
                    }
                });
            } else {
                this.initializePage();
            }
        }
    }

    private void updateAttributesFromRepository(boolean force) {
        if (!this.client.getCache().hasDetails() || force) {
            try {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        JiraClient client = JiraClientFactory.getDefault().getJiraClient(JiraFilterDefinitionPage.this.getTaskRepository());
                        try {
                            client.getCache().refreshDetails(monitor);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            throw new InterruptedException();
                        }
                        catch (JiraException e) {
                            this.showWarning(NLS.bind((String)"Error updating attributes: {0}\nPlease check repository settings in the Task Repositories view.", (Object)e.getMessage()));
                        }
                        catch (Exception e) {
                            String msg = NLS.bind((String)"Error updating attributes: {0}\nPlease check repository settings in the Task Repositories view.", (Object)e.getMessage());
                            this.showWarning(msg);
                            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.jira.ui", msg, (Throwable)e));
                        }
                    }

                    private void showWarning(final String msg) {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                JiraFilterDefinitionPage.this.setErrorMessage(msg);
                            }
                        });
                    }
                };
                if (this.getContainer() != null) {
                    this.getContainer().run(true, true, runnable);
                } else if (this.getSearchContainer() != null) {
                    this.getSearchContainer().getRunnableContext().run(true, true, runnable);
                } else {
                    IProgressService service = PlatformUI.getWorkbench().getProgressService();
                    service.busyCursorWhile(runnable);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        this.initializeContentProviders();
    }

    void updateCurrentProject(Project project) {
        this.fixFor.setInput((Object)project);
        this.components.setInput((Object)project);
        this.reportedIn.setInput((Object)project);
    }

    static final class ComponentLabelProvider
    implements ILabelProvider {
        ComponentLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Placeholder) {
                return ((Placeholder)element).getText();
            }
            return ((Component)element).getName();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static final class Placeholder {
        private final String text;

        public Placeholder(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }

    static final class VersionLabelProvider
    implements ILabelProvider,
    IColorProvider {
        VersionLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Color getBackground(Object element) {
            if (element instanceof Placeholder) {
                return Display.getCurrent().getSystemColor(29);
            }
            return null;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Placeholder) {
                return ((Placeholder)element).getText();
            }
            return ((Version)element).getName();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

