/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core;

import java.util.Date;
import java.util.EnumSet;
import org.eclipse.mylyn.internal.trac.core.TracAttribute;
import org.eclipse.mylyn.internal.trac.core.util.TracUtil;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;

public class TracAttributeMapper
extends TaskAttributeMapper {
    public static final String NEW_CC = "task.common.newcc";
    public static final String REMOVE_CC = "task.common.removecc";
    public static final EnumSet<Flag> NO_FLAGS = EnumSet.noneOf(Flag.class);

    public static boolean isInternalAttribute(TaskAttribute attribute) {
        String type = attribute.getMetaData().getType();
        if ("attachment".equals(type) || "operation".equals(type) || "comment".equals(type)) {
            return true;
        }
        String id = attribute.getId();
        return "task.common.comment.new".equals(id) || "task.common.addselfcc".equals(id) || REMOVE_CC.equals(id) || NEW_CC.equals(id);
    }

    public TracAttributeMapper(TaskRepository taskRepository) {
        super(taskRepository);
    }

    public Date getDateValue(TaskAttribute attribute) {
        return TracUtil.parseDate(attribute.getValue());
    }

    public String mapToRepositoryKey(TaskAttribute parent, String key) {
        TracAttribute attribute = TracAttribute.getByTaskKey(key);
        return attribute != null ? attribute.getTracKey() : key;
    }

    public void setDateValue(TaskAttribute attribute, Date date) {
        if (date == null) {
            attribute.clearValues();
        } else {
            attribute.setValue(String.valueOf(TracUtil.toTracTime(date)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        READ_ONLY,
        ATTRIBUTE,
        PEOPLE;

    }
}

