/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.usage;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.monitor.core.collection.IUsageCollector;
import org.eclipse.mylyn.internal.monitor.core.collection.IUsageScanner;
import org.eclipse.mylyn.internal.monitor.core.collection.InteractionEventComparator;
import org.eclipse.mylyn.internal.monitor.core.collection.InteractionEventSummary;
import org.eclipse.mylyn.internal.monitor.core.collection.InteractionEventUtil;
import org.eclipse.mylyn.internal.monitor.usage.InteractionEventLogger;
import org.eclipse.mylyn.internal.monitor.usage.UsageStatisticsSummary;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportGenerator {
    public static final String SUMMARY_SEPARATOR = "<hr><br>";
    private final InteractionEventLogger logger;
    private UsageStatisticsSummary lastParsedSummary = null;
    private final Set<Integer> userIds = new HashSet<Integer>();
    private final List<IUsageCollector> collectors;
    private List<IUsageScanner> scanners;
    private Map<Integer, Map<String, SortedSet<InteractionEvent>>> allUserEvents;
    private boolean saveAllUserEvents = false;
    private IJobChangeListener listener = null;
    private boolean forceSyncForTesting = false;

    public ReportGenerator(InteractionEventLogger logger, IUsageCollector collector, boolean saveAllUserEvents) {
        this(logger, collector);
        this.saveAllUserEvents = saveAllUserEvents;
    }

    public ReportGenerator(InteractionEventLogger logger, List<IUsageCollector> collectors, boolean saveAllUserEvents) {
        this(logger, collectors);
        this.saveAllUserEvents = saveAllUserEvents;
    }

    public ReportGenerator(InteractionEventLogger logger, IUsageCollector collector) {
        ArrayList<IUsageCollector> collectors = new ArrayList<IUsageCollector>();
        collectors.add(collector);
        this.logger = logger;
        this.collectors = collectors;
    }

    public ReportGenerator(InteractionEventLogger logger, List<IUsageCollector> collectors) {
        this.logger = logger;
        this.collectors = collectors;
    }

    public ReportGenerator(InteractionEventLogger logger, List<IUsageCollector> collectors, List<IUsageScanner> scanners, IJobChangeListener listener) {
        this(logger, collectors);
        this.scanners = scanners;
    }

    public ReportGenerator(InteractionEventLogger logger, IUsageCollector collector, IJobChangeListener listener) {
        this(logger, collector);
        this.listener = listener;
    }

    public ReportGenerator(InteractionEventLogger logger, List<IUsageCollector> collectors, IJobChangeListener listener, boolean forceSyncForTesting) {
        this(logger, collectors);
        this.listener = listener;
        this.forceSyncForTesting = forceSyncForTesting;
    }

    public void setScanners(List<IUsageScanner> scanners) {
        this.scanners = scanners;
    }

    public void getStatisticsFromInteractionHistory(File source, IJobChangeListener listener) {
        ArrayList<File> sources = new ArrayList<File>();
        sources.add(source);
        this.getStatisticsFromInteractionHistories(sources, listener);
    }

    public void getStatisticsFromInteractionHistories(List<File> sources, IJobChangeListener jobChangeListener) {
        GenerateStatisticsJob job = new GenerateStatisticsJob(this, sources);
        if (jobChangeListener != null) {
            job.addJobChangeListener(jobChangeListener);
        }
        if (this.listener != null) {
            job.addJobChangeListener(this.listener);
        }
        job.setPriority(30);
        if (this.forceSyncForTesting) {
            job.run((IProgressMonitor)new NullProgressMonitor());
        } else {
            job.schedule();
        }
    }

    public UsageStatisticsSummary getLastParsedSummary() {
        return this.lastParsedSummary;
    }

    private int getUserId(File source) {
        String userIDText = source.getName();
        int userId = -1;
        String prefix = "-usage-";
        if (source.getName().indexOf(prefix) >= 0) {
            try {
                userIDText = userIDText.substring(userIDText.indexOf(prefix) + prefix.length(), userIDText.length());
                userIDText = userIDText.substring(0, userIDText.indexOf("-"));
                userId = Integer.valueOf(userIDText);
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "Could not parse user ID from source file", t));
            }
        }
        return userId;
    }

    private String getPhase(File source) {
        String userIDText = source.getName();
        String phase = "unknown";
        String terminator = "-";
        if (source.getName().indexOf(terminator) >= 0) {
            try {
                phase = userIDText.substring(0, userIDText.indexOf(terminator) - 1);
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "Could not parse user ID from source file", t));
            }
        }
        return phase;
    }

    public static String formatPercentage(float percentage) {
        String percentageString = "" + percentage;
        int indexOf2ndDecimal = percentageString.indexOf(46) + 3;
        if (indexOf2ndDecimal <= percentageString.length()) {
            percentageString = percentageString.substring(0, indexOf2ndDecimal);
        }
        return percentageString;
    }

    public List<IUsageCollector> getCollectors() {
        return this.collectors;
    }

    public Map<Integer, Map<String, SortedSet<InteractionEvent>>> getAllUsers() {
        return this.allUserEvents;
    }

    public void forceSyncForTesting(boolean syncForTesting) {
        this.forceSyncForTesting = syncForTesting;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GenerateStatisticsJob
    extends Job {
        private static final String JOB_LABEL = "Mylyn Usage Summary Generation";
        private final ReportGenerator generator;
        private final List<File> sources;

        public GenerateStatisticsJob(ReportGenerator generator, List<File> sources) {
            super("Generate statistics job");
            this.generator = generator;
            this.sources = sources;
        }

        /*
         * WARNING - void declaration
         */
        public IStatus run(IProgressMonitor monitor) {
            if (ReportGenerator.this.saveAllUserEvents) {
                ReportGenerator.this.allUserEvents = new HashMap();
            }
            UsageStatisticsSummary statistics = new UsageStatisticsSummary();
            HashMap<Integer, Map<String, InteractionEventSummary>> summaryMap = new HashMap<Integer, Map<String, InteractionEventSummary>>();
            HashMap<Integer, void> filesPerUser = new HashMap<Integer, void>();
            try {
                for (File source : this.sources) {
                    void var8_12;
                    void var8_15;
                    int userId = ReportGenerator.this.getUserId(source);
                    ReportGenerator.this.userIds.add(userId);
                    Object var8_13 = null;
                    if (filesPerUser.containsKey(userId)) {
                        List list = (List)filesPerUser.get(userId);
                    }
                    if (var8_15 == null) {
                        ArrayList arrayList = new ArrayList();
                    }
                    var8_12.add(source);
                    filesPerUser.put(userId, var8_12);
                }
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "Could not generate usage report", t));
            }
            try {
                monitor.beginTask(JOB_LABEL, ReportGenerator.this.userIds.size() * 3);
                for (Integer aUser : filesPerUser.keySet()) {
                    SortedSet events;
                    HashMap<String, TreeSet<InteractionEvent>> userEvents = new HashMap<String, TreeSet<InteractionEvent>>();
                    for (File file : (List)filesPerUser.get(aUser)) {
                        TreeSet<InteractionEvent> orderedEvents;
                        String phase = ReportGenerator.this.getPhase(file);
                        if (userEvents.get(phase) == null) {
                            orderedEvents = new TreeSet<InteractionEvent>((Comparator<InteractionEvent>)new InteractionEventComparator());
                            orderedEvents.addAll(this.generator.logger.getHistoryFromFile(file));
                        } else {
                            orderedEvents = (TreeSet<InteractionEvent>)userEvents.get(phase);
                            orderedEvents.addAll(this.generator.logger.getHistoryFromFile(file));
                        }
                        userEvents.put(phase, orderedEvents);
                    }
                    monitor.worked(1);
                    if (this.generator.scanners != null && this.generator.scanners.size() > 0) {
                        for (Map.Entry entry : userEvents.entrySet()) {
                            events = (SortedSet)entry.getValue();
                            for (InteractionEvent event : events) {
                                for (IUsageScanner scanner : this.generator.scanners) {
                                    scanner.scanEvent(event, aUser.intValue());
                                }
                            }
                        }
                    }
                    monitor.worked(1);
                    if (ReportGenerator.this.allUserEvents != null) {
                        ReportGenerator.this.allUserEvents.put(aUser, userEvents);
                    }
                    for (Map.Entry entry : userEvents.entrySet()) {
                        events = (SortedSet)entry.getValue();
                        for (InteractionEvent event : events) {
                            if (event.getKind().isUserEvent()) {
                                for (IUsageCollector collector : this.generator.collectors) {
                                    collector.consumeEvent(event, aUser.intValue());
                                }
                            }
                            this.createUsageTableData(summaryMap, event, aUser);
                        }
                    }
                    monitor.worked(1);
                }
                for (IUsageCollector collector : this.generator.collectors) {
                    statistics.add(collector);
                }
                ArrayList<InteractionEventSummary> flattenedSummaries = new ArrayList<InteractionEventSummary>();
                HashMap<String, InteractionEventSummary> combinedUserSummary = new HashMap<String, InteractionEventSummary>();
                for (Map userSummary : summaryMap.values()) {
                    for (InteractionEventSummary aSummary : userSummary.values()) {
                        if (!combinedUserSummary.containsKey(aSummary.getName())) {
                            combinedUserSummary.put(aSummary.getName(), new InteractionEventSummary(aSummary));
                            continue;
                        }
                        InteractionEventSummary combinedSummary = (InteractionEventSummary)combinedUserSummary.get(aSummary.getName());
                        combinedSummary.combine(aSummary);
                        combinedUserSummary.put(aSummary.getName(), combinedSummary);
                    }
                }
                flattenedSummaries.addAll(combinedUserSummary.values());
                statistics.setSingleSummaries(flattenedSummaries);
                this.generator.lastParsedSummary = statistics;
                monitor.done();
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "Could not generate usage report", t));
            }
            return Status.OK_STATUS;
        }

        private void createUsageTableData(Map<Integer, Map<String, InteractionEventSummary>> summaryMap, InteractionEvent event, int userId) {
            InteractionEventSummary summary;
            Map<String, InteractionEventSummary> usersSummary = summaryMap.get(userId);
            if (usersSummary == null) {
                usersSummary = new HashMap<String, InteractionEventSummary>();
                summaryMap.put(userId, usersSummary);
            }
            if ((summary = usersSummary.get(this.getIdentifier(event))) == null) {
                summary = new InteractionEventSummary(event.getKind().toString(), InteractionEventUtil.getCleanOriginId((InteractionEvent)event), 0);
                usersSummary.put(this.getIdentifier(event), summary);
            }
            summary.setUsageCount(summary.getUsageCount() + 1);
            summary.setInterestContribution(summary.getInterestContribution() + event.getInterestContribution());
            summary.setDelta(event.getDelta());
            summary.addUserId(userId);
        }

        public String getIdentifier(InteractionEvent event) {
            return String.valueOf(event.getKind().toString()) + ':' + InteractionEventUtil.getCleanOriginId((InteractionEvent)event);
        }
    }
}

