/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.bridge.bugs;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.internal.bugzilla.ui.BugzillaUiPlugin;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.BugzillaMylynSearchOperation;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class Util {
    private static final String[] patternOperationValues = new String[]{"allwordssubstr", "anywordssubstr", "regexp"};

    public static String getExactSearchURL(String repositoryUrl, IMember je) {
        StringBuffer sb = Util.getQueryURLStart(repositoryUrl);
        String long_desc = "";
        long_desc = String.valueOf(long_desc) + BugzillaMylynSearchOperation.getFullyQualifiedName((IJavaElement)je);
        try {
            sb.append(URLEncoder.encode(long_desc, Charset.defaultCharset().toString()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        sb.append(Util.getQueryURLEnd(repositoryUrl));
        return sb.toString();
    }

    public static String getInexactSearchURL(String repositoryUrl, IMember je) {
        StringBuffer sb = Util.getQueryURLStart(repositoryUrl);
        String long_desc = "";
        if (!(je instanceof IType)) {
            long_desc = String.valueOf(long_desc) + je.getParent().getElementName() + ".";
        }
        long_desc = String.valueOf(long_desc) + je.getElementName();
        try {
            sb.append(URLEncoder.encode(long_desc, Charset.defaultCharset().toString()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        sb.append(Util.getQueryURLEnd(repositoryUrl));
        return sb.toString();
    }

    public static StringBuffer getQueryURLEnd(String repositoryUrl) {
        StringBuffer sb = new StringBuffer();
        TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(repositoryUrl);
        RepositoryConfiguration repositoryConfiguration = null;
        try {
            repositoryConfiguration = BugzillaCorePlugin.getRepositoryConfiguration((TaskRepository)repository, (boolean)false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Bugzilla Search Page", (String)"Unable to get configuration. Ensure proper repository configuration in Task Repositories.\n\n");
                }
            });
        }
        String[] resolutionValues = BugzillaUiPlugin.getQueryOptions((String)"org.eclipse.mylyn.bugzilla.values.resolution", null, (RepositoryConfiguration)repositoryConfiguration);
        String[] statusValues = BugzillaUiPlugin.getQueryOptions((String)"org.eclipse.mylyn.bugzilla.values.status", null, (RepositoryConfiguration)repositoryConfiguration);
        sb.append("&bug_status=" + statusValues[0]);
        sb.append("&bug_status=" + statusValues[1]);
        sb.append("&bug_status=" + statusValues[2]);
        sb.append("&bug_status=" + statusValues[3]);
        sb.append("&bug_status=" + statusValues[4]);
        sb.append("&bug_status=" + statusValues[5]);
        sb.append("&bug_status=" + statusValues[6]);
        sb.append("&resolution=" + resolutionValues[0]);
        sb.append("&resolution=" + resolutionValues[3]);
        sb.append("&resolution=---");
        return sb;
    }

    public static StringBuffer getQueryURLStart(String repositoryUrl) {
        StringBuffer sb = new StringBuffer(repositoryUrl);
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        sb.append("buglist.cgi?");
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository("bugzilla", repositoryUrl);
        if (repository != null && repository.hasCredentials()) {
            try {
                sb.append("GoAheadAndLogIn=1&Bugzilla_login=" + URLEncoder.encode(repository.getUserName(), Charset.defaultCharset().toString()) + "&Bugzilla_password=" + URLEncoder.encode(repository.getPassword(), Charset.defaultCharset().toString()) + "&");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        sb.append("long_desc_type=");
        sb.append(patternOperationValues[0]);
        sb.append("&long_desc=");
        return sb;
    }

    public static boolean hasElementName(String elementName, String comment) {
        String[] lines;
        String regexElement = ".*" + elementName + ".*";
        String[] stringArray = lines = comment.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.matches(regexElement)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

