/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.Person;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncomingTaskListContentProvider
extends TaskListContentProvider {
    Set<AbstractTaskContainer> people = new HashSet<AbstractTaskContainer>();

    public IncomingTaskListContentProvider(TaskListView taskListView) {
        super(taskListView);
    }

    public Object[] getElements(Object parent) {
        this.people.clear();
        if (parent instanceof Person) {
            return this.getChildren(parent);
        }
        for (ITaskContainer container : this.applyFilter(TasksUiPlugin.getTaskListManager().getTaskList().getRootElements())) {
            for (ITask task : this.getAllTasks(container.getChildren())) {
                if (task.getOwner() == null || !task.getSynchronizationState().isIncoming()) continue;
                this.people.add((AbstractTaskContainer)new Person(task.getOwner(), task.getConnectorKind(), task.getRepositoryUrl()));
            }
        }
        return this.people.toArray();
    }

    private Set<ITask> getAllTasks(Collection<ITask> children) {
        if (children != null) {
            HashSet<ITask> alltasks = new HashSet<ITask>(children);
            for (ITask task : children) {
                Set<ITask> childTasks;
                if (!(task instanceof AbstractTask) || (childTasks = this.getAllTasks(((AbstractTask)task).getChildren())) == null) continue;
                alltasks.addAll(childTasks);
            }
            return alltasks;
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        HashSet<ITask> children = new HashSet<ITask>();
        if (parent instanceof Person) {
            for (ITaskContainer container : this.applyFilter(TasksUiPlugin.getTaskListManager().getTaskList().getRootElements())) {
                for (ITask task : this.getAllTasks(container.getChildren())) {
                    if (task.getOwner() == null || !task.getOwner().equals(((Person)parent).getHandleIdentifier()) || !task.getSynchronizationState().isIncoming()) continue;
                    children.add(task);
                }
            }
        }
        return children.toArray();
    }

    public boolean hasChildren(Object parent) {
        return parent instanceof Person;
    }
}

